/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.access;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.access.GroupCacheAccess;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.access.JCSWorkerHelper;

public class JCSWorker<K, V> {
    private static final Log logger = LogManager.getLog(JCSWorker.class);
    private final CacheAccess<K, V> cache;
    private final GroupCacheAccess<K, V> groupCache;
    private final ConcurrentMap<String, JCSWorkerHelper<V>> map = new ConcurrentHashMap<String, JCSWorkerHelper<V>>();
    private final String region;

    public JCSWorker(String aRegion) {
        this.region = aRegion;
        try {
            this.cache = JCS.getInstance(aRegion);
            this.groupCache = JCS.getGroupCacheInstance(aRegion);
        }
        catch (CacheException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getRegion() {
        return this.region;
    }

    public V getResult(K aKey, JCSWorkerHelper<V> aWorker) throws Exception {
        return this.run(aKey, null, aWorker);
    }

    public V getResult(K aKey, String aGroup, JCSWorkerHelper<V> aWorker) throws Exception {
        return this.run(aKey, aGroup, aWorker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V run(K aKey, String aGroup, JCSWorkerHelper<V> aHelper) throws Exception {
        JCSWorkerHelper<V> jCSWorkerHelper;
        Object result = null;
        JCSWorkerHelper<V> helper = this.map.putIfAbsent(this.getRegion() + aKey, aHelper);
        if (helper != null) {
            jCSWorkerHelper = helper;
            synchronized (jCSWorkerHelper) {
                logger.debug("Found a worker already doing this work ({0}:{1}).", this::getRegion, () -> aKey);
                while (!helper.isFinished()) {
                    try {
                        helper.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                logger.debug("Another thread finished our work for us. Using those results instead. ({0}:{1}).", this::getRegion, () -> aKey);
            }
        }
        try {
            logger.debug("{0} is doing the work.", this::getRegion);
            result = aGroup != null ? (Object)this.groupCache.getFromGroup(aKey, aGroup) : (Object)this.cache.get(aKey);
            if (result == null) {
                result = aHelper.doWork();
                logger.debug("Work Done, caching: key:{0}, group:{1}, result:{2}.", aKey, aGroup, result);
                if (aGroup != null) {
                    this.groupCache.putInGroup(aKey, aGroup, result);
                } else {
                    this.cache.put(aKey, result);
                }
            }
            jCSWorkerHelper = result;
        }
        catch (Throwable throwable) {
            logger.debug("{0}:{1} entered finally.", this::getRegion, () -> aKey);
            if (helper == null) {
                this.map.remove(this.getRegion() + aKey);
            }
            JCSWorkerHelper<V> jCSWorkerHelper2 = aHelper;
            synchronized (jCSWorkerHelper2) {
                aHelper.setFinished(true);
                aHelper.notifyAll();
            }
            throw throwable;
        }
        logger.debug("{0}:{1} entered finally.", this::getRegion, () -> aKey);
        if (helper == null) {
            this.map.remove(this.getRegion() + aKey);
        }
        JCSWorkerHelper<V> jCSWorkerHelper3 = aHelper;
        synchronized (jCSWorkerHelper3) {
            aHelper.setFinished(true);
            aHelper.notifyAll();
        }
        return (V)jCSWorkerHelper;
    }
}

