/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.platform;

import java.util.Date;
import org.apache.torque.templates.platform.PlatformDefaultImpl;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;

public class PlatformMssqlImpl
extends PlatformDefaultImpl {
    private static final String DATE_FORMAT = "''yyyyMMdd HH:mm:ss''";

    public PlatformMssqlImpl() {
        this.initialize();
    }

    private void initialize() {
        this.setSchemaTypeToSqlTypeMapping(SchemaType.INTEGER, new SqlType("INT"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BOOLEANINT, new SqlType("INT"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.DOUBLE, new SqlType("FLOAT"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.LONGVARCHAR, new SqlType("TEXT"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.TIMESTAMP, new SqlType("DATETIME"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BINARY, new SqlType("BINARY"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.VARBINARY, new SqlType("IMAGE"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.LONGVARBINARY, new SqlType("IMAGE"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BLOB, new SqlType("IMAGE"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.CLOB, new SqlType("TEXT"));
    }

    @Override
    public String getNullString(boolean notNull) {
        return notNull ? "NOT NULL" : "NULL";
    }

    @Override
    protected boolean escapeBackslashes() {
        return false;
    }

    @Override
    public String getTimestampString(Date date) {
        return this.formatDateTimeString(date, DATE_FORMAT);
    }

    @Override
    public boolean usesStandaloneSchema() {
        return true;
    }

    @Override
    public boolean hasSize(String sqlType) {
        return !"IMAGE".equals(sqlType) && !"TEXT".equals(sqlType);
    }
}

