/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.threadpool;

import java.util.concurrent.ThreadFactory;

public class DaemonThreadFactory
implements ThreadFactory {
    private String prefix;
    private boolean threadIsDaemon = true;
    private int threadPriority = 5;

    public DaemonThreadFactory(String prefix) {
        this(prefix, 5);
    }

    public DaemonThreadFactory(String prefix, int threadPriority) {
        this.prefix = prefix;
        this.threadPriority = threadPriority;
    }

    @Override
    public Thread newThread(Runnable runner) {
        Thread t = new Thread(runner);
        String oldName = t.getName();
        t.setName(this.prefix + oldName);
        t.setDaemon(this.threadIsDaemon);
        t.setPriority(this.threadPriority);
        return t;
    }
}

