package org.apache.torque.util;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.commons.collections.map.ListOrderedMap;

/**
 * A subclass of the Apache Commons ListOrderedMap that has case insensitive
 * String key methods.  This is done by converting all String keys to
 * lower case.
 *
 * @author <a href="mailto:greg.monroe@dukece.com">Greg Monroe</a>
 * @version $Id: ListOrderedMapCI.java 1448414 2013-02-20 21:06:35Z tfischer $
 */
public class ListOrderedMapCI extends ListOrderedMap
{
    /** Version id for serializing. */
    private static final long serialVersionUID = -4349246328751938554L;

    /**
     * Constructs a new empty ListOrderedMap.
     */
    public ListOrderedMapCI()
    {
        super();
    }

    /**
     * Get the object associated with this key.
     *
     * @param key A case insensitive String.
     * @return The value for this key
     */
    public Object get(String key)
    {
       return super.get(key.toLowerCase());
    }

    /**
     * Adds a value to the end of the list with the specified key.
     *
     * @param key A case insensitive String.
     * @param value The value to add
     * @return The value for previously mapped to this key
     */
    public Object put(String key, Object value)
    {
        return super.put(key.toLowerCase(), value);
    }

    /**
     * Puts a key-value mapping into the map at the specified index.
     *
     * @param index The index at which the mapping should be inserted.
     * @param key A case insensitive String.
     * @param value The value.
     *
     * @return The value for previously mapped to this key
     */
    public Object put(int index, String key, Object value)
    {
        return super.put(index, key.toLowerCase(), value);
    }
    /**
     * Gets the index of the specified key.
     *
     * @param key A case insensitive String.
     * @return the index, or -1 if not found
     */
    public int indexOf(String key)
    {
        return super.indexOf(key.toLowerCase());
    }
    /**
     * Removes the mapping for the specified key.
     * @param key A case insensitive String.
     * @return the removed value, or null if none existed
     */
    public Object remove (String key)
    {
        return super.remove(key.toLowerCase());
    }
    /**
     * Test if the key exists in the mapping.
     *
     * @param key The case insensitive key to test for.
     * @return True if the key exists.
     */
    public boolean containsKey(String key)
    {
        return super.containsKey(key.toLowerCase());
    }
}
