/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.transform;

import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.file.Fileset;
import org.apache.torque.generator.source.Source;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.source.SourcePath;
import org.apache.torque.generator.source.stream.FileSourceProvider;
import org.apache.torque.generator.source.stream.StreamSourceFormat;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadAdditionalSourceTransformer
implements SourceTransformer {
    private static Log log = LogFactory.getLog(LoadAdditionalSourceTransformer.class);
    private String element;
    private List<String> fileIncludes;
    private List<String> fileExcludes;
    private String sourceFormat;

    @Override
    public SourceElement transform(SourceElement root, ControllerState controllerState) throws SourceTransformerException {
        FileSourceProvider fileSourceProvider;
        List<SourceElement> sourceElementList = SourcePath.getElementsFromRoot(root, this.element);
        if (sourceElementList.isEmpty()) {
            throw new SourceTransformerException("Source element " + this.element + " does not exist");
        }
        SourceElement sourceElement = sourceElementList.get(0);
        ConfigurationHandlers configurationHandlers = controllerState.getUnitConfiguration().getConfigurationHandlers();
        Set<StreamSourceFormat> streamSourceFormats = configurationHandlers.getStreamSourceFormats();
        StreamSourceFormat streamSourceFormat = null;
        for (StreamSourceFormat candidate : streamSourceFormats) {
            if (!this.sourceFormat.equals(candidate.getKey())) continue;
            streamSourceFormat = candidate;
            break;
        }
        if (streamSourceFormat == null) {
            throw new SourceTransformerException("Unknown source format" + this.sourceFormat);
        }
        try {
            fileSourceProvider = new FileSourceProvider(streamSourceFormat, new Fileset(controllerState.getSourceFile().getParentFile(), this.fileIncludes, this.fileExcludes), false);
            fileSourceProvider.init(configurationHandlers, controllerState);
        }
        catch (ConfigurationException e) {
            throw new SourceTransformerException("Could initialize file source provider", e);
        }
        while (fileSourceProvider.hasNext()) {
            SourceElement additionalSourceRoot;
            Source additionalSource = fileSourceProvider.next();
            try {
                additionalSourceRoot = additionalSource.getRootElement();
            }
            catch (SourceException e) {
                log.error((Object)("Could not construct source from schema file " + additionalSource.getDescription()), (Throwable)e);
                throw new SourceTransformerException("Could not construct source from schema file " + additionalSource.getDescription(), e);
            }
            sourceElement.getChildren().add(additionalSourceRoot);
        }
        return root;
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public List<String> getFileIncludes() {
        return this.fileIncludes;
    }

    public void setFileIncludes(List<String> fileIncludes) {
        this.fileIncludes = fileIncludes;
    }

    public List<String> getFileExcludes() {
        return this.fileExcludes;
    }

    public void setFileExcludes(List<String> fileExcludes) {
        this.fileExcludes = fileExcludes;
    }

    public String getSourceFormat() {
        return this.sourceFormat;
    }

    public void setSourceFormat(String sourceFormat) {
        this.sourceFormat = sourceFormat;
    }
}

