/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DeclareGlobalTempTableJavaJDBC30Test
extends BaseJDBCTestCase {
    public DeclareGlobalTempTableJavaJDBC30Test(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        baseTestSuite.addTest(TestConfiguration.embeddedSuite(DeclareGlobalTempTableJavaJDBC30Test.class));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(DeclareGlobalTempTableJavaJDBC30Test.getClientSuite()));
        return baseTestSuite;
    }

    private static Test getClientSuite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Client/Server");
        baseTestSuite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testOnCommitPreserveRowsWithHoldability"));
        baseTestSuite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testSavepointRollbackbehaviour7"));
        baseTestSuite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testSavepointRollbackbehaviour8"));
        baseTestSuite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testSavepointRollbackbehaviour11"));
        baseTestSuite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testSavepointRollbackbehaviour12"));
        baseTestSuite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testTest4"));
        baseTestSuite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testPooledConnectionClosed"));
        return baseTestSuite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getConnection().setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testOnCommitDeleteRowsWithHoldableOpenCursor() throws SQLException {
        Statement statement = this.getConnection().createStatement(1003, 1007, 1);
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit delete rows not logged");
        statement.executeUpdate("insert into session.t1 values(11, 1)");
        statement.executeUpdate("insert into session.t1 values(12, 2)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "2");
        ResultSet resultSet = statement.executeQuery("select * from SESSION.t1");
        resultSet.next();
        Statement statement2 = this.getConnection().createStatement(1003, 1007, 1);
        statement2.executeUpdate("declare global temporary table SESSION.t2(c21 int, c22 int) on commit delete rows not logged");
        statement2.executeUpdate("insert into session.t2 values(21, 1)");
        statement2.executeUpdate("insert into session.t2 values(22, 2)");
        JDBC.assertSingleValueResultSet(statement2.executeQuery("select count(*) from SESSION.t2"), "2");
        statement2.executeUpdate("declare global temporary table SESSION.t3(c31 int, c32 int) on commit delete rows not logged");
        statement2.executeUpdate("insert into session.t3 values(31, 1)");
        statement2.executeUpdate("insert into session.t3 values(32, 2)");
        JDBC.assertSingleValueResultSet(statement2.executeQuery("select count(*) from SESSION.t3"), "2");
        ResultSet resultSet2 = statement2.executeQuery("select * from SESSION.t2, SESSION.t3 where c22=c32");
        resultSet2.next();
        Statement statement3 = this.getConnection().createStatement(1003, 1007, 1);
        statement3.executeUpdate("declare global temporary table SESSION.t4(c41 int, c42 int) on commit delete rows not logged");
        statement3.executeUpdate("insert into session.t4 values(41, 1)");
        statement3.executeUpdate("insert into session.t4 values(42, 2)");
        ResultSet resultSet3 = statement3.executeQuery("select count(*) from SESSION.t4");
        JDBC.assertSingleValueResultSet(resultSet3, "2");
        resultSet3 = statement3.executeQuery("select * from SESSION.t4");
        resultSet3.next();
        resultSet3.close();
        this.commit();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "2");
        JDBC.assertSingleValueResultSet(statement2.executeQuery("select count(*) from SESSION.t2"), "2");
        JDBC.assertSingleValueResultSet(statement2.executeQuery("select count(*) from SESSION.t3"), "2");
        JDBC.assertSingleValueResultSet(statement3.executeQuery("select count(*) from SESSION.t4"), "0");
        statement.executeUpdate("drop table SESSION.t1");
        statement2.executeUpdate("drop table SESSION.t2");
        statement3.executeUpdate("drop table SESSION.t3");
        statement3.executeUpdate("drop table SESSION.t4");
        resultSet.close();
        resultSet2.close();
        resultSet3.close();
        this.commit();
        statement.close();
        statement2.close();
        statement3.close();
    }

    public void testOnCommitDeleteRowsHoldabilityWithPreparedStatements() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit delete rows not logged");
        statement.executeUpdate("insert into session.t1 values(11, 1)");
        statement.executeUpdate("insert into session.t1 values(12, 2)");
        PreparedStatement preparedStatement = this.getConnection().prepareStatement("select count(*) from SESSION.t1", 1003, 1007, 1);
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertSingleValueResultSet(resultSet, "2");
        PreparedStatement preparedStatement2 = this.getConnection().prepareStatement("select * from SESSION.t1", 1003, 1007, 1);
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        resultSet2.next();
        statement.executeUpdate("declare global temporary table SESSION.t2(c21 int, c22 int) on commit delete rows not logged");
        statement.executeUpdate("insert into session.t2 values(21, 1)");
        statement.executeUpdate("insert into session.t2 values(22, 2)");
        PreparedStatement preparedStatement3 = this.getConnection().prepareStatement("select count(*) from SESSION.t2", 1003, 1007, 1);
        ResultSet resultSet3 = preparedStatement3.executeQuery();
        JDBC.assertSingleValueResultSet(resultSet3, "2");
        PreparedStatement preparedStatement4 = this.getConnection().prepareStatement("select * from SESSION.t2", 1003, 1007, 1);
        resultSet3 = preparedStatement4.executeQuery();
        resultSet3.next();
        resultSet3.close();
        this.commit();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "2");
        resultSet2.close();
        resultSet.close();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "0");
        statement.executeUpdate("drop table SESSION.t1");
        statement.executeUpdate("drop table SESSION.t2");
    }

    public void testOnCommitPreserveRowsWithHoldability() throws SQLException {
        Statement statement = this.getConnection().createStatement(1003, 1007, 1);
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged");
        statement.executeUpdate("insert into session.t1 values(11, 1)");
        statement.executeUpdate("insert into session.t1 values(12, 2)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "2");
        ResultSet resultSet = statement.executeQuery("select * from SESSION.t1");
        resultSet.next();
        Statement statement2 = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t2(c11 int, c12 int) on commit preserve rows not logged");
        statement.executeUpdate("insert into session.t2 values(11, 1)");
        statement.executeUpdate("insert into session.t2 values(12, 2)");
        JDBC.assertSingleValueResultSet(statement2.executeQuery("select count(*) from SESSION.t2"), "2");
        ResultSet resultSet2 = statement2.executeQuery("select * from SESSION.t2");
        resultSet2.next();
        this.commit();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "2");
        JDBC.assertSingleValueResultSet(statement2.executeQuery("select count(*) from SESSION.t2"), "2");
        statement.executeUpdate("drop table SESSION.t1");
        statement2.executeUpdate("drop table SESSION.t2");
    }

    public void testSavepointRollbackbehaviour1() throws SQLException {
        Statement statement = this.createStatement();
        Savepoint savepoint = this.getConnection().setSavepoint();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged");
        PreparedStatement preparedStatement = this.prepareStatement("insert into SESSION.t1 values (?, ?)");
        preparedStatement.setInt(1, 11);
        preparedStatement.setInt(2, 1);
        preparedStatement.execute();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "1");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        statement.executeUpdate("drop table SESSION.t1");
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", statement, "select * from SESSION.t1");
        this.getConnection().rollback(savepoint2);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        this.getConnection().rollback(savepoint);
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", statement, "select * from SESSION.t1");
    }

    public void testSavepointRollbackbehaviour2() throws SQLException {
        Statement statement = this.createStatement();
        Savepoint savepoint = this.getConnection().setSavepoint();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        statement.executeUpdate("declare global temporary table SESSION.t2(c21 int, c22 int) on commit preserve rows not logged");
        this.getConnection().releaseSavepoint(savepoint);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "0");
        statement.executeUpdate("drop table SESSION.t2");
        this.rollback();
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", statement, "select * from SESSION.t1");
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", statement, "select * from SESSION.t2");
    }

    public void testSavepointRollbackbehaviour3() throws SQLException {
        Statement statement = this.createStatement();
        Savepoint savepoint = this.getConnection().setSavepoint();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        statement.executeUpdate("declare global temporary table SESSION.t2(c21 int, c22 int) on commit preserve rows  not logged");
        this.getConnection().releaseSavepoint(savepoint);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "0");
        Savepoint savepoint3 = this.getConnection().setSavepoint();
        this.getConnection().rollback(savepoint3);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "0");
        this.rollback();
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", statement, "select * from SESSION.t1");
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", statement, "select * from SESSION.t2");
    }

    public void testSavepointRollbackbehaviour4() throws SQLException {
        Statement statement = this.createStatement();
        Savepoint savepoint = this.getConnection().setSavepoint();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        statement.executeUpdate("drop table SESSION.t1");
        this.getConnection().rollback(savepoint2);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        this.commit();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        statement.executeUpdate("drop table SESSION.t1");
    }

    public void testSavepointRollbackbehaviour5() throws SQLException {
        Statement statement = this.createStatement();
        Savepoint savepoint = this.getConnection().setSavepoint();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        statement.executeUpdate("drop table SESSION.t1");
        this.getConnection().rollback(savepoint);
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", statement, "select * from SESSION.t1");
    }

    public void testSavepointRollbackbehaviour6() throws SQLException {
        String[] stringArray = new String[]{"C11", "C12"};
        String[] stringArray2 = new String[]{"C11", "C12", "C13"};
        Statement statement = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        statement.executeUpdate("insert into SESSION.t1 values(11, 11)");
        ResultSet resultSet = statement.executeQuery("select * from SESSION.t1");
        JDBC.assertColumnNames(resultSet, stringArray);
        this.getConnection().commit();
        Savepoint savepoint = this.getConnection().setSavepoint();
        statement.executeUpdate("drop table SESSION.t1");
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int, c13 int not null) on commit preserve rows not logged");
        statement.executeUpdate("insert into SESSION.t1 values(22, 22, 22)");
        resultSet = statement.executeQuery("select * from SESSION.t1");
        JDBC.assertColumnNames(resultSet, stringArray2);
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        statement.executeUpdate("drop table SESSION.t1");
        this.rollback();
        resultSet = statement.executeQuery("select * from SESSION.t1");
        JDBC.assertColumnNames(resultSet, stringArray);
        statement.executeUpdate("drop table SESSION.t1");
    }

    public void testSavepointRollbackbehaviour7() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged on rollback delete rows");
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged");
        statement.executeUpdate("insert into SESSION.t1 values(11, 1)");
        statement.executeUpdate("insert into session.t2 values(21, 1)");
        this.commit();
        statement.executeUpdate("insert into SESSION.t1 values(12, 2)");
        statement.executeUpdate("insert into SESSION.t2 values(22, 2)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "2");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "2");
        Savepoint savepoint = this.getConnection().setSavepoint();
        statement.executeUpdate("UPDATE SESSION.t1 SET c12 = 3 where c12>1");
        statement.executeUpdate("UPDATE SESSION.t2 SET c22 = 3 where c22>2");
        this.getConnection().rollback(savepoint);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "0");
        this.commit();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        statement.executeUpdate("drop table SESSION.t1");
        statement.executeUpdate("drop table SESSION.t2");
    }

    public void testSavepointRollbackbehaviour8() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged on rollback delete rows");
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows  not logged on rollback delete rows");
        statement.executeUpdate("insert into SESSION.t1 values(11, 1)");
        statement.executeUpdate("insert into session.t2 values(21, 1)");
        this.commit();
        statement.executeUpdate("insert into SESSION.t1 values(12, 2)");
        statement.executeUpdate("insert into session.t2 values(22, 2)");
        Savepoint savepoint = this.getConnection().setSavepoint();
        statement.executeUpdate("UPDATE SESSION.t1 SET c12 = 3 where c12>1");
        statement.executeUpdate("UPDATE SESSION.t2 SET c22 = 3 where c22>3");
        this.getConnection().rollback(savepoint);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        this.rollback();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        statement.executeUpdate("drop table SESSION.t1");
        statement.executeUpdate("drop table SESSION.t2");
    }

    public void testSavepointRollbackbehaviour9() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged on rollback delete rows");
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged on rollback delete rows");
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c31 int, c32 int) on commit preserve rows not logged on rollback delete rows");
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t4(c41 int, c42 int) on commit preserve rows not logged on rollback delete rows");
        statement.executeUpdate("insert into SESSION.t1 values(11, 1)");
        statement.executeUpdate("insert into SESSION.t2 values(21, 1)");
        statement.executeUpdate("insert into SESSION.t3 values(31, 1)");
        statement.executeUpdate("insert into SESSION.t4 values(41, 1)");
        this.commit();
        statement.executeUpdate("insert into SESSION.t1 values(12, 2)");
        statement.executeUpdate("insert into session.t2 values(22, 2)");
        statement.executeUpdate("insert into session.t3 values(32, 2)");
        Savepoint savepoint = this.getConnection().setSavepoint();
        statement.executeUpdate("DELETE FROM SESSION.t1 where c12>1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "1");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        statement.executeUpdate("DELETE FROM SESSION.t2 where c22>1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "1");
        this.getConnection().releaseSavepoint(savepoint2);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "1");
        this.getConnection().rollback(savepoint);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t3"), "2");
        this.rollback();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t3"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t4"), "1");
        statement.executeUpdate("drop table SESSION.t1");
        statement.executeUpdate("drop table SESSION.t2");
        statement.executeUpdate("drop table SESSION.t3");
        statement.executeUpdate("drop table SESSION.t4");
    }

    public void testSavepointRollbackbehaviour10() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged on rollback delete rows");
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged on rollback delete rows");
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c31 int, c32 int) on commit preserve rows not logged on rollback delete rows");
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t4(c41 int, c42 int) on commit preserve rows not logged on rollback delete rows");
        statement.executeUpdate("insert into SESSION.t1 values(11, 1)");
        statement.executeUpdate("insert into SESSION.t1 values(12, 2)");
        statement.executeUpdate("insert into SESSION.t2 values(21, 1)");
        statement.executeUpdate("insert into SESSION.t2 values(22, 2)");
        statement.executeUpdate("insert into SESSION.t3 values(31, 1)");
        statement.executeUpdate("insert into SESSION.t4 values(41, 1)");
        this.commit();
        statement.executeUpdate("insert into SESSION.t3 values(31, 2)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t3"), "2");
        Savepoint savepoint = this.getConnection().setSavepoint();
        statement.executeUpdate("DELETE FROM SESSION.t1 where c12>1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "1");
        statement.executeUpdate("DELETE FROM SESSION.t2 where c22>3");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "2");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        statement.executeUpdate("DELETE FROM SESSION.t2 where c22>1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "1");
        this.rollback();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t3"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t4"), "1");
        statement.executeUpdate("drop table SESSION.t1");
        statement.executeUpdate("drop table SESSION.t2");
        statement.executeUpdate("drop table SESSION.t3");
        statement.executeUpdate("drop table SESSION.t4");
    }

    public void testSavepointRollbackbehaviour11() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged on rollback delete rows");
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged on rollback delete rows");
        statement.executeUpdate("insert into SESSION.t1 values(11, 1)");
        statement.executeUpdate("insert into SESSION.t2 values(21, 1)");
        this.commit();
        statement.executeUpdate("insert into SESSION.t1 values(12, 2)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "2");
        Savepoint savepoint = this.getConnection().setSavepoint();
        statement.executeUpdate("insert into SESSION.t2 values(22, 2)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "2");
        this.getConnection().rollback(savepoint);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "2");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "0");
        this.commit();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "2");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "0");
        statement.executeUpdate("drop table SESSION.t1");
        statement.executeUpdate("drop table SESSION.t2");
    }

    public void testSavepointRollbackbehaviour12() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged");
        statement.executeUpdate("insert into SESSION.t1 values(11, 1)");
        statement.executeUpdate("insert into SESSION.t1 values(12, 2)");
        this.commit();
        Savepoint savepoint = this.getConnection().setSavepoint();
        statement.executeUpdate("insert into SESSION.t1 values(13, 3)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "3");
        this.getConnection().releaseSavepoint(savepoint);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "3");
        this.rollback();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        statement.executeUpdate("drop table SESSION.t1");
    }

    public void testSavepointRollbackbehaviour13() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged on commit preserve rows");
        PreparedStatement preparedStatement = this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        preparedStatement.setInt(1, 21);
        preparedStatement.setInt(2, 1);
        preparedStatement.execute();
        preparedStatement.setInt(1, 22);
        preparedStatement.setInt(2, 2);
        preparedStatement.execute();
        preparedStatement.setInt(1, 23);
        preparedStatement.setInt(2, 2);
        preparedStatement.execute();
        PreparedStatement preparedStatement2 = this.prepareStatement("UPDATE SESSION.t2 SET c22 = 3 where c21=?");
        preparedStatement2.setInt(1, 23);
        preparedStatement2.execute();
        PreparedStatement preparedStatement3 = this.prepareStatement("DELETE FROM SESSION.t2 where c21 = ?");
        preparedStatement3.setInt(1, 23);
        preparedStatement3.execute();
        this.commit();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "2");
        Savepoint savepoint = this.getConnection().setSavepoint();
        preparedStatement.setInt(1, 23);
        preparedStatement.setInt(2, 2);
        preparedStatement.execute();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "3");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        preparedStatement2.setInt(1, 23);
        preparedStatement2.execute();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "3");
        this.getConnection().rollback(savepoint2);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "0");
        Savepoint savepoint3 = this.getConnection().setSavepoint();
        preparedStatement.setInt(1, 21);
        preparedStatement.setInt(2, 1);
        preparedStatement.execute();
        preparedStatement.setInt(1, 22);
        preparedStatement.setInt(2, 2);
        preparedStatement.execute();
        preparedStatement.setInt(1, 23);
        preparedStatement.setInt(2, 333);
        preparedStatement.execute();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "3");
        Savepoint savepoint4 = this.getConnection().setSavepoint();
        preparedStatement2.setInt(1, 23);
        preparedStatement2.execute();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "3");
        this.getConnection().releaseSavepoint(savepoint4);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "3");
        preparedStatement3.setInt(1, 23);
        preparedStatement3.execute();
        this.commit();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t2"), "2");
        statement.executeUpdate("drop table SESSION.t2");
    }

    public void testTest4() throws SQLException {
        Statement statement = this.getConnection().createStatement(1003, 1007, 1);
        try {
            statement.executeUpdate("drop table t1");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaJDBC30Test.assertSQLState("42Y55", sQLException);
        }
        statement.executeUpdate("create table t1(c11 int, c12 int)");
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit delete rows not logged");
        statement.executeUpdate("insert into session.t1 values(11, 1)");
        statement.executeUpdate("insert into session.t1 values(12, 2)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "2");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from t1"), "0");
        statement.executeUpdate("INSERT INTO T1 SELECT * FROM SESSION.T1");
        this.commit();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from t1"), "2");
        statement.executeUpdate("drop table SESSION.t1");
        statement.executeUpdate("drop table t1");
    }

    public void testPooledConnectionClosed() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("CREATE schema SESSION");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaJDBC30Test.assertSQLState("X0Y68", sQLException);
        }
        statement.executeUpdate("CREATE TABLE SESSION.tx(c21 int)");
        statement.executeUpdate("insert into SESSION.tx values(11)");
        statement.executeUpdate("insert into SESSION.tx values(12)");
        statement.executeUpdate("insert into SESSION.tx values(13)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.tx"), "3");
        statement.executeUpdate("declare global temporary table SESSION.tx(c11 int, c12 int) on commit preserve rows not logged");
        statement.executeUpdate("insert into SESSION.tx values(11,1)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.tx"), "1");
        this.commit();
        this.getConnection().close();
        statement = this.getConnection().createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.tx"), "3");
        statement.executeUpdate("drop table SESSION.tx");
    }

    public void test_derby_6189() throws Exception {
        Connection connection = this.getConnection();
        connection.prepareStatement("DECLARE GLOBAL TEMPORARY TABLE SESSION.t6189( c21 int, c22 int) not logged on commit preserve rows").execute();
        PreparedStatement preparedStatement = connection.prepareStatement("insert into SESSION.t6189 values (23, 1)");
        preparedStatement.execute();
        connection.rollback();
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", preparedStatement);
    }
}

