/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Bug4356Test
extends BaseJDBCTestCase {
    public Bug4356Test(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(Bug4356Test.class)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("CREATE TABLE T1 (a integer, b integer)");
                statement.executeUpdate("CREATE TABLE T2 (a integer)");
                statement.executeUpdate("INSERT INTO T2 VALUES(1)");
            }
        };
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBug4356() throws SQLException {
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO T1 VALUES (?,(select count(*) from t2 where a = ?)) ");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 1);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 2);
        preparedStatement.setInt(2, 2);
        preparedStatement.executeUpdate();
        this.commit();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM T1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "1"}, {"2", "0"}});
        resultSet.close();
        statement.close();
    }
}

