/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SSLTest
extends BaseJDBCTestCase {
    public SSLTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("SSLTest");
        if (!TestConfiguration.loadingFromJars()) {
            return baseTestSuite;
        }
        if (!Derby.hasServer()) {
            return baseTestSuite;
        }
        if (SSLTest.vmAtLeast(1, 10)) {
            return baseTestSuite;
        }
        baseTestSuite.addTest(SSLTest.decorateTest("testSSLBasicDSConnect"));
        baseTestSuite.addTest(SSLTest.decorateTest("testSSLBasicDSPlainConnect"));
        return baseTestSuite;
    }

    private static Test decorateTest(String string) {
        SSLTest sSLTest = new SSLTest(string);
        String[] stringArray = SSLTest.getStartupProperties();
        String[] stringArray2 = new String[]{};
        NetworkServerTestSetup networkServerTestSetup = new NetworkServerTestSetup((Test)sSLTest, stringArray, stringArray2, true);
        TestSetup testSetup = networkServerTestSetup;
        testSetup = new SupportFilesSetup((Test)testSetup, null, new String[]{"functionTests/tests/derbynet/SSLTestServerKey.key"}, null, new String[]{"SSLTestServerKey.key"});
        Test test = TestConfiguration.defaultServerDecorator((Test)testSetup);
        test = TestConfiguration.changeSSLDecorator(test, "basic");
        return test;
    }

    private static String[] getStartupProperties() {
        return new String[]{"javax.net.ssl.keyStore=extinout/SSLTestServerKey.key", "javax.net.ssl.keyStorePassword=qwerty"};
    }

    public void testSSLBasicDSConnect() throws Exception {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
        JDBCDataSource.setBeanProperty(dataSource, "ssl", "basic");
        Connection connection = dataSource.getConnection();
        connection.close();
    }

    public void testSSLBasicDSPlainConnect() throws Exception {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
        try {
            Connection connection = dataSource.getConnection();
            connection.close();
            SSLTest.fail();
        }
        catch (SQLException sQLException) {
            SSLTest.assertSQLState("08006", sQLException);
        }
    }
}

