/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.compatibility;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.tests.compatibility.VersionCombinationConfigurator;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.DerbyDistribution;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.ServerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class _Suite
extends BaseJDBCTestCase {
    static final String INCLUDE_RELEASES = "derby.tests.compat.includeReleases";
    static final String EXCLUDE_RELEASES = "derby.tests.compat.excludeReleases";
    protected static VersionCombinationConfigurator configurator;

    private static int addVersionCombinations(BaseTestSuite suite) {
        String include = _Suite.getSystemProperty(INCLUDE_RELEASES);
        String exclude = _Suite.getSystemProperty(EXCLUDE_RELEASES);
        List<DerbyVersion> toInclude = _Suite.parseVersionList(include);
        List<DerbyVersion> toExclude = _Suite.parseVersionList(exclude);
        if (configurator == null) {
            configurator = VersionCombinationConfigurator.getInstanceDevMATS();
        }
        suite.setName("Compatibility suite, " + configurator.getName());
        configurator.setIncludes(toInclude);
        configurator.setExcludes(toExclude);
        return configurator.addTests(suite);
    }

    private static List<DerbyVersion> parseVersionList(String versions) {
        if (versions == null || versions.length() == 0) {
            return Collections.emptyList();
        }
        String[] vlist = versions.split(",");
        ArrayList<DerbyVersion> ret = new ArrayList<DerbyVersion>(vlist.length);
        for (String v : vlist) {
            try {
                ret.add(DerbyVersion.parseVersionString(v));
            }
            catch (IllegalArgumentException iae) {
                _Suite.alarm("badly formatted version string: " + v);
            }
        }
        return ret;
    }

    public _Suite(String name) {
        super(name);
        throw new IllegalStateException("invoke suite() instead");
    }

    public static Test suite() {
        if (JVMInfo.isModuleAware()) {
            return new BaseTestSuite("tests.compatibility disabled when using a module path");
        }
        if (_Suite.suffersFromDerby5889()) {
            String msg = "tests.compatibility disabled on Windows with UNC paths, see DERBY-5889";
            _Suite.println(msg);
            return new BaseTestSuite(msg);
        }
        if (!TestConfiguration.loadingFromJars()) {
            return new BaseTestSuite("Compatibility tests skipped becasue they need to run from jars");
        }
        if (!Derby.hasClient() || !Derby.hasServer()) {
            return new BaseTestSuite("Compatibility tests skipped because client or server is missing");
        }
        BaseTestSuite suite = new BaseTestSuite();
        _Suite.addVersionCombinations(suite);
        TestConfiguration config = TestConfiguration.getCurrent();
        return new ServerSetup((Test)suite, "localhost", config.getPort());
    }

    public static boolean suffersFromDerby5889() {
        if (!_Suite.isWindowsPlatform()) {
            return false;
        }
        DerbyDistribution[] dists = TestConfiguration.getReleaseRepository().getDistributions();
        for (int i = 0; i < dists.length; ++i) {
            if (!dists[i].getDerbyEngineJarPath().startsWith("\\\\")) continue;
            return true;
        }
        return false;
    }
}

