/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Barrier;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DeadlockDetectionTest
extends BaseJDBCTestCase {
    private static final String DEADLOCK = "40001";

    public static Test suite() {
        Test test = TestConfiguration.embeddedSuite(DeadlockDetectionTest.class);
        test = DatabasePropertyTestSetup.setLockTimeouts(test, 1, 30);
        return new CleanDatabaseTestSetup(test);
    }

    public DeadlockDetectionTest(String string) {
        super(string);
    }

    public void testDerby3980_repeatable_read() throws Exception {
        int n;
        Statement statement = this.createStatement();
        statement.executeUpdate("create table derby3980 (i int)");
        statement.executeUpdate("insert into derby3980 values 1956, 180, 456, 3");
        Thread[] threadArray = new Thread[2];
        Connection[] connectionArray = new Connection[threadArray.length];
        final Barrier barrier = new Barrier(threadArray.length);
        List<Object> list = Collections.synchronizedList(new ArrayList());
        for (n = 0; n < threadArray.length; ++n) {
            Object object = this.openDefaultConnection();
            object.setTransactionIsolation(4);
            object.setAutoCommit(false);
            final PreparedStatement preparedStatement = object.prepareStatement("select * from derby3980 where i = 456");
            final PreparedStatement preparedStatement2 = object.prepareStatement("update derby3980 set i = 456 where i = 456");
            threadArray[n] = new Thread(this, (Connection)object, list){
                final /* synthetic */ Connection val$c;
                final /* synthetic */ List val$exceptions;
                {
                    this.val$c = connection;
                    this.val$exceptions = list;
                }

                @Override
                public void run() {
                    try {
                        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "456");
                        barrier.await();
                        BaseJDBCTestCase.assertUpdateCount(preparedStatement2, 1);
                        this.val$c.rollback();
                    }
                    catch (Exception exception) {
                        this.val$exceptions.add(exception);
                    }
                }
            };
            connectionArray[n] = object;
            threadArray[n].start();
        }
        for (n = 0; n < threadArray.length; ++n) {
            threadArray[n].join();
            connectionArray[n].rollback();
            connectionArray[n].close();
        }
        for (Object object : list) {
            if (object instanceof SQLException) {
                DeadlockDetectionTest.assertSQLState(DEADLOCK, (SQLException)object);
                continue;
            }
            throw object;
        }
        DeadlockDetectionTest.assertEquals((String)"Number of victims", (int)1, (int)list.size());
    }

    public void testDerby5073_dodgy_victims() throws Exception {
        int n;
        int n2;
        Statement statement = this.createStatement();
        statement.executeUpdate("create table derby5073(x int primary key, y int)");
        statement.executeUpdate("insert into derby5073(x) values 0, 1, 2");
        Connection[] connectionArray = new Connection[6];
        Thread[] threadArray = new Thread[connectionArray.length];
        for (n2 = 0; n2 < connectionArray.length; ++n2) {
            connectionArray[n2] = this.openDefaultConnection();
            connectionArray[n2].setAutoCommit(false);
        }
        for (n2 = 3; n2 < 6; ++n2) {
            PreparedStatement preparedStatement = connectionArray[n2].prepareStatement("update derby5073 set y = x where x = ?");
            preparedStatement.setInt(1, n2 % 3);
            DeadlockDetectionTest.assertUpdateCount(preparedStatement, 1);
        }
        List<Object> list = Collections.synchronizedList(new ArrayList());
        for (n = 0; n < threadArray.length; ++n) {
            Object object = connectionArray[n].prepareStatement("select x from derby5073 where x = ?");
            int n3 = (n + 1) % 3;
            object.setInt(1, n3);
            threadArray[n] = new Thread(this, (PreparedStatement)object, n3, list){
                final /* synthetic */ PreparedStatement val$ps;
                final /* synthetic */ int val$row;
                final /* synthetic */ List val$exceptions;
                {
                    this.val$ps = preparedStatement;
                    this.val$row = n;
                    this.val$exceptions = list;
                }

                @Override
                public void run() {
                    try {
                        JDBC.assertSingleValueResultSet(this.val$ps.executeQuery(), Integer.toString(this.val$row));
                        this.val$ps.getConnection().commit();
                    }
                    catch (Exception exception) {
                        this.val$exceptions.add(exception);
                    }
                }
            };
            threadArray[n].start();
            if (n != 2) continue;
            Thread.sleep(100L);
        }
        for (n = 0; n < threadArray.length; ++n) {
            threadArray[n].join();
            connectionArray[n].rollback();
            connectionArray[n].close();
        }
        for (Object object : list) {
            if (object instanceof SQLException) {
                DeadlockDetectionTest.assertSQLState(DEADLOCK, (SQLException)object);
                continue;
            }
            throw object;
        }
        DeadlockDetectionTest.assertEquals((String)"Number of victims", (int)1, (int)list.size());
    }
}

