/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;

public class T_RowSource
implements RowSource {
    public static final int INTEGER_ROW_TYPE = 1;
    public static final int STRING_ROW_TYPE = 2;
    protected static final String REC_001 = "McLaren";
    protected static final String REC_002 = "Ferrari";
    protected static final String REC_003 = "Benetton";
    protected static final String REC_004 = "Prost";
    protected static final String REC_005 = "Tyrell";
    protected static final String REC_006 = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
    protected static final String REC_007 = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
    protected static final String REC_008 = "z";
    protected static final int DEFAULT_ROW_COUNT = 500000;
    protected static final int DEFAULT_COLUMN_COUNT = 13;
    protected static final int DEFAULT_SEED = 53;
    private int rowCount;
    private int columnCount;
    private DataValueDescriptor[] row;
    private FormatableBitSet validColumns;
    private boolean forceAbort;
    private Transaction t;

    public T_RowSource() {
        this.rowCount = 500000;
        this.columnCount = 13;
        this.row = new DataValueDescriptor[13];
        this.row = this.setStringRow();
    }

    public T_RowSource(int n, int n2, int n3, boolean bl, Transaction transaction) {
        this.rowCount = n;
        this.columnCount = n2;
        this.validColumns = new FormatableBitSet(n2);
        for (int i = 0; i < n2; ++i) {
            this.validColumns.set(i);
        }
        this.row = new DataValueDescriptor[n2];
        if (n3 == 1) {
            this.setIntegerRow();
        } else {
            this.row = this.setStringRow();
        }
        this.forceAbort = bl;
        this.t = transaction;
    }

    public T_RowSource(int n, int n2, int n3, FormatableBitSet formatableBitSet) {
        this.rowCount = n;
        this.columnCount = n2;
        this.validColumns = formatableBitSet;
        this.row = new DataValueDescriptor[n2];
        if (n3 == 1) {
            this.setIntegerRow();
        } else {
            this.row = this.setStringRow();
        }
    }

    public boolean hasMoreRows() throws StandardException {
        return this.rowCount > 0;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        if (this.rowCount <= 0) {
            return null;
        }
        if (this.forceAbort && this.rowCount < 3) {
            this.t.abort();
        }
        --this.rowCount;
        return this.row;
    }

    public FormatableBitSet getValidColumns() {
        return this.validColumns;
    }

    public void closeRowSource() {
        this.rowCount = 0;
    }

    public boolean needsRowLocation() {
        return false;
    }

    public boolean needsToClone() {
        return true;
    }

    public void rowLocation(RowLocation rowLocation) {
        rowLocation = null;
    }

    public DataValueDescriptor[] getTemplate() throws StandardException {
        return this.row;
    }

    private void setIntegerRow() {
        for (int i = 0; i < this.columnCount; ++i) {
            this.row[i] = new SQLInteger(i + 53);
        }
    }

    private DataValueDescriptor[] setStringRow() {
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(this.columnCount);
        block15: for (int i = 0; i < this.columnCount; ++i) {
            switch (i % 13) {
                case 0: {
                    t_RawStoreRow.setColumn(i, (String)null);
                    continue block15;
                }
                case 1: {
                    t_RawStoreRow.setColumn(i, REC_001);
                    continue block15;
                }
                case 2: {
                    t_RawStoreRow.setColumn(i, REC_002);
                    continue block15;
                }
                case 3: {
                    t_RawStoreRow.setColumn(i, REC_003);
                    continue block15;
                }
                case 4: {
                    t_RawStoreRow.setColumn(i, REC_004);
                    continue block15;
                }
                case 5: {
                    t_RawStoreRow.setColumn(i, REC_005);
                    continue block15;
                }
                case 6: {
                    t_RawStoreRow.setColumn(i, REC_006);
                    continue block15;
                }
                case 7: {
                    t_RawStoreRow.setColumn(i, REC_007);
                    continue block15;
                }
                case 8: {
                    t_RawStoreRow.setColumn(i, (String)null);
                    continue block15;
                }
                case 9: {
                    t_RawStoreRow.setColumn(i, REC_008);
                    continue block15;
                }
                case 10: {
                    t_RawStoreRow.setColumn(i, REC_007);
                    continue block15;
                }
                case 11: {
                    t_RawStoreRow.setColumn(i, (String)null);
                    continue block15;
                }
                case 12: {
                    t_RawStoreRow.setColumn(i, REC_006);
                    continue block15;
                }
                default: {
                    t_RawStoreRow.setColumn(i, REC_008);
                }
            }
        }
        return t_RawStoreRow.getRow();
    }
}

