/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.sql.SQLException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.shared.common.error.StandardException;

public class T_ConsistencyChecker {
    private DataDictionary dd;
    private TransactionController tc;
    private LanguageConnectionContext lcc;
    private String indexName;
    private String schemaName;
    private String tableName;
    private ConglomerateDescriptor id;
    private SchemaDescriptor sd;
    private TableDescriptor td;

    T_ConsistencyChecker(String string, String string2, String string3) throws StandardException {
        this.schemaName = string;
        this.tableName = string2;
        this.indexName = string3;
    }

    public static void deleteFirstHeapRow(String string, String string2) throws StandardException {
        T_ConsistencyChecker t_ConsistencyChecker = new T_ConsistencyChecker(string, string2, null);
        t_ConsistencyChecker.getContexts();
        t_ConsistencyChecker.getDescriptors();
        ScanController scanController = t_ConsistencyChecker.openUnqualifiedHeapScan();
        scanController.next();
        scanController.delete();
        scanController.close();
    }

    public static void reinsertFirstHeapRow(String string, String string2) throws StandardException {
        T_ConsistencyChecker t_ConsistencyChecker = new T_ConsistencyChecker(string, string2, null);
        t_ConsistencyChecker.getContexts();
        t_ConsistencyChecker.getDescriptors();
        ScanController scanController = t_ConsistencyChecker.openUnqualifiedHeapScan();
        scanController.next();
        ExecRow execRow = t_ConsistencyChecker.getHeapRowOfNulls();
        scanController.fetch(execRow.getRowArray());
        scanController.close();
        ConglomerateController conglomerateController = t_ConsistencyChecker.openHeapCC();
        conglomerateController.insert(execRow.getRowArray());
        conglomerateController.close();
    }

    public static void nullFirstHeapRow(String string, String string2) throws StandardException {
        T_ConsistencyChecker t_ConsistencyChecker = new T_ConsistencyChecker(string, string2, null);
        t_ConsistencyChecker.getContexts();
        t_ConsistencyChecker.getDescriptors();
        ScanController scanController = t_ConsistencyChecker.openUnqualifiedHeapScan();
        scanController.next();
        RowLocation rowLocation = scanController.newRowLocationTemplate();
        scanController.fetchLocation(rowLocation);
        scanController.replace(t_ConsistencyChecker.getHeapRowOfNulls().getRowArray(), (FormatableBitSet)null);
        scanController.close();
    }

    public static void insertBadRowLocation(String string, String string2, String string3) throws StandardException {
        T_ConsistencyChecker t_ConsistencyChecker = new T_ConsistencyChecker(string, string2, string3);
        t_ConsistencyChecker.getContexts();
        t_ConsistencyChecker.getDescriptors();
        ScanController scanController = t_ConsistencyChecker.openUnqualifiedHeapScan();
        RowLocation rowLocation = scanController.newRowLocationTemplate();
        RowLocation rowLocation2 = scanController.newRowLocationTemplate();
        scanController.close();
        ExecRow execRow = t_ConsistencyChecker.getIndexTemplateRow(rowLocation);
        ScanController scanController2 = t_ConsistencyChecker.openUnqualifiedIndexScan();
        scanController2.next();
        scanController2.fetch(execRow.getRowArray());
        scanController2.close();
        int n = t_ConsistencyChecker.getIndexDescriptor().getIndexDescriptor().baseColumnPositions().length;
        execRow.setColumn(n + 1, (DataValueDescriptor)rowLocation2);
        ConglomerateController conglomerateController = t_ConsistencyChecker.openIndexCC();
        conglomerateController.insert(execRow.getRowArray());
        conglomerateController.close();
    }

    public static void swapColumnsInFirstHeapRow(String string, String string2, int n, int n2) throws StandardException {
    }

    private void getContexts() throws StandardException {
        this.lcc = (LanguageConnectionContext)T_ConsistencyChecker.getContext("LanguageConnectionContext");
        this.tc = this.lcc.getTransactionExecute();
        this.dd = this.lcc.getDataDictionary();
    }

    private void getDescriptors() throws StandardException {
        this.sd = this.dd.getSchemaDescriptor(this.schemaName, this.tc, true);
        this.td = this.dd.getTableDescriptor(this.tableName, this.sd, this.tc);
        if (this.td == null) {
            throw StandardException.newException((String)"42X05", (Object[])new Object[]{this.schemaName + "." + this.tableName});
        }
        if (this.indexName != null) {
            this.id = this.dd.getConglomerateDescriptor(this.indexName, this.sd, true);
            if (this.id == null) {
                throw StandardException.newException((String)"42X65", (Object[])new Object[]{this.indexName});
            }
        }
    }

    private ExecRow getHeapRowOfNulls() throws StandardException {
        ConglomerateController conglomerateController = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 0, 7, 5);
        ExecRow execRow = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getValueRow(this.td.getNumberOfColumns());
        ColumnDescriptorList columnDescriptorList = this.td.getColumnDescriptorList();
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
            execRow.setColumn(columnDescriptor.getPosition(), dataTypeDescriptor.getNull());
        }
        conglomerateController.close();
        return execRow;
    }

    private ScanController openUnqualifiedHeapScan() throws StandardException {
        ScanController scanController = this.tc.openScan(this.td.getHeapConglomerateId(), false, 4, 7, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        return scanController;
    }

    private ConglomerateController openHeapCC() throws StandardException {
        ConglomerateController conglomerateController = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        return conglomerateController;
    }

    private ExecRow getIndexTemplateRow(RowLocation rowLocation) throws StandardException {
        int n;
        int n2 = 0;
        int[] nArray = this.id.getIndexDescriptor().baseColumnPositions();
        n2 = nArray.length;
        FormatableBitSet formatableBitSet = new FormatableBitSet();
        for (n = 0; n < n2; ++n) {
            formatableBitSet.grow(nArray[n]);
            formatableBitSet.set(nArray[n] - 1);
        }
        ExecRow execRow = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getValueRow(n2 + 1);
        for (n = 0; n < n2; ++n) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(nArray[n]);
            DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
            execRow.setColumn(n + 1, dataTypeDescriptor.getNull());
        }
        execRow.setColumn(n2 + 1, (DataValueDescriptor)rowLocation);
        return execRow;
    }

    private ScanController openUnqualifiedIndexScan() throws StandardException {
        ScanController scanController = this.tc.openScan(this.id.getConglomerateNumber(), false, 4, 7, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        return scanController;
    }

    private ConglomerateController openIndexCC() throws StandardException {
        ConglomerateController conglomerateController = this.tc.openConglomerate(this.id.getConglomerateNumber(), false, 4, 7, 5);
        return conglomerateController;
    }

    private ConglomerateDescriptor getIndexDescriptor() {
        return this.id;
    }

    public static String runConsistencyChecker() throws StandardException, SQLException {
        return T_ConsistencyChecker.countOpens() + T_ConsistencyChecker.countDependencies();
    }

    public static String countOpens() throws StandardException {
        int n = 0;
        Object object = "No open scans, etc.\n";
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)T_ConsistencyChecker.getContext("LanguageConnectionContext");
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        n = transactionController.countOpens(5);
        if (n > 0) {
            object = n + " conglomerates/scans/sorts found open\n";
        }
        return object;
    }

    public static String countDependencies() throws StandardException, SQLException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)T_ConsistencyChecker.getContext("LanguageConnectionContext");
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        n = dependencyManager.countDependencies();
        if (n > 0) {
            stringBuffer.append(n + " dependencies found");
        } else {
            stringBuffer.append("No outstanding dependencies.\n");
        }
        return stringBuffer.toString();
    }

    private static Context getContext(String string) {
        return ContextService.getContext((String)string);
    }
}

