/*

   Derby - Class org.apache.derby.catalog.DefaultInfo

   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */

package org.apache.derby.catalog;

/**
 <p>An interface for describing a default for a column or parameter in Derby systems.</p>
 */
public interface DefaultInfo
{
	/**
	 * Get the text of a default.
	 *
	 * @return The text of the default.
	 */
	public String getDefaultText();
	
	/**
	 * If this default is a generation clause, then return the names of
	 * other columns in the row which the generation clause references.
     *
     * @return the referenced column names
	 */
	public String[] getReferencedColumnNames();
	
	
	/**
	 * Is default value generated by auto increment?
	 *
	 * @return true if always generated by auto increment.
	 */
	
	//ToCleanUp
	//Additional definitive information of AutoIncremnt 
	//such as autoIncrementStart and autoInrementInc 
	//should be gotten from this interface.

	public boolean isDefaultValueAutoinc();

	/**
	 * Return true if this is the generation clause for a generated column.
     *
     * @return true if this is the generation clause for a generated column.
	 */
	public boolean isGeneratedColumn();
	
	/**
	 * Return the name of the current schema when the default was created. This
	 * is filled in for generated columns.
     *
     * @return the name of the current schema when the default was created
	 */
	public String   getOriginalCurrentSchema();
	

}
