/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.util.Properties;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.ChangeConfigurationSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Decorator {
    private Decorator() {
    }

    public static Test encryptedDatabase(Test test) {
        return Decorator.encryptedDatabaseBpw(test, Decorator.getBootPhrase(16));
    }

    public static Test encryptedDatabaseBpw(Test test, String string) {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("no encryption support");
        }
        Properties properties = new Properties();
        properties.setProperty("dataEncryption", "true");
        properties.setProperty("bootPassword", string);
        return Decorator.attributesDatabase(properties, test);
    }

    public static Test encryptedDatabase(Test test, String string) {
        return Decorator.encryptedDatabaseBpw(test, string, Decorator.getBootPhrase(16));
    }

    public static Test encryptedDatabaseBpw(Test test, String string, String string2) {
        Properties properties = new Properties();
        properties.setProperty("dataEncryption", "true");
        properties.setProperty("bootPassword", string2);
        properties.setProperty("encryptionAlgorithm", string);
        return Decorator.attributesDatabase(properties, test);
    }

    private static String getBootPhrase(int n) {
        Random random = new Random();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = (char)random.nextInt();
            if (!Character.isLetterOrDigit(c)) continue;
            cArray[n2++] = c;
        }
        return new String(cArray);
    }

    public static Test territoryCollatedDatabase(Test test, String string) {
        Properties properties = new Properties();
        properties.setProperty("collation", "TERRITORY_BASED");
        if (string != null) {
            properties.setProperty("territory", string);
        }
        return Decorator.attributesDatabase(properties, test);
    }

    public static Test logDeviceAttributeDatabase(Test test, String string) {
        Properties properties = new Properties();
        if (string != null) {
            properties.setProperty("logDevice", string);
        }
        test = TestConfiguration.singleUseDatabaseDecorator(test);
        return Decorator.attributesDatabase(properties, test);
    }

    public static Test territoryCollatedCaseInsensitiveDatabase(Test test, String string) {
        Properties properties = new Properties();
        properties.setProperty("collation", "TERRITORY_BASED:SECONDARY");
        if (string != null) {
            properties.setProperty("territory", string);
        }
        return Decorator.attributesDatabase(properties, test);
    }

    public static Test attributesDatabase(final Properties properties, Test object) {
        object = new ChangeConfigurationSetup((Test)object){

            @Override
            TestConfiguration getNewConfiguration(TestConfiguration testConfiguration) {
                return testConfiguration.addConnectionAttributes(properties);
            }
        };
        return TestConfiguration.singleUseDatabaseDecorator(object);
    }
}

