/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class QueryPlanTest
extends BaseJDBCTestCase {
    public QueryPlanTest(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.optimizer.noTimeout", "true");
        return new CleanDatabaseTestSetup((Test)new SystemPropertyTestSetup(TestConfiguration.embeddedSuite(QueryPlanTest.class), properties, true));
    }

    public void testDerby6011PreferUniqueIndex() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE jobs(id BIGINT PRIMARY KEY)");
        statement.execute("CREATE TABLE jobqueue(docpriority FLOAT, id BIGINT PRIMARY KEY, priorityset BIGINT, docid CLOB NOT NULL, failcount BIGINT, status CHAR(1) NOT NULL, dochash VARCHAR(40) NOT NULL, isseed CHAR(1), checktime BIGINT, checkaction CHAR(1), jobid BIGINT NOT NULL CONSTRAINT jobs_fk REFERENCES jobs, failtime BIGINT)");
        statement.execute("CREATE UNIQUE INDEX DOCHASH_JOBID_IDX ON jobqueue(dochash, jobid)");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        PreparedStatement preparedStatement = this.prepareStatement("SELECT id,status,checktime FROM jobqueue WHERE dochash=? AND jobid=? FOR UPDATE");
        preparedStatement.setString(1, "");
        preparedStatement.setInt(2, 0);
        JDBC.assertEmpty(preparedStatement.executeQuery());
        this.assertIndex("JOBQUEUE", "DOCHASH_JOBID_IDX");
        statement.execute("create table t1(a int not null, b int not null, c int not null, d int not null, e blob)");
        statement.execute("create index idx_t1_a on t1(a)");
        statement.execute("create unique index uidx_t1_a on t1(a)");
        preparedStatement = this.prepareStatement("select * from t1 where a = ?");
        preparedStatement.setInt(1, 1);
        JDBC.assertEmpty(preparedStatement.executeQuery());
        this.assertIndex("T1", "UIDX_T1_A");
        statement.execute("drop index uidx_t1_a");
        statement.execute("create index idx_t1_ab on t1(a,b)");
        statement.execute("create unique index uidx_t1_ab on t1(a,b)");
        preparedStatement = this.prepareStatement("select * from t1 where a = ? and b = ?");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 2);
        JDBC.assertEmpty(preparedStatement.executeQuery());
        this.assertIndex("T1", "UIDX_T1_AB");
        statement.execute("drop index uidx_t1_ab");
        statement.execute("create index idx_t1_abc on t1(a,b,c)");
        statement.execute("create unique index uidx_t1_abc on t1(a,b,c)");
        preparedStatement = this.prepareStatement("select * from t1 where a = ? and b = ? and c = ?");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 2);
        preparedStatement.setInt(3, 3);
        JDBC.assertEmpty(preparedStatement.executeQuery());
        this.assertIndex("T1", "UIDX_T1_ABC");
        statement.execute("drop index uidx_t1_abc");
        statement.execute("create unique index uidx_t1_abcd on t1(a,b,c,d)");
        preparedStatement = this.prepareStatement("select * from t1 where a = ? and b = ? and c = ? and d = ?");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 2);
        preparedStatement.setInt(3, 3);
        preparedStatement.setInt(4, 4);
        JDBC.assertEmpty(preparedStatement.executeQuery());
        this.assertIndex("T1", "UIDX_T1_ABCD");
        statement.execute("create table t2(a varchar(200) not null, b varchar(200) not null, c varchar(200) not null)");
        statement.execute("create unique index uidx_t2_ab on t1(a,b)");
        statement.execute("create index idx_t2_abc on t2(a,b,c)");
        preparedStatement = this.prepareStatement("select * from t2 where a = ? and b = ? and c = ?");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 2);
        preparedStatement.setInt(3, 3);
        JDBC.assertEmpty(preparedStatement.executeQuery());
        this.assertIndex("T2", "IDX_T2_ABC");
    }

    private void assertIndex(String string, String string2) throws SQLException {
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(this.createStatement());
        if (!runtimeStatisticsParser.usedSpecificIndexForIndexScan(string, string2)) {
            QueryPlanTest.fail((String)("Should have used index " + string2 + " when accessing table " + string + ". Actual plan:\n" + runtimeStatisticsParser));
        }
    }
}

