/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

abstract class ConstantNode
extends ValueNode {
    DataValueDescriptor value;

    ConstantNode(TypeId typeId, boolean bl, int n, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.setType(typeId, bl, n);
    }

    ConstantNode(ContextManager contextManager) {
        super(contextManager);
    }

    void setValue(DataValueDescriptor dataValueDescriptor) {
        this.value = dataValueDescriptor;
    }

    DataValueDescriptor getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    boolean isCloneable() {
        return true;
    }

    @Override
    ValueNode getClone() {
        return this;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return true;
    }

    @Override
    boolean constantExpression(PredicateList predicateList) {
        return true;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.isNull()) {
            expressionClassBuilder.generateNull(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        } else {
            this.generateConstant(expressionClassBuilder, methodBuilder);
            expressionClassBuilder.generateDataValue(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType(), null);
        }
    }

    abstract void generateConstant(ExpressionClassBuilder var1, MethodBuilder var2) throws StandardException;

    boolean isNull() {
        return this.value == null || this.value.isNull();
    }

    @Override
    protected int getOrderableVariantType() {
        return 3;
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (this.isSameNodeKind(valueNode)) {
            ConstantNode constantNode = (ConstantNode)valueNode;
            return constantNode.getValue() == null && this.getValue() == null || constantNode.getValue() != null && constantNode.getValue().compare(this.getValue()) == 0;
        }
        return false;
    }
}

