/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.Formatters;

public class dbManagerLimits {
    public static void main(String[] stringArray) throws Throwable {
        ij.getPropertyArg((String[])stringArray);
        Connection connection = ij.startJBMS();
        dbManagerLimits.testStringAndHexConstants(connection);
        dbManagerLimits.testMostColumnsInTable(connection);
        dbManagerLimits.testMostColumnsInView(connection);
        dbManagerLimits.testMostElementsInSelectList(connection);
        dbManagerLimits.testMostElementsInOrderBy(connection);
        dbManagerLimits.testMostParametersInStoredProcedures(connection);
    }

    public static void testStringAndHexConstants(Connection connection) throws Throwable {
        try {
            System.out.println("Test - maximum length of character constant is 32672 and that of hex constant is 16336");
            String string = Formatters.repeatChar("a", 32671);
            String string2 = Formatters.repeatChar("a", 16334);
            Statement statement = connection.createStatement();
            statement.executeUpdate("create table t1 (c11 long varchar, c12 long varchar for bit data)");
            System.out.println("First testing less than maximum constant lengths through insert statement");
            statement.executeUpdate("insert into t1(c11) values ('" + string + "')");
            statement.executeUpdate("insert into t1(c12) values (X'" + string2 + "')");
            System.out.println("Next testing less than maximum constant lengths through values");
            statement.execute("values ('" + string + "')");
            statement.execute("values (X'" + string2 + "')");
            System.out.println("Next testing maximum constant lengths through insert statement");
            statement.executeUpdate("insert into t1(c11) values ('" + string + "a')");
            statement.executeUpdate("insert into t1(c12) values (X'" + string2 + "ab')");
            System.out.println("Next testing maximum constant lengths through values");
            statement.execute("values ('" + string + "a')");
            statement.execute("values (X'" + string2 + "ab')");
            System.out.println("Next testing maximum constant lengths + 1 through insert statement");
            try {
                statement.executeUpdate("insert into t1(c11) values ('" + string + "ab')");
                System.out.println("FAIL - should have gotten string constant too long error for this insert statement");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54002")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            try {
                statement.executeUpdate("insert into t1(c12) values (X'" + string2 + "abcd')");
                System.out.println("FAIL - should have gotten string constant too long error for this insert statement");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54002")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            System.out.println("Next testing maximum constant lengths + 1 through values");
            try {
                statement.executeUpdate("values ('" + string + "ab')");
                System.out.println("FAIL - should have gotten string constant too long error for this values statement");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54002")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            try {
                statement.executeUpdate("values (X'" + string2 + "abcd')");
                System.out.println("FAIL - should have gotten string constant too long error for this values statement");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54002")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            System.out.println("Next testing maximum constant lengths + n through insert statement");
            try {
                statement.executeUpdate("insert into t1(c11) values ('" + string + "bcdef')");
                System.out.println("FAIL - should have gotten string constant too long error for this insert statement");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54002")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            try {
                statement.executeUpdate("insert into t1(c12) values (X'" + string2 + "abcdef')");
                System.out.println("FAIL - should have gotten string constant too long error for this insert statement");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54002")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            System.out.println("Next testing maximum constant lengths + n through values");
            try {
                statement.executeUpdate("values ('" + string + "bcdef')");
                System.out.println("FAIL - should have gotten string constant too long error for this values statement");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54002")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            try {
                statement.executeUpdate("values (X'" + string2 + "abcdef')");
                System.out.println("FAIL - should have gotten string constant too long error for this values statement");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54002")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            System.out.println("Next testing odd number of hex digits in a hex constant through insert statement");
            try {
                statement.executeUpdate("insert into t1(c12) values (X'" + string2 + "a')");
                System.out.println("FAIL - should have gotten hex constant invalid string constant too long error for this values statement");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("42606")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            System.out.println("And finally testing odd number of hex digits in a hex constant through values statement");
            try {
                statement.executeUpdate("values (X'" + string2 + "a')");
                System.out.println("FAIL - should have gotten string constant too long error for this values statement");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("42606")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            statement.executeUpdate("drop table t1");
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }

    public static void testMostColumnsInTable(Connection connection) throws Throwable {
        block15: {
            try {
                System.out.println("Test - most columns allowed in a table");
                StringBuffer stringBuffer = new StringBuffer();
                String string = new String();
                int n = 0;
                stringBuffer.append("create table t1 (");
                for (n = 0; n < 1010; ++n) {
                    stringBuffer.append("c" + n + " int, ");
                }
                Statement statement = connection.createStatement();
                System.out.println("First create a table with one column less than maximum allowed number of columns");
                string = stringBuffer.toString().concat("c" + n + " int)");
                statement.executeUpdate(string);
                System.out.println("  Try alter table on it to have table with maximum allowed number of columns");
                statement.executeUpdate("alter table t1 add column c" + (n + 1) + " int");
                System.out.println("  Try another alter table to have table with one column more than maximum allowed number of columns");
                try {
                    statement.executeUpdate("alter table t1 add column c" + (n + 2) + " int");
                    System.out.println("FAIL - The alter table should have failed");
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("54011")) {
                        System.out.println("expected exception " + sQLException.getMessage());
                    }
                    dbManagerLimits.dumpSQLExceptions(sQLException);
                }
                statement.executeUpdate("drop table t1");
                System.out.println("Next create a table with maximum allowed number of columns");
                string = stringBuffer.toString().concat("c" + n + " int, c" + (n + 1) + " int)");
                statement.executeUpdate(string);
                System.out.println("  Try alter table to have table with more columns than maximum allowed number of columns");
                try {
                    statement.executeUpdate("alter table t1 add column c" + (n + 2) + " int");
                    System.out.println("FAIL - The alter table should have failed");
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("54011")) {
                        System.out.println("expected exception " + sQLException.getMessage());
                    }
                    dbManagerLimits.dumpSQLExceptions(sQLException);
                }
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                dbManagerLimits.getCount(databaseMetaData.getColumns("", "APP", "T1", null));
                statement.executeUpdate("insert into t1(c1, c2) values (1,1)");
                statement.executeUpdate("drop table t1");
                System.out.println("Next create a table with one column more than maximum allowed number of columns");
                string = stringBuffer.toString().concat("c" + n + " int, c" + (n + 1) + " int, c" + (n + 2) + " int)");
                try {
                    statement.executeUpdate(string);
                    System.out.println("FAIL - The create table should have failed");
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("54011")) {
                        System.out.println("expected exception " + sQLException.getMessage());
                    }
                    dbManagerLimits.dumpSQLExceptions(sQLException);
                }
                System.out.println("Finally, create a table with 2 columns more than maximum allowed number of columns");
                string = stringBuffer.toString().concat("c" + n + " int, c" + (n + 1) + " int, c" + (n + 2) + " int, c" + (n + 3) + " int)");
                try {
                    statement.executeUpdate(string);
                    System.out.println("FAIL - The create table should have failed");
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("54011")) {
                        System.out.println("expected exception " + sQLException.getMessage());
                        break block15;
                    }
                    dbManagerLimits.dumpSQLExceptions(sQLException);
                }
            }
            catch (SQLException sQLException) {
                JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
                sQLException.printStackTrace(System.out);
            }
        }
    }

    private static void getCount(ResultSet resultSet) throws Throwable {
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        System.out.println("Found " + n + " columns/parameters through meta data");
    }

    public static void testMostColumnsInView(Connection connection) throws Throwable {
        block9: {
            try {
                System.out.println("Test - most columns allowed in a view");
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                Object object = new String();
                int n = 0;
                for (n = 0; n < 4998; ++n) {
                    stringBuffer.append("1, ");
                    stringBuffer2.append("c" + n + ", ");
                }
                Statement statement = connection.createStatement();
                System.out.println("First create a view with one column less than maximum allowed number of columns");
                object = "create view v1(" + stringBuffer2.toString() + "c" + n + ") as values (" + stringBuffer.toString() + "1)";
                statement.executeUpdate((String)object);
                statement.executeUpdate("drop view v1");
                System.out.println("Next create a view with maximum allowed number of columns");
                object = "create view v1(" + stringBuffer2.toString() + "c" + n + ", c" + (n + 1) + ") as values (" + stringBuffer.toString() + "1,1)";
                statement.executeUpdate((String)object);
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                dbManagerLimits.getCount(databaseMetaData.getColumns("", "APP", "V1", null));
                statement.executeUpdate("drop view v1");
                System.out.println("Next create a view with one column more than that maximum allowed number of columns");
                object = "create view v1(" + stringBuffer2.toString() + "c" + n + ", c" + (n + 1) + ", c" + (n + 2) + ") as values (" + stringBuffer.toString() + "1,1,1)";
                try {
                    statement.executeUpdate((String)object);
                    System.out.println("FAIL - The create view should have failed");
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("54011")) {
                        System.out.println("expected exception " + sQLException.getMessage());
                    }
                    dbManagerLimits.dumpSQLExceptions(sQLException);
                }
                System.out.println("And finally create a view with 2 columns that maximum allowed number of columns");
                object = "create view v1(" + stringBuffer2.toString() + "c" + n + ", c" + (n + 1) + ", c" + (n + 2) + ", c" + (n + 3) + ") as values (" + stringBuffer.toString() + "1,1,1,1)";
                try {
                    statement.executeUpdate((String)object);
                    System.out.println("FAIL - The create view should have failed");
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("54011")) {
                        System.out.println("expected exception " + sQLException.getMessage());
                        break block9;
                    }
                    dbManagerLimits.dumpSQLExceptions(sQLException);
                }
            }
            catch (SQLException sQLException) {
                JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
                sQLException.printStackTrace(System.out);
            }
        }
    }

    public static void testMostElementsInSelectList(Connection connection) throws Throwable {
        try {
            System.out.println("Test - most elements allowed in a select list");
            StringBuffer stringBuffer = new StringBuffer();
            String string = new String();
            int n = 0;
            stringBuffer.append("create table t1 (");
            for (n = 0; n < 1010; ++n) {
                stringBuffer.append("c" + n + " int, ");
            }
            Statement statement = connection.createStatement();
            string = stringBuffer.toString().concat("c" + n + " int)");
            statement.executeUpdate(string);
            System.out.println("First try a select with one column less than maximum allowed number of columns");
            statement.execute("select * from t1");
            System.out.println("Next try a select with maximum allowed number of columns");
            statement.execute("select t1.*,1 from t1");
            System.out.println("Next try a select with one column more than maximum allowed number of columns");
            try {
                statement.execute("select t1.*,1,2 from t1");
                System.out.println("FAIL - select should have failed");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54004")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            System.out.println("Next try a select with 2 more columns than maximum allowed number of columns");
            try {
                statement.execute("select t1.*,1,2,3 from t1");
                System.out.println("FAIL - select should have failed");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54004")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            statement.executeUpdate("drop table t1");
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }

    public static void testMostElementsInOrderBy(Connection connection) throws Throwable {
        try {
            System.out.println("Test - most columns allowed in a ORDER BY clause");
            StringBuffer stringBuffer = new StringBuffer();
            String string = new String();
            int n = 0;
            stringBuffer.append("select * from t1 order by ");
            for (n = 0; n < 1010; ++n) {
                stringBuffer.append("c1, ");
            }
            Statement statement = connection.createStatement();
            statement.executeUpdate("create table t1 (c1 int not null, c2 int)");
            System.out.println("First try order by with one column less than maximum allowed number of columns");
            string = stringBuffer.toString().concat("c2");
            statement.execute(string);
            System.out.println("Next try an order by with maximum allowed number of columns");
            string = stringBuffer.toString().concat("c1, c2");
            statement.execute(string);
            System.out.println("Next try an order by with one column more than maximum allowed number of columns");
            string = stringBuffer.toString().concat("c1, c2, c1");
            try {
                statement.execute(string);
                System.out.println("FAIL - order by should have failed");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54004")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            System.out.println("And finally try an order by with 2 more columns than maximum allowed number of columns");
            string = stringBuffer.toString().concat("c1, c2, c1");
            try {
                statement.execute(string);
                System.out.println("FAIL - order by should have failed");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54004")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            statement.executeUpdate("drop table t1");
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }

    public static void testMostElementsInGroupBy(Connection connection) throws Throwable {
        try {
            int n;
            System.out.println("Test - most columns allowed in a GROUP BY clause");
            Statement statement = connection.createStatement();
            StringBuffer stringBuffer = new StringBuffer("select 1 from v1, v2, v3, v4, v5, v6, v7 group by ");
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            Object object = new String();
            int n2 = 0;
            for (n2 = 0; n2 < 4999; ++n2) {
                stringBuffer2.append("1, ");
            }
            for (n = 1; n < 8; ++n) {
                for (n2 = 0; n2 < 4999; ++n2) {
                    stringBuffer3.append("c" + n + n2 + ", ");
                }
                object = "create view v" + n + "(" + stringBuffer3.toString() + "c" + n + n2 + ") as values (" + stringBuffer2.toString() + "1)";
                statement.executeUpdate((String)object);
                stringBuffer3 = new StringBuffer();
            }
            for (n = 1; n < 7; ++n) {
                for (n2 = 0; n2 < 5000; ++n2) {
                    stringBuffer.append("c" + n + n2 + ", ");
                }
            }
            for (n2 = 0; n2 < 2675; ++n2) {
                stringBuffer.append("c7" + n2 + ", ");
            }
            System.out.println("First try group by with one column less than maximum allowed number of columns");
            object = stringBuffer.toString().concat("c72675");
            statement.execute((String)object);
            System.out.println("Next try an group by with maximum allowed number of columns");
            object = stringBuffer.toString().concat("c72675, c72675");
            statement.execute((String)object);
            System.out.println("And finally try an group by with more columns that maximum allowed number of columns");
            object = stringBuffer.toString().concat("c72675, c72676, c72677");
            try {
                statement.execute((String)object);
                System.out.println("FAIL - group by should have failed");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54004")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            statement.executeUpdate("drop view v1");
            statement.executeUpdate("drop view v2");
            statement.executeUpdate("drop view v3");
            statement.executeUpdate("drop view v4");
            statement.executeUpdate("drop view v5");
            statement.executeUpdate("drop view v6");
            statement.executeUpdate("drop view v7");
            statement.execute("select 1 from v1 group by c1,c2");
            statement.executeUpdate("drop table t1");
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }

    public static void testMostParametersInStoredProcedures(Connection connection) throws Throwable {
        try {
            System.out.println("Test - most parameters allowed for a stored procedure");
            Statement statement = connection.createStatement();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            Object object = new String();
            int n = 0;
            int n2 = 90;
            for (n = 0; n < n2 - 2; ++n) {
                stringBuffer.append("i" + n + " int, ");
                stringBuffer2.append("1, ");
            }
            System.out.println("First create a procedure with one parameter less than maximum allowed number of parameters");
            object = "create procedure P1(" + stringBuffer.toString() + "i" + n + " int) parameter style java language java external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.lessThanMaxParams' NO SQL";
            statement.executeUpdate((String)object);
            System.out.println("Next create a procedure with maximum allowed number of parameters");
            object = "create procedure P2(" + stringBuffer.toString() + "i" + n + " int, i" + (n + 1) + " int) parameter style java language java external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.maxAllowedParams' NO SQL";
            statement.executeUpdate((String)object);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            dbManagerLimits.getCount(databaseMetaData.getProcedureColumns("", "APP", "P2", null));
            System.out.println("And finally create a procedure with more parameters that maximum allowed number of parameters");
            object = "create procedure P3(" + stringBuffer.toString() + "i" + n + " int, i" + (n + 1) + " int, i" + (n + 2) + " int) parameter style java language java external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.moreThanMaxAllowedParams' NO SQL";
            statement.executeUpdate((String)object);
            dbManagerLimits.getCount(databaseMetaData.getProcedureColumns("", "APP", "P3", null));
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }

    public static void testMostIndexesOnTable(Connection connection) throws Throwable {
        try {
            System.out.println("Test - most indexes allowed on a table");
            connection.setAutoCommit(false);
            Statement statement = connection.createStatement();
            int n = 0;
            statement.executeUpdate("create table t1 (c1 int not null, c2 int, primary key(c1))");
            System.out.println("First create one index less than maximum allowed number of indexes");
            for (n = 0; n < 32765; ++n) {
                statement.executeUpdate("create index i" + n + " on t1(c1,c2)");
                System.out.println("   create index" + n);
            }
            System.out.println("Next create maximum allowed number of indexes");
            statement.executeUpdate("create index i" + (n + 1) + " on t1(c1,c2)");
            System.out.println("And finally create one index more than maximum allowed number of indexes");
            try {
                statement.executeUpdate("create index i" + (n + 2) + " on t1(c1,c2)");
                System.out.println("FAIL - create index should have failed");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54011")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            System.out.println("And finally try maximum allowed number of indexes violation using add constraint");
            try {
                statement.executeUpdate("alter table t1 add constraint i" + (n + 2) + " unique (c1,c2)");
                System.out.println("FAIL - create index should have failed");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("54011")) {
                    System.out.println("expected exception " + sQLException.getMessage());
                }
                dbManagerLimits.dumpSQLExceptions(sQLException);
            }
            statement.executeUpdate("drop table t1");
            connection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }

    private static void dumpSQLExceptions(SQLException sQLException) {
        System.out.println("FAIL -- unexpected exception: " + sQLException.toString());
        while (sQLException != null) {
            System.out.print("SQLSTATE(" + sQLException.getSQLState() + "):");
            sQLException = sQLException.getNextException();
        }
    }
}

