/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Collator;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.BatchUpdateTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest;
import org.apache.derbyTesting.functionTests.tests.lang.GroupByExpressionTest;
import org.apache.derbyTesting.functionTests.tests.lang.UpdatableResultSetTest;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.XML;

public class CollationTest
extends BaseJDBCTestCase {
    private static final String[] NAMES = new String[]{"Smith", "Zebra", "\u0104corn", "\u017bebra", "Acorn", "\u015amith", "aacorn"};
    private static final String[] ENGLISH_CASE_SENSITIVE = new String[]{"testEnglishCollation", "testUsingClauseAndNaturalJoin", "testNullColumnInInsert", "test_5951"};
    private static final String[] ENGLISH_CASE_INSENSITIVE = new String[]{"testUsingClauseAndNaturalJoin", "testNullColumnInInsert", "testDerby6227", "testDerby6890"};
    private static final String[] NORWEGIAN_CASE_SENSITIVE = new String[]{"testNorwayCollation", "testInListNorwayCollation", "testLikeEscapeClauseLengthRestriction"};
    private static final String[] POLISH_CASE_SENSITIVE = new String[]{"testPolishCollation"};
    private static final String[] FRENCH_CASE_SENSITIVE = new String[]{"testFrenchCollation"};
    private static final String[] SWEDISH_CASE_INSENSITIVE = new String[]{"testSwedishCaseInsensitiveCollation"};
    private static final String INVALID_ESCAPE = "22019";

    public CollationTest(String string) {
        super(string);
    }

    public void testDefaultCollation() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        this.setUpTable(statement);
        this.checkLangBasedQuery(statement, "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')", new String[][]{{"UCS_BASIC"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER ORDER BY NAME", new String[][]{{"4", "Acorn"}, {"0", "Smith"}, {"1", "Zebra"}, {"6", "aacorn"}, {"2", "\u0104corn"}, {"5", "\u015amith"}, {"3", "\u017bebra"}});
        statement.executeUpdate("CREATE FUNCTION mimic(val VARCHAR(32000)) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.CollationTest.mimic' LANGUAGE JAVA PARAMETER STYLE JAVA");
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER ORDER BY MIMIC(NAME)", new String[][]{{"4", "Acorn"}, {"0", "Smith"}, {"1", "Zebra"}, {"6", "aacorn"}, {"2", "\u0104corn"}, {"5", "\u015amith"}, {"3", "\u017bebra"}});
        statement.executeUpdate("DROP FUNCTION mimic");
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' = 'Acorn' ", null);
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' < 'Acorn' ", null);
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER WHERE NAME <= 'Smith' ", new String[][]{{"0", "Smith"}, {"4", "Acorn"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER WHERE NAME between 'Acorn' and 'Zebra' ", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"4", "Acorn"}});
        statement.executeUpdate("set schema SYS");
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM APP.CUSTOMER WHERE NAME <= 'Smith' ", new String[][]{{"0", "Smith"}, {"4", "Acorn"}});
        statement.executeUpdate("set schema APP");
        this.checkLangBasedQuery(statement, "SELECT 1 FROM SYS.SYSTABLES WHERE  TABLENAME = 'CUSTOMER' ", new String[][]{{"1"}});
        this.checkLangBasedQuery(statement, "SELECT 1 FROM SYS.SYSTABLES WHERE CAST  (TABLENAME AS CHAR(15)) = 'CUSTOMER' ", new String[][]{{"1"}});
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE CASE  WHEN 1=1 THEN TABLENAME ELSE 'c' END = 'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE CAST  ((CASE WHEN 1=1 THEN TABLENAME ELSE 'c' END) AS CHAR(12)) =  'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TABLENAME || ' ' = 'SYSCOLUMNS '", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST (TABLENAME || ' ' AS CHAR(12)) =  'SYSCOLUMNS '", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  COALESCE(TABLENAME, 'c') = 'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST (COALESCE (TABLENAME, 'c') AS CHAR(12)) =  'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  NULLIF(TABLENAME, 'c') = 'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST (NULLIF (TABLENAME, 'c') AS CHAR(12)) =  'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(statement, "SELECT count(*) FROM CUSTOMER WHERE CURRENT_USER = 'APP'", new String[][]{{"7"}});
        this.checkLangBasedQuery(statement, "SELECT MAX(NAME) maxName FROM CUSTOMER ORDER BY maxName ", new String[][]{{"\u017bebra"}});
        this.checkLangBasedQuery(statement, "SELECT MIN(NAME) minName FROM CUSTOMER ORDER BY minName ", new String[][]{{"Acorn"}});
        statement.executeUpdate("set schema SYS");
        this.checkLangBasedQuery(statement, "SELECT CHAR(ID) FROM APP.CUSTOMER WHERE  CHAR(ID)='0'", new String[][]{{"0"}});
        statement.executeUpdate("set schema APP");
        if (XML.classpathMeetsXMLReqs()) {
            this.checkLangBasedQuery(statement, "SELECT XMLSERIALIZE(x as CHAR(10))  FROM xmlTable, SYS.SYSTABLES WHERE  XMLSERIALIZE(x as CHAR(10)) = TABLENAME", null);
        }
        statement.executeUpdate("set schema APP");
        PreparedStatement preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  ? = TABLENAME");
        preparedStatement.setString(1, "SYSCOLUMNS");
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCOLUMNS"}});
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  SUBSTR(?,2) = TABLENAME");
        preparedStatement.setString(1, " SYSCOLUMNS");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCOLUMNS"}});
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  LTRIM(?) = TABLENAME");
        preparedStatement.setString(1, " SYSCOLUMNS");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCOLUMNS"}});
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  RTRIM(?) = TABLENAME");
        preparedStatement.setString(1, "SYSCOLUMNS  ");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCOLUMNS"}});
        preparedStatement = this.prepareStatement("SELECT COUNT(*) FROM CUSTOMER WHERE  ? IN (SELECT TABLENAME FROM SYS.SYSTABLES)");
        preparedStatement.setString(1, "SYSCOLUMNS");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"7"}});
        statement.close();
        this.compareAgrave(1, 1, 2);
    }

    public void testFrenchCollation() throws SQLException {
        this.compareAgrave(2, 1, 1);
    }

    private void compareAgrave(int n, int n2, int n3) throws SQLException {
        String[] stringArray = new String[]{"VARCHAR(5)", "CHAR(5)"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.compareAgrave(stringArray[i], n, n2, n3);
        }
    }

    private void compareAgrave(String string, int n, int n2, int n3) throws SQLException {
        String string2 = "\u00c0";
        String string3 = "A\u0300";
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("DROP TABLE T");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.executeUpdate("CREATE TABLE T (vc " + string + ")");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO T VALUES (?)");
        preparedStatement.setString(1, string2);
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, string3);
        preparedStatement.executeUpdate();
        preparedStatement = this.prepareStatement("SELECT COUNT(*) FROM T WHERE VC = ?");
        preparedStatement.setString(1, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertSingleValueResultSet(resultSet, Integer.toString(n));
        preparedStatement = this.prepareStatement("SELECT COUNT(*) FROM T WHERE VC LIKE ? || '%'");
        preparedStatement.setString(1, string2);
        resultSet = preparedStatement.executeQuery();
        JDBC.assertSingleValueResultSet(resultSet, Integer.toString(n2));
        int n4 = JDBC.assertDrainResults(statement.executeQuery("SELECT DISTINCT VC FROM T"));
        CollationTest.assertEquals((String)"Unexpected number of distinct rows", (int)n3, (int)n4);
    }

    public void testPolishCollation() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        this.setUpTable(statement);
        this.checkLangBasedQuery(statement, "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')", new String[][]{{"TERRITORY_BASED"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER ORDER BY NAME", new String[][]{{"6", "aacorn"}, {"4", "Acorn"}, {"2", "\u0104corn"}, {"0", "Smith"}, {"5", "\u015amith"}, {"1", "Zebra"}, {"3", "\u017bebra"}});
        statement.executeUpdate("CREATE FUNCTION mimic(val VARCHAR(32000)) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.CollationTest.mimic' LANGUAGE JAVA PARAMETER STYLE JAVA");
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER ORDER BY MIMIC(NAME)", new String[][]{{"6", "aacorn"}, {"4", "Acorn"}, {"2", "\u0104corn"}, {"0", "Smith"}, {"5", "\u015amith"}, {"1", "Zebra"}, {"3", "\u017bebra"}});
        statement.executeUpdate("DROP FUNCTION mimic");
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' = 'Acorn' ", null);
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' < 'Acorn'", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"2", "\u0104corn"}, {"3", "\u017bebra"}, {"4", "Acorn"}, {"5", "\u015amith"}, {"6", "aacorn"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER WHERE NAME <= 'Smith' ", new String[][]{{"0", "Smith"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"6", "aacorn"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER WHERE NAME between 'Acorn' and 'Zebra' ", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"5", "\u015amith"}});
        statement.executeUpdate("set schema SYS");
        CollationTest.assertStatementError("42818", statement, "SELECT ID, NAME FROM APP.CUSTOMER WHERE NAME <= 'Smith' ");
        statement.executeUpdate("set schema APP");
        this.checkLangBasedQuery(statement, "SELECT MAX(NAME) maxName FROM CUSTOMER ORDER BY maxName ", new String[][]{{"\u017bebra"}});
        this.checkLangBasedQuery(statement, "SELECT MIN(NAME) minName FROM CUSTOMER ORDER BY minName ", new String[][]{{"aacorn"}});
        this.commonTestingForTerritoryBasedDB(statement);
    }

    public void testInListNorwayCollation() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE derby6025_T1( c1 varchar(40) )");
        statement.executeUpdate("INSERT INTO derby6025_T1 VALUES'Stranda Idrottslag', 'Aalesunds Fotballklubb'");
        ResultSet resultSet = statement.executeQuery("select * from derby6025_T1 where C1 in ('Aalesunds Fotballklubb', cast('xyz' as char(3)))");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Aalesunds Fotballklubb"}});
        statement.executeUpdate("create index i1 on derby6025_T1(c1)");
        resultSet = statement.executeQuery("select * from derby6025_T1 where C1 in ('Aalesunds Fotballklubb', cast('xyz' as char(3)))");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Aalesunds Fotballklubb"}});
        statement.execute("DROP TABLE derby6025_T1");
    }

    public void testNorwayCollation() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        this.setUpTable(statement);
        this.checkLangBasedQuery(statement, "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')", new String[][]{{"TERRITORY_BASED"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER ORDER BY NAME", new String[][]{{"4", "Acorn"}, {"2", "\u0104corn"}, {"0", "Smith"}, {"5", "\u015amith"}, {"1", "Zebra"}, {"3", "\u017bebra"}, {"6", "aacorn"}});
        statement.executeUpdate("CREATE FUNCTION mimic(val VARCHAR(32000)) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.CollationTest.mimic' LANGUAGE JAVA PARAMETER STYLE JAVA");
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER ORDER BY MIMIC(NAME)", new String[][]{{"4", "Acorn"}, {"2", "\u0104corn"}, {"0", "Smith"}, {"5", "\u015amith"}, {"1", "Zebra"}, {"3", "\u017bebra"}, {"6", "aacorn"}});
        statement.executeUpdate("DROP FUNCTION mimic");
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' = 'Acorn' ", null);
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' < 'Acorn' ", null);
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER WHERE NAME <= 'Smith' ", new String[][]{{"0", "Smith"}, {"2", "\u0104corn"}, {"4", "Acorn"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER WHERE NAME between 'Acorn' and 'Zebra' ", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"5", "\u015amith"}});
        statement.executeUpdate("set schema SYS");
        CollationTest.assertStatementError("42818", statement, "SELECT ID, NAME FROM APP.CUSTOMER WHERE NAME <= 'Smith' ");
        statement.executeUpdate("set schema APP");
        this.checkLangBasedQuery(statement, "SELECT MAX(NAME) maxName FROM CUSTOMER ORDER BY maxName ", new String[][]{{"aacorn"}});
        this.checkLangBasedQuery(statement, "SELECT MIN(NAME) minName FROM CUSTOMER ORDER BY minName ", new String[][]{{"Acorn"}});
        this.commonTestingForTerritoryBasedDB(statement);
        statement.close();
    }

    public void testNullColumnInInsert() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        statement.executeUpdate("CREATE TABLE derby5531_t1(x varchar(10) unique, y varchar(10))");
        statement.executeUpdate("INSERT INTO derby5531_t1 VALUES(NULL, 'a')");
        statement.executeUpdate("INSERT INTO derby5531_t1 VALUES('1', 'a')");
        statement.executeUpdate("INSERT INTO derby5531_t1 VALUES('2', NULL)");
        statement.executeUpdate("INSERT INTO derby5531_t1 VALUES(NULL, NULL)");
        statement.executeUpdate("INSERT INTO derby5531_t1(x) VALUES(NULL)");
        statement.executeUpdate("INSERT INTO derby5531_t1 VALUES('3', 'b')");
        resultSet = statement.executeQuery("select * from derby5531_t1 order by x");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "a"}, {"2", null}, {"3", "b"}, {null, null}, {null, null}, {null, "a"}});
        statement.executeUpdate("DROP TABLE derby5531_t1");
        statement.executeUpdate("CREATE TABLE derby5531_t2(x varchar(10) unique)");
        statement.executeUpdate("INSERT INTO derby5531_t2 VALUES(NULL)");
        statement.executeUpdate("INSERT INTO derby5531_t2(x) VALUES(NULL)");
        statement.executeUpdate("INSERT INTO derby5531_t2 VALUES('a')");
        resultSet = statement.executeQuery("select * from derby5531_t2 order by x");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"a"}, {null}, {null}});
        statement.executeUpdate("DROP TABLE derby5531_t2");
    }

    public void testUsingClauseAndNaturalJoin() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        resultSet = statement.executeQuery("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')");
        resultSet.next();
        String string = resultSet.getString(1);
        statement.executeUpdate("CREATE TABLE derby4631_t1(x int)");
        statement.executeUpdate("CREATE TABLE derby4631_t2(x int)");
        statement.executeUpdate("INSERT INTO derby4631_t1 VALUES 1,2");
        statement.executeUpdate("INSERT INTO derby4631_t2 VALUES 2,3");
        this.checkLangBasedQuery(statement, "SELECT x+2, coalesce(derby4631_t2.x, derby4631_t1.x)+2 cx FROM derby4631_t2 NATURAL LEFT OUTER JOIN derby4631_t1", new String[][]{{"4", "4"}, {"5", "5"}});
        this.checkLangBasedQuery(statement, "SELECT x+2, coalesce(derby4631_t2.x, derby4631_t1.x)+2 cx FROM derby4631_t2 LEFT OUTER JOIN derby4631_t1 USING(x)", new String[][]{{"4", "4"}, {"5", "5"}});
        this.checkLangBasedQuery(statement, "SELECT x*2, coalesce(derby4631_t2.x, derby4631_t1.x)*2 cx FROM derby4631_t2 NATURAL RIGHT OUTER JOIN derby4631_t1", new String[][]{{"2", "2"}, {"4", "4"}});
        this.checkLangBasedQuery(statement, "SELECT x*2, coalesce(derby4631_t2.x, derby4631_t1.x)*2 cx FROM derby4631_t2 RIGHT OUTER JOIN derby4631_t1 USING(x)", new String[][]{{"2", "2"}, {"4", "4"}});
        statement.executeUpdate("DROP TABLE derby4631_t1");
        statement.executeUpdate("DROP TABLE derby4631_t2");
        statement.executeUpdate("CREATE TABLE derby4631_t1(x varchar(5))");
        statement.executeUpdate("CREATE TABLE derby4631_t2(x varchar(5))");
        statement.executeUpdate("INSERT INTO derby4631_t2 VALUES 'A','B'");
        this.checkLangBasedQuery(statement, "SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL LEFT OUTER JOIN derby4631_t1", new String[][]{{"A", "A"}, {"B", "B"}});
        this.checkLangBasedQuery(statement, "SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 LEFT OUTER JOIN derby4631_t1 USING(x)", new String[][]{{"A", "A"}, {"B", "B"}});
        this.checkLangBasedQuery(statement, "SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL RIGHT OUTER JOIN derby4631_t1", null);
        this.checkLangBasedQuery(statement, "SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 RIGHT OUTER JOIN derby4631_t1 USING(x)", null);
        statement.executeUpdate("DROP TABLE derby4631_t1");
        statement.executeUpdate("DROP TABLE derby4631_t2");
        statement.executeUpdate("CREATE TABLE derby4631_t1(x varchar(5))");
        statement.executeUpdate("INSERT INTO derby4631_t1 VALUES 'A','B'");
        statement.executeUpdate("CREATE TABLE derby4631_t2(x varchar(5))");
        statement.executeUpdate("INSERT INTO derby4631_t2 VALUES 'b','c'");
        statement.executeUpdate("CREATE TABLE derby4631_t3(x1 varchar(5), x2 varchar(5), x3 int default 11)");
        this.checkLangBasedQuery(statement, "SELECT x x1, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL LEFT OUTER JOIN derby4631_t1", new String[][]{{"b", "b"}, {"c", "c"}});
        this.checkLangBasedQuery(statement, "SELECT x x1, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 LEFT OUTER JOIN derby4631_t1 USING(x)", new String[][]{{"b", "b"}, {"c", "c"}});
        statement.executeUpdate("INSERT INTO derby4631_t3(x1, x2) SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL LEFT OUTER JOIN derby4631_t1");
        this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_t3 ", new String[][]{{"b", "b", "11"}, {"c", "c", "11"}});
        statement.executeUpdate("UPDATE derby4631_t3 SET x3=22 where x1 in (SELECT coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL LEFT OUTER JOIN derby4631_t1)");
        this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_t3 ", new String[][]{{"b", "b", "22"}, {"c", "c", "22"}});
        statement.executeUpdate("DELETE FROM derby4631_t3 where x1 in (SELECT coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL LEFT OUTER JOIN derby4631_t1)");
        this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_t3", null);
        statement.executeUpdate("INSERT INTO derby4631_t3(x1, x2) SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 LEFT OUTER JOIN derby4631_t1 USING(x)");
        this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_t3 ", new String[][]{{"b", "b", "11"}, {"c", "c", "11"}});
        statement.executeUpdate("UPDATE derby4631_t3 SET x3=22 where x1 in (SELECT coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 LEFT OUTER JOIN derby4631_t1 USING(x))");
        this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_t3 ", new String[][]{{"b", "b", "22"}, {"c", "c", "22"}});
        statement.executeUpdate("DELETE FROM derby4631_t3 where x1 in (SELECT coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 LEFT OUTER JOIN derby4631_t1 USING(x))");
        this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_t3", null);
        statement.executeUpdate("create view derby4631_v2 as (SELECT x,coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL LEFT OUTER JOIN derby4631_t1)");
        this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_v2 ", new String[][]{{"b", "b"}, {"c", "c"}});
        statement.executeUpdate("drop view derby4631_v2 ");
        statement.executeUpdate("create view derby4631_v2 as (SELECT x,coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 LEFT OUTER JOIN derby4631_t1 USING(x))");
        this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_v2 ", new String[][]{{"b", "b"}, {"c", "c"}});
        statement.executeUpdate("drop view derby4631_v2 ");
        this.checkLangBasedQuery(statement, "SELECT x FROM (values ('b')) v2(x) NATURAL LEFT OUTER JOIN derby4631_t2 NATURAL LEFT OUTER JOIN derby4631_t1 ", new String[][]{{"b"}});
        this.checkLangBasedQuery(statement, "SELECT x FROM (values ('b')) v2(x) LEFT OUTER JOIN derby4631_t2 USING(x) LEFT OUTER JOIN derby4631_t1 USING(x) ", new String[][]{{"b"}});
        if (string != null && string.equals("TERRITORY_BASED:SECONDARY")) {
            this.checkLangBasedQuery(statement, "SELECT x x1, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL RIGHT OUTER JOIN derby4631_t1", new String[][]{{"A", "A"}, {"b", "b"}});
            this.checkLangBasedQuery(statement, "SELECT x x1, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 RIGHT OUTER JOIN derby4631_t1 USING(x)", new String[][]{{"A", "A"}, {"b", "b"}});
            statement.executeUpdate("INSERT INTO derby4631_t3(x1, x2) SELECT x xx, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL RIGHT OUTER JOIN derby4631_t1");
            this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_t3 ", new String[][]{{"A", "A", "11"}, {"b", "b", "11"}});
            statement.executeUpdate("UPDATE derby4631_t3 SET x3=22 where x1 in (SELECT coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL RIGHT OUTER JOIN derby4631_t1)");
            this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_t3 ", new String[][]{{"A", "A", "22"}, {"b", "b", "22"}});
            statement.executeUpdate("DELETE FROM derby4631_t3 where x1 in (SELECT coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL RIGHT OUTER JOIN derby4631_t1)");
            this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_t3", null);
            statement.executeUpdate("INSERT INTO derby4631_t3(x1, x2) SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 RIGHT OUTER JOIN derby4631_t1 USING(x)");
            this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_t3 ", new String[][]{{"A", "A", "11"}, {"b", "b", "11"}});
            statement.executeUpdate("UPDATE derby4631_t3 SET x3=22 where x1 in (SELECT coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 RIGHT OUTER JOIN derby4631_t1 USING(x))");
            this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_t3 ", new String[][]{{"A", "A", "22"}, {"b", "b", "22"}});
            statement.executeUpdate("DELETE FROM derby4631_t3 where x1 in (SELECT coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 RIGHT OUTER JOIN derby4631_t1 USING(x))");
            this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_t3", null);
            statement.executeUpdate("create view derby4631_v2 as (SELECT x,coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL RIGHT OUTER JOIN derby4631_t1)");
            this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_v2 ", new String[][]{{"A", "A"}, {"b", "b"}});
            statement.executeUpdate("drop view derby4631_v2 ");
            statement.executeUpdate("create view derby4631_v2 as (SELECT x,coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 RIGHT OUTER JOIN derby4631_t1 USING(x))");
            this.checkLangBasedQuery(statement, "SELECT * FROM derby4631_v2 ", new String[][]{{"A", "A"}, {"b", "b"}});
            statement.executeUpdate("drop view derby4631_v2 ");
            this.checkLangBasedQuery(statement, "SELECT x FROM (values ('b')) v2(x) NATURAL RIGHT OUTER JOIN derby4631_t2 NATURAL RIGHT OUTER JOIN derby4631_t1 ", new String[][]{{"A"}, {"b"}});
            this.checkLangBasedQuery(statement, "SELECT x FROM (values ('b')) v2(x) RIGHT OUTER JOIN derby4631_t2 USING(x) RIGHT OUTER JOIN derby4631_t1 USING(x) ", new String[][]{{"A"}, {"b"}});
        } else {
            this.checkLangBasedQuery(statement, "SELECT x x1, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 NATURAL RIGHT OUTER JOIN derby4631_t1", new String[][]{{"A", "A"}, {"B", "B"}});
            this.checkLangBasedQuery(statement, "SELECT x x1, coalesce(derby4631_t2.x, derby4631_t1.x) cx FROM derby4631_t2 RIGHT OUTER JOIN derby4631_t1 USING(x)", new String[][]{{"A", "A"}, {"B", "B"}});
        }
        statement.executeUpdate("DROP TABLE derby4631_t1");
        statement.executeUpdate("DROP TABLE derby4631_t2");
        statement.executeUpdate("CREATE TABLE derby4631_t1(x varchar(5), y varchar(2), z int, a int)");
        statement.executeUpdate("INSERT INTO derby4631_t1 VALUES ('A','z',1,11),('B','y',2,22)");
        statement.executeUpdate("CREATE TABLE derby4631_t2(x varchar(5), y varchar(2), z int)");
        statement.executeUpdate("INSERT INTO derby4631_t2 VALUES  ('b','Y',2),('c','Y',2)");
        if (string != null && string.equals("TERRITORY_BASED:SECONDARY")) {
            this.checkLangBasedQuery(statement, "SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx, y, coalesce(derby4631_t2.y, derby4631_t1.y) cy, z, coalesce(derby4631_t2.z, derby4631_t1.z) cz, a FROM derby4631_t2 NATURAL LEFT OUTER JOIN derby4631_t1", new String[][]{{"b", "b", "Y", "Y", "2", "2", "22"}, {"c", "c", "Y", "Y", "2", "2", null}});
            this.checkLangBasedQuery(statement, "SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx, y, coalesce(derby4631_t2.y, derby4631_t1.y) cy, z, coalesce(derby4631_t2.z, derby4631_t1.z) cz, a FROM derby4631_t2 LEFT OUTER JOIN derby4631_t1 USING(x,y,z)", new String[][]{{"b", "b", "Y", "Y", "2", "2", "22"}, {"c", "c", "Y", "Y", "2", "2", null}});
            this.checkLangBasedQuery(statement, "SELECT coalesce(derby4631_t2.x, derby4631_t1.x) cx, y, coalesce(derby4631_t2.y, derby4631_t1.y) cy, z, coalesce(derby4631_t2.z, derby4631_t1.z) cz, a FROM derby4631_t2 LEFT OUTER JOIN derby4631_t1 USING(y,z)", new String[][]{{"b", "Y", "Y", "2", "2", "22"}, {"c", "Y", "Y", "2", "2", "22"}});
            this.checkLangBasedQuery(statement, "SELECT coalesce(derby4631_t2.x, derby4631_t1.x) cx, y, coalesce(derby4631_t2.y, derby4631_t1.y) cy, z, coalesce(derby4631_t2.z, derby4631_t1.z) cz, a FROM derby4631_t2 RIGHT OUTER JOIN derby4631_t1 USING(y,z)", new String[][]{{"A", "z", "z", "1", "1", "11"}, {"b", "Y", "Y", "2", "2", "22"}, {"c", "Y", "Y", "2", "2", "22"}});
            this.checkLangBasedQuery(statement, "SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx, y, coalesce(derby4631_t2.y, derby4631_t1.y) cy, z, coalesce(derby4631_t2.z, derby4631_t1.z) cz, a FROM derby4631_t2 NATURAL RIGHT OUTER JOIN derby4631_t1", new String[][]{{"A", "A", "z", "z", "1", "1", "11"}, {"b", "b", "Y", "Y", "2", "2", "22"}});
            this.checkLangBasedQuery(statement, "SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx, y, coalesce(derby4631_t2.y, derby4631_t1.y) cy, z, coalesce(derby4631_t2.z, derby4631_t1.z) cz, a FROM derby4631_t2 RIGHT OUTER JOIN derby4631_t1 USING(x,y,z)", new String[][]{{"A", "A", "z", "z", "1", "1", "11"}, {"b", "b", "Y", "Y", "2", "2", "22"}});
        } else {
            this.checkLangBasedQuery(statement, "SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx, y, coalesce(derby4631_t2.y, derby4631_t1.y) cy, z, coalesce(derby4631_t2.z, derby4631_t1.z) cz, a FROM derby4631_t2 NATURAL LEFT OUTER JOIN derby4631_t1", new String[][]{{"b", "b", "Y", "Y", "2", "2", null}, {"c", "c", "Y", "Y", "2", "2", null}});
            this.checkLangBasedQuery(statement, "SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx, y, coalesce(derby4631_t2.y, derby4631_t1.y) cy, z, coalesce(derby4631_t2.z, derby4631_t1.z) cz, a FROM derby4631_t2 LEFT OUTER JOIN derby4631_t1 USING(x,y,z)", new String[][]{{"b", "b", "Y", "Y", "2", "2", null}, {"c", "c", "Y", "Y", "2", "2", null}});
            this.checkLangBasedQuery(statement, "SELECT coalesce(derby4631_t2.x, derby4631_t1.x) cx, y, coalesce(derby4631_t2.y, derby4631_t1.y) cy, z, coalesce(derby4631_t2.z, derby4631_t1.z) cz, a FROM derby4631_t2 LEFT OUTER JOIN derby4631_t1 USING(y,z)", new String[][]{{"b", "Y", "Y", "2", "2", null}, {"c", "Y", "Y", "2", "2", null}});
            this.checkLangBasedQuery(statement, "SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx, y, coalesce(derby4631_t2.y, derby4631_t1.y) cy, z, coalesce(derby4631_t2.z, derby4631_t1.z) cz, a FROM derby4631_t2 NATURAL RIGHT OUTER JOIN derby4631_t1", new String[][]{{"A", "A", "z", "z", "1", "1", "11"}, {"B", "B", "y", "y", "2", "2", "22"}});
            this.checkLangBasedQuery(statement, "SELECT x, coalesce(derby4631_t2.x, derby4631_t1.x) cx, y, coalesce(derby4631_t2.y, derby4631_t1.y) cy, z, coalesce(derby4631_t2.z, derby4631_t1.z) cz, a FROM derby4631_t2 RIGHT OUTER JOIN derby4631_t1 USING(x,y,z)", new String[][]{{"A", "A", "z", "z", "1", "1", "11"}, {"B", "B", "y", "y", "2", "2", "22"}});
            this.checkLangBasedQuery(statement, "SELECT coalesce(derby4631_t2.x, derby4631_t1.x) cx, y, coalesce(derby4631_t2.y, derby4631_t1.y) cy, z, coalesce(derby4631_t2.z, derby4631_t1.z) cz, a FROM derby4631_t2 RIGHT OUTER JOIN derby4631_t1 USING(y,z)", new String[][]{{"A", "z", "z", "1", "1", "11"}, {"B", "y", "y", "2", "2", "22"}});
        }
        statement.executeUpdate("DROP TABLE derby4631_t1");
        statement.executeUpdate("DROP TABLE derby4631_t2");
        statement.executeUpdate("CREATE TABLE derby4631_t1(x varchar(5), y varchar(2))");
        statement.executeUpdate("INSERT INTO derby4631_t1 VALUES ('A','z'),('B','y')");
        statement.executeUpdate("CREATE TABLE derby4631_t2(x varchar(5), y varchar(2))");
        statement.executeUpdate("INSERT INTO derby4631_t2 VALUES ('b','Y'),('c','x')");
        statement.executeUpdate("create view derby4631_v1 as select * from derby4631_t1");
        statement.executeUpdate("create view derby4631_v2 as select * from derby4631_t2");
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE gt1 (x varchar(5), y varchar(2)) on commit delete rows not logged");
        statement.executeUpdate("INSERT INTO session.gt1 VALUES ('A','z'),('B','y')");
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE gt2(x varchar(5), y varchar(2)) on commit delete rows not logged");
        statement.executeUpdate("INSERT INTO session.gt2 VALUES ('b','Y'),('c','x')");
        this.joinTesting(statement, "derby4631_t2", "derby4631_t1", "derby4631_t2", "derby4631_t1", " NATURAL LEFT OUTER JOIN ", "", new String[][]{{"b", "Y", "b", "Y"}, {"c", "x", "c", "x"}});
        this.joinTesting(statement, "derby4631_v2", "derby4631_v1", "derby4631_v2", "derby4631_v1", " NATURAL LEFT OUTER JOIN ", "", new String[][]{{"b", "Y", "b", "Y"}, {"c", "x", "c", "x"}});
        this.joinTesting(statement, "gt2", "gt1", "session.gt2 gt2", "session.gt1 gt1", " NATURAL LEFT OUTER JOIN ", "", new String[][]{{"b", "Y", "b", "Y"}, {"c", "x", "c", "x"}});
        this.joinTesting(statement, "v2", "v1", " (values ('b','Y'),('c','x')) v2(x,y) ", " (values('A','z'),('B','y')) v1(x,y) ", " NATURAL LEFT OUTER JOIN ", "", new String[][]{{"b", "Y", "b", "Y"}, {"c", "x", "c", "x"}});
        this.joinTesting(statement, "t2", "t1", " (select * from derby4631_t2) t2(x,y) ", " (select * from derby4631_t1) t1(x,y) ", " NATURAL LEFT OUTER JOIN ", "", new String[][]{{"b", "Y", "b", "Y"}, {"c", "x", "c", "x"}});
        this.joinTesting(statement, "derby4631_t2", "derby4631_t1", "derby4631_t2", "derby4631_t1", "  LEFT OUTER JOIN ", " USING(x,y)", new String[][]{{"b", "Y", "b", "Y"}, {"c", "x", "c", "x"}});
        this.joinTesting(statement, "derby4631_v2", "derby4631_v1", "derby4631_v2", "derby4631_v1", "  LEFT OUTER JOIN ", " USING(x,y)", new String[][]{{"b", "Y", "b", "Y"}, {"c", "x", "c", "x"}});
        this.joinTesting(statement, "gt2", "gt1", "session.gt2 gt2", "session.gt1 gt1", "  LEFT OUTER JOIN ", " USING(x,y)", new String[][]{{"b", "Y", "b", "Y"}, {"c", "x", "c", "x"}});
        this.joinTesting(statement, "v2", "v1", " (values ('b','Y'),('c','x')) v2(x,y) ", " (values('A','z'),('B','y')) v1(x,y) ", " LEFT OUTER JOIN ", " USING(x,y)", new String[][]{{"b", "Y", "b", "Y"}, {"c", "x", "c", "x"}});
        this.joinTesting(statement, "t2", "t1", " (select * from derby4631_t2) t2(x,y) ", " (select * from derby4631_t1) t1(x,y) ", " LEFT OUTER JOIN ", " USING(x,y)", new String[][]{{"b", "Y", "b", "Y"}, {"c", "x", "c", "x"}});
        if (string != null && string.equals("TERRITORY_BASED:SECONDARY")) {
            this.joinTesting(statement, "derby4631_t2", "derby4631_t1", "derby4631_t2", "derby4631_t1", " NATURAL RIGHT OUTER JOIN ", "", new String[][]{{"A", "z", "A", "z"}, {"b", "Y", "b", "Y"}});
            this.joinTesting(statement, "derby4631_v2", "derby4631_v1", "derby4631_v2", "derby4631_v1", " NATURAL RIGHT OUTER JOIN ", "", new String[][]{{"A", "z", "A", "z"}, {"b", "Y", "b", "Y"}});
            this.joinTesting(statement, "gt2", "gt1", "session.gt2 gt2", "session.gt1 gt1", " NATURAL RIGHT OUTER JOIN ", "", new String[][]{{"A", "z", "A", "z"}, {"b", "Y", "b", "Y"}});
            this.joinTesting(statement, "v2", "v1", " (values ('b','Y'),('c','x')) v2(x,y) ", " (values('A','z'),('B','y')) v1(x,y) ", " NATURAL RIGHT OUTER JOIN ", "", new String[][]{{"A", "z", "A", "z"}, {"b", "Y", "b", "Y"}});
            this.joinTesting(statement, "t2", "t1", " (select * from derby4631_t2) t2(x,y) ", " (select * from derby4631_t1) t1(x,y) ", " NATURAL RIGHT OUTER JOIN ", "", new String[][]{{"A", "z", "A", "z"}, {"b", "Y", "b", "Y"}});
            this.joinTesting(statement, "derby4631_t2", "derby4631_t1", "derby4631_t2", "derby4631_t1", " RIGHT OUTER JOIN ", " USING(x,y)", new String[][]{{"A", "z", "A", "z"}, {"b", "Y", "b", "Y"}});
            this.joinTesting(statement, "derby4631_v2", "derby4631_v1", "derby4631_v2", "derby4631_v1", " RIGHT OUTER JOIN ", " USING(x,y)", new String[][]{{"A", "z", "A", "z"}, {"b", "Y", "b", "Y"}});
            this.joinTesting(statement, "gt2", "gt1", "session.gt2 gt2", "session.gt1 gt1", " RIGHT OUTER JOIN ", " USING(x,y)", new String[][]{{"A", "z", "A", "z"}, {"b", "Y", "b", "Y"}});
            this.joinTesting(statement, "v2", "v1", " (values ('b','Y'),('c','x')) v2(x,y) ", " (values('A','z'),('B','y')) v1(x,y) ", " RIGHT OUTER JOIN ", " USING(x,y) ", new String[][]{{"A", "z", "A", "z"}, {"b", "Y", "b", "Y"}});
            this.joinTesting(statement, "t2", "t1", " (select * from derby4631_t2) t2(x,y) ", " (select * from derby4631_t1) t1(x,y) ", " RIGHT OUTER JOIN ", " USING(x,y)", new String[][]{{"A", "z", "A", "z"}, {"b", "Y", "b", "Y"}});
        } else {
            this.joinTesting(statement, "derby4631_t2", "derby4631_t1", "derby4631_t2", "derby4631_t1", " NATURAL RIGHT OUTER JOIN ", "", new String[][]{{"A", "z", "A", "z"}, {"B", "y", "B", "y"}});
            this.joinTesting(statement, "derby4631_v2", "derby4631_v1", "derby4631_v2", "derby4631_v1", " NATURAL RIGHT OUTER JOIN ", "", new String[][]{{"A", "z", "A", "z"}, {"B", "y", "B", "y"}});
            this.joinTesting(statement, "v2", "v1", " (values ('b','Y'),('c','x')) v2(x,y) ", " (values('A','z'),('B','y')) v1(x,y) ", " NATURAL RIGHT OUTER JOIN ", "", new String[][]{{"A", "z", "A", "z"}, {"B", "y", "B", "y"}});
            this.joinTesting(statement, "derby4631_t2", "derby4631_t1", "derby4631_t2", "derby4631_t1", " RIGHT OUTER JOIN ", " USING(x,y)", new String[][]{{"A", "z", "A", "z"}, {"B", "y", "B", "y"}});
            this.joinTesting(statement, "derby4631_v2", "derby4631_v1", "derby4631_v2", "derby4631_v1", " RIGHT OUTER JOIN ", " USING(x,y)", new String[][]{{"A", "z", "A", "z"}, {"B", "y", "B", "y"}});
            this.joinTesting(statement, "v2", "v1", " (values ('b','Y'),('c','x')) v2(x,y) ", " (values('A','z'),('B','y')) v1(x,y) ", " RIGHT OUTER JOIN ", " USING(x,y) ", new String[][]{{"A", "z", "A", "z"}, {"B", "y", "B", "y"}});
        }
        statement.executeUpdate("DROP TABLE session.gt1");
        statement.executeUpdate("DROP TABLE session.gt2");
        statement.executeUpdate("DROP VIEW derby4631_v1");
        statement.executeUpdate("DROP VIEW derby4631_v2");
        statement.executeUpdate("DROP TABLE derby4631_t1");
        statement.executeUpdate("DROP TABLE derby4631_t2");
    }

    private void joinTesting(Statement statement, String string, String string2, String string3, String string4, String string5, String string6, String[][] stringArray) throws SQLException {
        String string7 = "SELECT x, y,coalesce(" + string + ".x, " + string2 + ".x) cx, coalesce(" + string + ".y, " + string2 + ".y) cy FROM " + string3 + string5 + string4 + string6;
        this.checkLangBasedQuery(statement, string7, stringArray);
    }

    public void testEnglishCollation() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        this.setUpTable(statement);
        this.checkLangBasedQuery(statement, "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')", new String[][]{{"TERRITORY_BASED"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER ORDER BY NAME", new String[][]{{"6", "aacorn"}, {"4", "Acorn"}, {"2", "\u0104corn"}, {"0", "Smith"}, {"5", "\u015amith"}, {"1", "Zebra"}, {"3", "\u017bebra"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' = 'Acorn' ", null);
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' < 'Acorn'", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"2", "\u0104corn"}, {"3", "\u017bebra"}, {"4", "Acorn"}, {"5", "\u015amith"}, {"6", "aacorn"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER WHERE NAME <= 'Smith' ", new String[][]{{"0", "Smith"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"6", "aacorn"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER WHERE NAME between 'Acorn' and 'Zebra' ", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"5", "\u015amith"}});
        statement.executeUpdate("set schema SYS");
        CollationTest.assertStatementError("42818", statement, "SELECT ID, NAME FROM APP.CUSTOMER WHERE NAME <= 'Smith' ");
        statement.executeUpdate("set schema APP");
        this.checkLangBasedQuery(statement, "SELECT MAX(NAME) maxName FROM CUSTOMER ORDER BY maxName ", new String[][]{{"\u017bebra"}});
        this.checkLangBasedQuery(statement, "SELECT MIN(NAME) minName FROM CUSTOMER ORDER BY minName ", new String[][]{{"aacorn"}});
        this.commonTestingForTerritoryBasedDB(statement);
        statement.close();
    }

    public void testSwedishCaseInsensitiveCollation() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        this.setUpTable(statement);
        this.checkLangBasedQuery(statement, "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')", new String[][]{{"TERRITORY_BASED:SECONDARY"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER ORDER BY NAME", new String[][]{{"6", "aacorn"}, {"4", "Acorn"}, {"2", "\u0104corn"}, {"0", "Smith"}, {"5", "\u015amith"}, {"1", "Zebra"}, {"3", "\u017bebra"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' = 'Acorn' ", null);
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER where NAME = 'AaCorn' ORDER BY NAME ", new String[][]{{"6", "aacorn"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER where NAME like 'a%'", new String[][]{{"4", "Acorn"}, {"6", "aacorn"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER WHERE NAME <= 'Smith' ", new String[][]{{"0", "Smith"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"6", "aacorn"}});
        this.checkLangBasedQuery(statement, "SELECT ID, NAME FROM CUSTOMER WHERE NAME between 'acorn' and 'zebra' ", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"5", "\u015amith"}});
        statement.executeUpdate("set schema SYS");
        CollationTest.assertStatementError("42818", statement, "SELECT ID, NAME FROM APP.CUSTOMER WHERE NAME <= 'Smith' ");
        statement.executeUpdate("set schema APP");
        this.checkLangBasedQuery(statement, "SELECT MAX(NAME) maxName FROM CUSTOMER ORDER BY maxName ", new String[][]{{"\u017bebra"}});
        this.checkLangBasedQuery(statement, "SELECT MIN(NAME) minName FROM CUSTOMER ORDER BY minName ", new String[][]{{"aacorn"}});
        this.commonTestingForTerritoryBasedDB(statement);
        statement.close();
    }

    private void commonTestingForTerritoryBasedDB(Statement statement) throws SQLException {
        Connection connection = statement.getConnection();
        statement.executeUpdate("set schema APP");
        CollationTest.assertStatementError("42818", statement, "SELECT 1 FROM SYS.SYSTABLES WHERE  TABLENAME = 'CUSTOMER' ");
        this.checkLangBasedQuery(statement, "SELECT 1 FROM SYS.SYSTABLES WHERE CAST  (TABLENAME AS CHAR(15)) = 'CUSTOMER' ", new String[][]{{"1"}});
        CollationTest.assertStatementError("42818", statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE CASE  WHEN 1=1 THEN TABLENAME ELSE 'c' END = 'SYSCOLUMNS'");
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE CAST  ((CASE WHEN 1=1 THEN TABLENAME ELSE 'c' END) AS CHAR(12)) =  'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(statement, "SELECT count(*) FROM CUSTOMER WHERE CASE WHEN  1=1 THEN NAMECHAR ELSE NAME END = NAMECHAR", new String[][]{{"7"}});
        this.checkLangBasedQuery(statement, "SELECT count(*) FROM SYS.SYSTABLES WHERE CASE  WHEN 1=1 THEN TABLENAME ELSE TABLEID END = TABLENAME", new String[][]{{"26"}});
        CollationTest.assertStatementError("42818", statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TABLENAME || ' ' = 'SYSCOLUMNS '");
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST (TABLENAME || ' ' AS CHAR(12)) =  'SYSCOLUMNS '", new String[][]{{"SYSCOLUMNS"}});
        CollationTest.assertStatementError("42818", statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TABLENAME || ' ' = TABLENAME || 'SYSCOLUMNS '");
        CollationTest.assertStatementError("42818", statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  COALESCE(TABLENAME, 'c') = 'SYSCOLUMNS'");
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST (COALESCE (TABLENAME, 'c') AS CHAR(12)) =  'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        CollationTest.assertStatementError("42818", statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  NULLIF(TABLENAME, 'c') = 'SYSCOLUMNS'");
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  NULLIF (CAST (TABLENAME AS CHAR(12)), 'c' ) =  'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        statement.executeUpdate("set schema SYS");
        this.checkLangBasedQuery(statement, "SELECT CHAR(ID) FROM APP.CUSTOMER WHERE  CHAR(ID)='0'", new String[][]{{"0"}});
        this.checkLangBasedQuery(statement, "SELECT ID FROM APP.CUSTOMER WHERE  VARCHAR(NAME)='Smith'", new String[][]{{"0"}});
        statement.executeUpdate("set schema APP");
        CollationTest.assertStatementError("42818", statement, "SELECT CHAR(TABLENAME) FROM  SYS.SYSTABLES WHERE CHAR(TABLENAME)= TABLENAME AND  VARCHAR(TABLENAME) = 'SYSCOLUMNS'");
        this.checkLangBasedQuery(statement, "SELECT CHAR(TABLENAME) FROM SYS.SYSTABLES WHERE  CHAR(TABLENAME)= (CAST (TABLENAME AS CHAR(12))) AND  VARCHAR(TABLENAME) = 'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        CollationTest.assertStatementError("42818", statement, "SELECT count(*) FROM CUSTOMER WHERE CURRENT_USER = 'APP'");
        this.checkLangBasedQuery(statement, "SELECT count(*) FROM CUSTOMER WHERE CAST(CURRENT_USER AS CHAR(12)) = 'APP'", new String[][]{{"7"}});
        this.checkLangBasedQuery(statement, "SELECT count(*) FROM CUSTOMER WHERE SESSION_USER = USER", new String[][]{{"7"}});
        CollationTest.assertStatementError("42818", statement, "SELECT count(*) FROM CUSTOMER WHERE CURRENT ISOLATION = 'CS'");
        this.checkLangBasedQuery(statement, "SELECT count(*) FROM CUSTOMER WHERE CAST(CURRENT ISOLATION AS CHAR(12)) = 'CS'", new String[][]{{"7"}});
        statement.executeUpdate("set schema SYS");
        this.checkLangBasedQuery(statement, "SELECT count(*) FROM APP.CUSTOMER WHERE CURRENT SCHEMA = 'SYS'", new String[][]{{"7"}});
        statement.executeUpdate("set schema APP");
        if (XML.classpathMeetsXMLReqs()) {
            CollationTest.assertStatementError("42818", statement, "SELECT XMLSERIALIZE(x as CHAR(10))  FROM xmlTable, SYS.SYSTABLES WHERE  XMLSERIALIZE(x as CHAR(10)) = TABLENAME");
            this.checkLangBasedQuery(statement, "SELECT XMLSERIALIZE(x as CHAR(10)) FROM  xmlTable, SYS.SYSTABLES WHERE XMLSERIALIZE(x as CHAR(10)) =  CAST(TABLENAME AS CHAR(10))", null);
            this.assertCompileError("42Z70", "SELECT XMLSERIALIZE(x as CHAR(10))  FROM xmlTable, SYS.SYSTABLES WHERE  XMLSERIALIZE(? as CHAR(10)) = TABLENAME");
            this.assertCompileError("42Z70", "SELECT XMLSERIALIZE(x as CHAR(10)) FROM  xmlTable, SYS.SYSTABLES WHERE XMLSERIALIZE(? as CHAR(10)) =  CAST(TABLENAME AS CHAR(10))");
        }
        statement.executeUpdate("set schema APP");
        statement.executeUpdate("CREATE FUNCTION CONCAT_NOCALL(VARCHAR(10), VARCHAR(10))  RETURNS VARCHAR(20) RETURNS NULL ON NULL INPUT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.RoutineTest.concat'  LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.executeUpdate("CREATE FUNCTION AA.B() RETURNS VARCHAR(10) NO SQL PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME 'aaa.bbb.ccc' ");
        CollationTest.assertStatementError("XJ001", statement, "SELECT AA.B() FROM CUSTOMER ");
        statement.executeUpdate("set schema APP");
        PreparedStatement preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  ? = TABLENAME");
        preparedStatement.setString(1, "SYSCOLUMNS");
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCOLUMNS"}});
        this.assertCompileError("42818", "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  SUBSTR(?,2) = TABLENAME");
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  SUBSTR(?,2) = CAST(TABLENAME AS CHAR(10))");
        preparedStatement.setString(1, "aSYSCOLUMNS");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCOLUMNS"}});
        this.assertCompileError("42ZA2", "SELECT TABLENAME FROM SYS.SYSTABLES  WHERE TABLENAME || ? LIKE 'SYSCOLUMNS '");
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST((TABLENAME || ?) AS CHAR(20)) LIKE 'SYSCOLUMNS'");
        statement.executeUpdate("set schema SYS");
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES  WHERE TABLENAME || ? LIKE 'SYSCOLUMNS'");
        statement.executeUpdate("set schema APP");
        CollationTest.assertStatementError("42ZA2", statement, "SELECT TABLENAME FROM SYS.SYSTABLES  WHERE TABLENAME || 'AA' LIKE 'SYSCOLUMNS '");
        this.checkLangBasedQuery(statement, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST ((TABLENAME || 'AA') AS CHAR(12)) LIKE 'SYSCOLUMNS '", null);
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  ? IS NULL");
        preparedStatement.setString(1, " ");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertEmpty(resultSet);
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  ? IS NOT NULL");
        preparedStatement.setNull(1, 12);
        resultSet = preparedStatement.executeQuery();
        JDBC.assertEmpty(resultSet);
        this.assertCompileError("42X36", "SELECT COUNT(*) FROM CUSTOMER WHERE  LENGTH(?) != 0");
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TABLENAME NOT BETWEEN ? AND TABLENAME");
        preparedStatement.setString(1, " ");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertEmpty(resultSet);
        this.assertCompileError("42818", "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TABLENAME NOT BETWEEN ? AND 'SYSCOLUMNS'");
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  COALESCE(TABLENAME, ?) = ?");
        preparedStatement.setString(1, " ");
        preparedStatement.setString(2, "SYSCOLUMNS ");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCOLUMNS"}});
        this.assertCompileError("42818", "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  LTRIM(?) = TABLENAME");
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  LTRIM(?) = CAST(TABLENAME AS CHAR(10))");
        preparedStatement.setString(1, " SYSCOLUMNS");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCOLUMNS"}});
        this.assertCompileError("42818", "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  RTRIM(?) = TABLENAME");
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  RTRIM(?) = CAST(TABLENAME AS CHAR(10))");
        preparedStatement.setString(1, "SYSCOLUMNS  ");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCOLUMNS"}});
        this.assertCompileError("42818", "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TRIM('a' FROM ?) = TABLENAME");
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TRIM('a' FROM ?) = CAST(TABLENAME AS CHAR(10))");
        preparedStatement.setString(1, "aSYSCOLUMNS");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCOLUMNS"}});
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TRIM(LEADING SUBSTR(TABLENAME, LENGTH(TABLENAME)) FROM ?) = TABLENAME");
        preparedStatement.setString(1, "SYSCOLUMNS");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertEmpty(resultSet);
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  LOCATE(?, TABLENAME) != 0");
        preparedStatement.setString(1, "ABC");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertEmpty(resultSet);
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  LOCATE(TABLENAME, ?) != 0");
        preparedStatement.setString(1, "ABC");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertEmpty(resultSet);
        preparedStatement = this.prepareStatement("SELECT COUNT(*) FROM CUSTOMER WHERE ? IN  (SELECT TABLENAME FROM SYS.SYSTABLES)");
        preparedStatement.setString(1, "SYSCOLUMNS");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"7"}});
        this.assertCompileError("42818", "SELECT TABLENAME FROM SYS.SYSTABLES  WHERE TABLENAME NOT IN (?, ' SYSCOLUMNS ') AND  CAST(TABLENAME AS CHAR(10)) = 'SYSCOLUMNS' ");
        statement.executeUpdate("set schema SYS");
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES  WHERE TABLENAME NOT IN (?, ' SYSCOLUMNS ') AND  CAST(TABLENAME AS CHAR(10)) = 'SYSCOLUMNS' ");
        preparedStatement.setString(1, "aSYSCOLUMNS");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCOLUMNS"}});
        statement.executeUpdate("set schema APP");
        preparedStatement = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST(TABLENAME AS CHAR(10)) NOT IN (?, ' SYSCOLUMNS ') AND  CAST(TABLENAME AS CHAR(10)) = 'SYSCOLUMNS' ");
        preparedStatement.setString(1, "aSYSCOLUMNS");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCOLUMNS"}});
        statement.executeUpdate("set schema SYS");
        preparedStatement = this.prepareStatement("INSERT INTO APP.CUSTOMER(NAME) VALUES(?)");
        preparedStatement.setString(1, "SYSCOLUMNS");
        preparedStatement.executeUpdate();
        preparedStatement.close();
        statement.executeUpdate("INSERT INTO APP.CUSTOMER(NAME) VALUES('abc')");
        resultSet = statement.executeQuery("SELECT COUNT(*) FROM APP.CUSTOMER ");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"9"}});
        CollationTest.assertStatementError("42818", statement, "DELETE FROM APP.CUSTOMER WHERE NAME = 'abc'");
        statement.executeUpdate("set schema APP");
        statement.executeUpdate("DELETE FROM APP.CUSTOMER WHERE NAME = 'abc'");
        resultSet = statement.executeQuery("SELECT COUNT(*) FROM APP.CUSTOMER ");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"8"}});
        statement.executeUpdate("set schema APP");
        CollationTest.assertStatementError("42ZA3", statement, "CREATE TABLE T AS SELECT TABLENAME  FROM SYS.SYSTABLES WITH NO DATA");
        statement.executeUpdate("CREATE TABLE T AS SELECT COLUMNNUMBER FROM  SYS.SYSCOLUMNS WITH NO DATA");
        statement.execute("create table assoc (x char(10) not null primary key,  y char(100))");
        statement.execute("create table assocout(x char(10))");
        preparedStatement = this.prepareStatement("insert into assoc values (?, 'hello')");
        preparedStatement.setString(1, "10");
        preparedStatement.executeUpdate();
        statement.execute("CREATE TABLE DERBY_2955 (EMPNAME CHAR(20), CONSTRAINT  STAFF9_EMPNAME CHECK (EMPNAME NOT LIKE 'T%'))");
        statement.execute("CREATE TABLE DERBY_2960 (C CHAR(10), V VARCHAR(50))");
        statement.execute("INSERT INTO DERBY_2960 VALUES ('duplicate', 'is duplicated')");
        resultSet = statement.executeQuery("SELECT SUBSTR(c||v, 1, 4), COUNT(*) FROM DERBY_2960 GROUP BY SUBSTR(c||v, 1, 4)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"dupl", "1"}});
        preparedStatement = connection.prepareStatement("SELECT * FROM CUSTOMER FOR UPDATE", 1003, 1008);
        resultSet = preparedStatement.executeQuery();
        resultSet.moveToInsertRow();
        resultSet.close();
        preparedStatement.close();
        statement.execute("CREATE TABLE DERBY_2973 (V VARCHAR(40))");
        statement.execute("CREATE INDEX DERBY_2973_I1 ON DERBY_2973 (V)");
        statement.execute("ALTER TABLE DERBY_2973 ALTER V SET DATA TYPE VARCHAR(4096)");
        statement.execute("INSERT INTO DERBY_2973 VALUES('hello')");
        statement.executeUpdate("create table DERBY_2967(c11 int)");
        statement.executeUpdate("insert into DERBY_2967 values 1");
        preparedStatement = this.prepareStatement("select 1 from DERBY_2967 where '\ufa2d' like ?");
        String[] stringArray = new String[]{"%", "_", "\ufa2d"};
        for (int i = 0; i < stringArray.length; ++i) {
            preparedStatement.setString(1, stringArray[i]);
            resultSet = preparedStatement.executeQuery();
            JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        }
        statement.executeUpdate("set schema APP");
        if (XML.classpathMeetsXMLReqs()) {
            this.checkLangBasedQuery(statement, "SELECT ID, XMLSERIALIZE(V AS CLOB)  FROM DERBY_2961 ORDER BY 1", new String[][]{{"1", null}});
        }
        statement.executeUpdate("CREATE FUNCTION HELLO () RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.CollationTest.hello' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.executeUpdate("create table testing (a varchar(2024))");
        statement.executeUpdate("insert into testing values('hello')");
        resultSet = statement.executeQuery("select * from testing where a = HELLO()");
        JDBC.assertSingleValueResultSet(resultSet, "hello");
        statement.executeUpdate("DROP FUNCTION hello");
        statement.executeUpdate("DROP TABLE  testing");
        CollationTest.assertStatementError("42818", statement, "VALUES case WHEN SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.stream.error.logSeverityLevel') = '50000'  THEN 'LOGSHUTDOWN  ERRORS' ELSE 'DONT KNOW' END");
        resultSet = statement.executeQuery("VALUES case WHEN CAST(SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.stream.error.logSeverityLevel') AS VARCHAR(30000))   = '50000'  THEN 'LOGSHUTDOWN  ERRORS' ELSE 'DONT KNOW' END");
        JDBC.assertSingleValueResultSet(resultSet, "DONT KNOW");
        statement.executeUpdate("create table lockfunctesttable (i int)");
        connection.setAutoCommit(false);
        statement.executeUpdate("insert into lockfunctesttable values(1)");
        CollationTest.assertStatementError("42818", statement, "select * from SYSCS_DIAG.LOCK_TABLE where tablename = 'LOCKFUNCTESTTABLE'");
        preparedStatement = this.prepareStatement("select * from SYSCS_DIAG.LOCK_TABLE where tablename = ?");
        preparedStatement.setString(1, "LOCKFUNCTESTTABLE");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertDrainResults(resultSet, 2);
        statement.executeUpdate("drop table lockfunctesttable");
        statement.executeUpdate("create table a (vc varchar(30))");
        statement.executeUpdate("insert into a values(CURRENT_DATE)");
        resultSet = statement.executeQuery("select vc from a where vc <= CURRENT_DATE");
        CollationTest.assertEquals((int)1, (int)JDBC.assertDrainResults(resultSet));
        resultSet = statement.executeQuery("select vc from a where vc <= UPPER(CURRENT_DATE)");
        JDBC.assertDrainResults(resultSet, 1);
        resultSet = statement.executeQuery("select vc from a where vc <= LOWER(CURRENT_DATE)");
        JDBC.assertDrainResults(resultSet, 1);
        resultSet = statement.executeQuery("select vc from a where vc <=  '' || CURRENT_DATE");
        JDBC.assertDrainResults(resultSet, 1);
        resultSet = statement.executeQuery("select vc from a where '' || CURRENT_DATE >= vc");
        JDBC.assertDrainResults(resultSet, 1);
        CollationTest.assertStatementError("42818", statement, "select TABLENAME FROM SYS.SYSTABLES WHERE UPPER(CURRENT_DATE) = TABLENAME");
        preparedStatement = this.prepareStatement("select vc from a where  CAST (? AS VARCHAR(30)) = vc");
        preparedStatement.setString(1, "hello");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select vc from a where '1.2' + 1.2 = 2.4");
        JDBC.assertDrainResults(resultSet, 1);
        statement.executeUpdate("create table t1 (vc varchar(30))");
        statement.executeUpdate("create table t2 (vc varchar(30))");
        statement.executeUpdate("insert into t2 values('hello2')");
        resultSet = statement.executeQuery("select vc from t2 where vc = (select vc from t2 union select vc from t)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"hello2"}});
        statement.executeUpdate("drop table t1");
        statement.executeUpdate("drop table t2");
        resultSet = statement.executeQuery("VALUES CURRENT_DATE");
        resultSet.next();
        Date date = resultSet.getDate(1);
        statement.executeUpdate("create table t1 (vc varchar(30))");
        statement.executeUpdate("insert into t1 values(CURRENT_DATE)");
        preparedStatement = this.prepareStatement("select vc from t1 where vc like ? escape '%'");
        preparedStatement.setDate(1, date);
        resultSet = preparedStatement.executeQuery();
        JDBC.assertDrainResults(resultSet);
        statement.executeUpdate("drop table t1");
        statement.close();
    }

    public static String hello() {
        return "hello";
    }

    public static String mimic(String string) {
        return string;
    }

    private void setUpTable(Statement statement) throws SQLException {
        statement.execute("CREATE TABLE CUSTOMER(ID INT, NAME VARCHAR(40), NAMECHAR CHAR(40))");
        Connection connection = statement.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO CUSTOMER VALUES(?,?,?)");
        for (int i = 0; i < NAMES.length; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, NAMES[i]);
            preparedStatement.setString(3, NAMES[i]);
            preparedStatement.executeUpdate();
        }
        statement.execute("create table xmlTable (x xml)");
        statement.executeUpdate("insert into xmlTable values(null)");
        statement.execute("create table DERBY_2961 (ID INT  GENERATED ALWAYS AS  IDENTITY PRIMARY KEY, V XML)");
        statement.executeUpdate("insert into DERBY_2961(V) values(null)");
        connection.commit();
        preparedStatement.close();
    }

    private void checkLangBasedQuery(Statement statement, String string, String[][] stringArray) throws SQLException {
        ResultSet resultSet = statement.executeQuery(string);
        if (stringArray == null) {
            JDBC.assertEmpty(resultSet);
        } else {
            JDBC.assertFullResultSet(resultSet, stringArray);
        }
    }

    public void testMissingCollatorSupport() throws SQLException {
        String string = ";create=true;territory=xx;collation=TERRITORY_BASED";
        try {
            TestUtil.getConnection("missingCollatorDB", string);
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState("Unexpected error when connecting to database ", "XBM04", sQLException);
        }
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("CollationTest");
        CollationTest collationTest = new CollationTest("testMissingCollatorSupport");
        baseTestSuite.addTest((Test)collationTest);
        baseTestSuite.addTest((Test)new CleanDatabaseTestSetup((Test)new CollationTest("testDefaultCollation")));
        baseTestSuite.addTest(CollationTest.collatedSuite("en", false, ENGLISH_CASE_SENSITIVE));
        baseTestSuite.addTest(CollationTest.collatedSuite("en", true, ENGLISH_CASE_INSENSITIVE));
        Locale[] localeArray = Collator.getAvailableLocales();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < localeArray.length; ++i) {
            if ("no".equals(localeArray[i].getLanguage())) {
                bl = true;
            }
            if ("pl".equals(localeArray[i].getLanguage())) {
                bl2 = true;
            }
            if ("fr".equals(localeArray[i].getLanguage())) {
                bl3 = true;
            }
            if (!"sv".equals(localeArray[i].getLanguage())) continue;
            bl4 = true;
        }
        if (bl) {
            baseTestSuite.addTest(CollationTest.collatedSuite("no", false, NORWEGIAN_CASE_SENSITIVE));
        }
        if (bl2) {
            baseTestSuite.addTest(CollationTest.collatedSuite("pl", false, POLISH_CASE_SENSITIVE));
        }
        if (bl3) {
            baseTestSuite.addTest(CollationTest.collatedSuite("fr", false, FRENCH_CASE_SENSITIVE));
        }
        if (bl4 && !CollationTest.hasBuggySwedishLocale()) {
            baseTestSuite.addTest(CollationTest.collatedSuite("sv", true, SWEDISH_CASE_INSENSITIVE));
        }
        return baseTestSuite;
    }

    private static boolean hasBuggySwedishLocale() {
        Collator collator = Collator.getInstance(new Locale("sv"));
        return collator.compare("aa", "ab") >= 0;
    }

    private static Test collatedSuite(String string, boolean bl, String[] stringArray) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("CollationTest:territory=" + string);
        for (int i = 0; i < stringArray.length; ++i) {
            baseTestSuite.addTest((Test)new CollationTest(stringArray[i]));
        }
        if ("en".equals(string)) {
            baseTestSuite.addTest(DatabaseMetaDataTest.suite());
            baseTestSuite.addTest(BatchUpdateTest.embeddedSuite());
            baseTestSuite.addTest(GroupByExpressionTest.suite());
            baseTestSuite.addTest(UpdatableResultSetTest.suite());
        }
        return bl ? Decorator.territoryCollatedCaseInsensitiveDatabase((Test)baseTestSuite, string) : Decorator.territoryCollatedDatabase((Test)baseTestSuite, string);
    }

    public void test_5951() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE derby5951( a clob )");
        statement.execute("create function makeClob( contents varchar( 32672 ) ) returns clob\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.CollationTest.makeClob'\n");
        statement.executeUpdate("INSERT INTO derby5951 VALUES( makeClob( 'a' ) )");
        ResultSet resultSet = statement.executeQuery("select * from derby5951");
        JDBC.assertSingleValueResultSet(resultSet, "a");
        statement.executeUpdate("DROP TABLE derby5951");
        statement.executeUpdate("DROP function makeClob");
    }

    public static Clob makeClob(String string) throws Exception {
        return new HarmonySerialClob(string);
    }

    public void testLikeEscapeClauseLengthRestriction() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table d6030(x varchar(10), y varchar(10), z varchar(10))");
        statement.execute("insert into d6030 values ('a', 'b', 'c')");
        PreparedStatement preparedStatement = this.prepareStatement("select * from d6030 where x like y escape z");
        PreparedStatement preparedStatement2 = this.prepareStatement("update d6030 set z = ?");
        JDBC.assertEmpty(preparedStatement.executeQuery());
        preparedStatement2.setString(1, "\u00df");
        CollationTest.assertUpdateCount(preparedStatement2, 1);
        CollationTest.assertStatementError(INVALID_ESCAPE, preparedStatement);
        preparedStatement2.setString(1, "aa");
        CollationTest.assertUpdateCount(preparedStatement2, 1);
        CollationTest.assertStatementError(INVALID_ESCAPE, preparedStatement);
        JDBC.assertEmpty(statement.executeQuery("select * from d6030 where x like y escape 'c'"));
        CollationTest.assertStatementError(INVALID_ESCAPE, statement, "select * from d6030 where x like y escape '\u00df'");
        CollationTest.assertStatementError(INVALID_ESCAPE, statement, "select * from d6030 where x like y escape 'aa'");
    }

    public void testDerby6227() throws SQLException {
        String string = "select i, count(distinct s) from (values (1, 'a'), (1, 'a'), (2, 'b'), (2, 'B'), (3, 'a'), (3, 'A'), (3, 'b'), (3, 'B'), (3, 'c')) v(i, s) group by i order by i";
        String[][] stringArray = new String[][]{{"1", "1"}, {"2", "1"}, {"3", "3"}};
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery(string), stringArray);
    }

    public void testDerby6890() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE Module (id BIGINT NOT NULL, title VARCHAR(200), CONSTRAINT PK_MODULE PRIMARY KEY (id))");
        statement.execute("CREATE INDEX Module_title ON Module(title)");
        statement.execute("ALTER TABLE MODULE ADD COLUMN ID_TEMP BIGINT GENERATED BY DEFAULT AS IDENTITY");
        statement.execute("UPDATE MODULE SET ID_TEMP = ID");
        statement.execute("ALTER TABLE MODULE ALTER COLUMN ID_TEMP NOT NULL");
        statement.execute("ALTER TABLE MODULE DROP ID");
        statement.execute("RENAME COLUMN MODULE.ID_TEMP TO ID");
        statement.execute("ALTER TABLE MODULE ADD CONSTRAINT PK_MODULE PRIMARY KEY (ID)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into Module(title) values(?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 295; ++i) {
            preparedStatement.setString(1, "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
            preparedStatement.executeUpdate();
        }
        this.commit();
    }
}

