/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.catalog.SystemProcedures;
import org.apache.derby.iapi.jdbc.InternalDriver;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.sql.dictionary.UserDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;
import org.apache.derby.shared.common.error.SQLWarningFactory;
import org.apache.derby.shared.common.error.StandardException;

public final class NativeAuthenticationServiceImpl
extends AuthenticationServiceBase
implements UserAuthenticator {
    private boolean _creatingCredentialsDB = false;
    private String _credentialsDB;
    private boolean _authenticateDatabaseOperationsLocally;
    private long _passwordLifetimeMillis = 2678400000L;
    private double _passwordExpirationThreshold = 0.125;
    private String _badlyFormattedPasswordProperty;

    @Override
    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        if (PropertyUtil.nativeAuthenticationEnabled(properties)) {
            this.parseNativeSpecification(properties);
            return true;
        }
        return false;
    }

    private void parseNativeSpecification(Properties properties) {
        String expirationThresholdString;
        int dbNameEndIdx;
        String authenticationProvider = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        this._authenticateDatabaseOperationsLocally = PropertyUtil.localNativeAuthenticationEnabled(properties);
        int dbNameStartIdx = authenticationProvider.indexOf(":") + 1;
        int n = dbNameEndIdx = this._authenticateDatabaseOperationsLocally ? authenticationProvider.lastIndexOf(":") : authenticationProvider.length();
        if (dbNameEndIdx > dbNameStartIdx) {
            this._credentialsDB = authenticationProvider.substring(dbNameStartIdx, dbNameEndIdx);
            if (this._credentialsDB.length() == 0) {
                this._credentialsDB = null;
            }
        }
        this._badlyFormattedPasswordProperty = null;
        String passwordLifetimeString = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.native.passwordLifetimeMillis");
        if (passwordLifetimeString != null) {
            Long passwordLifetime = this.parsePasswordLifetime(passwordLifetimeString);
            if (passwordLifetime != null) {
                this._passwordLifetimeMillis = passwordLifetime;
            } else {
                this._badlyFormattedPasswordProperty = "derby.authentication.native.passwordLifetimeMillis";
            }
        }
        if ((expirationThresholdString = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.native.passwordLifetimeThreshold")) != null) {
            Double expirationThreshold = this.parsePasswordThreshold(expirationThresholdString);
            if (expirationThreshold != null) {
                this._passwordExpirationThreshold = expirationThreshold;
            } else {
                this._badlyFormattedPasswordProperty = "derby.authentication.native.passwordLifetimeThreshold";
            }
        }
    }

    private boolean validAuthenticationProvider() throws StandardException {
        boolean systemWideAuthentication;
        boolean bl = systemWideAuthentication = this.getServiceName() == null;
        if (this._credentialsDB != null) {
            if (NativeAuthenticationServiceImpl.getMonitor().getCanonicalServiceName(this._credentialsDB) == null) {
                throw StandardException.newException("4251L", this._credentialsDB);
            }
            return true;
        }
        if (systemWideAuthentication) {
            return false;
        }
        return this._authenticateDatabaseOperationsLocally;
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        super.boot(create, properties);
        if (!this.validAuthenticationProvider()) {
            throw StandardException.newException("4251H", new Object[0]);
        }
        if (this._badlyFormattedPasswordProperty != null) {
            throw StandardException.newException("4251J", this._badlyFormattedPasswordProperty);
        }
        try {
            MessageDigest digestAlgorithm = MessageDigest.getInstance("SHA-1");
            digestAlgorithm.reset();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw Monitor.exceptionStartingModule(nsae);
        }
        this._creatingCredentialsDB = create && this.authenticatingInThisService(this.getCanonicalServiceName());
        this.setAuthenticationService(this);
    }

    @Override
    public String getSystemCredentialsDatabaseName() {
        return this._credentialsDB;
    }

    @Override
    public boolean authenticateUser(String userName, String userPassword, String databaseName, Properties info) throws SQLException {
        try {
            if (userName == null) {
                return false;
            }
            if (userPassword == null) {
                return false;
            }
            if (databaseName == null || !this.authenticatingInThisDatabase(databaseName)) {
                return this.authenticateRemotely(userName, userPassword, databaseName);
            }
            return this.authenticateLocally(userName, userPassword, databaseName);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    private boolean authenticatingInThisDatabase(String userVisibleDatabaseName) throws StandardException {
        return this.authenticatingInThisService(NativeAuthenticationServiceImpl.getMonitor().getCanonicalServiceName(userVisibleDatabaseName));
    }

    private boolean authenticatingInThisService(String canonicalDatabaseName) throws StandardException {
        if (this._authenticateDatabaseOperationsLocally) {
            return true;
        }
        return this.isCredentialsService(canonicalDatabaseName);
    }

    private boolean isCredentialsService(String canonicalDatabaseName) throws StandardException {
        String canonicalCredentialsDBName = this.getCanonicalServiceName(this._credentialsDB);
        String canonicalDB = NativeAuthenticationServiceImpl.getMonitor().getCanonicalServiceName(canonicalDatabaseName);
        if (canonicalCredentialsDBName == null) {
            return false;
        }
        return canonicalCredentialsDBName.equals(canonicalDatabaseName);
    }

    private String getCanonicalServiceName() throws StandardException {
        return this.getCanonicalServiceName(this.getServiceName());
    }

    private String getCanonicalServiceName(String rawName) throws StandardException {
        return NativeAuthenticationServiceImpl.getMonitor().getCanonicalServiceName(rawName);
    }

    private boolean authenticateRemotely(String userName, String userPassword, String databaseName) throws StandardException, SQLWarning {
        if (this._credentialsDB == null) {
            throw StandardException.newException("4251H", new Object[0]);
        }
        SQLWarning warnings = null;
        try {
            Properties properties = new Properties();
            properties.setProperty("user", userName);
            properties.setProperty("password", userPassword);
            String connectionURL = "jdbc:derby:" + this._credentialsDB;
            Connection conn = InternalDriver.activeDriver().connect(connectionURL, properties, 0);
            warnings = conn.getWarnings();
            conn.close();
        }
        catch (SQLException se) {
            String sqlState = se.getSQLState();
            if ("08004".equals(sqlState)) {
                return false;
            }
            if ("XJ004.C".startsWith(sqlState)) {
                throw StandardException.newException("4251I", this._credentialsDB);
            }
            throw this.wrap(se);
        }
        if (warnings != null) {
            throw warnings;
        }
        return true;
    }

    private StandardException wrap(Throwable t) {
        return StandardException.plainWrapException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateLocally(String userName, String userPassword, String databaseName) throws StandardException, SQLException {
        userName = IdUtil.getUserAuthorizationId(userName);
        if (this._creatingCredentialsDB) {
            this._creatingCredentialsDB = false;
            TransactionController tc = this.getTransaction();
            SystemProcedures.addUser(userName, userPassword, tc);
            tc.commit();
            return true;
        }
        DataDictionary dd = (DataDictionary)AuthenticationServiceBase.getServiceModule(this, "org.apache.derby.iapi.sql.dictionary.DataDictionary");
        UserDescriptor userDescriptor = dd.getUser(userName);
        if (userDescriptor == null) {
            PasswordHasher hasher = dd.makePasswordHasher(this.getDatabaseProperties());
            hasher.hashPasswordIntoString(userName, userPassword).toCharArray();
            return false;
        }
        PasswordHasher hasher = new PasswordHasher(userDescriptor.getHashingScheme());
        char[] candidatePassword = hasher.hashPasswordIntoString(userName, userPassword).toCharArray();
        char[] actualPassword = userDescriptor.getAndZeroPassword();
        try {
            if (candidatePassword == null || actualPassword == null) {
                boolean bl = false;
                return bl;
            }
            if (candidatePassword.length != actualPassword.length) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < candidatePassword.length; ++i) {
                if (candidatePassword[i] == actualPassword[i]) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (candidatePassword != null) {
                Arrays.fill(candidatePassword, '\u0000');
            }
            if (actualPassword != null) {
                Arrays.fill(actualPassword, '\u0000');
            }
        }
        if (this._passwordLifetimeMillis > 0L) {
            long expirationThreshold;
            long passwordAge = System.currentTimeMillis() - userDescriptor.getLastModified().getTime();
            long remainingLifetime = this._passwordLifetimeMillis - passwordAge;
            if (remainingLifetime <= 0L) {
                if (!dd.getAuthorizationDatabaseOwner().equals(userName)) {
                    return false;
                }
                remainingLifetime = 0L;
            }
            if (remainingLifetime <= (expirationThreshold = (long)((double)this._passwordLifetimeMillis * this._passwordExpirationThreshold))) {
                if (dd.getAuthorizationDatabaseOwner().equals(userName)) {
                    throw SQLWarningFactory.newSQLWarning("01J16", databaseName);
                }
                long daysRemaining = remainingLifetime / 86400000L;
                throw SQLWarningFactory.newSQLWarning("01J15", Long.toString(daysRemaining), databaseName);
            }
        }
        return true;
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static String getServiceName(Object serviceModule) {
        return Monitor.getServiceName(serviceModule);
    }
}

