/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class TestRoutines {
    public static void installRoutines() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        TestRoutines.installRoutines(conn);
    }

    public static void installRoutines(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("CREATE PROCEDURE TESTROUTINE.SET_SYSTEM_PROPERTY(IN PROPERTY_KEY VARCHAR(32000), IN PROPERTY_VALUE VARCHAR(32000)) NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.TestRoutines.setSystemProperty' language java parameter style java");
        s.execute("CREATE PROCEDURE TESTROUTINE.SLEEP(IN SLEEP_TIME_MS BIGINT) NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.TestRoutines.sleep' language java parameter style java");
        s.execute("CREATE FUNCTION TESTROUTINE.READ_FILE(FILE_NAME VARCHAR(60), ENCODING VARCHAR(60)) RETURNS VARCHAR(32000) NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.TestRoutines.readFile' language java parameter style java");
        s.close();
    }

    public static void setSystemProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public static void sleep(long ms) throws InterruptedException {
        Thread.sleep(ms);
    }

    public static String readFile(String fileName, String encoding) throws IOException {
        int ci;
        FileInputStream fin = new FileInputStream(fileName);
        InputStreamReader isr = new InputStreamReader((InputStream)new BufferedInputStream(fin, 32768), encoding);
        StringBuffer sb = new StringBuffer();
        while ((ci = isr.read()) >= 0) {
            if (ci <= 127) {
                sb.append((char)ci);
                continue;
            }
            sb.append("\\u");
            String hex = Integer.toHexString(ci);
            switch (hex.length()) {
                case 2: {
                    sb.append("00");
                    break;
                }
                case 3: {
                    sb.append("0");
                }
            }
            sb.append(hex);
        }
        return sb.toString();
    }
}

