/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.storetests;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class st_reclaim_longcol
extends BaseJDBCTestCase {
    static boolean verbose = false;

    public st_reclaim_longcol(String name) {
        super(name);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(st_reclaim_longcol.class));
    }

    private void test1(int blob_size, int num_rows) throws SQLException {
        byte[] long_byteVal = new byte[blob_size];
        byte[] short_byteVal = new byte[10];
        st_reclaim_longcol.println("test1:insert/delete of " + num_rows + " rows with blob(" + blob_size + ")");
        Arrays.fill(long_byteVal, (byte)76);
        Arrays.fill(short_byteVal, (byte)83);
        Statement s = this.createStatement();
        this.dropTable("LONGCOL");
        s.execute("create table longcol (id int primary key not null, val blob(" + blob_size + "))");
        this.commit();
        PreparedStatement ins_stmt = this.prepareStatement("insert into longcol values (?, ?)");
        PreparedStatement del_stmt = this.prepareStatement("delete from longcol where id = ?");
        int worst_case_max_allocated = 5;
        for (int iter = 1; iter < num_rows; ++iter) {
            ins_stmt.setInt(1, iter);
            ins_stmt.setBytes(2, long_byteVal);
            ins_stmt.executeUpdate();
            ins_stmt.setInt(1, -iter);
            ins_stmt.setBytes(2, short_byteVal);
            ins_stmt.executeUpdate();
            del_stmt.setInt(1, iter);
            del_stmt.executeUpdate();
            this.commit();
            this.wait_for_max_allocated("test1", ++worst_case_max_allocated);
        }
        ResultSet rs = this.getSpaceTable("LONGCOL");
        st_reclaim_longcol.assertTrue((String)"Space table was empty", (boolean)rs.next());
        int allocated = rs.getInt("NUMALLOCATEDPAGES");
        int free = rs.getInt("NUMFREEPAGES");
        int total_pages = allocated + free;
        st_reclaim_longcol.println("Space information after " + num_rows + "insert/delete pairs of rows in longcol table containing " + blob_size + "blobs:");
        this.printCurrentRow(rs);
        JDBC.assertEmpty(rs);
        int total_expected_page_max = 12 + num_rows;
        if (total_pages > total_expected_page_max) {
            st_reclaim_longcol.fail((String)("Test 1 failed, expected less than " + total_expected_page_max + " pages - count is:\nfree pages     : " + free + "\nallocated pages: " + allocated));
        }
        this.commit();
    }

    private void test2(int blob_size, int work_size, int total_work) throws SQLException {
        int iter;
        byte[] long_byteVal = new byte[blob_size];
        byte[] short_byteVal = new byte[10];
        st_reclaim_longcol.println("test2:queue of " + work_size + " rows with blob(" + blob_size + "), total_work = " + total_work);
        Arrays.fill(long_byteVal, (byte)76);
        Arrays.fill(short_byteVal, (byte)83);
        Statement s = this.createStatement();
        this.dropTable("LONGCOL");
        s.execute("create table longcol (id int primary key not null, val blob(" + blob_size + "))");
        PreparedStatement ins_stmt = this.prepareStatement("insert into longcol values (?, ?)");
        PreparedStatement del_stmt = this.prepareStatement("delete from longcol where id = ?");
        for (iter = 0; iter < work_size; ++iter) {
            ins_stmt.setInt(1, iter);
            ins_stmt.setBytes(2, long_byteVal);
            ins_stmt.executeUpdate();
        }
        this.commit();
        for (iter = work_size; iter < total_work; ++iter) {
            ins_stmt.setInt(1, iter);
            ins_stmt.setBytes(2, long_byteVal);
            ins_stmt.executeUpdate();
            del_stmt.setInt(1, iter - work_size);
            del_stmt.executeUpdate();
            this.commit();
        }
        this.wait_for_max_allocated("test2", 10 * work_size + 5);
        ResultSet rs = this.getSpaceTable("LONGCOL");
        st_reclaim_longcol.assertTrue((String)"Space table was empty", (boolean)rs.next());
        int total_pages = rs.getInt("NUMALLOCATEDPAGES") + rs.getInt("NUMFREEPAGES");
        st_reclaim_longcol.println("Space information:");
        this.printCurrentRow(rs);
        JDBC.assertEmpty(rs);
        this.commit();
        for (int iter2 = total_work; iter2 < total_work * 2; ++iter2) {
            ins_stmt.setInt(1, iter2);
            ins_stmt.setBytes(2, long_byteVal);
            ins_stmt.executeUpdate();
            del_stmt.setInt(1, iter2 - work_size);
            del_stmt.executeUpdate();
            this.commit();
        }
        this.wait_for_max_allocated("test2_2", 10 * work_size + 5);
        rs = this.getSpaceTable("LONGCOL");
        st_reclaim_longcol.assertTrue((String)"Space table was empty", (boolean)rs.next());
        int second_total_pages = rs.getInt("NUMALLOCATEDPAGES") + rs.getInt("NUMFREEPAGES");
        st_reclaim_longcol.println("Space information:");
        this.printCurrentRow(rs);
        JDBC.assertEmpty(rs);
        this.commit();
        if (total_pages != second_total_pages) {
            st_reclaim_longcol.fail((String)("Test 2 failed, expected constant memory after second run.initial total = " + total_pages + "second total = " + second_total_pages));
        }
    }

    private ResultSet getSpaceTable(String table) throws SQLException {
        PreparedStatement ps = this.prepareStatement("select * from table(syscs_diag.space_table(?)) t where isindex = 0");
        ps.setString(1, table);
        return ps.executeQuery();
    }

    private void printCurrentRow(ResultSet rs) throws SQLException {
        if (TestConfiguration.getCurrent().isVerbose()) {
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                st_reclaim_longcol.println(rsmd.getColumnName(col) + ": " + rs.getObject(col));
            }
        }
    }

    private void wait_for_max_allocated(String test_name, int alloc_wait_count) throws SQLException {
        st_reclaim_longcol.sleep(100L);
        Integer save_total_alloc = null;
        int max_wait_for_bg_thread = 10000;
        int ms_waited = 100;
        while (true) {
            ResultSet rs = this.getSpaceTable("LONGCOL");
            st_reclaim_longcol.assertTrue((String)"Space table was empty", (boolean)rs.next());
            int total_alloc = rs.getInt("NUMALLOCATEDPAGES");
            int free = rs.getInt("NUMFREEPAGES");
            JDBC.assertEmpty(rs);
            if (total_alloc <= alloc_wait_count) break;
            if (save_total_alloc == null) {
                save_total_alloc = total_alloc;
            }
            if (ms_waited < max_wait_for_bg_thread) {
                ms_waited += 1000;
                st_reclaim_longcol.sleep(1000L);
                continue;
            }
            if (total_alloc < save_total_alloc) {
                save_total_alloc = total_alloc;
                max_wait_for_bg_thread += 10000;
                continue;
            }
            st_reclaim_longcol.fail((String)("Test " + test_name + " failed in wait_for_max_allocated(), expected less than " + alloc_wait_count + " allocated pages:\nfree pages     : " + free + "\nallocated pages: " + total_alloc + "\nWaited " + ms_waited + "ms. for background work."));
        }
    }

    public void testList() throws SQLException {
        this.setAutoCommit(false);
        this.test1(250000, 20);
    }
}

