/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public class BooleanValuesTest
extends GeneratedColumnsHelper {
    private static final String ILLEGAL_GET = "22005";
    private static final String ILLEGAL_XML_SELECTION = "42Z71";
    private static final String BAD_CAST = "22018";
    private static final String NOT_UNION_COMPATIBLE = "42X61";
    private static final String BAD_CONVERSION = "42846";
    private static final String ILLEGAL_INSERT = "42821";
    private static final String BAD_DEFAULT = "42894";
    private static final String ILLEGAL_UPDATE = "XCL12";
    private static final String NON_BOOLEAN_OPERAND = "42Y94";
    private boolean _supportsXML = XML.classpathMeetsXMLReqs();

    public BooleanValuesTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite result = (BaseTestSuite)TestConfiguration.defaultSuite(BooleanValuesTest.class);
        return result;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Connection conn = this.getConnection();
        if (!this.routineExists(conn, "MAKESIMPLEBLOB")) {
            this.goodStatement(conn, "create function makeSimpleBlob( ) returns blob\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.BooleanValuesTest.makeSimpleBlob'\n");
        }
        if (!this.tableExists(conn, "ALL_TYPES")) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("create table all_types\n(\n    key_col int,\n    bigint_col  BIGINT,\n    blob_col  BLOB(2147483647),\n    char_col  CHAR(10),\n    char_for_bit_data_col  CHAR (10) FOR BIT DATA,\n    clob_col  CLOB(2147483647),\n    date_col  DATE,\n    decimal_col  DECIMAL(5,2),\n    real_col  REAL,\n    double_col  DOUBLE,\n    int_col  INTEGER,\n    long_varchar_col  LONG VARCHAR,\n    long_varchar_for_bit_data_col  LONG VARCHAR FOR BIT DATA,\n    numeric_col  NUMERIC(5,2), \n    smallint_col  SMALLINT,\n    time_col  TIME,\n    timestamp_col  TIMESTAMP,\n    varchar_col  VARCHAR(10),\n    varchar_for_bit_data_col  VARCHAR (10) FOR BIT DATA\n");
            if (this._supportsXML) {
                buffer.append("    ,xml_col  XML\n");
            }
            buffer.append(")\n");
            this.goodStatement(conn, buffer.toString());
            buffer = new StringBuffer();
            buffer.append("insert into all_types\n(\n    key_col,\n    bigint_col,\n    blob_col,\n    char_col,\n    char_for_bit_data_col,\n    clob_col,\n    date_col,\n    decimal_col,\n    real_col,\n    double_col,\n    int_col,\n    long_varchar_col,\n    long_varchar_for_bit_data_col,\n    numeric_col, \n    smallint_col,\n    time_col,\n    timestamp_col,\n    varchar_col,\n    varchar_for_bit_data_col\n");
            if (this._supportsXML) {
                buffer.append("    ,xml_col\n");
            }
            buffer.append(")\nvalues\n(\n    0,\n    0,\n    makeSimpleBlob(),\n    '0',\n    X'DE',\n    '0',\n    date('1994-02-23'),\n    0.00,\n    0.0,\n    0.0,\n    0,\n    '0',\n    X'DE',\n    0.00, \n    0,\n    time('15:09:02'),\n    timestamp('1962-09-23 03:23:34.234'),\n    '0',\n    X'DE'\n");
            if (this._supportsXML) {
                buffer.append("    , xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html/>' preserve whitespace )\n");
            }
            buffer.append("),\n(\n    1,\n    1,\n    makeSimpleBlob(),\n    '1',\n    X'DE',\n    '1',\n    date('1994-02-23'),\n    1.00,\n    1.0,\n    1.0,\n    1,\n    '1',\n    X'DE',\n    1.00, \n    1,\n    time('15:09:02'),\n    timestamp('1962-09-23 03:23:34.234'),\n    '1',\n    X'DE'\n");
            if (this._supportsXML) {
                buffer.append("    , xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html/>' preserve whitespace )\n");
            }
            buffer.append("),\n(\n    2,\n    2,\n    makeSimpleBlob(),\n    '2',\n    X'DE',\n    '2',\n    date('1994-02-23'),\n    2.00,\n    2.0,\n    2.0,\n    2,\n    '2',\n    X'DE',\n    2.00, \n    2,\n    time('15:09:02'),\n    timestamp('1962-09-23 03:23:34.234'),\n    '2',\n    X'DE'\n");
            if (this._supportsXML) {
                buffer.append("    , xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html/>' preserve whitespace )\n");
            }
            buffer.append("),\n(\n    3,\n    3,\n    makeSimpleBlob(),\n    'baffle',\n    X'DE',\n    'baffle',\n    date('1994-02-23'),\n    3.00,\n    3.0,\n    3.0,\n    3,\n    'baffle',\n    X'DE',\n    3.00, \n    3,\n    time('15:09:02'),\n    timestamp('1962-09-23 03:23:34.234'),\n    'baffle',\n    X'DE'\n");
            if (this._supportsXML) {
                buffer.append("    , xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html/>' preserve whitespace )\n");
            }
            buffer.append(")\n");
            this.goodStatement(conn, buffer.toString());
        }
        if (!this.tableExists(conn, "BOOLEANSTRING")) {
            this.goodStatement(conn, "create table booleanString( keyCol int, stringCol varchar( 20 ) )");
            this.goodStatement(conn, "insert into booleanString( keyCol, stringCol )\nvalues ( 0, 'false' ), ( 1, 'true' ), ( 2, null ), ( 3, 'unknown' ), ( 10, ' false ' ), ( 11, ' true ' ), ( 12, null ), ( 13, ' unknown ' )\n");
        }
        if (!this.tableExists(conn, "T_4704")) {
            this.goodStatement(conn, "create table t_4704( keyCol int, stringCol varchar( 20 ) not null )");
            this.goodStatement(conn, "insert into t_4704( keyCol, stringCol )\nvalues ( 0, 'false' ), ( 1, 'true' ), ( 2, 'unknown' )\n");
        }
        if (!this.tableExists(conn, "STRING_TYPES")) {
            this.goodStatement(conn, "create table string_types\n(\n    key_col int,\n    char_col  CHAR(10),\n    clob_col  CLOB(2147483647),\n    long_varchar_col  LONG VARCHAR,\n    varchar_col  VARCHAR(10)\n)\n");
            this.goodStatement(conn, "insert into string_types\n( key_col, char_col, clob_col, long_varchar_col, varchar_col )\nvalues\n( 0, 'false', 'false', 'false', 'false' ),\n( 1, 'true', 'true', 'true', 'true' ),\n( 2, 'unknown', 'unknown', 'unknown', 'unknown' ),\n( 3, null, null, null, null ),\n( 4, ' false ', ' false ', ' false ', ' false ' ),\n( 5, ' true ', ' true ', ' true ', ' true ' ),\n( 6, ' unknown ', ' unknown ', ' unknown ', ' unknown ' ),\n( 7, null, null, null, null ),\n( 10, 'FALSE', 'FALSE', 'FALSE', 'FALSE' ),\n( 11, 'TRUE', 'TRUE', 'TRUE', 'TRUE' ),\n( 12, 'UNKNOWN', 'UNKNOWN', 'UNKNOWN', 'UNKNOWN' ),\n( 13, NULL, NULL, NULL, NULL ),\n( 14, ' FALSE ', ' FALSE ', ' FALSE ', ' FALSE ' ),\n( 15, ' TRUE ', ' TRUE ', ' TRUE ', ' TRUE ' ),\n( 16, ' UNKNOWN ', ' UNKNOWN ', ' UNKNOWN ', ' UNKNOWN ' ),\n( 17, NULL, NULL, NULL, NULL ),\n( 20, 'arg', 'arg', 'arg', 'arg' ),\n( 21, '0', '0', '0', '0' ),\n( 22, '1', '1', '1', '1' ),\n( 23, '2', '2', '2', '2' )\n");
        }
        if (!this.routineExists(conn, "BOOLEANVALUE")) {
            this.goodStatement(conn, "create function booleanValue( b boolean )\nreturns varchar( 100 ) language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.BooleanValuesTest.booleanValue'\n");
        }
        if (!this.tableExists(conn, "BOOLEAN_TABLE")) {
            this.goodStatement(conn, "create table boolean_table\n(\n    key_col int,\n    boolean_col  boolean\n)\n");
        }
        if (!this.tableExists(conn, "T_4889")) {
            this.goodStatement(conn, "create table t_4889\n(\n    key_col int,\n    setter_col varchar( 20 ),\n    boolean_col  boolean\n)\n");
        }
    }

    public void test_01_datatypeCount() throws Exception {
        Connection conn = this.getConnection();
        ResultSet rs = conn.getMetaData().getTypeInfo();
        int actualTypeCount = 0;
        while (rs.next()) {
            ++actualTypeCount;
        }
        rs.close();
        BooleanValuesTest.assertEquals((int)22, (int)actualTypeCount);
    }

    public void test_02_defined() throws Exception {
        Connection conn = this.getConnection();
        this.vet_getBoolean(conn, "BIGINT_COL");
        this.vet_getBoolean(conn, "CHAR_COL");
        this.vet_getBoolean(conn, "INT_COL");
        this.vet_getBoolean(conn, "SMALLINT_COL");
        this.vet_getBoolean(conn, "VARCHAR_COL");
    }

    public void test_03_undefinedButLegal() throws Exception {
        Connection conn = this.getConnection();
        this.vet_getBoolean(conn, "DECIMAL_COL");
        this.vet_getBoolean(conn, "REAL_COL");
        this.vet_getBoolean(conn, "DOUBLE_COL");
        this.vet_getBoolean(conn, "LONG_VARCHAR_COL");
        this.vet_getBoolean(conn, "NUMERIC_COL");
    }

    public void test_04_undefinedAndIllegal() throws Exception {
        Connection conn = this.getConnection();
        this.vet_getBooleanIsIllegal(conn, "BLOB_COL");
        this.vet_getBooleanIsIllegal(conn, "CHAR_FOR_BIT_DATA_COL");
        this.vet_getBooleanIsIllegal(conn, "CLOB_COL");
        this.vet_getBooleanIsIllegal(conn, "DATE_COL");
        this.vet_getBooleanIsIllegal(conn, "LONG_VARCHAR_FOR_BIT_DATA_COL");
        this.vet_getBooleanIsIllegal(conn, "TIME_COL");
        this.vet_getBooleanIsIllegal(conn, "TIMESTAMP_COL");
        this.vet_getBooleanIsIllegal(conn, "VARCHAR_FOR_BIT_DATA_COL");
    }

    public void test_05_undefinedIllegalOutliers() throws Exception {
        if (this._supportsXML) {
            this.expectCompilationError(ILLEGAL_XML_SELECTION, this.makeQuery("XML_COL"));
        }
    }

    private void vet_getBoolean(Connection conn, String columnName) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, this.makeQuery(columnName));
        ResultSet rs = ps.executeQuery();
        rs.next();
        BooleanValuesTest.assertFalse((boolean)rs.getBoolean(columnName));
        rs.next();
        BooleanValuesTest.assertTrue((boolean)rs.getBoolean(columnName));
        rs.next();
        BooleanValuesTest.assertTrue((boolean)rs.getBoolean(columnName));
        rs.next();
        BooleanValuesTest.assertTrue((boolean)rs.getBoolean(columnName));
        rs.close();
        ps.close();
    }

    private String makeQuery(String columnName) {
        return "select key_col, " + columnName + " from all_types order by key_col";
    }

    private void vet_getBooleanIsIllegal(Connection conn, String columnName) throws Exception {
        this.vet_getBooleanException(conn, columnName, ILLEGAL_GET);
    }

    private void vet_getBooleanException(Connection conn, String columnName, String sqlstate) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, this.makeQuery(columnName));
        ResultSet rs = ps.executeQuery();
        rs.next();
        try {
            rs.getBoolean(columnName);
            BooleanValuesTest.fail((String)("getBoolean() on " + columnName + " should not have succeeded."));
        }
        catch (SQLException se) {
            BooleanValuesTest.assertSQLState("getBoolean() on " + columnName, sqlstate, se);
        }
    }

    public void test_06_unions() throws Exception {
        Connection conn = this.getConnection();
        this.vetBadImplicitCasts(conn, "bigint_col");
        this.vetBadImplicitCasts(conn, "blob_col");
        this.vetBadImplicitCasts(conn, "char_col");
        this.vetBadImplicitCasts(conn, "char_for_bit_data_col");
        this.vetBadImplicitCasts(conn, "clob_col");
        this.vetBadImplicitCasts(conn, "date_col");
        this.vetBadImplicitCasts(conn, "decimal_col");
        this.vetBadImplicitCasts(conn, "real_col");
        this.vetBadImplicitCasts(conn, "double_col");
        this.vetBadImplicitCasts(conn, "int_col");
        this.vetBadImplicitCasts(conn, "long_varchar_col");
        this.vetBadImplicitCasts(conn, "long_varchar_for_bit_data_col");
        this.vetBadImplicitCasts(conn, "numeric_col");
        this.vetBadImplicitCasts(conn, "smallint_col");
        this.vetBadImplicitCasts(conn, "time_col");
        this.vetBadImplicitCasts(conn, "timestamp_col");
        this.vetBadImplicitCasts(conn, "varchar_col");
        this.vetBadImplicitCasts(conn, "varchar_for_bit_data_col");
        if (this._supportsXML) {
            this.vetBadImplicitCasts(conn, "xml_col");
        }
    }

    private void vetBadImplicitCasts(Connection conn, String columnName) throws Exception {
        this.vetBadImplicitCastToBoolean(conn, columnName);
        this.vetBadImplicitCastFromBoolean(conn, columnName);
    }

    private void vetBadImplicitCastToBoolean(Connection conn, String columnName) throws Exception {
        String query = "select isindex from sys.sysconglomerates where conglomeratename = 'foo'\nunion\nselect " + columnName + " from all_types\n";
        this.expectCompilationError(NOT_UNION_COMPATIBLE, query);
    }

    private void vetBadImplicitCastFromBoolean(Connection conn, String columnName) throws Exception {
        String query = "select " + columnName + " from all_types\nunion\nselect isindex from sys.sysconglomerates\n";
        this.expectCompilationError(NOT_UNION_COMPATIBLE, query);
    }

    public void test_07_booleanLiterals() throws Exception {
        Connection conn = this.getConnection();
        this.assertResults(conn, "values ( true )", new String[][]{{"true"}}, false);
        this.assertResults(conn, "values ( false )", new String[][]{{"false"}}, false);
    }

    public void test_08_stringCasts() throws Exception {
        Connection conn = this.getConnection();
        this.assertResults(conn, "values ( cast( 'true' as boolean ) )", new String[][]{{"true"}}, false);
        this.assertResults(conn, "values ( cast( 'false' as boolean ) )", new String[][]{{"false"}}, false);
        this.assertResults(conn, "values ( cast( null as boolean ) )", new String[][]{{null}}, false);
        this.assertResults(conn, "values ( cast( 'unknown' as boolean ) )", new String[][]{{null}}, false);
        this.assertResults(conn, "values ( cast( ' true ' as boolean ) )", new String[][]{{"true"}}, false);
        this.assertResults(conn, "values ( cast( ' false ' as boolean ) )", new String[][]{{"false"}}, false);
        this.assertResults(conn, "values ( cast( ' unknown ' as boolean ) )", new String[][]{{null}}, false);
        this.expectCompilationError(BAD_CAST, "values ( cast( 'arglebargle' as boolean ) )");
        this.expectCompilationError(BAD_CAST, "values ( cast( '1' as boolean ) )");
        this.expectCompilationError(BAD_CAST, "values ( cast( '0' as boolean ) )");
        this.expectCompilationError(BAD_CAST, "values ( cast( '2' as boolean ) )");
        this.assertResults(conn, "select keyCol, cast( stringCol as boolean) from booleanString order by keyCol", new String[][]{{"0", "false"}, {"1", "true"}, {"2", null}, {"3", null}, {"10", "false"}, {"11", "true"}, {"12", null}, {"13", null}}, false);
        this.goodStatement(conn, "update booleanString set stringCol = 'arglebargle'");
        this.expectExecutionError(conn, BAD_CAST, "select keyCol, cast( stringCol as boolean) from booleanString order by keyCol");
        this.goodStatement(conn, "update booleanString set stringCol = '0'");
        this.expectExecutionError(conn, BAD_CAST, "select keyCol, cast( stringCol as boolean) from booleanString order by keyCol");
        this.goodStatement(conn, "update booleanString set stringCol = '1'");
        this.expectExecutionError(conn, BAD_CAST, "select keyCol, cast( stringCol as boolean) from booleanString order by keyCol");
        this.goodStatement(conn, "update booleanString set stringCol = '2'");
        this.expectExecutionError(conn, BAD_CAST, "select keyCol, cast( stringCol as boolean) from booleanString order by keyCol");
    }

    public void test_09_explicitCasts() throws Exception {
        Connection conn = this.getConnection();
        this.vetBadExplicitCasts(conn, "bigint_col", "BIGINT", "0");
        this.vetBadExplicitCasts(conn, "blob_col", "BLOB(2147483647)", "makeSimpleBlob()");
        this.vetBadExplicitCasts(conn, "char_for_bit_data_col", "CHAR (10) FOR BIT DATA", "X'DE'");
        this.vetBadExplicitCasts(conn, "date_col", "DATE", "date('1994-02-23')");
        this.vetBadExplicitCasts(conn, "decimal_col", "DECIMAL(5,2)", "0.00");
        this.vetBadExplicitCasts(conn, "real_col", "REAL", "0.0");
        this.vetBadExplicitCasts(conn, "double_col", "DOUBLE", "0.0");
        this.vetBadExplicitCasts(conn, "int_col", "INTEGER", "0");
        this.vetBadExplicitCasts(conn, "long_varchar_for_bit_data_col", "LONG VARCHAR FOR BIT DATA", "X'DE'");
        this.vetBadExplicitCasts(conn, "numeric_col", "NUMERIC(5,2)", "0.00");
        this.vetBadExplicitCasts(conn, "smallint_col", "SMALLINT", "0");
        this.vetBadExplicitCasts(conn, "time_col", "TIME", "time('15:09:02')");
        this.vetBadExplicitCasts(conn, "timestamp_col", "TIMESTAMP", "timestamp('1962-09-23 03:23:34.234')");
        this.vetBadExplicitCasts(conn, "varchar_for_bit_data_col", "VARCHAR (10) FOR BIT DATA", "X'DE'");
        if (this._supportsXML) {
            this.vetBadExplicitCasts(conn, "xml_col", "XML", "xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html/>' preserve whitespace )");
        }
        this.assertResults(conn, "select key_col, cast( char_col as boolean ), cast( clob_col as boolean ), cast( long_varchar_col as boolean ), cast( varchar_col as boolean )\nfrom string_types where key_col < 18 order by key_col\n", new String[][]{{"0", "false", "false", "false", "false"}, {"1", "true", "true", "true", "true"}, {"2", null, null, null, null}, {"3", null, null, null, null}, {"4", "false", "false", "false", "false"}, {"5", "true", "true", "true", "true"}, {"6", null, null, null, null}, {"7", null, null, null, null}, {"10", "false", "false", "false", "false"}, {"11", "true", "true", "true", "true"}, {"12", null, null, null, null}, {"13", null, null, null, null}, {"14", "false", "false", "false", "false"}, {"15", "true", "true", "true", "true"}, {"16", null, null, null, null}, {"17", null, null, null, null}}, false);
        this.assertResults(conn, "values ( cast( true as boolean) )\n", new String[][]{{"true"}}, false);
        this.vetBadStringCast(conn, "char_col");
        this.vetBadStringCast(conn, "clob_col");
        this.vetBadStringCast(conn, "long_varchar_col");
        this.vetBadStringCast(conn, "varchar_col");
        this.vet4704();
    }

    private void vetBadStringCast(Connection conn, String columnName) throws Exception {
        for (int i = 20; i < 24; ++i) {
            this.expectExecutionError(conn, BAD_CAST, "select cast( " + columnName + " as boolean ) from string_types where key_col = " + i);
        }
    }

    private void vetBadExplicitCasts(Connection conn, String columnName, String dataType, String literal) throws Exception {
        this.vetBadExplicitCastToBoolean(conn, columnName, literal);
        this.vetBadExplicitCastFromBoolean(conn, dataType);
    }

    private void vetBadExplicitCastToBoolean(Connection conn, String columnName, String literal) throws Exception {
        this.expectCompilationError(BAD_CONVERSION, "values ( cast( " + literal + " as boolean ) )");
        this.expectCompilationError(BAD_CONVERSION, "select cast( " + columnName + " as boolean ) from all_types\n");
    }

    private void vetBadExplicitCastFromBoolean(Connection conn, String dataType) throws Exception {
        this.expectCompilationError(BAD_CONVERSION, "values ( cast( true as " + dataType + " ) )");
        this.expectCompilationError(BAD_CONVERSION, "select cast( isindex as " + dataType + " ) from sys.sysconglomerates");
    }

    public void vet4704() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select keyCol, stringCol from t_4704 order by keyCol");
        JDBC.assertNullability(rs, new boolean[]{true, false});
        rs = s.executeQuery("select keyCol, cast(stringCol as boolean) from t_4704 order by keyCol");
        JDBC.assertNullability(rs, new boolean[]{true, true});
        JDBC.assertFullResultSet(rs, new String[][]{{"0", "false"}, {"1", "true"}, {"2", null}});
    }

    public void test_10_nullabilityOfCastFromLiteral() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("values cast('true' as boolean)");
        JDBC.assertNullability(rs, new boolean[]{false});
        JDBC.assertSingleValueResultSet(rs, "true");
        rs = s.executeQuery("values cast('false' as boolean)");
        JDBC.assertNullability(rs, new boolean[]{false});
        JDBC.assertSingleValueResultSet(rs, "false");
        rs = s.executeQuery("values cast('unknown' as boolean)");
        JDBC.assertNullability(rs, new boolean[]{true});
        JDBC.assertSingleValueResultSet(rs, null);
        rs = s.executeQuery("values (cast('true' as boolean),\n        cast('false' as boolean),\n        cast('unknown' as boolean))");
        JDBC.assertNullability(rs, new boolean[]{false, false, true});
        JDBC.assertFullResultSet(rs, new String[][]{{"true", "false", null}});
        rs = s.executeQuery("values (cast ('true' as boolean)),\n       (cast ('false' as boolean)),\n       (cast ('unknown' as boolean))");
        JDBC.assertNullability(rs, new boolean[]{true});
        JDBC.assertFullResultSet(rs, new String[][]{{"true"}, {"false"}, {null}});
    }

    public void test_11_booleanFunctionParameters() throws Exception {
        Connection conn = this.getConnection();
        this.assertResults(conn, "values ( booleanValue( true ) ), ( booleanValue( false ) ), ( booleanValue( null ) )", new String[][]{{"True value"}, {"False value"}, {"Null value"}}, false);
        PreparedStatement ps = this.chattyPrepare(conn, "values ( booleanValue( ? ) )");
        ps.setBoolean(1, true);
        this.assertScalarResult(ps, "True value");
        ps.setBoolean(1, false);
        this.assertScalarResult(ps, "False value");
        ps.setNull(1, 16);
        this.assertScalarResult(ps, "Null value");
        ps.close();
    }

    private void assertScalarResult(PreparedStatement ps, String result) throws Exception {
        ResultSet rs = ps.executeQuery();
        this.assertResults(rs, new String[][]{{result}}, false);
        rs.close();
    }

    public void test_12_booleanColumns() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "insert into boolean_table( key_col, boolean_col ) values ( 0, true ), ( 1, false ), ( 2, null )");
        this.assertResults(conn, "select * from boolean_table order by boolean_col", new String[][]{{"1", "false"}, {"0", "true"}, {"2", null}}, false);
        this.goodStatement(conn, "delete from boolean_table");
        this.vetBadInsert("bigint_col");
        this.vetBadInsert("blob_col");
        this.vetBadInsert("char_for_bit_data_col");
        this.vetBadInsert("date_col");
        this.vetBadInsert("decimal_col");
        this.vetBadInsert("real_col");
        this.vetBadInsert("double_col");
        this.vetBadInsert("int_col");
        this.vetBadInsert("long_varchar_for_bit_data_col");
        this.vetBadInsert("numeric_col");
        this.vetBadInsert("smallint_col");
        this.vetBadInsert("time_col");
        this.vetBadInsert("timestamp_col");
        this.vetBadInsert("varchar_for_bit_data_col");
        this.vetStringInsert(conn, "char_col");
        this.vetStringInsert(conn, "clob_col");
        this.vetStringInsert(conn, "long_varchar_col");
        this.vetStringInsert(conn, "varchar_col");
    }

    private void vetBadInsert(String columnName) throws Exception {
        this.expectCompilationError(ILLEGAL_INSERT, "insert into boolean_table( key_col, boolean_col ) select key_col, " + columnName + " from all_types");
    }

    private void vetStringInsert(Connection conn, String columnName) throws Exception {
        this.goodStatement(conn, "insert into boolean_table( key_col, boolean_col ) select key_col, " + columnName + " from string_types where key_col < 18");
        this.assertResults(conn, "select * from boolean_table order by key_col", new String[][]{{"0", "false"}, {"1", "true"}, {"2", null}, {"3", null}, {"4", "false"}, {"5", "true"}, {"6", null}, {"7", null}, {"10", "false"}, {"11", "true"}, {"12", null}, {"13", null}, {"14", "false"}, {"15", "true"}, {"16", null}, {"17", null}}, false);
        for (int i = 20; i < 24; ++i) {
            this.expectExecutionError(conn, BAD_CAST, "insert into boolean_table( key_col, boolean_col ) select key_col, " + columnName + " from string_types where key_col = " + i);
        }
        this.goodStatement(conn, "delete from boolean_table");
    }

    public void test_13_sortOrder() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table booleanUnindexed( a boolean )");
        this.goodStatement(conn, "create table booleanIndexed( a boolean )");
        this.goodStatement(conn, "create index bi on booleanIndexed( a )");
        this.goodStatement(conn, "insert into booleanUnindexed( a ) values ( true ), ( null ), ( false )");
        this.goodStatement(conn, "insert into booleanIndexed( a ) values ( true ), ( null ), ( false )");
        String[][] expectedResults = new String[][]{{"false"}, {"true"}, {null}};
        this.assertResults(conn, "select * from booleanUnindexed order by a", expectedResults, false);
        this.assertResults(conn, "select * from booleanIndexed order by a", expectedResults, false);
        this.goodStatement(conn, "drop table booleanUnindexed");
        this.goodStatement(conn, "drop table booleanIndexed");
    }

    public void test_14_defaults() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table booleanDefaults( a int, b boolean default true, c boolean default false, d boolean default null )");
        this.goodStatement(conn, "insert into booleanDefaults( a ) values ( 0 )");
        this.assertResults(conn, "select * from booleanDefaults order by a", new String[][]{{"0", "true", "false", null}}, false);
        this.goodStatement(conn, "alter table booleanDefaults add column e boolean default true");
        this.assertResults(conn, "select * from booleanDefaults order by a", new String[][]{{"0", "true", "false", null, "true"}}, false);
        this.goodStatement(conn, "drop table booleanDefaults");
        this.expectCompilationError(BAD_DEFAULT, "create table badDefault( a int, b boolean default 0 )");
        this.expectCompilationError(BAD_DEFAULT, "create table badDefault( a int, b boolean default 9.99 )");
        this.expectCompilationError(BAD_DEFAULT, "create table badDefault( a int, b boolean default 5e1 )");
        this.expectCompilationError(BAD_DEFAULT, "create table badDefault( a int, b boolean default 'false' )");
        this.expectCompilationError(BAD_DEFAULT, "create table badDefault( a int, b boolean default X'DE' )");
    }

    public void test_15_selectList() throws Exception {
        Connection conn = this.getConnection();
        this.assertResults(conn, "select columnnumber > 0 from sys.syscolumns where columnname = 'TABLENAME'", new String[][]{{"true"}}, false);
        this.assertResults(conn, "values 3 > 10", new String[][]{{"false"}}, false);
    }

    public void test_16_alterTable() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table booleanAlter( a int )");
        this.goodStatement(conn, "insert into booleanAlter( a ) values ( 0 ), ( 1 ), ( 2 )");
        this.goodStatement(conn, "alter table booleanAlter add column b boolean");
        this.goodStatement(conn, "alter table booleanAlter add column c boolean default true");
        this.goodStatement(conn, "alter table booleanAlter add column d boolean default false");
        this.goodStatement(conn, "alter table booleanAlter add column e boolean default null");
        this.assertResults(conn, "select * from booleanAlter order by a", new String[][]{{"0", null, "true", "false", null}, {"1", null, "true", "false", null}, {"2", null, "true", "false", null}}, false);
        this.goodStatement(conn, "alter table booleanAlter drop column b");
        this.assertResults(conn, "select * from booleanAlter order by a", new String[][]{{"0", "true", "false", null}, {"1", "true", "false", null}, {"2", "true", "false", null}}, false);
        this.goodStatement(conn, "drop table booleanAlter");
    }

    public void test_17_generatedColumns() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table tree\n(\n    treeID int primary key generated always as identity,\n    latinName varchar( 100 ),\n    commonName varchar( 100 ),\n    waterPerWeek int,\n    minimumSunNeeded int,\n    maximumSunTolerated int,\n    windTolerated int,\n    isHardy boolean generated always as( (waterPerWeek < 10) and (minimumSunNeeded < 5) and (maximumSunTolerated > 90) and (windTolerated > 100) )\n)\n");
        this.generatedMinion(conn);
        this.goodStatement(conn, "create table tree\n(\n    treeID int primary key generated always as identity,\n    latinName varchar( 100 ),\n    commonName varchar( 100 ),\n    waterPerWeek int,\n    minimumSunNeeded int,\n    maximumSunTolerated int,\n    windTolerated int,\n    isHardy generated always as( (waterPerWeek < 10) and (minimumSunNeeded < 5) and (maximumSunTolerated > 90) and (windTolerated > 100) )\n)\n");
        this.generatedMinion(conn);
    }

    private void generatedMinion(Connection conn) throws Exception {
        this.goodStatement(conn, "create index hardyTrees on tree( treeID, isHardy )");
        this.goodStatement(conn, "insert into tree( latinName, commonName, waterPerWeek, minimumSunNeeded, maximumSunTolerated, windTolerated )\nvalues\n( 'tristania conferta', 'brisbane boxwood', 7, 4, 95, 120 ),\n( 'acer rubrum', 'red maple', 20, 20, 95, 120 )\n");
        this.assertResults(conn, "select * from tree order by treeID", new String[][]{{"1", "tristania conferta", "brisbane boxwood", "7", "4", "95", "120", "true"}, {"2", "acer rubrum", "red maple", "20", "20", "95", "120", "false"}}, false);
        this.assertResults(conn, "select * from tree where isHardy order by treeID", new String[][]{{"1", "tristania conferta", "brisbane boxwood", "7", "4", "95", "120", "true"}}, false);
        this.goodStatement(conn, "drop table tree");
    }

    public void test_18_views() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table item\n(\n    itemID int primary key generated always as identity,\n    itemName varchar( 100 ),\n    quantityOnHand int,\n    quantityOrdered int\n)\n");
        this.goodStatement(conn, "create view orderView( itemID, needsRestocking )\n    as select itemID, quantityOrdered > quantityOnHand from item\n");
        this.goodStatement(conn, "insert into item( itemName, quantityOnHand, quantityOrdered )\nvalues\n( 'Bracelet', 100, 200 ),\n( 'Glasses', 200, 100 )\n");
        this.assertResults(conn, "select * from orderView order by itemID", new String[][]{{"1", "true"}, {"2", "false"}}, false);
        this.goodStatement(conn, "drop view orderView");
        this.goodStatement(conn, "drop table item");
    }

    public void test_19_foreignKeys() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table keys\n(\n    userName varchar( 100 ),\n    publicVersion boolean,\n    keyValue varchar( 1000 ),\n    primary key( publicVersion, userName )\n)\n");
        this.goodStatement(conn, "insert into keys( userName, publicVersion, keyValue )\nvalues\n( 'Robert', true, 'abcdefghij' ),\n( 'Robert', false, 'mnopqrstuv' )\n");
        this.goodStatement(conn, "create table messages\n(\n    messageID int primary key generated always as identity,\n    userName varchar( 100 ),\n    publicVersion boolean,\n    messageText clob,\n    foreign key ( publicVersion, userName ) references keys( publicVersion, userName )\n)\n");
        this.goodStatement(conn, "insert into messages( userName, publicVersion, messageText )\nvalues\n( 'Robert', false, 'Twas brillig' )\n");
        this.assertResults(conn, "select * from messages order by messageID", new String[][]{{"1", "Robert", "false", "Twas brillig"}}, false);
        this.goodStatement(conn, "drop table messages");
        this.goodStatement(conn, "drop table keys");
    }

    public void test_20_checkConstraints() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table remes\n(\n    remesID int primary key generated always as identity,\n    name varchar( 100 ),\n    isInsect boolean,\n    isArachnid boolean,\n    check ( isInsect or isArachnid )\n)\n");
        this.goodStatement(conn, "insert into remes( name, isInsect, isArachnid )\nvalues\n( 'black widow', false, true ),\n( 'house fly', true, false )\n");
        this.assertResults(conn, "select * from remes order by remesID", new String[][]{{"1", "black widow", "false", "true"}, {"2", "house fly", "true", "false"}}, false);
        this.goodStatement(conn, "drop table remes");
    }

    public void test_21_triggers() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table alumnus\n(\n    alumnusID int primary key generated always as identity,\n    name varchar( 100 ),\n    living boolean\n)\n");
        this.goodStatement(conn, "create table livenessChange\n(\n    eventID int primary key generated always as identity,\n    alumnusID int, \n    living boolean\n)\n");
        this.goodStatement(conn, "create trigger trig_after_update_row_trigger\nafter update of living\non alumnus\nreferencing new as newRow\nfor each row\ninsert into livenessChange( alumnusID, living ) values ( newRow.alumnusID, newRow.living )\n");
        this.goodStatement(conn, "insert into alumnus( name, living ) values ( 'Fred', true ), ( 'Monica', true )");
        this.goodStatement(conn, "update alumnus set living = false where name = 'Fred'");
        this.assertResults(conn, "select * from livenessChange order by eventID", new String[][]{{"1", "1", "false"}}, false);
        this.goodStatement(conn, "drop table alumnus");
        this.goodStatement(conn, "drop table livenessChange");
    }

    public void test_22_binary_operators() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table combos(b1 boolean, b2 boolean)");
        BooleanValuesTest.assertUpdateCount(s, 9, "insert into combos select * from (values true, false, cast(null as boolean)) v1, (values true, false, cast(null as boolean)) v2");
        JDBC.assertFullResultSet(s.executeQuery("select b1, b2, b1 = b2 from combos order by 1, 2"), new String[][]{{"false", "false", "true"}, {"false", "true", "false"}, {"false", null, null}, {"true", "false", "false"}, {"true", "true", "true"}, {"true", null, null}, {null, "false", null}, {null, "true", null}, {null, null, null}});
        JDBC.assertFullResultSet(s.executeQuery("select b1, b2, b1 <> b2 from combos order by 1, 2"), new String[][]{{"false", "false", "false"}, {"false", "true", "true"}, {"false", null, null}, {"true", "false", "true"}, {"true", "true", "false"}, {"true", null, null}, {null, "false", null}, {null, "true", null}, {null, null, null}});
        JDBC.assertFullResultSet(s.executeQuery("select b1, b2, b1 < b2 from combos order by 1, 2"), new String[][]{{"false", "false", "false"}, {"false", "true", "true"}, {"false", null, null}, {"true", "false", "false"}, {"true", "true", "false"}, {"true", null, null}, {null, "false", null}, {null, "true", null}, {null, null, null}});
        JDBC.assertFullResultSet(s.executeQuery("select b1, b2, b1 > b2 from combos order by 1, 2"), new String[][]{{"false", "false", "false"}, {"false", "true", "false"}, {"false", null, null}, {"true", "false", "true"}, {"true", "true", "false"}, {"true", null, null}, {null, "false", null}, {null, "true", null}, {null, null, null}});
        JDBC.assertFullResultSet(s.executeQuery("select b1, b2, b1 <= b2 from combos order by 1, 2"), new String[][]{{"false", "false", "true"}, {"false", "true", "true"}, {"false", null, null}, {"true", "false", "false"}, {"true", "true", "true"}, {"true", null, null}, {null, "false", null}, {null, "true", null}, {null, null, null}});
        JDBC.assertFullResultSet(s.executeQuery("select b1, b2, b1 >= b2 from combos order by 1, 2"), new String[][]{{"false", "false", "true"}, {"false", "true", "false"}, {"false", null, null}, {"true", "false", "true"}, {"true", "true", "true"}, {"true", null, null}, {null, "false", null}, {null, "true", null}, {null, null, null}});
        JDBC.assertFullResultSet(s.executeQuery("select b1, b2, b1 and b2 from combos order by 1, 2"), new String[][]{{"false", "false", "false"}, {"false", "true", "false"}, {"false", null, "false"}, {"true", "false", "false"}, {"true", "true", "true"}, {"true", null, null}, {null, "false", "false"}, {null, "true", null}, {null, null, null}});
        JDBC.assertFullResultSet(s.executeQuery("select b1, b2, (b1 or b2) from combos order by 1, 2"), new String[][]{{"false", "false", "false"}, {"false", "true", "true"}, {"false", null, null}, {"true", "false", "true"}, {"true", "true", "true"}, {"true", null, "true"}, {null, "false", null}, {null, "true", "true"}, {null, null, null}});
    }

    public void test_23_select_distinct() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        BooleanValuesTest.assertUpdateCount(s, 6, "insert into boolean_table(boolean_col) values true, true, false, false, null, null");
        JDBC.assertUnorderedResultSet(s.executeQuery("select distinct boolean_col from boolean_table"), new String[][]{{"true"}, {"false"}, {null}});
    }

    public void test_4890() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "delete from boolean_table");
        PreparedStatement ps = this.chattyPrepare(conn, "values ( cast ( ? as boolean ), cast ( ? as boolean ) )");
        ps.setString(1, "true");
        ps.setString(2, "false");
        ResultSet rs = ps.executeQuery();
        rs.next();
        BooleanValuesTest.assertTrue((boolean)rs.getBoolean(1));
        BooleanValuesTest.assertFalse((boolean)rs.getBoolean(2));
        rs.close();
        ps.close();
        ps = this.chattyPrepare(conn, "insert into boolean_table( key_col, boolean_col ) values ( 1, ? ), ( 2, ? )");
        ps.setString(1, "true");
        ps.setString(2, "false");
        ps.execute();
        this.assertResults(conn, "select * from boolean_table order by key_col", new String[][]{{"1", "true"}, {"2", "false"}}, false);
        this.goodStatement(conn, "delete from boolean_table");
    }

    public void test_4889() throws Exception {
        Connection conn = this.getConnection();
        this.minion_4889(conn, 0, false);
        this.minion_4889(conn, 1, true);
        this.minion_4889(conn, 2, true);
    }

    private void minion_4889(Connection conn, int value, boolean expectedBooleanResult) throws Exception {
        this.goodStatement(conn, "delete from t_4889");
        PreparedStatement ps = this.chattyPrepare(conn, "insert into t_4889( key_col, setter_col, boolean_col ) values ( ?, ?, ? )");
        ps.setInt(1, 1);
        ps.setString(2, "setByte");
        ps.setByte(3, (byte)value);
        ps.execute();
        ps.setInt(1, 2);
        ps.setString(2, "setShort");
        ps.setShort(3, (short)value);
        ps.execute();
        ps.setInt(1, 3);
        ps.setString(2, "setInt");
        ps.setInt(3, value);
        ps.execute();
        ps.setInt(1, 4);
        ps.setString(2, "setLong");
        ps.setLong(3, value);
        ps.execute();
        ps.setInt(1, 5);
        ps.setString(2, "setObject( Byte )");
        ps.setObject(3, (byte)value);
        ps.execute();
        ps.setInt(1, 6);
        ps.setString(2, "setObject( Short )");
        ps.setObject(3, (short)value);
        ps.execute();
        ps.setInt(1, 7);
        ps.setString(2, "setObject( Integer )");
        ps.setObject(3, value);
        ps.execute();
        ps.setInt(1, 8);
        ps.setString(2, "setObject( Long )");
        ps.setObject(3, value);
        ps.execute();
        String stringValue = Boolean.toString(value != 0);
        this.assertResults(conn, "select * from t_4889 order by key_col", new String[][]{{"1", "setByte", stringValue}, {"2", "setShort", stringValue}, {"3", "setInt", stringValue}, {"4", "setLong", stringValue}, {"5", "setObject( Byte )", stringValue}, {"6", "setObject( Short )", stringValue}, {"7", "setObject( Integer )", stringValue}, {"8", "setObject( Long )", stringValue}}, false);
    }

    public void test_4964() throws SQLException {
        PreparedStatement ps = this.prepareStatement("values cast(? as boolean)");
        this.test_4964_minion(ps, null, null);
        this.test_4964_minion(ps, "unknown", null);
        this.test_4964_minion(ps, "UNKNOWN", null);
        this.test_4964_minion(ps, "unKnoWn", null);
        this.test_4964_minion(ps, "  unknown  ", null);
        this.test_4964_minion(ps, "true", Boolean.TRUE);
        this.test_4964_minion(ps, "TRUE", Boolean.TRUE);
        this.test_4964_minion(ps, "TrUe", Boolean.TRUE);
        this.test_4964_minion(ps, "  true  ", Boolean.TRUE);
        this.test_4964_minion(ps, "false", Boolean.FALSE);
        this.test_4964_minion(ps, "FALSE", Boolean.FALSE);
        this.test_4964_minion(ps, "FaLsE", Boolean.FALSE);
        this.test_4964_minion(ps, "FaLsE", Boolean.FALSE);
        this.test_4964_minion(ps, "  false  ", Boolean.FALSE);
        this.test_4964_minion(ps, "0", BAD_CAST);
        this.test_4964_minion(ps, "1", BAD_CAST);
        this.test_4964_minion(ps, "2", BAD_CAST);
        this.test_4964_minion(ps, "null", BAD_CAST);
        this.test_4964_minion(ps, "true true", BAD_CAST);
        this.test_4964_minion(ps, "false false", BAD_CAST);
    }

    private void test_4964_minion(PreparedStatement ps, String input, Object expectedValue) throws SQLException {
        boolean shouldFail = expectedValue instanceof String;
        Object[][] rows = new Object[][]{{expectedValue}};
        try {
            ps.setString(1, input);
            JDBC.assertFullResultSet(ps.executeQuery(), rows, false);
            BooleanValuesTest.assertFalse((boolean)shouldFail);
        }
        catch (SQLException sqle) {
            if (shouldFail) {
                BooleanValuesTest.assertSQLState((String)expectedValue, sqle);
            }
            throw sqle;
        }
        try {
            ps.setObject(1, input);
            JDBC.assertFullResultSet(ps.executeQuery(), rows, false);
            BooleanValuesTest.assertFalse((boolean)shouldFail);
        }
        catch (SQLException sqle) {
            if (shouldFail) {
                BooleanValuesTest.assertSQLState((String)expectedValue, sqle);
            }
            throw sqle;
        }
        int[] types = new int[]{-7, 16, 1, 12};
        for (int i = 0; i < types.length; ++i) {
            try {
                ps.setObject(1, (Object)input, types[i]);
                JDBC.assertFullResultSet(ps.executeQuery(), rows, false);
                BooleanValuesTest.assertFalse((boolean)shouldFail);
                continue;
            }
            catch (SQLException sqle) {
                if (shouldFail) {
                    BooleanValuesTest.assertSQLState((String)expectedValue, sqle);
                    continue;
                }
                throw sqle;
            }
        }
    }

    public void test_4965() throws SQLException {
        String[] stringTypes = new String[]{"CHAR(10)", "VARCHAR(10)", "LONG VARCHAR"};
        for (int i = 0; i < stringTypes.length; ++i) {
            PreparedStatement ps = this.prepareStatement("values cast(? as " + stringTypes[i] + ")");
            ps.setBoolean(1, true);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "true");
            ps.setBoolean(1, false);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "false");
            ps.setObject(1, Boolean.TRUE);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "true");
            ps.setObject(1, Boolean.FALSE);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "false");
            int[] targetTypes = new int[]{-7, 16, 1, 12, -1};
            for (int j = 0; j < targetTypes.length; ++j) {
                ps.setObject(1, (Object)Boolean.TRUE, targetTypes[j]);
                JDBC.assertSingleValueResultSet(ps.executeQuery(), "true");
                ps.setObject(1, (Object)Boolean.FALSE, targetTypes[j]);
                JDBC.assertSingleValueResultSet(ps.executeQuery(), "false");
            }
        }
        String[] intTypes = new String[]{"SMALLINT", "INTEGER", "BIGINT"};
        for (int i = 0; i < intTypes.length; ++i) {
            PreparedStatement ps = this.prepareStatement("values cast(? as " + intTypes[i] + ")");
            ps.setBoolean(1, true);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
            ps.setBoolean(1, false);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "0");
            ps.setObject(1, Boolean.TRUE);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
            ps.setObject(1, Boolean.FALSE);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "0");
            int[] targetTypes = new int[]{-7, 16, 5, 4, -5};
            for (int j = 0; j < targetTypes.length; ++j) {
                ps.setObject(1, (Object)Boolean.TRUE, targetTypes[j]);
                JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
                ps.setObject(1, (Object)Boolean.FALSE, targetTypes[j]);
                JDBC.assertSingleValueResultSet(ps.executeQuery(), "0");
            }
        }
    }

    public void test_5042_updateBoolean() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement(1003, 1008);
        s.execute("create table derby5042(b boolean, i int, c char(10))");
        ResultSet rs = s.executeQuery("select * from derby5042");
        rs.moveToInsertRow();
        rs.updateBoolean("B", true);
        rs.updateBoolean("I", true);
        rs.updateBoolean("C", true);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateObject("B", (Object)Boolean.FALSE);
        rs.updateObject("I", (Object)Boolean.FALSE);
        rs.updateObject("C", (Object)Boolean.FALSE);
        rs.insertRow();
        rs.close();
        JDBC.assertFullResultSet(s.executeQuery("select * from derby5042 order by 1,2,3"), new String[][]{{"false", "0", "false"}, {"true", "1", "true"}});
    }

    public void test_5063_updateBytes() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table derby5063(b boolean)");
        PreparedStatement ps = this.prepareStatement("select b from derby5063", 1003, 1008);
        byte[] bytes = "abc".getBytes();
        ResultSet rs = ps.executeQuery();
        rs.moveToInsertRow();
        try {
            rs.updateBytes(1, bytes);
            BooleanValuesTest.fail((String)"updateBytes should fail");
        }
        catch (SQLException sqle) {
            BooleanValuesTest.assertSQLState(ILLEGAL_UPDATE, sqle);
        }
        rs.close();
        rs = ps.executeQuery();
        rs.moveToInsertRow();
        try {
            rs.updateObject(1, (Object)bytes);
            BooleanValuesTest.fail((String)"updateObject should fail");
        }
        catch (SQLException sqle) {
            BooleanValuesTest.assertSQLState(ILLEGAL_UPDATE, sqle);
        }
        rs.close();
    }

    public void test_5918() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table derby5918_1(b boolean)");
        s.execute("create table derby5918_2 as select * from derby5918_1 with no data");
        s.executeUpdate("insert into derby5918_2 values ( true )");
        this.assertResults(this.getConnection(), "select * from derby5918_2", new String[][]{{"true"}}, false);
    }

    public void test_5972() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery("select true and false from sysibm.sysdummy1"), "false");
        JDBC.assertSingleValueResultSet(s.executeQuery("select true or false from sysibm.sysdummy1"), "true");
        this.assertCompileError(NON_BOOLEAN_OPERAND, "select 1 and 2 from sysibm.sysdummy1");
        this.assertCompileError(NON_BOOLEAN_OPERAND, "select 1 or 2 from sysibm.sysdummy1");
        JDBC.assertSingleValueResultSet(s.executeQuery("values true and false"), "false");
        JDBC.assertSingleValueResultSet(s.executeQuery("values true or false"), "true");
        this.assertCompileError(NON_BOOLEAN_OPERAND, "values 1 and 2");
        this.assertCompileError(NON_BOOLEAN_OPERAND, "values 1 or 2");
        JDBC.assertSingleValueResultSet(s.executeQuery("values booleanValue(true and false)"), "False value");
        JDBC.assertSingleValueResultSet(s.executeQuery("values booleanValue(true or false)"), "True value");
        this.assertCompileError(NON_BOOLEAN_OPERAND, "values booleanValue(1 and 2)");
        this.assertCompileError(NON_BOOLEAN_OPERAND, "values booleanValue(1 or 2)");
        s.execute("create table d5972(b boolean)");
        BooleanValuesTest.assertUpdateCount(s, 0, "update d5972 set b = true and false");
        BooleanValuesTest.assertUpdateCount(s, 0, "update d5972 set b = true or false");
        this.assertCompileError(NON_BOOLEAN_OPERAND, "update d5972 set b = 1 and 2");
        this.assertCompileError(NON_BOOLEAN_OPERAND, "update d5972 set b = 1 or 2");
        JDBC.assertSingleValueResultSet(s.executeQuery("values case when true and false then 1 else 0 end"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("values case when true or false then 1 else 0 end"), "1");
        this.assertCompileError(NON_BOOLEAN_OPERAND, "values case when 1 and 2 then 1 else 0 end");
        this.assertCompileError(NON_BOOLEAN_OPERAND, "values case when 1 or 2 then 1 else 0 end");
    }

    public void test_6363() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table d6363(a int, b char)");
        s.execute("insert into d6363 values (1, 'a'), (2, 'b'), (3, 'a'), (4, 'b'), (5, 'a'), (6, 'b')");
        JDBC.assertFullResultSet(s.executeQuery("select a, ((b = 'a' or b = 'b') and a < 4), ((b = 'a' or b = 'c' or b = 'b') and a < 4), ((b = 'a' or (b = 'c' or b = 'b')) and a < 4), ((b = 'a' or b in ('c', 'b')) and a < 4), (a < 4 and (b = 'a' or b = 'b')) from d6363 order by a"), new String[][]{{"1", "true", "true", "true", "true", "true"}, {"2", "true", "true", "true", "true", "true"}, {"3", "true", "true", "true", "true", "true"}, {"4", "false", "false", "false", "false", "false"}, {"5", "false", "false", "false", "false", "false"}, {"6", "false", "false", "false", "false", "false"}});
        JDBC.assertFullResultSet(s.executeQuery("select a, b, case when ((b = 'a' or b = 'b') and a < 4) then 'x' else '-' end, case when (a < 4 and (b = 'a' or b = 'b')) then 'y' else '-' end from d6363 order by a"), new String[][]{{"1", "a", "x", "y"}, {"2", "b", "x", "y"}, {"3", "a", "x", "y"}, {"4", "b", "-", "-"}, {"5", "a", "-", "-"}, {"6", "b", "-", "-"}});
    }

    public static Blob makeSimpleBlob() throws SQLException {
        return new HarmonySerialBlob(new byte[]{1});
    }

    public static String booleanValue(Boolean b) {
        if (b == null) {
            return "Null value";
        }
        if (b.booleanValue()) {
            return "True value";
        }
        return "False value";
    }

    private boolean routineExists(Connection conn, String functionName) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "select count (*) from sys.sysaliases where alias = ?");
        ps.setString(1, functionName);
        ResultSet rs = ps.executeQuery();
        rs.next();
        boolean retval = rs.getInt(1) > 0;
        rs.close();
        ps.close();
        return retval;
    }

    private boolean tableExists(Connection conn, String tableName) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "select count (*) from sys.systables where tablename = ?");
        ps.setString(1, tableName);
        ResultSet rs = ps.executeQuery();
        rs.next();
        boolean retval = rs.getInt(1) > 0;
        rs.close();
        ps.close();
        return retval;
    }
}

