/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Collator;
import java.util.Locale;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_4
extends UpgradeChange {
    public Changes10_4(String string) {
        super(string);
    }

    public static Test suite(int n) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Upgrade test for 10.4");
        baseTestSuite.addTestSuite(Changes10_4.class);
        return new SupportFilesSetup((Test)baseTestSuite);
    }

    public void testMetaDataQueryRunInSYScompilationSchema() throws SQLException {
        if (!this.oldAtLeast(10, 3)) {
            return;
        }
        DataSource dataSource = JDBCDataSource.getDataSourceLogical("COLLATED_DB_10_3");
        switch (this.getPhase()) {
            case 0: {
                String string = "en";
                Locale[] localeArray = Collator.getAvailableLocales();
                for (int i = 0; i < localeArray.length; ++i) {
                    if (!"no".equals(localeArray[i].getLanguage())) continue;
                    string = "no";
                    break;
                }
                JDBCDataSource.setBeanProperty(dataSource, "ConnectionAttributes", "create=true;territory=" + string + ";collation=TERRITORY_BASED");
                dataSource.getConnection().close();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                Connection connection = dataSource.getConnection();
                Statement statement = connection.createStatement();
                statement.execute("SET SCHEMA APP");
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ResultSet resultSet = databaseMetaData.getTables(null, "APP", null, null);
                JDBC.assertDrainResults(resultSet);
                statement.close();
            }
        }
    }

    public void testTableFunctionDeclaration() throws SQLException {
        Statement statement = this.createStatement();
        String string = "create function svnLogReader( logFileName varchar( 32672 ) )\nreturns TABLE\n  (\n     XID varchar( 15 ),\n     committer    varchar( 20 ),\n     commit_time  timestamp,\n     line_count   varchar( 10 ),\n     description  varchar( 32672 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyDemo.vtis.example.SubversionLogVTI.subversionLogVTI'\n";
        switch (this.getPhase()) {
            case 0: {
                Changes10_4.assertStatementError("42X01", statement, string);
                break;
            }
            case 1: {
                Changes10_4.assertStatementError("XCL47", statement, string);
                break;
            }
            case 2: {
                Changes10_4.assertStatementError("42X01", statement, string);
                break;
            }
            case 3: {
                statement.execute(string);
            }
        }
        statement.close();
    }

    public void testRoutineParameters() throws SQLException {
        switch (this.getPhase()) {
            case 0: {
                break;
            }
            case 1: {
                Statement statement = this.createStatement();
                statement.execute("CREATE FUNCTION TYPES_10_4(A INTEGER) RETURNS CHAR(10) LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL EXTERNAL NAME 'java.lang.Integer.toHexString'");
            }
            case 2: 
            case 3: {
                PreparedStatement preparedStatement = this.prepareStatement("VALUES TYPES_10_4(?)");
                preparedStatement.setInt(1, 48879);
                JDBC.assertFullResultSet(preparedStatement.executeQuery(), (Object[][])new Object[][]{{"beef      "}}, false);
            }
        }
    }

    private void testIndexes(Statement statement, String string, int n, boolean bl, boolean bl2) throws Exception {
        statement.executeUpdate("delete from " + string);
        statement.executeUpdate("insert into " + string + " values (" + n + ")");
        try {
            statement.executeUpdate("insert into " + string + " values (" + n + ")");
            if (!bl2) {
                Changes10_4.fail((String)"no duplicates allowed");
            }
        }
        catch (SQLException sQLException) {
            if (!bl2) {
                Changes10_4.assertSQLState("duplicate record", "23505", sQLException);
            }
            throw sQLException;
        }
        try {
            statement.executeUpdate("insert into " + string + " values (null)");
            if (!bl) {
                Changes10_4.fail((String)"null in a not null column");
            }
        }
        catch (SQLException sQLException) {
            if (!bl) {
                Changes10_4.assertSQLState("null in not null column", "23502", sQLException);
            }
            throw sQLException;
        }
        if (!bl) {
            return;
        }
        try {
            statement.executeUpdate("insert into " + string + " values (null)");
            if (!bl2) {
                Changes10_4.fail((String)"no duplicates allowed");
            }
        }
        catch (SQLException sQLException) {
            if (!bl2) {
                Changes10_4.assertSQLState("duplicate record", "23505", sQLException);
            }
            throw sQLException;
        }
    }

    private void createTablesForIndexTesting(Statement statement, String string) throws Exception {
        statement.executeUpdate("create table  " + string + "_indextest1(col1 integer not null)");
        statement.executeUpdate("create unique index " + string + "_uinn on " + string + "_indextest1 (col1)");
        statement.executeUpdate("create table  " + string + "_indextest2(col1 integer)");
        statement.executeUpdate("create unique index " + string + "_uin on " + string + "_indextest2 (col1)");
        statement.executeUpdate("create table  " + string + "_indextest3(col1 integer not null)");
        statement.executeUpdate("create index " + string + "_nuinn on " + string + "_indextest3 (col1)");
        statement.executeUpdate("create table  " + string + "_indextest4(col1 integer)");
        statement.executeUpdate("create index " + string + "_nuin on " + string + "_indextest4 (col1)");
        statement.executeUpdate("create table  " + string + "_indextest5(col1 integer not null)");
        statement.executeUpdate("alter table " + string + "_indextest5 add constraint " + string + "_cons1 unique(col1)");
    }

    public void testIndexes() throws Exception {
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                this.createTablesForIndexTesting(statement, "ph_create");
                this.testIndexes(statement, "ph_create_indextest1", 1, false, false);
                this.testIndexes(statement, "ph_create_indextest2", 1, true, false);
                this.testIndexes(statement, "ph_create_indextest3", 1, false, true);
                this.testIndexes(statement, "ph_create_indextest4", 1, true, true);
                this.testIndexes(statement, "ph_create_indextest5", 1, false, false);
                break;
            }
            case 1: {
                this.testIndexes(statement, "ph_create_indextest1", 2, false, false);
                this.testIndexes(statement, "ph_create_indextest2", 2, true, false);
                this.testIndexes(statement, "ph_create_indextest3", 2, false, true);
                this.testIndexes(statement, "ph_create_indextest4", 2, true, true);
                this.testIndexes(statement, "ph_create_indextest5", 2, false, false);
                this.createTablesForIndexTesting(statement, "ph__soft_upg");
                this.testIndexes(statement, "ph__soft_upg_indextest1", 2, false, false);
                this.testIndexes(statement, "ph__soft_upg_indextest2", 2, true, false);
                this.testIndexes(statement, "ph__soft_upg_indextest3", 2, false, true);
                this.testIndexes(statement, "ph__soft_upg_indextest4", 2, true, true);
                this.testIndexes(statement, "ph__soft_upg_indextest5", 2, false, false);
                break;
            }
            case 2: {
                this.testIndexes(statement, "ph_create_indextest1", 3, false, false);
                this.testIndexes(statement, "ph_create_indextest2", 3, true, false);
                this.testIndexes(statement, "ph_create_indextest3", 3, false, true);
                this.testIndexes(statement, "ph_create_indextest4", 3, true, true);
                this.testIndexes(statement, "ph_create_indextest5", 3, false, false);
                this.testIndexes(statement, "ph__soft_upg_indextest1", 3, false, false);
                this.testIndexes(statement, "ph__soft_upg_indextest2", 3, true, false);
                this.testIndexes(statement, "ph__soft_upg_indextest3", 3, false, true);
                this.testIndexes(statement, "ph__soft_upg_indextest4", 3, true, true);
                this.testIndexes(statement, "ph__soft_upg_indextest5", 3, false, false);
                break;
            }
            case 3: {
                this.testIndexes(statement, "ph_create_indextest1", 4, false, false);
                this.testIndexes(statement, "ph_create_indextest2", 4, true, false);
                this.testIndexes(statement, "ph_create_indextest3", 4, false, true);
                this.testIndexes(statement, "ph_create_indextest4", 4, true, true);
                this.testIndexes(statement, "ph_create_indextest5", 4, false, false);
                this.testIndexes(statement, "ph__soft_upg_indextest1", 4, false, false);
                this.testIndexes(statement, "ph__soft_upg_indextest2", 4, true, false);
                this.testIndexes(statement, "ph__soft_upg_indextest3", 4, false, true);
                this.testIndexes(statement, "ph__soft_upg_indextest4", 4, true, true);
                this.testIndexes(statement, "ph__soft_upg_indextest5", 5, false, false);
                this.createTablesForIndexTesting(statement, "ph_upgrade");
                this.testIndexes(statement, "ph_upgrade_indextest1", 4, false, false);
                this.testIndexes(statement, "ph_upgrade_indextest2", 4, true, false);
                this.testIndexes(statement, "ph_upgrade_indextest3", 4, false, true);
                this.testIndexes(statement, "ph_upgrade_indextest4", 4, true, true);
                this.testIndexes(statement, "ph_upgrade_indextest5", 4, false, false);
            }
        }
        statement.close();
    }

    public void testUniqueConstraint() throws SQLException {
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                statement.executeUpdate("create table constraintest1 (i integer not null, j integer, k integer, constraint ucon unique (i))");
                statement.executeUpdate("create table constraintest2 (i integer, j integer, k integer)");
                statement.executeUpdate("create table constraintest3 (i integer not null, j integer, k integer)");
                break;
            }
            case 1: {
                Changes10_4.assertStatementError("42Z20", statement, "alter table constraintest1 alter column i null");
                Changes10_4.assertStatementError("42831", statement, "alter table constraintest2 add constraint ucon1 unique(i, j)");
                statement.execute("alter table constraintest3 add constraint ucon2 unique(i)");
                break;
            }
            case 2: {
                statement.executeUpdate("insert into constraintest3 (i) values (1)");
                Changes10_4.assertStatementError("23505", statement, "insert into constraintest3 (i) values (1)");
                break;
            }
            case 3: {
                statement.executeUpdate("insert into constraintest1 (i) values (2)");
                Changes10_4.assertStatementError("23505", statement, "insert into constraintest1 (i) values (2)");
                statement.executeUpdate("alter table constraintest1 alter column i null");
                statement.executeUpdate("alter table constraintest2 add constraint ucon1 unique(i, j)");
                statement.executeUpdate("insert into constraintest1 (j) values (1)");
                statement.executeUpdate("insert into constraintest1 (j) values (1)");
                statement.executeUpdate("insert into constraintest2 (j) values (1)");
                statement.executeUpdate("insert into constraintest2 (j) values (1)");
            }
        }
        statement.close();
    }

    private void verifyError() throws SQLException {
        ResultSet resultSet;
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("select text from errormessage where state = ?");
        if (this.oldAtLeast(10, 2)) {
            try {
                statement.execute("alter table t1 alter column i null");
                Changes10_4.fail((String)"expected error while setting primary key column to nullable");
            }
            catch (SQLException sQLException) {
                Changes10_4.assertSQLState("expected state 42Z20", "42Z20", sQLException);
                preparedStatement.setString(1, sQLException.getSQLState());
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                Changes10_4.assertEquals((String)"error message mismatch", (String)resultSet.getString(1), (String)sQLException.getMessage());
                resultSet.close();
            }
        }
        try {
            statement.execute("alter table t1 add constraint  uidx unique(j)");
            Changes10_4.fail((String)"expected error while creating unique constraint over nullable column");
        }
        catch (SQLException sQLException) {
            Changes10_4.assertSQLState("expected state 42831", "42831", sQLException);
            preparedStatement.setString(1, sQLException.getSQLState());
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            Changes10_4.assertEquals((String)"error message mismatch", (String)resultSet.getString(1), (String)sQLException.getMessage());
            resultSet.close();
        }
        statement.close();
        preparedStatement.close();
    }

    private void prepareTable() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table errormessage (state varchar (6), text varchar (200))");
        PreparedStatement preparedStatement = this.prepareStatement("insert into errormessage (state, text) values (?, ?)");
        statement.executeUpdate("create table t1 (i integer not null primary key, j integer)");
        if (this.oldAtLeast(10, 2)) {
            try {
                statement.execute("alter table t1 alter column i null");
                Changes10_4.fail((String)"expected error while setting primary key column to nullable");
            }
            catch (SQLException sQLException) {
                Changes10_4.assertSQLState("expected state 42Z20", "42Z20", sQLException);
                preparedStatement.setString(1, sQLException.getSQLState());
                preparedStatement.setString(2, sQLException.getMessage());
                preparedStatement.executeUpdate();
            }
        }
        try {
            statement.execute("alter table t1 add constraint  uidx unique(j)");
            Changes10_4.fail((String)"expected error while creating unique constraint over nullable column");
        }
        catch (SQLException sQLException) {
            Changes10_4.assertSQLState("expected state 42831", "42831", sQLException);
            preparedStatement.setString(1, sQLException.getSQLState());
            preparedStatement.setString(2, sQLException.getMessage());
            preparedStatement.executeUpdate();
        }
        statement.close();
        preparedStatement.close();
    }

    public void testErrorMessage() throws Exception {
        switch (this.getPhase()) {
            case 0: {
                this.prepareTable();
                break;
            }
            case 1: {
                this.verifyError();
            }
        }
    }

    public void testAlterColumnOfUniqueConstraint() throws Exception {
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                statement.executeUpdate("create table datatype_test (fl1 varchar (2) not null)");
                statement.executeUpdate("alter table datatype_test add constraint ucon_datatype_test unique (fl1)");
                statement.executeUpdate("alter table datatype_test alter column fl1 set data type varchar (3)");
                break;
            }
            case 1: {
                statement.executeUpdate("alter table datatype_test alter column fl1  set data type varchar (4)");
                break;
            }
            case 3: {
                statement.executeUpdate("alter table datatype_test alter column fl1  set data type varchar (5)");
            }
        }
        statement.close();
    }
}

