/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class CreateTableFromQueryTest
extends BaseJDBCTestCase {
    public CreateTableFromQueryTest(String string) {
        super(string);
    }

    public static void decorate(Statement statement) throws SQLException {
        statement.executeUpdate("create table t1(i int not null, s smallint, f float, dp double precision, v varchar(10) not null)");
        statement.executeUpdate("create table t2 (a int, s varchar(5))");
    }

    public static Test suite() {
        Test test = TestConfiguration.embeddedSuite(CreateTableFromQueryTest.class);
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                CreateTableFromQueryTest.decorate(statement);
            }
        };
    }

    public void testBasicTableCreation() throws Exception {
        this.positiveTest("create table t3 as select * from t1 with no data", new String[]{"I", "S", "F", "DP", "V"}, new String[]{"NO", "YES", "YES", "YES", "NO"}, new String[]{"INTEGER", "SMALLINT", "DOUBLE", "DOUBLE", "VARCHAR"});
    }

    public void testCreateTableWithColumnList() throws Exception {
        this.positiveTest("create table t3 (a,b,c,d,e) as select * from t1 with no data", new String[]{"A", "B", "C", "D", "E"}, new String[]{"NO", "YES", "YES", "YES", "NO"}, new String[]{"INTEGER", "SMALLINT", "DOUBLE", "DOUBLE", "VARCHAR"});
    }

    public void testCreateTableWithSubsetOfColumns() throws Exception {
        this.positiveTest("create table t3 as select v,f from t1 with no data", new String[]{"V", "F"}, new String[]{"NO", "YES"}, new String[]{"VARCHAR", "DOUBLE"});
    }

    public void testCreateTableWithSubsetOfColumnsAndColumnList() throws Exception {
        this.positiveTest("create table t3 (a,b,c) as select v,dp,i from t1 with no data", new String[]{"A", "B", "C"}, new String[]{"NO", "YES", "NO"}, new String[]{"VARCHAR", "DOUBLE", "INTEGER"});
    }

    public void testCreateTableWithMultipleBaseTables() throws Exception {
        this.positiveTest("create table t3 (one, two) as select x.s, y.v from t1 y, t2 x where x.a = y.i with no data", new String[]{"ONE", "TWO"}, new String[]{"YES", "NO"}, new String[]{"VARCHAR", "VARCHAR"});
    }

    public void testCreateTableWithDerivedColumnName() throws Exception {
        this.positiveTest("create table t3 (x,y) as select 2*i,2.0*f from t1 with no data", new String[]{"X", "Y"}, new String[]{"NO", "YES"}, new String[]{"INTEGER", "DOUBLE"});
    }

    public void testCreateTableFromValues() throws Exception {
        this.positiveTest("create table t3 (x,y) as values (1, 'name') with no data", new String[]{"X", "Y"}, new String[]{"NO", "NO"}, new String[]{"INTEGER", "CHAR"});
    }

    public void testCreateTableWithGroupByInQuery() throws Exception {
        this.positiveTest("create table t3 (x, y) as  (select v, sum(i) from t1 where i > 0  group by i, v having i <=  ANY (select a from t2)) with no data", new String[]{"X", "Y"}, new String[]{"NO", "YES"}, new String[]{"VARCHAR", "INTEGER"});
    }

    public void testDerby6956() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE DERBYTEST6956 (STRINGCOLUMN varchar(255),  INTEGERCOLUMN integer,  SHORTCOLUMN varchar(255),  LONGCOLUMN bigint,  DOUBLECOLUMN double,  FLOATCOLUMN double,  DECIMALCOLUMN decimal(31, 6),  BOOLEANCOLUMN smallint,  DATECOLUMN timestamp,  DATETIMECOLUMN timestamp,  ID integer,  LASTMODTIME timestamp,  PRIMARY KEY (ID))");
        statement.executeUpdate("CREATE TABLE DERBYTEST_TEMP6956 AS SELECT * FROM DERBYTEST6956 WITH NO DATA");
        statement.executeUpdate("CREATE TABLE DERBYTEST6956_A (STRINGCOLUMN varchar(255),  INTEGERCOLUMN integer,  SHORTCOLUMN varchar(255),  LONGCOLUMN bigint,  DOUBLECOLUMN double,  FLOATCOLUMN double,  DECIMALCOLUMN decimal(29, 6),  BOOLEANCOLUMN smallint,  DATECOLUMN timestamp,  DATETIMECOLUMN timestamp,  ID integer,  LASTMODTIME timestamp,  PRIMARY KEY (ID))");
        statement.executeUpdate("CREATE TABLE DERBYTEST_TEMP6956_A AS SELECT * FROM DERBYTEST6956_A WITH NO DATA");
        statement.executeUpdate("CREATE TABLE DERBYTEST6956_B (STRINGCOLUMN varchar(255),  INTEGERCOLUMN integer,  SHORTCOLUMN varchar(255),  LONGCOLUMN bigint,  DOUBLECOLUMN double,  FLOATCOLUMN double,  DECIMALCOLUMN decimal(31,31),  BOOLEANCOLUMN smallint,  DATECOLUMN timestamp,  DATETIMECOLUMN timestamp,  ID integer,  LASTMODTIME timestamp,  PRIMARY KEY (ID))");
        statement.executeUpdate("CREATE TABLE DERBYTEST_TEMP6956_B AS SELECT * FROM DERBYTEST6956_B WITH NO DATA");
        statement.executeUpdate("CREATE TABLE DERBYTEST6956_C (STRINGCOLUMN varchar(255),  INTEGERCOLUMN integer,  SHORTCOLUMN varchar(255),  LONGCOLUMN bigint,  DOUBLECOLUMN double,  FLOATCOLUMN double,  DECIMALCOLUMN decimal(31,0),  BOOLEANCOLUMN smallint,  DATECOLUMN timestamp,  DATETIMECOLUMN timestamp,  ID integer,  LASTMODTIME timestamp,  PRIMARY KEY (ID))");
        statement.executeUpdate("CREATE TABLE DERBYTEST_TEMP6956_C AS SELECT * FROM DERBYTEST6956_C WITH NO DATA");
    }

    public void testBaseTableDoesNotExist() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42X05", this.createStatement(), "create table t3 as select * from t4 with no data");
    }

    public void testParametersNotAllowed() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42X99", this.createStatement(), "create table t3 as select * from t1 where i = ? with no data");
    }

    public void testDuplicateColumnName() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42X12", this.createStatement(), "create table t3 (c1,c2,c1) as select i, s, f from t1 with no data");
    }

    public void testColumnCountMismatch() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42X70", this.createStatement(), "create table t3 (c1,c2,c3) as select i,s from t1 with no data");
    }

    public void testSystemGeneratedColumnName() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42909", this.createStatement(), "create table t3 as select i, 2*i from t1 with no data");
    }

    public void testNullValues() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42X07", this.createStatement(), "create table t3 (x) as values null with no data");
    }

    public void testUnimplementedWithDataClause() throws Exception {
        CreateTableFromQueryTest.assertStatementError("0A000", this.createStatement(), "create table t3 as select * from t1 with data");
    }

    public void testInvalidDataType() throws Exception {
        Statement statement = this.createStatement();
        CreateTableFromQueryTest.assertStatementError("42X71", statement, "create table t as select aliasinfo from sys.sysaliases with no data");
        CreateTableFromQueryTest.assertStatementError("42X71", statement, "create table t(x) as values 12345678901234567890123456789012345678901234 with no data");
    }

    private void positiveTest(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate(string);
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, null, "T3", null);
        int n = 0;
        while (resultSet.next()) {
            Assert.assertEquals((String)"Column names do not match:", (String)stringArray[n], (String)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((String)"Nullability incorrect:", (String)stringArray2[n], (String)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((String)"Column type incorrect:", (String)stringArray3[n], (String)resultSet.getString("TYPE_NAME"));
            ++n;
        }
        resultSet.close();
        Assert.assertEquals((String)"Unexpected column count:", (int)stringArray.length, (int)n);
        statement.executeUpdate("drop table t3");
    }

    protected void setUp() throws SQLException {
        this.setAutoCommit(false);
    }
}

