/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.services.MarkedLimitInputStream;

public class T_MarkedLimitInputStream
extends T_Generic {
    private static final int TEST_SIZE = 10000;
    private static final int BLOCK_SIZE = 256;

    private static MarkedLimitInputStream setup(byte[] byArray) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10200);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        T_MarkedLimitInputStream.writeDos(byteArrayInputStream, dataOutputStream);
        return T_MarkedLimitInputStream.makeMLIS(byteArrayOutputStream.toByteArray());
    }

    private static void writeDos(InputStream inputStream, DataOutputStream dataOutputStream) throws Exception {
        boolean bl = false;
        byte[] byArray = new byte[256];
        while (!bl) {
            int n = inputStream.read(byArray);
            if (n != 256) {
                bl = true;
                if (n < 0) {
                    n = 0;
                }
            }
            dataOutputStream.writeBoolean(bl);
            dataOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeByte(byArray[i]);
            }
        }
    }

    private static MarkedLimitInputStream makeMLIS(byte[] byArray) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        return new MarkedLimitInputStream(dataInputStream);
    }

    private static boolean readAndCompare(MarkedLimitInputStream markedLimitInputStream, byte[] byArray) throws Exception {
        int n;
        int n2 = 0;
        while ((n = markedLimitInputStream.read()) != -1) {
            if (byArray[n2] != (byte)n) {
                System.out.println("Stream and array differ at position " + n2);
                return false;
            }
            ++n2;
        }
        if (n2 != byArray.length) {
            System.out.println("array size and stream size differ");
            return false;
        }
        return true;
    }

    private static boolean readAndCompareChunks(MarkedLimitInputStream markedLimitInputStream, byte[] byArray) throws Exception {
        int n = 10;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while ((n2 = markedLimitInputStream.read(byArray2)) > 0) {
            for (int i = 0; i < n2; ++i) {
                if (byArray[n3 + i] == byArray2[i]) continue;
                System.out.println("Stream and array differ at position " + (n3 + i));
                System.out.println("Array : x[" + (n3 + i) + "] = " + byArray[n3 + i]);
                System.out.println("Stream : chunk[" + i + "] = " + byArray2[i]);
                return false;
            }
            n3 += n2;
        }
        if (n3 != byArray.length) {
            System.out.println("array size ( " + byArray.length + " ) and stream size ( " + n3 + " ) differ");
            return false;
        }
        return true;
    }

    private static boolean skipAndCompare(MarkedLimitInputStream markedLimitInputStream, byte[] byArray, long l) throws Exception {
        long l2 = markedLimitInputStream.skip(l);
        T_Fail.T_ASSERT(l2 == l);
        byte[] byArray2 = new byte[byArray.length - (int)l2];
        System.arraycopy(byArray, (int)l, byArray2, 0, byArray.length - (int)l2);
        return T_MarkedLimitInputStream.readAndCompare(markedLimitInputStream, byArray2);
    }

    @Override
    public String getModuleToTestProtocolName() {
        return "internalUtils.MarkedLimitInputStream";
    }

    @Override
    protected void runTests() throws Exception {
        boolean bl = true;
        byte[] byArray = new byte[10000];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(i & 0xFF);
        }
        MarkedLimitInputStream markedLimitInputStream = T_MarkedLimitInputStream.setup(byArray);
        if (T_MarkedLimitInputStream.readAndCompare(markedLimitInputStream, byArray)) {
            this.PASS("test1");
        } else {
            this.FAIL("test1");
            bl = false;
        }
        MarkedLimitInputStream markedLimitInputStream2 = T_MarkedLimitInputStream.setup(byArray);
        if (T_MarkedLimitInputStream.readAndCompareChunks(markedLimitInputStream2, byArray)) {
            this.PASS("test2");
        } else {
            this.FAIL("test2");
            bl = false;
        }
        MarkedLimitInputStream markedLimitInputStream3 = T_MarkedLimitInputStream.setup(byArray);
        if (T_MarkedLimitInputStream.skipAndCompare(markedLimitInputStream3, byArray, 5000L)) {
            this.PASS("test3");
        } else {
            this.FAIL("test3");
            bl = false;
        }
        MarkedLimitInputStream markedLimitInputStream4 = T_MarkedLimitInputStream.setup(byArray);
        if (T_MarkedLimitInputStream.skipAndCompare(markedLimitInputStream4, byArray, 9999L)) {
            this.PASS("test4");
        } else {
            this.FAIL("test4");
            bl = false;
        }
        if (!bl) {
            throw T_Fail.testFail();
        }
        byte[] byArray2 = new byte[256];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(i & 0xFF);
        }
        MarkedLimitInputStream markedLimitInputStream5 = T_MarkedLimitInputStream.setup(byArray2);
        if (T_MarkedLimitInputStream.readAndCompare(markedLimitInputStream5, byArray2)) {
            this.PASS("test5");
        } else {
            this.FAIL("test5");
            bl = false;
        }
        if (!bl) {
            throw T_Fail.testFail();
        }
    }
}

