/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.optimizer.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.derbyTesting.system.optimizer.StaticValues;
import org.apache.derbyTesting.system.optimizer.utils.TestUtils;

public class GenericQuery {
    protected String description = "Custom Test Query";
    protected Connection conn = null;
    protected ArrayList<String> queries = new ArrayList();
    protected ArrayList<String[]> prepStmtRunResults = new ArrayList();
    protected ArrayList<String[]> stmtRunResults = new ArrayList();
    protected int[] rowsExpected = null;

    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    public void generateQueries() {
    }

    public void generateQueries(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.queries.add(properties.getProperty(string));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void executeQueries(boolean bl, boolean bl2) throws SQLException {
        this.rowsExpected = new int[this.queries.size()];
        String string = "";
        if (bl) {
            if (bl2) {
                System.out.println("=====================> Using java.sql.PreparedStatement <====================");
            }
        } else if (bl2) {
            System.out.println("=====================> Using java.sql.Statement <====================");
        }
        try {
            for (int i = 0; i < this.queries.size(); ++i) {
                string = this.queries.get(i);
                String[] stringArray = new String[StaticValues.ITER];
                int n = 0;
                for (int j = 0; j < StaticValues.ITER; ++j) {
                    Statement statement = null;
                    ResultSet resultSet = null;
                    PreparedStatement preparedStatement = null;
                    if (bl) {
                        preparedStatement = this.conn.prepareStatement(string);
                    } else {
                        statement = this.conn.createStatement();
                    }
                    long l = System.currentTimeMillis();
                    resultSet = bl ? preparedStatement.executeQuery() : statement.executeQuery(string);
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n2 = resultSetMetaData.getColumnCount();
                    while (resultSet.next()) {
                        Object object = "";
                        for (int k = 1; k <= n2; ++k) {
                            object = (String)object + resultSet.getString(k) + " | ";
                        }
                        ++n;
                    }
                    long l2 = System.currentTimeMillis() - l;
                    if (bl2) {
                        System.out.println("Time required to execute:");
                        System.out.println(string);
                        System.out.println("Total Rows returned = " + n);
                        System.out.println("==> " + l2 + " milliseconds  OR " + TestUtils.getTime(l2));
                    }
                    stringArray[j] = TestUtils.getTime(l2);
                    resultSet.close();
                    if (bl) {
                        preparedStatement.close();
                    } else {
                        statement.close();
                    }
                    this.rowsExpected[i] = n;
                    n = 0;
                }
                if (bl) {
                    this.prepStmtRunResults.add(stringArray);
                    continue;
                }
                this.stmtRunResults.add(stringArray);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("Failed query:\n " + string + "\n SQLState= " + sQLException.getSQLState() + "\n ErrorCode= " + sQLException.getErrorCode() + "\n Message= " + sQLException.getMessage());
        }
    }

    public ArrayList<String[]> getPrepStmtRunResults() {
        return this.prepStmtRunResults;
    }

    public ArrayList<String[]> getStmtRunResults() {
        return this.stmtRunResults;
    }

    public int getRowsExpected(int n) {
        return this.rowsExpected[n];
    }

    public ArrayList getQueries() {
        return this.queries;
    }
}

