/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.SingleRecordFiller;

public class SingleRecordSelectClient
implements Client {
    private Connection conn;
    private final PreparedStatement[] pss;
    private final Random r;
    private final int tableSize;
    private final int dataType;
    private final boolean secondaryIndex;
    private final boolean noIndex;

    public SingleRecordSelectClient(int n, int n2) {
        this(n, n2, 12, false, false);
    }

    public SingleRecordSelectClient(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.tableSize = n;
        this.r = new Random();
        this.pss = new PreparedStatement[n2];
        this.dataType = n3;
        if (bl && bl2) {
            throw new IllegalArgumentException("Cannot select on both secondary index and non-index column");
        }
        this.secondaryIndex = bl;
        this.noIndex = bl2;
    }

    @Override
    public void init(Connection connection) throws SQLException {
        for (int i = 0; i < this.pss.length; ++i) {
            String string = SingleRecordFiller.getTableName(this.tableSize, i, this.dataType, this.secondaryIndex, this.noIndex);
            String string2 = "ID";
            if (this.secondaryIndex) {
                string2 = "SEC";
            } else if (this.noIndex) {
                string2 = "NI";
            }
            String string3 = "SELECT ID, TEXT FROM " + string + " WHERE " + string2 + " = ?";
            this.pss[i] = connection.prepareStatement(string3);
        }
        connection.setAutoCommit(false);
        this.conn = connection;
    }

    @Override
    public void doWork() throws SQLException {
        PreparedStatement preparedStatement = this.pss[this.r.nextInt(this.pss.length)];
        preparedStatement.setInt(1, this.r.nextInt(this.tableSize));
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        resultSet.getInt(1);
        this.fetchTextColumn(resultSet, 2);
        resultSet.close();
        this.conn.commit();
    }

    @Override
    public void printReport(PrintStream printStream) {
    }

    private void fetchTextColumn(ResultSet resultSet, int n) throws SQLException {
        if (this.dataType == 12) {
            resultSet.getString(n);
        } else if (this.dataType == 2005) {
            resultSet.getClob(n).getSubString(1L, 100);
        } else if (this.dataType == 2004) {
            resultSet.getBlob(n).getBytes(1L, 100);
        } else {
            throw new IllegalArgumentException();
        }
    }
}

