/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.store.StoreBaseTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;

public class Derby3625Test
extends StoreBaseTest {
    public Derby3625Test(String string) {
        super(string);
    }

    public void testTwoToOneByteCase() throws SQLException {
        int n;
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO testCompress VALUES(?, ?, ?)");
        byte[] byArray = new byte[32630];
        preparedStatement.setInt(1, 1);
        preparedStatement.setBytes(2, byArray);
        preparedStatement.setString(3, "page 1");
        preparedStatement.executeUpdate();
        byArray = new byte[302];
        preparedStatement.setInt(1, 2);
        preparedStatement.setBytes(2, byArray);
        preparedStatement.setString(3, "page 2");
        for (n = 0; n < 98; ++n) {
            preparedStatement.executeUpdate();
        }
        preparedStatement.setInt(1, 3);
        preparedStatement.setBytes(2, byArray);
        preparedStatement.setString(3, "page 3");
        for (n = 0; n < 98; ++n) {
            preparedStatement.executeUpdate();
        }
        byArray = new byte[100];
        preparedStatement.setInt(1, 4);
        preparedStatement.setBytes(2, byArray);
        preparedStatement.setString(3, "page 4");
        preparedStatement.executeUpdate();
        byArray = new byte[32534];
        preparedStatement.setInt(1, 4);
        preparedStatement.setBytes(2, byArray);
        preparedStatement.setString(3, "page 4");
        preparedStatement.executeUpdate();
        this.commit();
        int[] nArray = this.getSpaceInfo("APP", "TESTCOMPRESS", true);
        Assert.assertEquals((String)"wrong allocated page count in test setup", (int)4, (int)nArray[1]);
        Statement statement = this.createStatement();
        statement.executeUpdate("DELETE FROM testCompress where id = 2 or id = 3");
        this.commit();
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, 1, 1, 1)");
        callableStatement.setString(1, "APP");
        callableStatement.setString(2, "TESTCOMPRESS");
        callableStatement.executeUpdate();
        this.commit();
        nArray = this.getSpaceInfo("APP", "TESTCOMPRESS", true);
        Assert.assertEquals((String)"wrong allocated page count", (int)3, (int)nArray[1]);
        preparedStatement.close();
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(Derby3625Test.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 2, 4)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = statement.getConnection();
                CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
                callableStatement.setString(1, "derby.storage.pageReservedSpace");
                callableStatement.setString(2, "0");
                callableStatement.executeUpdate();
                statement.executeUpdate("CREATE TABLE testCompress (id int, padcol blob(1M), c varchar(200))");
                callableStatement.setString(2, null);
                callableStatement.executeUpdate();
                callableStatement.close();
                connection.setAutoCommit(false);
            }
        };
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Derby3625Test");
        baseTestSuite.addTest(Derby3625Test.baseSuite("Derby36625Test:embedded"));
        return baseTestSuite;
    }
}

