/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.jdbc.ClientDriver;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.tests.replicationTests.Utils;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ReplicationRun
extends BaseTestCase {
    static final String REPLICATIONTEST_PROPFILE = "replicationtest.properties";
    static final String REPLICATION_MASTER_TIMED_OUT = "XRE06";
    static final String REPLICATION_SLAVE_STARTED_OK = "XRE08";
    static final String REPLICATION_DB_NOT_BOOTED = "XRE11";
    static final String SLAVE_OPERATION_DENIED_WHILE_CONNECTED = "XRE41";
    static final String REPLICATION_SLAVE_SHUTDOWN_OK = "XRE42";
    static String testUser = null;
    static String userDir = null;
    static String userHome = null;
    static String dataEncryption = null;
    static String masterServerHost = "localhost";
    static int masterServerPort = TestConfiguration.getCurrent().getPort();
    static String slaveServerHost = "localhost";
    static int slaveServerPort = TestConfiguration.getCurrent().getNextAvailablePort();
    static String testClientHost = "localhost";
    static int slaveReplPort = TestConfiguration.getCurrent().getNextAvailablePort();
    static String masterDatabasePath = null;
    static String slaveDatabasePath = null;
    static String replicatedDb = "test";
    static String bootLoad = "";
    static String freezeDB = "";
    static String unFreezeDB = "";
    static boolean junitTest = true;
    static boolean runUnReplicated = false;
    static boolean simpleLoad = true;
    static int simpleLoadTuples = 1000;
    static int tuplesToInsertPerf = 10000;
    static int commitFreq = 0;
    static String masterDbSubPath = "db_master";
    static String slaveDbSubPath = "db_slave";
    static String replicationTest = "";
    static String replicationVerify = "";
    static int THREADS = 0;
    static int MINUTES = 0;
    static String sqlLoadInit = "";
    static final String networkServerControl = "org.apache.derby.drda.NetworkServerControl";
    static String specialTestingJar = null;
    static String jvmVersion = null;
    static String masterJvmVersion = null;
    static String slaveJvmVersion = null;
    static String derbyVersion = null;
    static String derbyMasterVersion = null;
    static String derbySlaveVersion = null;
    static String junit_jar = null;
    static String test_jars = null;
    static final String FS = File.separator;
    static final String PS = File.pathSeparator;
    static boolean showSysinfo = false;
    static long sleepTime = 5000L;
    static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.ClientDriver";
    static final String DB_PROTOCOL = "jdbc:derby";
    static final String ALL_INTERFACES = "0.0.0.0";
    static String LF = null;
    static final String remoteShell = "/usr/bin/ssh -x";
    Utils util = new Utils();
    State state = new State();
    static boolean localEnv = false;
    static String derbyProperties = null;
    String classPath = null;
    private Connection masterConn = null;
    private Connection slaveConn = null;
    private volatile Exception startSlaveException = null;
    private ArrayList<Thread> helperThreads = new ArrayList();
    private String db_uid = null;
    private String db_passwd = null;
    static Load masterPreRepl;
    static Load masterPostRepl;
    static Load slavePreSlave;
    static Load masterPostSlave;
    static Load slavePostSlave;

    public ReplicationRun(String string) {
        super(string);
        LF = System.getProperties().getProperty("line.separator");
    }

    public ReplicationRun(String string, String string2, String string3) {
        this(string);
        this.db_uid = string2;
        this.db_passwd = string3;
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
        for (Thread thread : this.helperThreads) {
            thread.join();
        }
        this.helperThreads = null;
        ReplicationRun.close(this.masterConn);
        ReplicationRun.close(this.slaveConn);
        this.masterConn = null;
        this.slaveConn = null;
        this.startSlaveException = null;
        this.classPath = null;
        this.util = null;
        this.state = null;
        super.tearDown();
    }

    private static void close(Connection connection) throws SQLException {
        if (connection != null && !connection.isClosed()) {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runBare() throws Throwable {
        try {
            super.runBare();
        }
        catch (Throwable throwable) {
            PrintWriter printWriter = null;
            try {
                String string = PrivilegedFileOpsForTests.getAbsolutePath(this.getFailureFolder());
                printWriter = new PrintWriter(PrivilegedFileOpsForTests.getFileOutputStream(new File(string, "error-stacktrace.out"), true));
                String[] stringArray = new String[]{masterDbSubPath, slaveDbSubPath};
                for (int i = 0; i < 2; ++i) {
                    File file = new File(stringArray[i], "derby.log");
                    File file2 = new File(string, stringArray[i] + "-derby.log");
                    PrivilegedFileOpsForTests.copy(file, file2);
                    String string2 = TestConfiguration.getCurrent().getDefaultDatabaseName();
                    File file3 = new File(stringArray[i], string2);
                    File file4 = new File(string, stringArray[i] + "-" + string2);
                    PrivilegedFileOpsForTests.copy(file3, file4);
                }
            }
            catch (IOException iOException) {
                BaseTestCase.printStackTrace(iOException);
                if (printWriter != null) {
                    printWriter.println("Copying db_slave/db_master's derby.log or database failed:");
                    iOException.printStackTrace(printWriter);
                    printWriter.println();
                }
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
                throw throwable;
            }
        }
    }

    String useEncryption(boolean bl) {
        Object object = "";
        if (dataEncryption != null) {
            if (bl) {
                object = ";dataEncryption=true";
            }
            object = (String)object + ";" + dataEncryption;
        }
        return object;
    }

    void connectPing(String string, String string2, int n, String string3) throws Exception {
        String string4 = this.serverURL(string, string2, n);
        Connection connection = null;
        Object object = null;
        long l = 200L;
        boolean bl = false;
        int n2 = 0;
        while (!bl) {
            try {
                Class.forName(DRIVER_CLASS_NAME);
                connection = DriverManager.getConnection(string4);
                bl = true;
                this.util.DEBUG("Ping Got connection after " + n2 + " * " + l + " ms.");
                connection.close();
            }
            catch (SQLException sQLException) {
                int n3 = sQLException.getErrorCode();
                object = sQLException.getMessage();
                String string5 = sQLException.getSQLState();
                String string6 = "08004";
                object = n3 + " " + string5 + " " + (String)object + ". Expected: " + string6;
                this.util.DEBUG("Got SQLException: " + (String)object);
                if (n3 == 40000 && string5.equalsIgnoreCase(string6)) {
                    if (n2++ >= 600) {
                        ReplicationRun.fail("Failover did not succeed", sQLException);
                    }
                    this.util.DEBUG("Failover not complete.");
                    Thread.sleep(l);
                    continue;
                }
                ReplicationRun.fail("Connect failed", sQLException);
            }
        }
    }

    String showCurrentState(String string, long l, String string2, String string3, int n) throws Exception {
        int n2 = 0;
        String string4 = "CONNECTED";
        String string5 = null;
        Thread.sleep(l);
        try {
            ClientDataSourceInterface clientDataSourceInterface = this.configureDataSource(string2, string3, n, this.useEncryption(false));
            Connection connection = clientDataSourceInterface.getConnection();
            connection.close();
        }
        catch (SQLException sQLException) {
            n2 = sQLException.getErrorCode();
            string5 = sQLException.getMessage();
            string4 = sQLException.getSQLState();
        }
        this.util.DEBUG(string + ": [" + string3 + ":" + n + "/" + string2 + "] " + n2 + " " + string4 + " " + string5);
        return string4;
    }

    void waitForConnect(long l, int n, String string, String string2, int n2) throws Exception {
        int n3 = 0;
        String string3 = null;
        while (true) {
            try {
                ClientDataSourceInterface clientDataSourceInterface = this.configureDataSource(string, string2, n2, this.useEncryption(false));
                Connection connection = clientDataSourceInterface.getConnection();
                this.util.DEBUG("Wait Got connection after " + (n3 - 1) + " * " + l + " ms.");
                connection.close();
                return;
            }
            catch (SQLException sQLException) {
                if (n3++ > n) {
                    ReplicationRun.fail("Could not connect in " + (long)n * l + " ms", sQLException);
                }
                string3 = sQLException.getErrorCode() + "' '" + sQLException.getSQLState() + "' '" + sQLException.getMessage();
                this.util.DEBUG(n3 + " got '" + string3 + "'.");
                Thread.sleep(l);
                continue;
            }
            break;
        }
    }

    void waitForSQLState(String string, long l, int n, String string2, String string3, int n2) throws Exception {
        int n3 = 0;
        Object object = null;
        while (true) {
            try {
                while (true) {
                    ClientDataSourceInterface clientDataSourceInterface = this.configureDataSource(string2, string3, n2, this.useEncryption(false));
                    Connection connection = clientDataSourceInterface.getConnection();
                    connection.close();
                    ReplicationRun.assertTrue((String)("Expected SQLState'" + string + "', but got connection!"), (boolean)false);
                }
            }
            catch (SQLException sQLException) {
                int n4 = sQLException.getErrorCode();
                object = sQLException.getMessage();
                String string4 = sQLException.getSQLState();
                object = "'" + n4 + "' '" + string4 + "' '" + (String)object + "'";
                this.util.DEBUG(n3 + ": SQLState expected '" + string + "', got " + (String)object);
                if (string4.equals(string)) {
                    this.util.DEBUG("Reached SQLState '" + string + "' in " + (n3 - 1) + "*" + l + "ms.");
                    return;
                }
                if (n3++ > n) {
                    ReplicationRun.fail("SQLState '" + string + "' was not reached in " + (long)n * l + " ms", sQLException);
                    continue;
                }
                Thread.sleep(l);
                continue;
            }
            break;
        }
    }

    void shutdownDb(String string, String string2, int n, String string3, String string4, String string5) throws Exception {
        String string6 = this.serverURL(string3 + FS + string4, string2, n);
        this.util.DEBUG("**** DriverManager.getConnection(\"" + string6 + ";shutdown=true\");");
        try {
            Class.forName(DRIVER_CLASS_NAME);
            DriverManager.getConnection(string6 + ";shutdown=true");
            ReplicationRun.fail((String)"Database shutdown should throw exception");
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState("08006", sQLException);
        }
    }

    void startServerMonitor(String string) {
        this.util.DEBUG("startServerMonitor(" + string + ") NOT YET IMPLEMENTED.");
    }

    void runTest(String string, String string2, String string3, String string4, int n, String string5) throws Exception {
        this.util.DEBUG("runTest(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + n + ", " + string5 + ") ");
        if (string == null) {
            this.util.DEBUG("No replicationTest specified. Exitting.");
            return;
        }
        if (simpleLoad) {
            this._testInsertUpdateDeleteOnMaster(string4, n, string5, simpleLoadTuples);
            return;
        }
        String string6 = this.masterURL(string5);
        String string7 = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbyTesting.jar" + PS + derbyVersion + FS + "derbytools.jar";
        String string8 = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbynet.jar" + PS + test_jars;
        String string9 = ReplicationRun.getClientJavaExecutableName();
        boolean bl = !string3.equals("localhost");
        boolean bl2 = string.indexOf(".sql") >= 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add(string9);
            arrayList.add("-classpath");
            arrayList.add(bl2 ? string7 : string8);
        }
        this.util.DEBUG("replicationTest: " + string);
        if (bl2) {
            arrayList.add("-Dij.driver=org.apache.derby.jdbc.ClientDriver");
            arrayList.add("-Dij.connection.startTestClient=" + string6);
            arrayList.add("org.apache.derby.tools.ij");
            arrayList.add(string);
        } else {
            arrayList.add("-Dderby.tests.trace=true");
            arrayList.add("-Dtest.serverHost=" + string4);
            arrayList.add("-Dtest.serverPort=" + n);
            arrayList.add("-Dtest.inserts=" + tuplesToInsertPerf);
            arrayList.add("-Dtest.commitFreq=" + commitFreq);
            if (THREADS != 0 && MINUTES != 0) {
                arrayList.add("-Dderby.tests.ThreadsMinutes=" + THREADS + "x" + MINUTES);
            }
            arrayList.add("-Dtest.dbPath=" + this.masterDbPath(string5));
            if (junitTest) {
                arrayList.add("junit.textui.TestRunner");
            }
            arrayList.add(string);
        }
        String[] stringArray = this.util.toStringArray(arrayList);
        long l = System.currentTimeMillis();
        String string10 = null;
        String string11 = userHome;
        if (!bl) {
            this.runUserCommandLocally(stringArray, "runTest ", null);
        } else {
            string10 = this.runUserCommandRemotely("cd " + string11 + ";" + this.util.splice(stringArray, ' '), string3, testUser, "runTest ");
        }
        this.util.DEBUG("Time: " + (double)(System.currentTimeMillis() - l) / 1000.0);
    }

    void runTestOnSlave(String string, String string2, String string3, String string4, int n, String string5) throws Exception {
        this.util.DEBUG("runTestOnSlave(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + n + ", " + string5 + ") ");
        String string6 = this.slaveURL(string5);
        String string7 = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbyTesting.jar" + PS + derbyVersion + FS + "derbytools.jar";
        String string8 = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbynet.jar" + PS + test_jars;
        String string9 = ReplicationRun.getSlaveJavaExecutableName();
        if (string == null) {
            this.util.DEBUG("No replicationTest specified. Exitting.");
            return;
        }
        boolean bl = !string4.equals("localhost");
        boolean bl2 = string.indexOf(".sql") >= 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add(string9);
            arrayList.add("-classpath");
            arrayList.add(bl2 ? string7 : string8);
        }
        this.util.DEBUG("replicationTest: " + string);
        if (bl2) {
            arrayList.add("-Dij.driver=org.apache.derby.jdbc.ClientDriver");
            arrayList.add("-Dij.connection.startTestClient=" + string6);
            arrayList.add("org.apache.derby.tools.ij");
            arrayList.add(string);
        } else {
            arrayList.add("-Dderby.tests.trace=true");
            arrayList.add("-Dtest.serverHost=" + string4);
            arrayList.add("-Dtest.serverPort=" + n);
            arrayList.add("-Dtest.inserts=" + tuplesToInsertPerf);
            arrayList.add("-Dtest.commitFreq=" + commitFreq);
            arrayList.add("-Dtest.dbPath=" + this.slaveDbPath(string5));
            arrayList.add("junit.textui.TestRunner");
            arrayList.add(string);
        }
        String[] stringArray = this.util.toStringArray(arrayList);
        long l = System.currentTimeMillis();
        String string10 = null;
        if (!bl) {
            this.runUserCommandLocally(stringArray, "runTestOnSlave ", null);
        } else {
            string10 = this.runUserCommandRemotely("cd " + userDir + ";" + this.util.splice(stringArray, ' '), string3, testUser, "runTestOnSlave ");
        }
        this.util.DEBUG("Time: " + (double)(System.currentTimeMillis() - l) / 1000.0);
    }

    private void runLoad(String string, String string2, String string3, String string4, int n, String string5) throws Exception {
        this.util.DEBUG("runLoad(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + n + ", " + string5 + ") ");
        String string6 = this.masterLoadURL(string5);
        String string7 = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbyTesting.jar" + PS + derbyVersion + FS + "derbytools.jar";
        String string8 = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbynet.jar" + PS + test_jars;
        String string9 = ReplicationRun.getClientJavaExecutableName();
        boolean bl = !string4.equals("localhost");
        boolean bl2 = string.indexOf(".sql") >= 0;
        this.util.DEBUG("load: " + string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add(string9);
            arrayList.add("-classpath");
            arrayList.add(bl2 ? string7 : string8);
        }
        if (bl2) {
            arrayList.add("-Dij.driver=org.apache.derby.jdbc.ClientDriver");
            arrayList.add("-Dij.connection.startTestClient=" + string6);
            arrayList.add("org.apache.derby.tools.ij");
            arrayList.add(string);
        } else {
            arrayList.add("-Dderby.tests.trace=true");
            arrayList.add("junit.textui.TestRunner");
            arrayList.add(string);
        }
        String[] stringArray = this.util.toStringArray(arrayList);
        if (!bl) {
            this.runUserCommandInThreadLocally(stringArray, string5, "runLoad[" + string5 + "] ");
        } else {
            this.runUserCommandInThreadRemotely(this.util.splice(stringArray, ' '), string3, testUser, "runLoad[" + string5 + "] ");
        }
    }

    private void runStateTest(String string, String string2, String string3, String string4, int n, String string5) throws Exception {
        this.util.DEBUG("runStateTest(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + n + ", " + string5 + ") ");
        String string6 = this.masterLoadURL(string5);
        Object object = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbyTesting.jar" + PS + derbyVersion + FS + "derbytools.jar";
        Object object2 = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbynet.jar" + PS + test_jars;
        String string7 = ReplicationRun.getClientJavaExecutableName();
        String string8 = null;
        if (string4.equals("localhost")) {
            object = this.classPath;
            object2 = this.classPath;
        }
        this.util.DEBUG("stateTest: " + string);
        string8 = string.indexOf(".sql") >= 0 ? string7 + " -Dij.driver=org.apache.derby.jdbc.ClientDriver -Dij.connection.startTestClient=" + string6 + " -classpath " + (String)object + " org.apache.derby.tools.ij " + string : "cd " + userDir + ";" + string7 + " -Dderby.tests.trace=true -classpath " + (String)object2 + " junit.textui.TestRunner " + string;
        this.runUserCommandRemotely(string8, string3, testUser, "runStateTest ");
    }

    void bootMasterDatabase(String string, String string2, String string3, String string4, int n, String string5) throws Exception {
        Object object = this.masterURL(string3) + ";create=true" + this.useEncryption(true);
        this.util.DEBUG("bootMasterDatabase getConnection(" + (String)object + ")");
        DriverManager.registerDriver((Driver)new ClientDriver());
        Connection connection = DriverManager.getConnection((String)object);
        connection.close();
        this.util.DEBUG("************************** DERBY-???? Preliminary needs to freeze db before copying to slave and setting replication mode.");
        object = this.masterURL(string3);
        Class.forName(DRIVER_CLASS_NAME);
        this.util.DEBUG("bootMasterDatabase getConnection(" + (String)object + ")");
        connection = DriverManager.getConnection((String)object);
        Statement statement = connection.createStatement();
        statement.execute("call syscs_util.syscs_freeze_database()");
        connection.close();
        if (string5 != null) {
            this.runLoad(string5, string, testClientHost, masterServerHost, n, string2 + FS + string3);
        }
        this.util.DEBUG("bootMasterDatabase done.");
    }

    void startMaster(String string, String string2, String string3, int n, String string4, int n2, String string5, int n3) throws Exception {
        if (string3.equalsIgnoreCase("localhost")) {
            this.startMaster_direct(string2, string3, n, string5, n3);
        } else {
            this.startMaster_ij(string2, string3, string5, n3);
        }
    }

    private void startMaster_ij(String string, String string2, String string3, int n) throws Exception {
        String string4 = this.masterURL(string) + ";startMaster=true;slaveHost=" + string3 + ";slavePort=" + n;
        Object object = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbytools.jar";
        if (string2.equals("localhost")) {
            object = this.classPath;
        }
        String string5 = ReplicationRun.getMasterJavaExecutableName();
        String string6 = string5 + " -Dij.driver=org.apache.derby.jdbc.ClientDriver -Dij.connection.startMaster=\"" + string4 + "\" -classpath " + (String)object + " org.apache.derby.tools.ij " + userHome + FS + "ij_dummy_script.sql";
        String string7 = this.runUserCommandRemotely(string6, string2, testUser, "startMaster_ij ");
        this.util.DEBUG(string7);
    }

    private void startMaster_direct(String string, String string2, int n, String string3, int n2) throws Exception {
        String string4 = this.masterURL(string) + ";startMaster=true;slaveHost=" + string3 + ";slavePort=" + n2;
        this.util.DEBUG("startMaster_direct getConnection(" + string4 + ")");
        Connection connection = null;
        boolean bl = false;
        int n3 = 0;
        while (!bl) {
            try {
                String string5 = "startMaster=true;slaveHost=" + string3 + ";slavePort=" + n2 + this.useEncryption(false);
                ClientDataSourceInterface clientDataSourceInterface = this.configureDataSource(this.masterDbPath(string), string2, n, string5);
                connection = clientDataSourceInterface.getConnection();
                bl = true;
                connection.close();
                this.util.DEBUG("startMaster_direct connected in " + n3 + " * 100ms.");
            }
            catch (SQLException sQLException) {
                int n4 = sQLException.getErrorCode();
                String string6 = sQLException.getMessage();
                String string7 = sQLException.getSQLState();
                String string8 = "XRE04";
                this.util.DEBUG("startMaster Got SQLException: " + n4 + " " + string7 + " " + string6 + ". Expected " + string8);
                if (n4 == 40000 && string7.equalsIgnoreCase(string8)) {
                    if (n3++ > 1200) {
                        ReplicationRun.fail("startMaster did not succeed", sQLException);
                    }
                    this.util.DEBUG("Not ready to startMaster. Beware: Will also report '... got a fatal error for database '...../<dbname>' in master derby.log.");
                    Thread.sleep(100L);
                    continue;
                }
                if (REPLICATION_MASTER_TIMED_OUT.equals(string7)) {
                    this.util.DEBUG("Master already started?");
                }
                this.util.DEBUG("startMaster_direct Got: " + this.state + " Expected " + string8);
                throw sQLException;
            }
        }
        this.util.DEBUG("startMaster_direct exit.");
    }

    protected Connection getMasterConnection() throws SQLException {
        if (this.masterConn == null) {
            String string = this.masterURL(replicatedDb);
            this.masterConn = DriverManager.getConnection(string);
        }
        return this.masterConn;
    }

    protected Connection getSlaveConnection() throws SQLException {
        if (this.slaveConn == null) {
            String string = this.slaveURL(replicatedDb);
            this.slaveConn = DriverManager.getConnection(string);
        }
        return this.slaveConn;
    }

    protected void executeOnMaster(String string) throws SQLException {
        Statement statement = this.getMasterConnection().createStatement();
        statement.execute(string);
        statement.close();
    }

    protected void executeOnSlave(String string) throws SQLException {
        Statement statement = this.getSlaveConnection().createStatement();
        statement.execute(string);
        statement.close();
    }

    void startSlave(String string, String string2, String string3, int n, String string4, int n2, String string5) throws Exception {
        if (string5.equalsIgnoreCase("localhost")) {
            this.startSlave_direct(string2, string3, n, string4, n2);
        } else {
            this.startSlave_ij(string2, string3, string4, n2);
        }
    }

    private void startSlave_ij(String string, String string2, String string3, int n) throws Exception {
        String string4 = this.slaveURL(string) + ";startSlave=true;slaveHost=" + string3 + ";slavePort=" + n;
        Object object = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbytools.jar";
        if (string2.equals("localhost")) {
            object = this.classPath;
        }
        String string5 = ReplicationRun.getSlaveJavaExecutableName();
        String string6 = string5 + " -Dij.driver=org.apache.derby.jdbc.ClientDriver -Dij.connection.startSlave=\"" + string4 + "\" -classpath " + (String)object + " org.apache.derby.tools.ij " + userHome + FS + "ij_dummy_script.sql";
        this.runUserCommandInThreadRemotely(string6, string2, testUser, "startSlave_ij ");
    }

    private void startSlave_direct(String string, String string2, int n, String string3, int n2) throws Exception {
        String string4 = this.slaveURL(string) + ";startSlave=true;slaveHost=" + string3 + ";slavePort=" + n2;
        this.util.DEBUG("startSlave_direct getConnection(" + string4 + ")");
        final String string5 = this.slaveDbPath(string);
        final String string6 = string2;
        final int n3 = n;
        final String string7 = "startSlave=true;slaveHost=" + string3 + ";slavePort=" + n2 + this.useEncryption(false);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReplicationRun.this.startSlaveException = null;
                Connection connection = null;
                try {
                    ClientDataSourceInterface clientDataSourceInterface = ReplicationRun.this.configureDataSource(string5, string6, n3, string7);
                    connection = clientDataSourceInterface.getConnection();
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ReplicationRun.this.startSlaveException = sQLException;
                }
                catch (Exception exception) {
                    ReplicationRun.this.startSlaveException = exception;
                }
            }
        });
        thread.start();
        this.registerThread(thread);
        this.util.DEBUG("startSlave_direct exit.");
    }

    void failOver(String string, String string2, String string3, String string4, String string5, int n, String string6) throws Exception {
        if (string5.equalsIgnoreCase("localhost")) {
            this.failOver_direct(string4);
        } else {
            this.failOver_ij(string4, string5, string6);
        }
    }

    private void failOver_ij(String string, String string2, String string3) throws Exception {
        String string4 = this.masterURL(string) + ";failover=true";
        Object object = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbytools.jar";
        if (string2.equals("localhost")) {
            object = this.classPath;
        }
        String string5 = ReplicationRun.getClientJavaExecutableName();
        String string6 = string5 + " -Dij.driver=org.apache.derby.jdbc.ClientDriver -Dij.connection.failover=\"" + string4 + "\" -classpath " + (String)object + " org.apache.derby.tools.ij " + userHome + FS + "ij_dummy_script.sql";
        String string7 = this.runUserCommandRemotely(string6, string3, testUser, "failOver_ij ");
        this.util.DEBUG(string7);
    }

    private void failOver_direct(String string) throws Exception {
        String string2 = this.masterURL(string) + ";failover=true";
        this.util.DEBUG("failOver_direct getConnection(" + string2 + ")");
        try {
            Class.forName(DRIVER_CLASS_NAME);
            DriverManager.getConnection(string2);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            Object object = sQLException.getMessage();
            String string3 = sQLException.getSQLState();
            String string4 = "XRE20";
            object = "failOver_direct Got SQLException: " + n + " " + string3 + " " + (String)object + ". Expected: " + string4;
            this.util.DEBUG((String)object);
            BaseJDBCTestCase.assertSQLState(string4, sQLException);
        }
    }

    int xFindServerPID(String string, int n) throws InterruptedException {
        if (string.equalsIgnoreCase("localhost")) {
            return 0;
        }
        int n2 = -1;
        String string2 = "ps auxwww";
        String string3 = " | grep " + n;
        String string4 = " | grep '.NetworkServerControl start -h '";
        String string5 = "";
        String string6 = " | grep -v grep";
        String string7 = " | grep -v ssh";
        String string8 = " | grep -v bash";
        String string9 = " | gawk '{ print $2 }'";
        String string10 = " | head -1";
        String string11 = string2 + string3 + string4 + string5 + string6 + string7 + string8 + ";";
        String string12 = this.runUserCommandRemotely(string11, string, testUser, "ps");
        this.util.DEBUG("xFindServerPID: '" + string12 + "'");
        string11 = string2 + string3 + string4 + string5 + string6 + string7 + string8 + string9 + string10 + ";";
        string12 = this.runUserCommandRemotely(string11, string, testUser, "ps");
        if (string12 == null) {
            this.util.DEBUG("xFindServerPID: Server process not found");
            return -1;
        }
        this.util.DEBUG("xFindServerPID: '" + string12 + "'");
        n2 = Integer.parseInt(string12.trim());
        this.util.DEBUG("xFindServerPID: " + n2);
        return n2;
    }

    void xStopServer(String string, int n) throws InterruptedException {
        if (n == -1 || n == 0) {
            this.util.DEBUG("Illegal PID");
            return;
        }
        String string2 = "kill " + n;
        this.runUserCommandRemotely(string2, string, testUser, "xStopServer");
    }

    void verifySlave() throws Exception {
        this.util.DEBUG("BEGIN verifySlave " + slaveServerHost + ":" + slaveServerPort + "/" + this.slaveDbPath(replicatedDb));
        if (replicationTest != null && simpleLoad) {
            this._verifyDatabase(slaveServerHost, slaveServerPort, this.slaveDbPath(replicatedDb), simpleLoadTuples);
        }
        ClientDataSourceInterface clientDataSourceInterface = this.configureDataSource(this.slaveDbPath(replicatedDb), slaveServerHost, slaveServerPort, this.useEncryption(false));
        Connection connection = clientDataSourceInterface.getConnection();
        this.simpleVerify(connection);
        connection.close();
        if (!slaveServerHost.equalsIgnoreCase("localhost")) {
            this.runSlaveVerificationCLient(jvmVersion, testClientHost, replicatedDb, slaveServerHost, slaveServerPort);
        }
        this.util.DEBUG("END   verifySlave");
    }

    void verifyMaster() throws Exception {
        this.util.DEBUG("BEGIN verifyMaster " + masterServerHost + ":" + masterServerPort + "/" + this.masterDbPath(replicatedDb));
        if (replicationTest != null && simpleLoad) {
            this._verifyDatabase(masterServerHost, masterServerPort, this.masterDbPath(replicatedDb), simpleLoadTuples);
        }
        ClientDataSourceInterface clientDataSourceInterface = this.configureDataSource(this.masterDbPath(replicatedDb), masterServerHost, masterServerPort, this.useEncryption(false));
        Connection connection = clientDataSourceInterface.getConnection();
        this.simpleVerify(connection);
        connection.close();
        if (!masterServerHost.equalsIgnoreCase("localhost")) {
            this.runMasterVerificationCLient(jvmVersion, testClientHost, replicatedDb, masterServerHost, masterServerPort);
        }
        this.util.DEBUG("END   verifyMaster");
    }

    private void simpleVerify(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select SCHEMAID, TABLENAME from sys.systables");
        while (resultSet.next()) {
            this.util.DEBUG(resultSet.getString(1) + " " + resultSet.getString(2));
        }
    }

    private void runSlaveVerificationCLient(String string, String string2, String string3, String string4, int n) throws Exception {
        this.util.DEBUG("runSlaveVerificationCLient");
        if (replicationVerify != null) {
            this.runTestOnSlave(replicationVerify, string, string2, string4, n, string3);
        }
    }

    private void runMasterVerificationCLient(String string, String string2, String string3, String string4, int n) throws Exception {
        this.util.DEBUG("runMasterVerificationCLient");
        if (replicationVerify != null) {
            this.runTest(replicationVerify, string, string2, string4, n, string3);
        }
    }

    private void runUserCommandLocally(String[] stringArray, String string, File file) {
        this.util.DEBUG("");
        String string2 = "runUserCommandLocally " + string + " ";
        this.util.DEBUG(string2 + stringArray);
        this.util.DEBUG(string2 + "localCommand: " + Arrays.asList(stringArray));
        try {
            Process process = ReplicationRun.execJavaCmd(null, null, stringArray, file);
            this.processDEBUGOutput(string2 + "pDo ", process);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.util.DEBUG(string2 + "--- runUserCommandLocally ");
        this.util.DEBUG("");
    }

    private String runUserCommandRemotely(String string, String string2, String string3, String string4) {
        String string5 = "runUserCommandRemotely " + string4 + " ";
        this.util.DEBUG(string5 + "Execute '" + string + "' on '" + string2 + "' as " + string3);
        String string6 = "/usr/bin/ssh -x -l " + string3 + " " + string2 + " " + string;
        String string7 = "";
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string6);
            string7 = this.processOutput(string5, process);
            int n = process.waitFor();
            this.util.DEBUG("ExitValue: " + n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string7;
    }

    private void runUserCommandInThreadLocally(final String[] stringArray, String string, String string2) {
        this.util.DEBUG("");
        final String string3 = "runUserCommandInThread " + string2 + " ";
        this.util.DEBUG(string3 + "Execute '" + stringArray + "'");
        this.util.DEBUG("+++ " + string3);
        this.util.DEBUG("runUserCommand: " + stringArray);
        String string4 = System.getProperty("user.dir");
        this.util.DEBUG("user.dir: " + string4);
        final File file = string == null ? null : new File(string4, string);
        this.util.DEBUG(string3 + "workingDir: " + file);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReplicationRun.this.util.DEBUG(string3 + "************** In run().");
                ReplicationRun.this.runUserCommandLocally(stringArray, string3, file);
                ReplicationRun.this.util.DEBUG(string3 + "************** Done run().");
            }
        });
        this.util.DEBUG(string3 + "************** Do .start().");
        thread.start();
        this.registerThread(thread);
        this.util.DEBUG(string3 + "--- ");
        this.util.DEBUG("");
    }

    private void runUserCommandInThreadRemotely(String string, final String string2, final String string3, String string4) {
        this.util.DEBUG("");
        final String string5 = string4 + " runUserCommandInThreadRemotely ";
        this.util.DEBUG(string5 + "+++ ");
        this.util.DEBUG(string5 + "Execute '" + string + "' on '" + string2 + "'");
        this.util.DEBUG(string5 + string + " @ " + string2 + " as " + string3);
        String[] stringArray = new String[]{"CLASS_PATH=", "PATH=" + FS + "home" + FS + string3 + FS + "bin:$PATH"};
        String string6 = System.getProperty("user.home");
        this.util.DEBUG(string5 + "user.home: " + string6);
        this.util.DEBUG(string5 + "envElements: " + this.util.splice(stringArray, ' '));
        this.util.DEBUG(string5 + "workingDir: " + string6);
        this.util.DEBUG(string5 + "Running command on non-local host " + string2);
        String[] stringArray2 = new String[]{"CLASS_PATH=", "PATH=" + FS + "home" + FS + string3 + FS + "bin:${PATH}"};
        String string7 = this.util.splice(stringArray2, ';');
        this.util.DEBUG(string5 + "shellEnv: " + string7);
        final String string8 = "cd " + string6 + ";pwd;" + string7 + ";" + string;
        this.util.DEBUG(string5 + "shellCmd: " + string8);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReplicationRun.this.util.DEBUG(string5 + "************** In run().");
                ReplicationRun.this.runUserCommandRemotely(string8, string2, string3, string5);
                ReplicationRun.this.util.DEBUG(string5 + "************** Done exec().");
            }
        });
        this.util.DEBUG(string5 + "************** Do .start(). ");
        thread.start();
        this.registerThread(thread);
        this.util.DEBUG(string5 + "--- ");
        this.util.DEBUG("");
    }

    void initEnvironment() throws IOException {
        this.util.printDebug = System.getProperty("derby.tests.repltrace", "false").equalsIgnoreCase("true");
        this.util.DEBUG("printDebug: " + this.util.printDebug);
        this.util.DEBUG("*** ReplicationRun.initEnvironment -----------------------------------------");
        this.util.DEBUG("*** Properties -----------------------------------------");
        userDir = System.getProperty("user.dir");
        this.util.DEBUG("user.dir:          " + userDir);
        this.util.DEBUG("derby.system.home: " + System.getProperty("derby.system.home"));
        showSysinfo = true;
        this.util.DEBUG("showSysinfo: " + showSysinfo);
        testUser = null;
        this.util.DEBUG("testUser: " + testUser);
        masterServerHost = "localhost";
        this.util.DEBUG("masterServerHost: " + masterServerHost);
        this.util.DEBUG("masterServerPort: " + masterServerPort);
        slaveServerHost = "localhost";
        this.util.DEBUG("slaveServerHost: " + slaveServerHost);
        this.util.DEBUG("slaveServerPort: " + slaveServerPort);
        this.util.DEBUG("slaveReplPort: " + slaveReplPort);
        testClientHost = "localhost";
        this.util.DEBUG("testClientHost: " + testClientHost);
        masterDatabasePath = userDir;
        this.util.DEBUG("masterDatabasePath: " + masterDatabasePath);
        slaveDatabasePath = userDir;
        this.util.DEBUG("slaveDatabasePath: " + slaveDatabasePath);
        replicatedDb = "wombat";
        this.util.DEBUG("replicatedDb: " + replicatedDb);
        bootLoad = null;
        this.util.DEBUG("bootLoad: " + bootLoad);
        freezeDB = null;
        this.util.DEBUG("freezeDB: " + freezeDB);
        unFreezeDB = null;
        this.util.DEBUG("unFreezeDB: " + unFreezeDB);
        simpleLoad = System.getProperty("derby.tests.replSimpleLoad", "true").equalsIgnoreCase("true");
        this.util.DEBUG("simpleLoad: " + simpleLoad);
        sqlLoadInit = null;
        this.util.DEBUG("sqlLoadInit: " + sqlLoadInit);
        specialTestingJar = null;
        this.util.DEBUG("specialTestingJar: " + specialTestingJar);
        jvmVersion = System.getProperty("java.home") + FS + "lib";
        this.util.DEBUG("jvmVersion: " + jvmVersion);
        masterJvmVersion = null;
        if (masterJvmVersion == null) {
            masterJvmVersion = jvmVersion;
        }
        this.util.DEBUG("masterJvmVersion: " + masterJvmVersion);
        slaveJvmVersion = null;
        if (slaveJvmVersion == null) {
            slaveJvmVersion = jvmVersion;
        }
        this.util.DEBUG("slaveJvmVersion: " + slaveJvmVersion);
        this.classPath = System.getProperty("java.class.path");
        this.util.DEBUG("classPath: " + this.classPath);
        this.util.DEBUG("derbyVersion: " + derbyVersion);
        derbyMasterVersion = null;
        if (derbyMasterVersion == null) {
            derbyMasterVersion = derbyVersion;
        }
        this.util.DEBUG("derbyMasterVersion: " + derbyMasterVersion);
        derbySlaveVersion = null;
        if (derbySlaveVersion == null) {
            derbySlaveVersion = derbyVersion;
        }
        this.util.DEBUG("derbySlaveVersion: " + derbySlaveVersion);
        Object object = derbyVersion + FS + "derbyTesting.jar";
        if (specialTestingJar != null) {
            object = specialTestingJar;
        }
        this.util.DEBUG("derbyTestingJar: " + (String)object);
        junit_jar = derbyVersion + FS + "junit.jar";
        this.util.DEBUG("junit_jar: " + junit_jar);
        test_jars = (String)object + PS + junit_jar;
        this.util.DEBUG("test_jars: " + test_jars);
        sleepTime = 15000L;
        this.util.DEBUG("sleepTime: " + sleepTime);
        runUnReplicated = false;
        this.util.DEBUG("runUnReplicated: " + runUnReplicated);
        localEnv = false;
        this.util.DEBUG("localEnv: " + localEnv);
        derbyProperties = "derby.infolog.append=true" + LF + "derby.drda.logConnections=true" + LF + "derby.drda.traceAll=true" + LF;
        this.util.DEBUG("--------------------------------------------------------");
        masterPreRepl = null;
        masterPostRepl = null;
        slavePreSlave = null;
        masterPostSlave = null;
        slavePostSlave = null;
        this.util.DEBUG("--------------------------------------------------------");
        tuplesToInsertPerf = 10000;
        commitFreq = 1000;
        this.util.DEBUG("--------------------------------------------------------");
        this.util.DEBUG("--------------------------------------------------------");
    }

    void initMaster(String string, String string2) throws Exception {
        File file = new File(masterDatabasePath, masterDbSubPath);
        File file2 = new File(slaveDatabasePath, slaveDbSubPath);
        this.util.DEBUG("initMaster");
        String string3 = null;
        if (string.equalsIgnoreCase("localhost") || localEnv) {
            if (PrivilegedFileOpsForTests.exists(file)) {
                BaseTestCase.assertDirectoryDeleted(file);
            }
            this.util.mkDirs(file.getPath());
            if (PrivilegedFileOpsForTests.exists(file2)) {
                BaseTestCase.assertDirectoryDeleted(file2);
            }
            this.util.mkDirs(file2.getPath());
        } else {
            String string4 = "mkdir -p " + masterDatabasePath + FS + masterDbSubPath + "; cd " + masterDatabasePath + FS + masterDbSubPath + "; rm -rf " + string2 + " derby.log; rm -f Server*.trace; ls -al;";
            string3 = this.runUserCommandRemotely(string4, string, testUser, "initMaster ");
        }
        this.util.DEBUG(string3);
    }

    private void removeSlaveDBfiles(String string, String string2) throws InterruptedException {
        String string3 = "cd " + slaveDatabasePath + FS + slaveDbSubPath + "; rm -f " + string2 + FS + "seg0" + FS + "* ; ls -al test test/seg0";
        String string4 = this.runUserCommandRemotely(string3, string, testUser, "removeSlaveDBfiles ");
        this.util.DEBUG(string4);
    }

    void initSlave(String string, String string2, String string3) throws Exception {
        this.util.DEBUG("initSlave");
        File file = new File(slaveDatabasePath, slaveDbSubPath);
        File file2 = new File(masterDatabasePath, masterDbSubPath);
        File file3 = new File(file2, string3);
        String string4 = null;
        if (string.equalsIgnoreCase("localhost") || localEnv) {
            File file4 = new File(file, string3);
            PrivilegedFileOpsForTests.copy(file3, file4);
        } else {
            String string5 = "mkdir -p " + file.getPath() + "; cd " + file.getPath() + "; rm -rf " + string3 + " derby.log; rm -f Server*.trace; scp -r " + masterServerHost + ":" + file3.getPath() + "/ .; ls -al";
            string4 = this.runUserCommandRemotely(string5, string, testUser, "initSlave ");
        }
        this.util.DEBUG(string4);
    }

    void restartServer(String string, String string2, String string3, String string4, int n, String string5) throws Exception {
        this.stopServer(string, string2, string3, n);
        this.startServer(string, string2, string3, string4, n, string5);
    }

    void startServer(String string, String string2, String string3, String string4, int n, String string5) throws Exception {
        this.util.DEBUG("");
        String string6 = "startServer@" + string3 + ":" + n + " ";
        this.util.DEBUG(string6 + "+++ StartServer " + string + " / " + string2);
        String string7 = string2 + FS + "derby.jar" + PS + string2 + FS + "derbynet.jar" + PS + test_jars;
        boolean bl = !string3.equals("localhost");
        String string8 = masterDatabasePath + FS + string5;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add(ReplicationRun.getMasterJavaExecutableName());
            arrayList.add("-cp");
            arrayList.add(string7);
        }
        arrayList.add("-Dderby.system.home=" + string8);
        arrayList.add("-Dderby.infolog.append=true");
        if (this.db_uid != null) {
            arrayList.add("-Dderby.authentication.provider=NATIVE:" + replicatedDb + ":LOCAL");
        }
        arrayList.add(networkServerControl);
        arrayList.add("start");
        arrayList.add("-h");
        arrayList.add(string4);
        arrayList.add("-p");
        arrayList.add(String.valueOf(n));
        arrayList.add("-noSecurityManager");
        String[] stringArray = this.util.toStringArray(arrayList);
        if (!bl) {
            this.util.DEBUG(string6 + "Starting server on localhost " + string3);
            this.runUserCommandInThreadLocally(stringArray, null, string6);
        } else {
            this.util.DEBUG(string6 + "Starting server on non-local host " + string3);
            String string9 = this.util.splice(stringArray, ' ');
            this.runUserCommandInThreadRemotely(string9, string3, testUser, string6);
        }
        this.pingServer(string3, n);
        this.util.DEBUG(string6 + "--- StartServer ");
        this.util.DEBUG("");
    }

    void killMaster(String string, int n) throws InterruptedException {
        this.util.DEBUG("killMaster: " + string + ":" + n);
        if (string.equals("localhost")) {
            this.stopServer(masterJvmVersion, derbyMasterVersion, string, n);
        } else {
            int n2 = this.xFindServerPID(string, n);
            this.xStopServer(string, n2);
        }
    }

    void killSlave(String string, int n) throws InterruptedException {
        this.util.DEBUG("killSlave: " + string + ":" + n);
        if (string.equals("localhost")) {
            this.stopServer(slaveJvmVersion, derbySlaveVersion, string, n);
        } else {
            int n2 = this.xFindServerPID(string, n);
            this.xStopServer(string, n2);
        }
    }

    void destroySlaveDB(String string) throws InterruptedException {
        this.removeSlaveDBfiles(string, replicatedDb);
    }

    void stopServer(String string, String string2, String string3, int n) {
        this.util.DEBUG("");
        String string4 = "stopServer@" + string3 + ":" + n + " ";
        this.util.DEBUG("+++ stopServer " + string + " / " + string2 + " " + string4);
        String string5 = ReplicationRun.getServerJavaExecutableName(string3, string);
        String string6 = string2 + FS + "derby.jar" + PS + string2 + FS + "derbynet.jar";
        boolean bl = !string3.equals("localhost");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add(string5);
            arrayList.add("-cp");
            arrayList.add(string6);
        }
        arrayList.add("-Dderby.infolog.append=true");
        if (JVMInfo.isModuleAware()) {
            arrayList.add("-m");
            arrayList.add("org.apache.derby.server/org.apache.derby.drda.NetworkServerControl");
        } else {
            arrayList.add(networkServerControl);
        }
        arrayList.add("shutdown");
        arrayList.add("-h");
        arrayList.add(string3);
        arrayList.add("-p");
        arrayList.add(String.valueOf(n));
        if (this.db_uid != null) {
            arrayList.add("-user");
            arrayList.add(this.db_uid);
            arrayList.add("-password");
            arrayList.add(this.db_passwd);
        }
        String[] stringArray = this.util.toStringArray(arrayList);
        String string7 = this.util.splice(stringArray, ' ');
        this.util.DEBUG(string4 + "commandElements: " + string7);
        boolean bl2 = string3.equalsIgnoreCase("localhost");
        if (bl2) {
            this.util.DEBUG(string4 + "Stopping server on localhost " + string3);
            this.runUserCommandLocally(stringArray, string4, null);
        } else {
            this.util.DEBUG(string4 + "Stopping server on non-local host " + string3);
            this.runUserCommandRemotely(string7, string3, testUser, string4);
        }
        this.util.DEBUG(string4 + "--- stopServer ");
        this.util.DEBUG("");
    }

    private String processOutput(String string, Process process) throws Exception {
        InputStream inputStream = process.getInputStream();
        InputStream inputStream2 = process.getErrorStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        InputStreamReader inputStreamReader2 = new InputStreamReader(inputStream2);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        BufferedReader bufferedReader2 = new BufferedReader(inputStreamReader2);
        String string2 = null;
        String string3 = null;
        this.util.DEBUG(string + "---- out:");
        while ((string2 = bufferedReader.readLine()) != null) {
            this.util.DEBUG(string + string2);
            string3 = string3 + LF + string2;
        }
        this.util.DEBUG(string + "---- err:");
        while ((string2 = bufferedReader2.readLine()) != null) {
            this.util.DEBUG(string + string2);
            string3 = string3 + LF + string2;
        }
        this.util.DEBUG(string + "----     ");
        return string3;
    }

    private void processDEBUGOutput(String string, Process process) throws Exception {
        InputStream inputStream = process.getInputStream();
        InputStream inputStream2 = process.getErrorStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        InputStreamReader inputStreamReader2 = new InputStreamReader(inputStream2);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        BufferedReader bufferedReader2 = new BufferedReader(inputStreamReader2);
        String string2 = null;
        this.util.DEBUG(string + "---- out:");
        while ((string2 = bufferedReader.readLine()) != null) {
            this.util.DEBUG(string + string2);
        }
        this.util.DEBUG(string + "---- err:");
        while ((string2 = bufferedReader2.readLine()) != null) {
            this.util.DEBUG(string + string2);
        }
        this.util.DEBUG(string + "----     ");
        int n = process.waitFor();
        this.util.DEBUG(string + "process exit status: " + n);
    }

    private void registerThread(Thread thread) {
        this.helperThreads.add(thread);
    }

    private void pingServer(String string, int n) throws Exception {
        this.util.DEBUG("+++ pingServer: " + string + ":" + n);
        NetworkServerControl networkServerControl = new NetworkServerControl(InetAddress.getByName(string), n);
        ReplicationRun.assertTrue((String)"Server did not start in time", (boolean)NetworkServerTestSetup.pingForServerStart(networkServerControl));
        this.util.DEBUG("--- pingServer: " + string + ":" + n);
    }

    void startOptionalLoad(Load load, String string, String string2, int n) throws Exception {
        String string3 = load.load;
        String string4 = load.database;
        boolean bl = load.existingDB;
        String string5 = load.clientHost;
        this.util.DEBUG("run load " + string3 + " on client " + string5 + " against server " + string2 + ":" + n + " using DB  " + string4 + "[" + bl + "]");
        if (string3 == null) {
            this.util.DEBUG("No load supplied!");
            return;
        }
        if (!bl) {
            String string6 = this.masterURL(string4) + ";create=true";
            Object object = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbyTesting.jar" + PS + derbyVersion + FS + "derbytools.jar";
            if (string2.equals("localhost")) {
                object = this.classPath;
            }
            String string7 = ReplicationRun.getClientJavaExecutableName();
            String string8 = "rm -rf /" + this.masterDbPath(string4) + ";" + string7 + " -Dij.driver=org.apache.derby.jdbc.ClientDriver -Dij.connection.create" + string4 + "=\"" + string6 + "\" -classpath " + (String)object + " org.apache.derby.tools.ij " + sqlLoadInit;
            String string9 = this.runUserCommandRemotely(string8, string5, testUser, "Create_" + string4);
        }
        this.runLoad(string3, jvmVersion, string5, string2, n, string + FS + string4);
    }

    void makeReadyForReplication() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, ALL_INTERFACES, masterServerPort, masterDbSubPath);
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, ALL_INTERFACES, slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
    }

    void cleanAllTestHosts() {
        this.util.DEBUG("************************** cleanAllTestHosts() Not yet implemented");
    }

    protected void assertSqlStateSlaveConn(String string) throws Exception {
        boolean bl = false;
        for (int i = 0; i < 10; ++i) {
            if (this.startSlaveException != null) {
                if (this.startSlaveException instanceof SQLException) {
                    BaseJDBCTestCase.assertSQLState("Unexpexted SQL State", string, (SQLException)this.startSlaveException);
                    bl = true;
                    break;
                }
                throw this.startSlaveException;
            }
            Thread.sleep(500L);
        }
        if (!bl) {
            ReplicationRun.fail((String)("Attempt to start slave hangs. Expected SQL state " + string));
        }
    }

    void assertException(SQLException sQLException, String string) {
        if (sQLException == null) {
            this.util.DEBUG("Got 'null' exception, expected '" + string + "'");
            ReplicationRun.assertTrue((String)("Expected exception: " + string + " got: 'null' exception"), (string == null ? 1 : 0) != 0);
            return;
        }
        int n = sQLException.getErrorCode();
        String string2 = sQLException.getSQLState();
        String string3 = "Got " + n + " " + string2 + " " + sQLException.getMessage() + ". Expected " + string;
        this.util.DEBUG(string3);
        if (string != null) {
            ReplicationRun.assertTrue((String)string3, (boolean)string2.equals(string));
        } else {
            ReplicationRun.assertTrue((String)string3, (boolean)false);
        }
    }

    void _testInsertUpdateDeleteOnMaster(String string, int n, String string2, int n2) throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        this.util.DEBUG("_testInsertUpdateDeleteOnMaster: " + string + ":" + n + "/" + string2 + " " + n2);
        ClientDataSourceInterface clientDataSourceInterface = this.configureDataSource(string2, string, n, this.useEncryption(false));
        Connection connection = clientDataSourceInterface.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("create table t(i integer primary key, s varchar(64))");
        preparedStatement.execute();
        preparedStatement = connection.prepareStatement("insert into t values (?,?)");
        for (int i = 0; i < n2; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, "dilldall" + i);
            preparedStatement.execute();
            if (i % 10000 != 0) continue;
            connection.commit();
        }
        this._verify(connection, n2);
        connection.close();
    }

    void _verifyDatabase(String string, int n, String string2, int n2) throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        this.util.DEBUG("_verifyDatabase: " + string + ":" + n + "/" + string2);
        ClientDataSourceInterface clientDataSourceInterface = this.configureDataSource(string2, string, n, this.useEncryption(false));
        Connection connection = clientDataSourceInterface.getConnection();
        this._verify(connection, n2);
        connection.close();
    }

    void _verify(Connection connection, int n) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select count(*) from t");
        resultSet.next();
        int n2 = resultSet.getInt(1);
        resultSet = statement.executeQuery("select max(i) from t");
        resultSet.next();
        int n3 = resultSet.getInt(1);
        this.util.DEBUG("_verify: " + n2 + "/" + n + " " + n3 + "/" + (n - 1));
        ReplicationRun.assertEquals((String)("Expected " + n + " tuples, got " + n2 + "."), (int)n, (int)n2);
        ReplicationRun.assertEquals((String)("Expected " + (n - 1) + " max, got " + n3 + "."), (int)(n - 1), (int)n3);
    }

    Connection getConnection(String string, int n, String string2, String string3, String string4) throws SQLException {
        String string5 = string2 + FS + string3 + FS + string4;
        String string6 = this.serverURL(string5, string, n);
        this.util.DEBUG(string6);
        return DriverManager.getConnection(string6);
    }

    String masterDbPath(String string) {
        return masterDatabasePath + FS + masterDbSubPath + FS + string;
    }

    String slaveDbPath(String string) {
        return slaveDatabasePath + FS + slaveDbSubPath + FS + string;
    }

    String masterURL(String string) {
        return this.serverURL(this.masterDbPath(string), masterServerHost, masterServerPort);
    }

    String masterLoadURL(String string) {
        return this.serverURL(masterDatabasePath + FS + string, masterServerHost, masterServerPort);
    }

    String slaveURL(String string) {
        return this.serverURL(this.slaveDbPath(string), slaveServerHost, slaveServerPort);
    }

    String serverURL(String string, String string2, int n) {
        return "jdbc:derby://" + string2 + ":" + n + "/" + string + this.useEncryption(false) + this.credentials();
    }

    String credentials() {
        if (this.db_uid == null) {
            return "";
        }
        return ";user=" + this.db_uid + ";password=" + this.db_passwd;
    }

    SQLException stopSlave(String string, int n, String string2, String string3, boolean bl) throws Exception {
        return this.stopSlave(string, n, string2, slaveDbSubPath, string3, bl);
    }

    SQLException stopSlave(String string, int n, String string2, String string3, String string4, boolean bl) throws Exception {
        this.util.DEBUG("stopSlave");
        String string5 = string2 + FS + string3 + FS + string4;
        String string6 = this.serverURL(string5, string, n) + ";stopSlave=true";
        if (bl) {
            try {
                Connection connection = DriverManager.getConnection(string6);
                connection.close();
                return null;
            }
            catch (SQLException sQLException) {
                return sQLException;
            }
        }
        SQLException sQLException = null;
        int n2 = 20;
        while (n2-- > 0) {
            sQLException = null;
            try {
                DriverManager.getConnection(string6);
                ReplicationRun.fail((String)"Unexpectedly connected");
            }
            catch (SQLException sQLException2) {
                if (sQLException2.getSQLState().equals(SLAVE_OPERATION_DENIED_WHILE_CONNECTED)) {
                    sQLException = sQLException2;
                    this.util.DEBUG("got SLAVE_OPERATION_DENIED_WHILE_CONNECTED, sleep");
                    Thread.sleep(1000L);
                    continue;
                }
                if (sQLException2.getSQLState().equals(REPLICATION_SLAVE_SHUTDOWN_OK)) {
                    sQLException = sQLException2;
                    this.util.DEBUG("got REPLICATION_SLAVE_SHUTDOWN_OK, sleep..");
                    Thread.sleep(1000L);
                    continue;
                }
                if (sQLException2.getSQLState().equals(REPLICATION_DB_NOT_BOOTED)) {
                    this.util.DEBUG("Got REPLICATION_DB_NOT_BOOTED as expected");
                    break;
                }
                sQLException = sQLException2;
                break;
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
        return null;
    }

    private static String getMasterJavaExecutableName() {
        if (masterServerHost.matches("localhost")) {
            return BaseTestCase.getJavaExecutableName();
        }
        return masterJvmVersion + FS + ".." + FS + "bin" + FS + "java";
    }

    private static String getSlaveJavaExecutableName() {
        if (slaveServerHost.matches("localhost")) {
            return BaseTestCase.getJavaExecutableName();
        }
        return slaveJvmVersion + FS + ".." + FS + "bin" + FS + "java";
    }

    private static String getClientJavaExecutableName() {
        if (testClientHost.matches("localhost")) {
            return BaseTestCase.getJavaExecutableName();
        }
        return jvmVersion + FS + ".." + FS + "bin" + FS + "java";
    }

    private static String getServerJavaExecutableName(String string, String string2) {
        if (string.matches("localhost")) {
            return BaseTestCase.getJavaExecutableName();
        }
        return string2 + FS + ".." + FS + "bin" + FS + "java";
    }

    ClientDataSourceInterface configureDataSource(String string, String string2, int n, String string3) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ClientDataSourceInterface clientDataSourceInterface;
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientDataSource40");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        clientDataSourceInterface.setDatabaseName(string);
        clientDataSourceInterface.setServerName(string2);
        clientDataSourceInterface.setPortNumber(n);
        clientDataSourceInterface.setConnectionAttributes(string3);
        if (this.db_uid != null) {
            clientDataSourceInterface.setUser(this.db_uid);
            clientDataSourceInterface.setPassword(this.db_passwd);
        }
        return clientDataSourceInterface;
    }

    class State {
        String testPreStartedMasterServer = null;
        boolean testPreStartedMasterServerReturn = false;
        String testPreStartedSlaveServer = null;
        boolean testPreStartedSlaveServerReturn = false;
        String testPreStartedMaster = null;
        boolean testPreStartedMasterReturn = false;
        String testPreInitSlave = null;
        boolean testPreInitSlaveReturn = false;
        String testPreStartedSlave = null;
        boolean testPreStartedSlaveReturn = false;
        String testPostStartedMasterAndSlave = null;
        boolean testPostStartedMasterAndSlaveReturn = false;
        String testPreStoppedMaster = null;
        boolean testPreStoppedMasterReturn = false;
        String testPreStoppedMasterServer = null;
        boolean testPreStoppedMasterServerReturn = false;
        String testPreStoppedSlave = null;
        boolean testPreStoppedSlaveReturn = false;
        String testPreStoppedSlaveServer = null;
        boolean testPreStoppedSlaveServerReturn = false;
        String testPostStoppedSlave = null;
        boolean testPostStoppedSlaveReturn = false;
        String testPostStoppedSlaveServer = null;
        boolean testPostStoppedSlaveServerReturn = false;

        State() {
        }

        void initEnvironment(Properties properties) {
            this.testPreStartedMasterServer = properties.getProperty("test.PreStartedMasterServer", null);
            this.testPreStartedMasterServerReturn = properties.getProperty("test.PreStartedMasterServer.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStartedMasterServer:" + this.testPreStartedMasterServer + FS + this.testPreStartedMasterServerReturn);
            this.testPreStartedSlaveServer = properties.getProperty("test.PreStartedSlaveServer", null);
            this.testPreStartedSlaveServerReturn = properties.getProperty("test.PreStartedSlaveServer.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStartedSlaveServer:" + this.testPreStartedSlaveServer + FS + this.testPreStartedSlaveServerReturn);
            this.testPreInitSlave = properties.getProperty("test.PreInitSlave", null);
            this.testPreInitSlaveReturn = properties.getProperty("test.PreInitSlave.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreInitSlave:" + this.testPreInitSlave + FS + this.testPreInitSlaveReturn);
            this.testPreStartedMaster = properties.getProperty("test.PreStartedMaster", null);
            this.testPreStartedMasterReturn = properties.getProperty("test.PreStartedMaster.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStartedMaster:" + this.testPreStartedMaster + FS + this.testPreStartedMasterReturn);
            this.testPreStartedSlave = properties.getProperty("test.PreStartedSlave", null);
            this.testPreStartedSlaveReturn = properties.getProperty("test.PreStartedSlave.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStartedSlave:" + this.testPreStartedSlave + FS + this.testPreStartedSlaveReturn);
            this.testPostStartedMasterAndSlave = properties.getProperty("test.PostStartedMasterAndSlave", null);
            this.testPostStartedMasterAndSlaveReturn = properties.getProperty("test.PostStartedMasterAndSlave.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPostStartedMasterAndSlave:" + this.testPostStartedMasterAndSlave + FS + this.testPostStartedMasterAndSlaveReturn);
            this.testPreStoppedMaster = properties.getProperty("test.PreStoppedMaster", null);
            this.testPreStoppedMasterReturn = properties.getProperty("test.PreStoppedMaster.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStoppedMaster:" + this.testPreStoppedMaster + FS + this.testPreStoppedMasterReturn);
            this.testPreStoppedMasterServer = properties.getProperty("test.PreStoppedMasterServer", null);
            this.testPreStoppedMasterServerReturn = properties.getProperty("test.PreStoppedMasterServer.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStoppedMasterServer:" + this.testPreStoppedMasterServer + FS + this.testPreStoppedMasterServerReturn);
            this.testPreStoppedSlave = properties.getProperty("test.PreStoppedSlave", null);
            this.testPreStoppedSlaveReturn = properties.getProperty("test.PreStoppedSlave.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStoppedSlave:" + this.testPreStoppedSlave + FS + this.testPreStoppedSlaveReturn);
            this.testPostStoppedSlave = properties.getProperty("test.PostStoppedSlave", null);
            this.testPostStoppedSlaveReturn = properties.getProperty("test.PostStoppedSlave.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPostStoppedSlave:" + this.testPostStoppedSlave + FS + this.testPostStoppedSlaveReturn);
            this.testPostStoppedSlaveServer = properties.getProperty("test.PostStoppedSlaveServer", null);
            this.testPostStoppedSlaveServerReturn = properties.getProperty("test.PostStoppedSlaveServer.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPostStoppedSlaveServer:" + this.testPostStoppedSlaveServer + FS + this.testPostStoppedSlaveServerReturn);
        }

        boolean testPreStartedMasterServer() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStartedMasterServer");
            if (this.testPreStartedMasterServer != null) {
                ReplicationRun.this.runStateTest(this.testPreStartedMasterServer, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStartedMasterServerReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStartedMasterServer");
            return this.testPreStartedMasterServerReturn;
        }

        boolean testPreStartedSlaveServer() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStartedSlaveServer");
            if (this.testPreStartedSlaveServer != null) {
                ReplicationRun.this.runStateTest(this.testPreStartedSlaveServer, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStartedSlaveServerReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStartedSlaveServer");
            return this.testPreStartedSlaveServerReturn;
        }

        boolean testPreStartedMaster() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStartedMaster");
            if (this.testPreStartedMaster != null) {
                ReplicationRun.this.runStateTest(this.testPreStartedMaster, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStartedMasterReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStartedMaster");
            return this.testPreStartedMasterReturn;
        }

        boolean testPreInitSlave() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreInitSlave");
            if (this.testPreInitSlave != null) {
                ReplicationRun.this.runStateTest(this.testPreInitSlave, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreInitSlaveReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreInitSlave");
            return this.testPreInitSlaveReturn;
        }

        boolean testPreStartedSlave() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStartedSlave");
            if (this.testPreStartedSlave != null) {
                ReplicationRun.this.runStateTest(this.testPreStartedSlave, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStartedSlaveReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStartedSlave");
            return this.testPreStartedSlaveReturn;
        }

        boolean testPostStartedMasterAndSlave() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPostStartedMasterAndSlave");
            if (this.testPostStartedMasterAndSlave != null) {
                ReplicationRun.this.runStateTest(this.testPostStartedMasterAndSlave, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPostStartedMasterAndSlaveReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPostStartedMasterAndSlave");
            return this.testPostStartedMasterAndSlaveReturn;
        }

        boolean testPreStoppedMaster() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStoppedMaster");
            if (this.testPreStoppedMaster != null) {
                ReplicationRun.this.runStateTest(this.testPreStoppedMaster, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStoppedMasterReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStoppedMaster");
            return this.testPreStoppedMasterReturn;
        }

        boolean testPreStoppedMasterServer() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStoppedMasterServer");
            if (this.testPreStoppedMasterServer != null) {
                ReplicationRun.this.runStateTest(this.testPreStoppedMasterServer, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStoppedMasterServerReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStoppedMasterServer");
            return this.testPreStoppedMasterServerReturn;
        }

        boolean testPreStoppedSlave() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStoppedSlave");
            if (this.testPreStoppedSlave != null) {
                ReplicationRun.this.runStateTest(this.testPreStoppedSlave, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStoppedSlaveReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStoppedSlave");
            return this.testPreStoppedSlaveReturn;
        }

        boolean testPreStoppedSlaveServer() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStoppedSlaveServer");
            if (this.testPreStoppedSlaveServer != null) {
                ReplicationRun.this.runStateTest(this.testPreStoppedSlaveServer, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStoppedSlaveServerReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStoppedSlaveServer");
            return this.testPreStoppedSlaveServerReturn;
        }

        boolean testPostStoppedSlaveServer() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPostStoppedSlaveServer");
            if (this.testPostStoppedSlaveServer != null) {
                ReplicationRun.this.runStateTest(this.testPostStoppedSlaveServer, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPostStoppedSlaveServerReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPostStoppedSlaveServer");
            return this.testPostStoppedSlaveServerReturn;
        }

        private void cleanupAndShutdown() {
            ReplicationRun.this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
            ReplicationRun.this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        }
    }

    class Load {
        String load = null;
        String database = null;
        boolean existingDB = false;
        String clientHost = null;

        Load(String string, Properties properties) {
            ReplicationRun.this.util.DEBUG("Load(): " + string);
            String string2 = "test." + string;
            if (properties.getProperty(string2, "false").equalsIgnoreCase("false")) {
                ReplicationRun.this.util.DEBUG(string2 + " Not defined or set to false!");
            } else {
                string2 = "test." + string + ".load";
                this.load = properties.getProperty(string2, "org.apache.derbyTesting.functionTests.tests.replicationTests.DefaultLoad");
                ReplicationRun.this.util.DEBUG(string2 + ": " + this.load);
                string2 = "test." + string + ".database";
                this.database = properties.getProperty(string2, string);
                ReplicationRun.this.util.DEBUG(string2 + ": " + this.database);
                string2 = "test." + string + ".existingDB";
                this.existingDB = properties.getProperty(string2, "false").equalsIgnoreCase("true");
                ReplicationRun.this.util.DEBUG(string2 + ": " + this.existingDB);
                string2 = "test." + string + ".clientHost";
                this.clientHost = properties.getProperty(string2, testClientHost);
                ReplicationRun.this.util.DEBUG(string2 + ": " + this.clientHost);
            }
        }
    }
}

