/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;

public class DeadlockWatchdog
implements Runnable {
    private boolean stopped = false;
    private long timeout;

    public DeadlockWatchdog(long l) {
        this.timeout = l;
    }

    public synchronized void start() {
        this.stopped = false;
        Thread thread = new Thread((Runnable)this, "WATCHDOG");
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    @Override
    public synchronized void run() {
        long l;
        long l2 = System.currentTimeMillis() + this.timeout;
        while (!this.stopped && l2 > (l = System.currentTimeMillis())) {
            try {
                this.wait(l2 - l);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.stopped) {
            try {
                boolean bl = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws IOException, MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException {
                        return DeadlockWatchdog.this.checkForDeadlock();
                    }
                });
                if (bl) {
                    System.err.println("Deadlock detected");
                    System.exit(1);
                }
            }
            catch (Exception exception) {
                System.err.println("Watchdog failed: " + exception.toString());
                System.exit(1);
            }
        }
    }

    boolean checkForDeadlock() throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] lArray = threadMXBean.findDeadlockedThreads();
        return null != lArray && 0 != lArray.length;
    }
}

