/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InterruptResilienceTest
extends BaseJDBCTestCase {
    private static volatile TestConfiguration thisConf;
    static int NO_OF_THREADS;
    static long NO_OF_MT_OPS;
    private static int threadNo;
    static volatile boolean allDone;

    public InterruptResilienceTest(String string) {
        super(string);
    }

    protected static Test makeSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        Test test = TestConfiguration.embeddedSuite(InterruptResilienceTest.class);
        Test test2 = TestConfiguration.clientServerSuite(InterruptResilienceTest.class);
        test = TestConfiguration.singleUseDatabaseDecorator(test);
        test2 = TestConfiguration.singleUseDatabaseDecorator(test2);
        Properties properties = new Properties();
        properties.put("derby.system.durability", "test");
        properties.put("derby.infolog.append", "true");
        properties.put("derby.stream.error.extendedDiagSeverityLevel", "50000");
        baseTestSuite.addTest((Test)new SystemPropertyTestSetup(test, properties, true));
        baseTestSuite.addTest((Test)new SystemPropertyTestSetup(test2, properties, true));
        return baseTestSuite;
    }

    public static Test suite() {
        String string = "InterruptResilienceTest";
        if (InterruptResilienceTest.isIBMJVM() && InterruptResilienceTest.getSystemProperty("java.version").startsWith("1.4.2")) {
            InterruptResilienceTest.println("InterruptResilienceTest skipped for this VM, cf. DERBY-5074/5109");
            return new BaseTestSuite(string);
        }
        if (!JDBC.vmSupportsJDBC3()) {
            InterruptResilienceTest.println("Test skipped for this VM, DriverManager is not supported with JSR169");
            return new BaseTestSuite(string);
        }
        if (InterruptResilienceTest.hasInterruptibleIO()) {
            InterruptResilienceTest.println("Test skipped due to interruptible IO.");
            InterruptResilienceTest.println("This is default on Solaris/Sun Java <= 1.6, use -XX:-UseVMInterruptibleIO if available.");
            return new BaseTestSuite(string);
        }
        return InterruptResilienceTest.makeSuite(string);
    }

    protected void setUp() throws Exception {
        Object object;
        try {
            object = Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            ((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setUp();
        object = this.createStatement();
        object.executeUpdate("create table t1(x int primary key)");
        object.executeUpdate("create table mtTab(i bigint, inserter varchar(40), primary key(i, inserter))");
        object.close();
        thisConf = TestConfiguration.getCurrent();
        threadNo = 0;
        DriverManager.setLoginTimeout(1000);
        allDone = false;
    }

    @Override
    protected void tearDown() throws Exception {
        DriverManager.setLoginTimeout(0);
        this.rollback();
        this.dropTable("t1");
        this.dropTable("mtTab");
        this.commit();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tstRAFwriteInterrupted() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = null;
        long l = 0L;
        long l2 = 0L;
        try {
            preparedStatement = connection.prepareStatement("insert into t1 values (?)");
            for (int i = 0; i < 100000; ++i) {
                if (i % 1000 == 0) {
                    connection.commit();
                }
                Thread.currentThread().interrupt();
                preparedStatement.setLong(1, i);
                preparedStatement.executeUpdate();
                InterruptResilienceTest.assertTrue((String)"interrupt flag lost", (boolean)Thread.interrupted());
            }
        }
        finally {
            Thread.interrupted();
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            connection.close();
        }
    }

    public void testRAFWriteInterrupted() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create procedure tstRAFWriteInterrupted () modifies sql data external name 'org.apache.derbyTesting.functionTests.tests.store.InterruptResilienceTest.tstRAFwriteInterrupted' language java parameter style java");
        statement.executeUpdate("call tstRAFWriteInterrupted()");
    }

    public static void tstRAFReadWriteMultipleThreads() throws Exception {
        WorkerThread workerThread;
        int n;
        Object object;
        int n2;
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        ArrayList<WorkerThread> arrayList = new ArrayList<WorkerThread>();
        ArrayList<InterruptorThread> arrayList2 = new ArrayList<InterruptorThread>();
        for (n2 = 0; n2 < NO_OF_THREADS; ++n2) {
            object = new WorkerThread(thisConf.openDefaultConnection(), false, NO_OF_MT_OPS);
            arrayList.add((WorkerThread)object);
            ((Thread)object).start();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            InterruptorThread interruptorThread = new InterruptorThread((WorkerThread)object, 500);
            arrayList2.add(interruptorThread);
            interruptorThread.start();
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object = (WorkerThread)arrayList.get(n2);
            ((Thread)object).join();
            if (((WorkerThread)object).e == null) continue;
            InterruptResilienceTest.fail("WorkerThread " + n2, ((WorkerThread)object).e);
        }
        allDone = true;
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            ((InterruptorThread)arrayList2.get(n2)).join();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Statement statement = connection.createStatement();
        object = statement.executeQuery("select count(*) from mtTab");
        JDBC.assertSingleValueResultSet((ResultSet)object, Long.toString((long)NO_OF_THREADS * NO_OF_MT_OPS));
        allDone = false;
        threadNo = 0;
        arrayList.clear();
        arrayList2.clear();
        for (n = 0; n < NO_OF_THREADS; ++n) {
            workerThread = new WorkerThread(thisConf.openDefaultConnection(), true, NO_OF_MT_OPS);
            arrayList.add(workerThread);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            InterruptorThread interruptorThread = new InterruptorThread(workerThread, 500);
            arrayList2.add(interruptorThread);
            interruptorThread.start();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ((WorkerThread)arrayList.get(n)).start();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            workerThread = (WorkerThread)arrayList.get(n);
            workerThread.join();
            if (workerThread.e == null) continue;
            InterruptResilienceTest.fail("WorkerThread " + n, workerThread.e);
        }
        allDone = true;
        for (n = 0; n < arrayList2.size(); ++n) {
            ((InterruptorThread)arrayList2.get(n)).join();
        }
        connection.close();
    }

    static synchronized int getThreadNo() {
        return ++threadNo;
    }

    private static long randAbs(long l) {
        if (l == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        return Math.abs(l);
    }

    public void testRAFReadWriteMultipleThreads() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create procedure tstRAFReadWriteMultipleThreads () modifies sql data external name 'org.apache.derbyTesting.functionTests.tests.store.InterruptResilienceTest.tstRAFReadWriteMultipleThreads' language java parameter style java");
        statement.executeUpdate("call tstRAFReadWriteMultipleThreads()");
    }

    public static void tstInterruptLongQuery() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        try {
            Thread.currentThread().interrupt();
            ResultSet resultSet = statement.executeQuery("select * from sys.syscolumns");
            while (resultSet.next()) {
            }
            InterruptResilienceTest.fail((String)"expected CONN_INTERRUPT");
        }
        catch (SQLException sQLException) {
            InterruptResilienceTest.assertSQLState("expected CONN_INTERRUPT", "08000", sQLException);
            InterruptResilienceTest.assertTrue((boolean)Thread.interrupted());
        }
    }

    public void testLongQueryInterrupt() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.executeUpdate("create procedure tstInterruptLongQuery() reads sql data external name 'org.apache.derbyTesting.functionTests.tests.store.InterruptResilienceTest.tstInterruptLongQuery' language java parameter style java");
        try {
            statement.executeUpdate("call tstInterruptLongQuery()");
            InterruptResilienceTest.fail((String)"expected 40XC0 exception");
        }
        catch (SQLException sQLException) {
            InterruptResilienceTest.assertSQLState("expected 40XC0", "40XC0", sQLException);
            InterruptResilienceTest.assertTrue((boolean)connection.isClosed());
        }
    }

    public static void tstInterruptBatch() throws Exception {
        int n;
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table tmp(i int)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into tmp values (?)");
        for (n = 0; n < 10; ++n) {
            statement.addBatch("insert into tmp values (" + n + ")");
        }
        statement.executeBatch();
        for (n = 0; n < 10; ++n) {
            statement.addBatch("insert into tmp values (" + n + ")");
        }
        try {
            Thread.currentThread().interrupt();
            statement.executeBatch();
            InterruptResilienceTest.fail((String)"expected CONN_INTERRUPT");
        }
        catch (SQLException sQLException) {
            InterruptResilienceTest.assertSQLState("expected CONN_INTERRUPT", "08000", sQLException);
            InterruptResilienceTest.assertTrue((boolean)Thread.interrupted());
        }
    }

    public void testInterruptBatch() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create procedure tstInterruptBatch() modifies sql data external name 'org.apache.derbyTesting.functionTests.tests.store.InterruptResilienceTest.tstInterruptBatch' language java parameter style java");
        try {
            statement.executeUpdate("call tstInterruptBatch()");
            InterruptResilienceTest.fail((String)"expected 40XC0 exception");
        }
        catch (SQLException sQLException) {
            InterruptResilienceTest.assertSQLState("expected 40XC0", "40XC0", sQLException);
            InterruptResilienceTest.assertTrue((boolean)connection.isClosed());
        }
        this.setAutoCommit(false);
        statement = this.createStatement();
        statement.executeUpdate("create table tmp(i int)");
        this.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterruptShutdown() throws SQLException {
        if (!InterruptResilienceTest.usingEmbedded()) {
            return;
        }
        this.setAutoCommit(false);
        try {
            Statement statement = this.createStatement();
            statement.executeUpdate("create table foo (i int)");
            PreparedStatement preparedStatement = this.prepareStatement("insert into foo values ?");
            for (int i = 0; i < 1000; ++i) {
                preparedStatement.setInt(1, i);
                preparedStatement.executeUpdate();
            }
            Thread.currentThread().interrupt();
            TestConfiguration.getCurrent().shutdownDatabase();
            InterruptResilienceTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    public void testCreateDropInterrupted() throws SQLException {
        if (!InterruptResilienceTest.usingEmbedded()) {
            return;
        }
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        try {
            Thread.currentThread().interrupt();
            statement.executeUpdate("create table foo (i int)");
            statement.executeUpdate("insert into foo values 1");
            statement.executeUpdate("drop table foo");
            InterruptResilienceTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    static {
        NO_OF_THREADS = 3;
        NO_OF_MT_OPS = 10000L;
    }

    static class WorkerThread
    extends Thread {
        private final boolean readertest;
        private final long noOps;
        public Throwable e;
        private Connection c;

        public WorkerThread(Connection connection, boolean bl, long l) {
            this.readertest = bl;
            this.noOps = l;
            this.c = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = InterruptResilienceTest.getThreadNo();
            int n2 = 0;
            this.setName("WorkerThread. Thread#" + n);
            BaseTestCase.println("Running " + this.getName());
            try {
                this.c.setAutoCommit(false);
                String string = this.readertest ? "select * from mtTab where i=?" : "insert into mtTab values (?,?)";
                PreparedStatement preparedStatement = this.c.prepareStatement(string);
                Random random = new Random();
                int n3 = 0;
                for (long i = 0L; i < this.noOps + (long)n3; ++i) {
                    if (this.readertest) {
                        long l = InterruptResilienceTest.randAbs(random.nextLong()) % this.noOps;
                        preparedStatement.setLong(1, l);
                        try {
                            ResultSet resultSet = preparedStatement.executeQuery();
                            resultSet.next();
                            if (WorkerThread.interrupted()) {
                                ++n2;
                            }
                            Assert.assertEquals((String)"wrong row content", (long)l, (long)resultSet.getLong(1));
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {
                            if ("08000".equals(sQLException.getSQLState())) {
                                this.c = thisConf.openDefaultConnection();
                                preparedStatement = this.c.prepareStatement(string);
                                Assert.assertTrue((boolean)WorkerThread.interrupted());
                                ++n2;
                                ++n3;
                                continue;
                            }
                            BaseTestCase.fail("expected 08000", sQLException);
                        }
                        this.c.commit();
                        if (!WorkerThread.interrupted()) continue;
                        ++n2;
                        continue;
                    }
                    preparedStatement.setLong(1, i);
                    preparedStatement.setString(2, this.getName());
                    try {
                        preparedStatement.executeUpdate();
                    }
                    catch (SQLException sQLException) {
                        if ("08000".equals(sQLException.getSQLState())) {
                            this.c = thisConf.openDefaultConnection();
                            preparedStatement = this.c.prepareStatement(string);
                            Assert.assertTrue((boolean)WorkerThread.interrupted());
                            ++n2;
                            ++n3;
                            continue;
                        }
                        BaseTestCase.fail("expected 08000", sQLException);
                    }
                    if (WorkerThread.interrupted()) {
                        ++n2;
                    }
                    this.c.commit();
                    if (!WorkerThread.interrupted()) continue;
                    ++n2;
                }
                preparedStatement.close();
            }
            catch (Throwable throwable) {
                this.e = throwable;
            }
            finally {
                try {
                    this.c.close();
                }
                catch (Exception exception) {}
            }
            BaseTestCase.println("Thread " + this.getName() + " saw " + n2 + " interrupts");
        }
    }

    static class InterruptorThread
    extends Thread {
        private WorkerThread myVictim;
        private int millisBetweenShots;

        public InterruptorThread(WorkerThread workerThread, int n) {
            this.myVictim = workerThread;
            this.millisBetweenShots = n;
        }

        @Override
        public void run() {
            this.setName("InterruptorThread. Thread #" + InterruptResilienceTest.getThreadNo());
            BaseTestCase.println("Running " + this.getName() + " with victim " + this.myVictim.getName());
            int n = 0;
            while (!allDone) {
                try {
                    Thread.sleep(this.millisBetweenShots);
                    this.myVictim.interrupt();
                    ++n;
                }
                catch (Exception exception) {}
            }
            BaseTestCase.println(this.getName() + " shot " + n + " interrupts at " + this.myVictim.getName());
        }
    }
}

