/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derby.jdbc.BasicClientDataSource40;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SimplePerfTest
extends BaseJDBCTestCase {
    private static String dbPath = "UNDEFINED!";
    private static String masterHostName = "UNDEFINED!";
    private static int masterPortNo = -1;
    private static int tuplesToInsert = 0;
    private static int commitFreq = 0;

    public SimplePerfTest(String string) {
        super(string);
    }

    public static Test suite() throws Exception {
        masterHostName = System.getProperty("test.serverHost", "localhost");
        masterPortNo = Integer.parseInt(System.getProperty("test.serverPort", "1527"));
        dbPath = System.getProperty("test.dbPath", "wombat");
        BaseTestSuite baseTestSuite = new BaseTestSuite("SimplePerfTest");
        tuplesToInsert = Integer.parseInt(System.getProperty("test.inserts", "1000"));
        commitFreq = Integer.parseInt(System.getProperty("test.commitFreq", "0"));
        baseTestSuite.addTest(SimplePerfTest.suite(masterHostName, masterPortNo, dbPath));
        return baseTestSuite;
    }

    public static Test suite(String string, int n, String string2) {
        Test test = TestConfiguration.existingServerSuite(SimplePerfTest.class, false, string, n, string2);
        return SecurityManagerSetup.noSecurityManager(test);
    }

    public void testInserts() throws SQLException, IOException, InterruptedException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Object object = "";
        for (int i = 0; i < 20000; ++i) {
            object = (String)object + "a";
        }
        Connection connection = this.clientConnection(masterHostName, masterPortNo, dbPath);
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("drop table t");
        }
        catch (SQLException sQLException) {
            System.out.println("'drop table t' caused: " + sQLException.getMessage());
        }
        statement.executeUpdate("create table t (i integer primary key, vc varchar(20100))");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t values (?,?)");
        connection.setAutoCommit(commitFreq == 0);
        for (int i = 0; i < tuplesToInsert; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, (String)object + i);
            try {
                preparedStatement.execute();
            }
            catch (Exception exception) {
                System.out.println("Exception when inserting: " + exception.getMessage());
                return;
            }
            if (commitFreq == 0 || i % commitFreq != 0) continue;
            System.out.println("i: " + i);
            connection.commit();
        }
        connection.commit();
        ResultSet resultSet = statement.executeQuery("select count(*) from t");
        resultSet.next();
        int n = resultSet.getInt(1);
        System.out.println("count: " + n);
    }

    public void verifyTestInserts() throws SQLException, IOException, InterruptedException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Connection connection = this.clientConnection(masterHostName, masterPortNo, dbPath);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select count(*) from t");
        resultSet.next();
        int n = resultSet.getInt(1);
    }

    private Connection clientConnection(String string, int n, String string2) throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        BasicClientDataSource40 basicClientDataSource40;
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            basicClientDataSource40 = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            basicClientDataSource40 = new BasicClientDataSource40();
        }
        basicClientDataSource40.setDatabaseName(string2);
        basicClientDataSource40.setServerName(string);
        basicClientDataSource40.setPortNumber(n);
        return basicClientDataSource40.getConnection();
    }
}

