/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public class XMLBindingTest
extends BaseJDBCTestCase {
    public XMLBindingTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("XML Binding Suite");
        if (XML.classpathMeetsXMLReqs()) {
            Object object = TestConfiguration.defaultSuite(XMLBindingTest.class, false);
            object = new XBindTestSetup((Test)object);
            object = new SupportFilesSetup((Test)object, new String[]{"functionTests/tests/lang/xmlTestFiles/personal.dtd"});
            object = SystemPropertyTestSetup.singleProperty(object, "javax.xml.accessExternalDTD", "file");
            baseTestSuite.addTest((Test)object);
        }
        return baseTestSuite;
    }

    public void testInvalidXMLBindings() throws Exception {
        this.assertCompileError("42Z70", "insert into xTable.t1(x) values (?)");
        this.assertCompileError("42Z70", "select XMLSERIALIZE(? AS CLOB) FROM XTABLE.T1");
        this.assertCompileError("42Z70", "select i from xTable.t1 where XMLEXISTS('//*' PASSING BY REF ?)");
        this.assertCompileError("42Z70", "select i from xTable.t1 where XMLQUERY('//*' PASSING BY REF ? EMPTY ON EMPTY) is not null");
        this.assertCompileError("42Z71", "select x from xTable.t1");
    }

    public void testXMLSerializeBinding() throws Exception {
        int[] nArray = new int[]{40228, 38712, 1948, 1942, 1967, 1709, 22, -1, -1};
        int n = 0;
        ResultSet resultSet = this.createStatement().executeQuery("select i, XMLSERIALIZE(X AS CLOB) FROM xTable.t1");
        while (resultSet.next()) {
            int n2;
            Reader reader = resultSet.getCharacterStream(2);
            if (!resultSet.wasNull()) {
                int n3 = reader.read();
                n2 = 0;
                while (n3 != -1) {
                    if ((char)n3 != '\r') {
                        ++n2;
                    }
                    n3 = reader.read();
                }
                reader.close();
            } else {
                n2 = -1;
            }
            XMLBindingTest.assertEquals((String)"Unexpected serialized character count:", (int)nArray[n], (int)n2);
            ++n;
        }
        XMLBindingTest.assertEquals((String)"Unexpected row count when serializing:", (int)nArray.length, (int)n);
    }

    public void testXMLExistsBinding() throws Exception {
        this.assertCompileError("42Z75", "select i from xTable.t1 where XMLEXISTS (? PASSING BY REF x)");
        this.existsQuery("//abb", 1);
        this.existsQuery("//d50", 1);
        this.existsQuery("//person/email", 4);
        this.existsQuery("/personnel", 5);
        this.existsQuery("//person/@id", 4);
        this.existsQuery("//person/@noteTwo", 1);
    }

    public void testXMLQueryBinding() throws Exception {
        this.assertCompileError("42Z75", "select i from xTable.t1 where XMLQUERY (? PASSING BY REF x EMPTY ON EMPTY) is not null");
    }

    private void existsQuery(String string, int n) throws Exception {
        ResultSet resultSet = this.createStatement().executeQuery("select i from xTable.t1 where xmlexists('" + string + "' passing by ref x)");
        JDBC.assertDrainResults(resultSet, n);
    }

    private static class XBindTestSetup
    extends BaseJDBCTestSetup {
        public XBindTestSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            String string = "xTable.t1";
            Connection connection = this.getConnection();
            connection.createStatement().execute("create table " + string + "(i int generated always as identity, x xml)");
            XML.insertFile(connection, string, "x", "wide40k.xml", 1);
            XML.insertFile(connection, string, "x", "deep40k.xml", 1);
            XML.insertFile(connection, string, "x", "xsdDoc.xml", 1);
            XML.insertDocWithDTD(connection, string, "x", "dtdDoc.xml", "personal.dtd", 1);
            XML.insertFile(connection, string, "x", "xsdDoc_invalid.xml", 1);
            XML.insertDocWithDTD(connection, string, "x", "dtdDoc_invalid.xml", "personal.dtd", 1);
            PreparedStatement preparedStatement = this.getConnection().prepareStatement("insert into xTable.t1(x) values (XMLPARSE (DOCUMENT CAST (? as CLOB) PRESERVE WHITESPACE))");
            preparedStatement.setString(1, "<simple> doc </simple>");
            preparedStatement.execute();
            preparedStatement.setString(1, null);
            preparedStatement.execute();
            preparedStatement.setNull(1, 2005);
            preparedStatement.execute();
            preparedStatement.close();
            connection = null;
        }

        @Override
        public void tearDown() throws Exception {
            this.getConnection().createStatement().execute("drop table xTable.t1");
            super.tearDown();
        }
    }
}

