/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.AuthenticationTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PoolDSAuthenticationTest
extends AuthenticationTest {
    public PoolDSAuthenticationTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("ConnectionPoolDataSource not available with JSR169; empty test");
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("PoolDSAuthenticationTest");
        baseTestSuite.addTest(PoolDSAuthenticationTest.baseSuite("PoolDSAuthenticationTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(PoolDSAuthenticationTest.baseSuite("PoolDSAuthenticationTest:client")));
        return baseTestSuite;
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("PoolDSAuthenticationTest");
        PoolDSAuthenticationTest poolDSAuthenticationTest = new PoolDSAuthenticationTest("testConnectShutdownAuthentication");
        PoolDSAuthenticationTest.setBaseProps(baseTestSuite, (Test)poolDSAuthenticationTest);
        poolDSAuthenticationTest = new PoolDSAuthenticationTest("testUserFunctions");
        PoolDSAuthenticationTest.setBaseProps(baseTestSuite, (Test)poolDSAuthenticationTest);
        poolDSAuthenticationTest = new PoolDSAuthenticationTest("testNotFullAccessUsers");
        PoolDSAuthenticationTest.setBaseProps(baseTestSuite, (Test)poolDSAuthenticationTest);
        poolDSAuthenticationTest = new PoolDSAuthenticationTest("testChangePasswordAndDatabasePropertiesOnly");
        PoolDSAuthenticationTest.setBaseProps(baseTestSuite, (Test)poolDSAuthenticationTest);
        poolDSAuthenticationTest = new PoolDSAuthenticationTest("testGreekCharacters");
        PoolDSAuthenticationTest.setBaseProps(baseTestSuite, (Test)poolDSAuthenticationTest);
        poolDSAuthenticationTest = new PoolDSAuthenticationTest("testSystemShutdown");
        PoolDSAuthenticationTest.setBaseProps(baseTestSuite, (Test)poolDSAuthenticationTest);
        return TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite);
    }

    @Override
    protected void assertConnectionOK(String string, String string2, String string3) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string);
        connectionPoolDataSource.getPooledConnection(string2, string3).close();
    }

    @Override
    protected void assertConnectionWOUPOK(String string, String string2, String string3) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "user", string2);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "password", string3);
        connectionPoolDataSource.getPooledConnection().close();
    }

    @Override
    protected void assertConnectionFail(String string, String string2, String string3, String string4) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string2);
        try {
            connectionPoolDataSource.getPooledConnection(string3, string4);
            PoolDSAuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException sQLException) {
            PoolDSAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    protected void assertConnectionWOUPFail(String string, String string2, String string3, String string4) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string2);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "user", string3);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "password", string4);
        try {
            connectionPoolDataSource.getPooledConnection();
            PoolDSAuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException sQLException) {
            PoolDSAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    protected void assertShutdownUsingSetShutdownOK(String string, String string2, String string3) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "shutdownDatabase", "shutdown");
        try {
            connectionPoolDataSource.getPooledConnection(string2, string3);
            PoolDSAuthenticationTest.fail((String)"expected a failed shutdown connection");
        }
        catch (SQLException sQLException) {
            PoolDSAuthenticationTest.assertSQLState("08006", sQLException);
        }
    }

    @Override
    protected void assertShutdownUsingConnAttrsOK(String string, String string2, String string3) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "connectionAttributes", "shutdown=true");
        try {
            connectionPoolDataSource.getPooledConnection(string2, string3);
            PoolDSAuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException sQLException) {
            PoolDSAuthenticationTest.assertSQLState("08006", sQLException);
        }
    }

    @Override
    protected void assertShutdownWOUPOK(String string, String string2, String string3) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "user", string2);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "password", string3);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "shutdownDatabase", "shutdown");
        try {
            connectionPoolDataSource.getPooledConnection();
            PoolDSAuthenticationTest.fail((String)"expected a failed shutdown connection");
        }
        catch (SQLException sQLException) {
            PoolDSAuthenticationTest.assertSQLState("08006", sQLException);
        }
    }

    @Override
    protected void assertShutdownFail(String string, String string2, String string3, String string4) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string2);
        try {
            connectionPoolDataSource.getPooledConnection(string3, string4);
            PoolDSAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException sQLException) {
            PoolDSAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    protected void assertShutdownWOUPFail(String string, String string2, String string3, String string4) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "user", string3);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "password", string4);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string2);
        try {
            connectionPoolDataSource.getPooledConnection();
            PoolDSAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException sQLException) {
            PoolDSAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    protected void assertSystemShutdownOK(String string, String string2, String string3) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.clearStringBeanProperty(connectionPoolDataSource, "databaseName");
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "user", string2);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "password", string3);
        try {
            connectionPoolDataSource.getPooledConnection();
            PoolDSAuthenticationTest.fail((String)"expected system shutdown resulting in XJ015 error");
        }
        catch (SQLException sQLException) {
            PoolDSAuthenticationTest.assertSQLState("XJ015", sQLException);
        }
    }

    @Override
    protected void assertSystemShutdownFail(String string, String string2, String string3, String string4) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.clearStringBeanProperty(connectionPoolDataSource, "databaseName");
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string2);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "user", string3);
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "password", string4);
        try {
            connectionPoolDataSource.getPooledConnection();
            PoolDSAuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException sQLException) {
            PoolDSAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    public void assertConnectionFail(String string) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        if (PoolDSAuthenticationTest.usingDerbyNetClient()) {
            JDBCDataSource.setBeanProperty(connectionPoolDataSource, "user", "APP");
        } else {
            JDBCDataSource.clearStringBeanProperty(connectionPoolDataSource, "user");
        }
        JDBCDataSource.clearStringBeanProperty(connectionPoolDataSource, "password");
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", string);
        try {
            connectionPoolDataSource.getPooledConnection();
            PoolDSAuthenticationTest.fail((String)"expected connection to fail");
        }
        catch (SQLException sQLException) {
            PoolDSAuthenticationTest.assertSQLState("08004", sQLException);
        }
    }
}

