/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OCRecoveryTest
extends BaseJDBCTestCase {
    private static final String tableName = "RECTEST1";

    public OCRecoveryTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("OCRecoveryTest");
        if (BaseTestCase.isJ9Platform()) {
            return baseTestSuite;
        }
        baseTestSuite.addTest(OCRecoveryTest.decorateTest());
        return baseTestSuite;
    }

    private static Test decorateTest() {
        Test test = TestConfiguration.embeddedSuite(OCRecoveryTest.class);
        return TestConfiguration.singleUseDatabaseDecorator(test, "OCRecoveryDB");
    }

    public void testOCRecovery() throws Exception {
        OCRecoveryTest.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.store.OCRecoveryTest.launchOCRecovery_1", "OCRecoveryDB");
        OCRecoveryTest.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.store.OCRecoveryTest.launchOCRecovery_2", "OCRecoveryDB");
        OCRecoveryTest.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.store.OCRecoveryTest.launchOCRecovery_3", "OCRecoveryDB");
        OCRecoveryTest.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.store.OCRecoveryTest.launchOCRecovery_4", "OCRecoveryDB");
    }

    public void launchOCRecovery_1() throws Exception {
        this.getConnection();
        this.setAutoCommit(false);
        this.createAndLoadTable(tableName, true, 5000, 0);
        Statement statement = this.createStatement();
        statement.executeUpdate("DELETE FROM RECTEST1");
        this.commit();
        this.callCompress(tableName, true, true, true, true);
        statement.close();
    }

    public void launchOCRecovery_2() throws Exception {
        this.setAutoCommit(false);
        this.assertCheckTable(tableName);
        this.createAndLoadTable(tableName, false, 6000, 0);
        this.assertCheckTable(tableName);
        String string = "RECTEST1_2";
        this.createAndLoadTable(string, true, 2000, 0);
        Statement statement = this.createStatement();
        statement.executeUpdate("DELETE FROM RECTEST1");
        this.commit();
        this.callCompress(tableName, true, true, true, true);
        statement.close();
    }

    public void launchOCRecovery_3() throws SQLException {
        this.setAutoCommit(false);
        String string = "RECTEST1_2";
        this.assertCheckTable(string);
        this.createAndLoadTable(tableName, false, 2000, 0);
        this.assertCheckTable(tableName);
        this.createAndLoadTable(string, false, 4000, 2000);
        Statement statement = this.createStatement();
        statement.executeUpdate("DELETE FROM " + string);
        this.commit();
        this.callCompress(string, true, true, true, false);
        statement.close();
    }

    public void launchOCRecovery_4() throws SQLException {
        this.setAutoCommit(false);
        String string = "RECTEST1_2";
        this.assertCheckTable(string);
        this.createAndLoadTable(string, false, 6000, 0);
        this.assertCheckTable(string);
    }

    private void createAndLoadTable(String string, boolean bl, int n, int n2) throws SQLException {
        Statement statement;
        if (bl) {
            statement = this.createStatement();
            statement.execute("CREATE TABLE " + string + "(keycol int, indcol1 int, indcol2 int, indcol3 int, data1 varchar(2000), data2 varchar(2000))");
            statement.close();
            OCRecoveryTest.println("table created: " + string);
        }
        statement = this.prepareStatement("INSERT INTO " + string + " VALUES(?, ?, ?, ?, ?, ?)");
        char[] cArray = new char[500];
        char[] cArray2 = new char[500];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 97;
            cArray2[i] = 98;
        }
        String string2 = new String(cArray);
        String string3 = new String(cArray2);
        int n3 = 0;
        int n4 = n2;
        while (n3 < n) {
            statement.setInt(1, n4);
            statement.setInt(2, n4 * 10);
            statement.setInt(3, n4 * 100);
            statement.setInt(4, -n4);
            statement.setString(5, string2);
            statement.setString(6, string3);
            statement.execute();
            ++n3;
            ++n4;
        }
        if (bl) {
            Statement statement2 = this.createStatement();
            statement2.execute("create index " + string + "_idx_keycol on " + string + "(keycol)");
            statement2.execute("create index " + string + "_idx_indcol1 on " + string + "(indcol1)");
            statement2.execute("create index " + string + "_idx_indcol2 on " + string + "(indcol2)");
            statement2.execute("create unique index " + string + "_idx_indcol3 on " + string + "(indcol3)");
            statement2.close();
        }
        this.commit();
    }

    private void callCompress(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, ?, ?, ?)");
        callableStatement.setString(1, this.getTestConfiguration().getUserName());
        callableStatement.setString(2, string);
        callableStatement.setInt(3, bl ? 1 : 0);
        callableStatement.setInt(4, bl2 ? 1 : 0);
        callableStatement.setInt(5, bl3 ? 1 : 0);
        callableStatement.execute();
        if (bl4) {
            this.commit();
        }
    }
}

