/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.security.Permission;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import junit.framework.Test;
import org.apache.derby.shared.common.security.SystemPermission;
import org.apache.derbyTesting.functionTests.tests.management.JMXConnectionDecorator;
import org.apache.derbyTesting.functionTests.tests.management.MBeanTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CacheManagerMBeanTest
extends MBeanTest {
    private static final int DEFAULT_PAGE_CACHE_SIZE = 1000;
    private static final int DEFAULT_CONTAINER_CACHE_SIZE = 100;
    private static final int DEFAULT_STATEMENT_CACHE_SIZE = 100;
    private static String[] ALL_ATTRIBUTES = new String[]{"CollectAccessCounts", "HitCount", "MissCount", "EvictionCount", "MaxEntries", "AllocatedEntries", "UsedEntries"};

    public CacheManagerMBeanTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        baseTestSuite.addTest(MBeanTest.suite(CacheManagerMBeanTest.class, "CacheManagerMBeanTest"));
        if (TestConfiguration.loadingFromJars()) {
            Object object = new CacheManagerMBeanTest("withoutPermsTest");
            object = JMXConnectionDecorator.platformMBeanServer((Test)object);
            object = new SecurityManagerSetup((Test)object, "org/apache/derbyTesting/functionTests/tests/management/CacheManagerMBeanTest.withoutPerm.policy");
            baseTestSuite.addTest((Test)object);
            Object object2 = new CacheManagerMBeanTest("withPermsTest");
            object2 = JMXConnectionDecorator.platformMBeanServer((Test)object2);
            object2 = new SecurityManagerSetup((Test)object2, "org/apache/derbyTesting/functionTests/tests/management/CacheManagerMBeanTest.withPerm.policy");
            baseTestSuite.addTest((Test)object2);
        }
        return baseTestSuite;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getConnection().close();
        TestConfiguration.getCurrent().shutdownDatabase();
    }

    private ObjectName createObjectName(String string, String string2) throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", "CacheManager");
        hashtable.put("name", string == null ? "*" : string);
        hashtable.put("db", string2 == null ? "*" : ObjectName.quote(string2));
        return this.getDerbyMBeanName(hashtable);
    }

    public void testAllMBeansStartedAndStopped() throws Exception {
        ObjectName objectName = this.createObjectName(null, null);
        Set<ObjectName> set = this.queryMBeans(objectName);
        if (!set.isEmpty()) {
            CacheManagerMBeanTest.fail((String)("Should not find MBeans before boot, found: " + set));
        }
        this.getConnection();
        set = this.queryMBeans(objectName);
        CacheManagerMBeanTest.assertEquals((String)("Incorrect number of MBeans found in " + set), (int)3, (int)set.size());
        TestConfiguration.getCurrent().shutdownDatabase();
        set = this.queryMBeans(objectName);
        if (!set.isEmpty()) {
            CacheManagerMBeanTest.fail((String)("Should not find MBeans after shutdown, found: " + set));
        }
    }

    public void testPageCache() throws Exception {
        this.getConnection();
        Set<ObjectName> set = this.queryMBeans(this.createObjectName("PageCache", null));
        CacheManagerMBeanTest.assertEquals((String)"Should have a single page cache", (int)1, (int)set.size());
        ObjectName objectName = set.iterator().next();
        this.assertBooleanAttribute(false, objectName, "CollectAccessCounts");
        this.assertLongAttribute(0, objectName, "HitCount");
        this.assertLongAttribute(0, objectName, "MissCount");
        this.assertLongAttribute(0, objectName, "EvictionCount");
        this.assertLongAttribute(1000, objectName, "MaxEntries");
        Long l = (Long)this.getAttribute(objectName, "AllocatedEntries");
        CacheManagerMBeanTest.assertTrue((String)("Allocated entries: " + l), (l > 0L ? 1 : 0) != 0);
        Long l2 = (Long)this.getAttribute(objectName, "UsedEntries");
        CacheManagerMBeanTest.assertTrue((String)("Used entries: " + l2), (l2 > 0L ? 1 : 0) != 0);
        PreparedStatement preparedStatement = this.prepareStatement("select * from sysibm.sysdummy1");
        JDBC.assertDrainResults(preparedStatement.executeQuery());
        this.assertLongAttribute(0, objectName, "HitCount");
        this.assertLongAttribute(0, objectName, "MissCount");
        this.assertLongAttribute(0, objectName, "EvictionCount");
        this.setAttribute(objectName, "CollectAccessCounts", Boolean.TRUE);
        this.assertBooleanAttribute(true, objectName, "CollectAccessCounts");
        JDBC.assertDrainResults(preparedStatement.executeQuery());
        this.assertLongAttribute(1, objectName, "HitCount");
        this.assertLongAttribute(0, objectName, "MissCount");
        this.setAttribute(objectName, "CollectAccessCounts", Boolean.FALSE);
        this.assertBooleanAttribute(false, objectName, "CollectAccessCounts");
    }

    public void testContainerCache() throws Exception {
        this.getConnection();
        Set<ObjectName> set = this.queryMBeans(this.createObjectName("ContainerCache", null));
        CacheManagerMBeanTest.assertEquals((String)"Should have a single container cache", (int)1, (int)set.size());
        ObjectName objectName = set.iterator().next();
        this.assertBooleanAttribute(false, objectName, "CollectAccessCounts");
        this.assertLongAttribute(0, objectName, "HitCount");
        this.assertLongAttribute(0, objectName, "MissCount");
        this.assertLongAttribute(0, objectName, "EvictionCount");
        this.assertLongAttribute(100, objectName, "MaxEntries");
        Long l = (Long)this.getAttribute(objectName, "AllocatedEntries");
        CacheManagerMBeanTest.assertTrue((String)("Allocated entries: " + l), (l > 0L ? 1 : 0) != 0);
        Long l2 = (Long)this.getAttribute(objectName, "UsedEntries");
        CacheManagerMBeanTest.assertTrue((String)("Used entries: " + l2), (l2 > 0L ? 1 : 0) != 0);
    }

    public void testStatementCache() throws Exception {
        this.getConnection();
        Set<ObjectName> set = this.queryMBeans(this.createObjectName("StatementCache", null));
        CacheManagerMBeanTest.assertEquals((String)"Should have a single statement cache", (int)1, (int)set.size());
        ObjectName objectName = set.iterator().next();
        this.assertBooleanAttribute(false, objectName, "CollectAccessCounts");
        this.assertLongAttribute(0, objectName, "HitCount");
        this.assertLongAttribute(0, objectName, "MissCount");
        this.assertLongAttribute(0, objectName, "EvictionCount");
        this.assertLongAttribute(100, objectName, "MaxEntries");
        this.assertLongAttribute(0, objectName, "AllocatedEntries");
        this.assertLongAttribute(0, objectName, "UsedEntries");
        this.prepareStatement("values 1").close();
        this.assertLongAttribute(1, objectName, "AllocatedEntries");
        this.assertLongAttribute(1, objectName, "UsedEntries");
        this.prepareStatement("values 2").close();
        this.assertLongAttribute(2, objectName, "AllocatedEntries");
        this.assertLongAttribute(2, objectName, "UsedEntries");
        Statement statement = this.createStatement();
        statement.execute("call syscs_util.syscs_empty_statement_cache()");
        this.assertLongAttribute(3, objectName, "AllocatedEntries");
        this.assertLongAttribute(0, objectName, "UsedEntries");
        this.assertLongAttribute(0, objectName, "HitCount");
        this.assertLongAttribute(0, objectName, "MissCount");
        this.assertLongAttribute(0, objectName, "EvictionCount");
        this.setAttribute(objectName, "CollectAccessCounts", Boolean.TRUE);
        this.assertBooleanAttribute(true, objectName, "CollectAccessCounts");
        this.prepareStatement("values 1").close();
        this.assertLongAttribute(0, objectName, "HitCount");
        this.assertLongAttribute(1, objectName, "MissCount");
        this.assertLongAttribute(0, objectName, "EvictionCount");
        this.prepareStatement("values 2").close();
        this.assertLongAttribute(0, objectName, "HitCount");
        this.assertLongAttribute(2, objectName, "MissCount");
        this.assertLongAttribute(0, objectName, "EvictionCount");
        this.prepareStatement("values 1").close();
        this.assertLongAttribute(1, objectName, "HitCount");
        this.assertLongAttribute(2, objectName, "MissCount");
        this.assertLongAttribute(0, objectName, "EvictionCount");
        for (int i = 0; i < 200; ++i) {
            this.prepareStatement("values 1, " + i).close();
        }
        this.assertLongAttribute(1, objectName, "HitCount");
        this.assertLongAttribute(202, objectName, "MissCount");
        this.assertLongAttribute(102, objectName, "EvictionCount");
        this.assertLongAttribute(100, objectName, "MaxEntries");
        this.assertLongAttribute(100, objectName, "AllocatedEntries");
        this.assertLongAttribute(100, objectName, "UsedEntries");
        this.setAttribute(objectName, "CollectAccessCounts", Boolean.FALSE);
        this.assertBooleanAttribute(false, objectName, "CollectAccessCounts");
    }

    public void withoutPermsTest() throws Exception {
        this.getConnection();
        Set<ObjectName> set = this.queryMBeans(this.createObjectName("StatementCache", null));
        CacheManagerMBeanTest.assertEquals((String)"Should have a single statement cache", (int)1, (int)set.size());
        ObjectName objectName = set.iterator().next();
        SystemPermission systemPermission = new SystemPermission("engine", "monitor");
        for (String string : ALL_ATTRIBUTES) {
            try {
                this.getAttribute(objectName, string);
                CacheManagerMBeanTest.fail();
            }
            catch (RuntimeMBeanException runtimeMBeanException) {
                this.vetException(runtimeMBeanException, (Permission)systemPermission);
            }
        }
        try {
            this.setAttribute(objectName, "CollectAccessCounts", Boolean.FALSE);
            CacheManagerMBeanTest.fail();
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            this.vetException(runtimeMBeanException, (Permission)systemPermission);
        }
    }

    private void vetException(RuntimeMBeanException runtimeMBeanException, Permission permission) {
        String string;
        Throwable throwable = runtimeMBeanException.getCause();
        if (throwable instanceof SecurityException && (string = throwable.getMessage()) != null && string.contains(permission.toString())) {
            return;
        }
        CacheManagerMBeanTest.fail("Unexpected exception", runtimeMBeanException);
    }

    public void withPermsTest() throws Exception {
        this.getConnection();
        Set<ObjectName> set = this.queryMBeans(this.createObjectName("StatementCache", null));
        CacheManagerMBeanTest.assertEquals((String)"Should have a single statement cache", (int)1, (int)set.size());
        ObjectName objectName = set.iterator().next();
        for (String string : ALL_ATTRIBUTES) {
            this.getAttribute(objectName, string);
        }
        this.setAttribute(objectName, "CollectAccessCounts", Boolean.FALSE);
    }
}

