/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby6131
extends BaseJDBCTestCase {
    public Derby6131(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(Derby6131.class);
    }

    public void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    public void testOrigUserRepro() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table myTbl1 (name varchar(1000))");
        statement.executeUpdate("create table myTbl2 (name varchar(1000))");
        statement.executeUpdate("create view myView (name) as select t1.name from myTbl1 t1 union all select t2.name from myTbl2 t2");
        String string = "select name from myView where upper(name) in ('AA', 'BB')";
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[0][]);
        this.dropView("myView");
        this.dropTable("myTbl1");
        this.dropTable("myTbl2");
        statement.close();
    }

    public void testOrigUserReproWithData() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table myTbl1 (name varchar(1000))");
        statement.executeUpdate("create table myTbl2 (name varchar(1000))");
        statement.executeUpdate("insert into myTbl1 values ('aA'), ('bB'), ('Cc'), ('Dd')");
        statement.executeUpdate("insert into myTbl2 values ('eE'), ('fF'), ('GG'), ('hh')");
        statement.executeUpdate("create view myView (name) as select t1.name from myTbl1 t1 union all select t2.name from myTbl2 t2");
        String string = "select name from myView where upper(name) in ('AA', 'BB')";
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[][]{{"aA"}, {"bB"}});
        String string2 = "select name from myView where upper(name) in (?, ?)";
        PreparedStatement preparedStatement = this.prepareStatement(string2);
        preparedStatement.setString(1, "AA");
        preparedStatement.setString(2, "BB");
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"aA"}, {"bB"}});
        string = "select name from myView where upper(name) in ('CC', 'HH')";
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[][]{{"Cc"}, {"hh"}});
        preparedStatement.setString(1, "CC");
        preparedStatement.setString(2, "HH");
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[][]{{"Cc"}, {"hh"}});
        string = "select name from myView where upper(name) in ('cc', 'hh')";
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[0][]);
        preparedStatement.setString(1, "cc");
        preparedStatement.setString(2, "hh");
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[0][]);
        string = "select name from myView where lower(name) in ('cc', 'hh')";
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[][]{{"Cc"}, {"hh"}});
        string2 = "select name from myView where upper(name) in (?, ?)";
        preparedStatement = this.prepareStatement(string2);
        preparedStatement.setString(1, "cc");
        preparedStatement.setString(2, "hh");
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[][]{{"Cc"}, {"hh"}});
        this.dropView("myView");
        this.dropTable("myTbl1");
        this.dropTable("myTbl2");
        statement.close();
        preparedStatement.close();
    }
}

