/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;

public class executeUpdate {
    public static void main(String[] stringArray) {
        try {
            System.out.println("executeUpdate Test Starts");
            ij.getPropertyArg((String[])stringArray);
            Connection connection = ij.startJBMS();
            if (connection == null) {
                System.out.println("conn didn't work");
                return;
            }
            Statement statement = connection.createStatement();
            int n = statement.executeUpdate("create table exup(a int)");
            if (n != 0) {
                System.out.println("FAIL - non zero return count on create table");
            } else {
                System.out.println("PASS - create table");
            }
            n = statement.executeUpdate("insert into exup values(1)");
            if (n != 1) {
                System.out.println("FAIL - expected row count 1, got " + n);
            } else {
                System.out.println("PASS - insert 1 row");
            }
            n = statement.executeUpdate("insert into exup values(2),(3),(4)");
            if (n != 3) {
                System.out.println("FAIL - expected row count 3, got " + n);
            } else {
                System.out.println("PASS - insert 3 rows");
            }
            System.out.println("Rows in table should be 1,2,3,4");
            ResultSet resultSet = statement.executeQuery("select * from exup");
            int n2 = 1;
            boolean bl = false;
            while (resultSet.next()) {
                int n3 = resultSet.getInt(1);
                if (n2++ == n3) continue;
                System.out.println("FAIL - expecting " + n2 + " got " + n3);
                bl = true;
            }
            if (n2 != 5) {
                System.out.println("FAIL - too many rows in table");
            } else if (!bl) {
                System.out.println("PASS - correct rows in table");
            }
            resultSet.close();
            n = statement.executeUpdate("drop table exup");
            if (n != 0) {
                System.out.println("FAIL - non zero return count on drop table");
            } else {
                System.out.println("PASS - drop table");
            }
            statement.close();
            System.out.println("executeUpdate Test ends");
            connection.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

