/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.GenericActivationHolder;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;
import org.apache.derby.shared.common.util.ArrayUtil;

public class GenericPreparedStatement
implements ExecPreparedStatement {
    public Statement statement;
    protected GeneratedClass activationClass;
    protected ResultDescription resultDesc;
    protected DataTypeDescriptor[] paramTypeDescriptors;
    private String spsName;
    private SQLWarning warnings;
    private boolean referencesSessionSchema;
    protected ExecCursorTableReference targetTable;
    protected List<String> updateColumns;
    protected int updateMode;
    protected ConstantAction executionConstants;
    protected Object[] savedObjects;
    protected List<StatementPermission> requiredPermissionsList;
    protected String UUIDString;
    protected UUID UUIDValue;
    private boolean needsSavepoint;
    private String execStmtName;
    private String execSchemaName;
    protected boolean isAtomic;
    protected String sourceTxt;
    private int inUseCount;
    private boolean compilingStatement;
    boolean invalidatedWhileCompiling;
    protected long parseTime;
    protected long bindTime;
    protected long optimizeTime;
    protected long generateTime;
    protected long compileTime;
    protected Timestamp beginCompileTimestamp;
    protected Timestamp endCompileTimestamp;
    protected boolean isValid;
    protected boolean spsAction;
    private Cacheable cacheHolder;
    private long versionCounter;
    private RowCountStatistics rowCountStats = new RowCountStatistics();

    GenericPreparedStatement() {
        UUIDFactory uuidFactory = GenericPreparedStatement.getMonitor().getUUIDFactory();
        this.UUIDValue = uuidFactory.createUUID();
        this.UUIDString = this.UUIDValue.toString();
        this.spsAction = false;
    }

    public GenericPreparedStatement(Statement st) {
        this();
        this.statement = st;
    }

    @Override
    public synchronized boolean upToDate() throws StandardException {
        return this.isUpToDate();
    }

    @Override
    public synchronized boolean upToDate(GeneratedClass gc) {
        return this.activationClass == gc && this.isUpToDate();
    }

    private boolean isUpToDate() {
        return this.isValid && this.activationClass != null && !this.compilingStatement;
    }

    final synchronized boolean isCompiling() {
        return this.compilingStatement;
    }

    final synchronized void beginCompiling() {
        this.compilingStatement = true;
        this.setActivationClass(null);
    }

    final synchronized void endCompiling() {
        this.compilingStatement = false;
        this.notifyAll();
    }

    @Override
    public void rePrepare(LanguageConnectionContext lcc) throws StandardException {
        this.rePrepare(lcc, false);
    }

    public void rePrepare(LanguageConnectionContext lcc, boolean forMetaData) throws StandardException {
        if (!this.upToDate()) {
            PreparedStatement ps = this.statement.prepare(lcc, forMetaData);
            SanityManager.ASSERT(ps == this, "ps != this");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Activation getActivation(LanguageConnectionContext lcc, boolean scrollable) throws StandardException {
        GenericActivationHolder ac;
        GenericPreparedStatement genericPreparedStatement = this;
        synchronized (genericPreparedStatement) {
            GeneratedClass gc = this.getActivationClass();
            if (gc == null) {
                this.rePrepare(lcc);
                gc = this.getActivationClass();
            }
            ac = new GenericActivationHolder(lcc, gc, this, scrollable);
            ++this.inUseCount;
        }
        lcc.closeUnusedActivations();
        Activation parentAct = null;
        StatementContext stmctx = lcc.getStatementContext();
        if (stmctx != null) {
            parentAct = stmctx.getActivation();
        }
        ac.setParentActivation(parentAct);
        return ac;
    }

    @Override
    public ResultSet executeSubStatement(LanguageConnectionContext lcc, boolean rollbackParentContext, long timeoutMillis) throws StandardException {
        Activation parent = lcc.getLastActivation();
        Activation a = this.getActivation(lcc, false);
        a.setSingleExecution();
        lcc.setupSubStatementSessionContext(parent);
        return this.executeStmt(a, rollbackParentContext, false, timeoutMillis);
    }

    @Override
    public ResultSet executeSubStatement(Activation parent, Activation activation, boolean rollbackParentContext, long timeoutMillis) throws StandardException {
        parent.getLanguageConnectionContext().setupSubStatementSessionContext(parent);
        return this.executeStmt(activation, rollbackParentContext, false, timeoutMillis);
    }

    @Override
    public ResultSet execute(Activation activation, boolean forMetaData, long timeoutMillis) throws StandardException {
        return this.executeStmt(activation, false, forMetaData, timeoutMillis);
    }

    private ResultSet executeStmt(Activation activation, boolean rollbackParentContext, boolean forMetaData, long timeoutMillis) throws StandardException {
        ResultSet resultSet;
        StatementContext statementContext;
        LanguageConnectionContext lccToUse;
        boolean needToClearSavePoint = false;
        if (activation == null || activation.getPreparedStatement() != this) {
            throw StandardException.newException("XCL09.S", "execute");
        }
        while (true) {
            if ((lccToUse = activation.getLanguageConnectionContext()).getLogStatementText()) {
                HeaderPrintWriter istream = Monitor.getStream();
                String xactId = lccToUse.getTransactionExecute().getActiveStateTxIdString();
                Object pvsString = "";
                ParameterValueSet pvs = activation.getParameterValueSet();
                if (pvs != null && pvs.getParameterCount() > 0) {
                    pvsString = " with " + pvs.getParameterCount() + " parameters " + pvs.toString();
                }
                istream.printlnWithHeader("(XID = " + xactId + "), (SESSIONID = " + lccToUse.getInstanceNumber() + "), (DATABASE = " + lccToUse.getDbname() + "), (DRDAID = " + lccToUse.getDrdaID() + "), Executing prepared statement: " + this.getSource() + " :End prepared statement" + (String)pvsString);
            }
            ParameterValueSet pvs = activation.getParameterValueSet();
            if (!this.spsAction) {
                this.rePrepare(lccToUse, forMetaData);
            }
            statementContext = lccToUse.pushStatementContext(this.isAtomic, this.updateMode == 1, this.getSource(), pvs, rollbackParentContext, timeoutMillis);
            statementContext.setActivation(activation);
            if (this.needsSavepoint()) {
                statementContext.setSavePoint();
                needToClearSavePoint = true;
            }
            if (this.executionConstants != null) {
                lccToUse.validateStmtExecution(this.executionConstants);
            }
            try {
                resultSet = activation.execute();
                resultSet.open();
            }
            catch (StandardException se) {
                if (!se.getMessageId().equals("XCL32.S") || this.spsAction) {
                    throw se;
                }
                statementContext.cleanupOnError(se);
                continue;
            }
            break;
        }
        if (needToClearSavePoint) {
            statementContext.clearSavePoint();
        }
        lccToUse.popStatementContext(statementContext, null);
        if (activation.getSQLSessionContextForChildren() != null) {
            lccToUse.popNestedSessionContext(activation);
        }
        if (activation.isSingleExecution() && resultSet.isClosed()) {
            activation.close();
        }
        return resultSet;
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.resultDesc;
    }

    @Override
    public DataTypeDescriptor[] getParameterTypes() {
        return ArrayUtil.copy(this.paramTypeDescriptors);
    }

    @Override
    public DataTypeDescriptor getParameterType(int idx) throws StandardException {
        if (this.paramTypeDescriptors == null) {
            throw StandardException.newException("07009", new Object[0]);
        }
        if (idx < 0 || idx >= this.paramTypeDescriptors.length) {
            throw StandardException.newException("XCL13.S", idx + 1, this.paramTypeDescriptors.length);
        }
        return this.paramTypeDescriptors[idx];
    }

    @Override
    public String getSource() {
        return this.sourceTxt != null ? this.sourceTxt : (this.statement == null ? "null" : this.statement.getSource());
    }

    @Override
    public void setSource(String text) {
        this.sourceTxt = text;
    }

    public final void setSPSName(String name) {
        this.spsName = name;
    }

    @Override
    public String getSPSName() {
        return this.spsName;
    }

    @Override
    public long getCompileTimeInMillis() {
        return this.compileTime;
    }

    @Override
    public long getParseTimeInMillis() {
        return this.parseTime;
    }

    @Override
    public long getBindTimeInMillis() {
        return this.bindTime;
    }

    @Override
    public long getOptimizeTimeInMillis() {
        return this.optimizeTime;
    }

    @Override
    public long getGenerateTimeInMillis() {
        return this.generateTime;
    }

    @Override
    public Timestamp getBeginCompileTimestamp() {
        return DataTypeUtilities.clone(this.beginCompileTimestamp);
    }

    @Override
    public Timestamp getEndCompileTimestamp() {
        return DataTypeUtilities.clone(this.endCompileTimestamp);
    }

    void setCompileTimeWarnings(SQLWarning warnings) {
        this.warnings = warnings;
    }

    @Override
    public final SQLWarning getCompileTimeWarnings() {
        return this.warnings;
    }

    protected void setCompileTimeMillis(long parseTime, long bindTime, long optimizeTime, long generateTime, long compileTime, Timestamp beginCompileTimestamp, Timestamp endCompileTimestamp) {
        this.parseTime = parseTime;
        this.bindTime = bindTime;
        this.optimizeTime = optimizeTime;
        this.generateTime = generateTime;
        this.compileTime = compileTime;
        this.beginCompileTimestamp = beginCompileTimestamp;
        this.endCompileTimestamp = endCompileTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(LanguageConnectionContext lcc) {
        GenericPreparedStatement genericPreparedStatement = this;
        synchronized (genericPreparedStatement) {
            --this.inUseCount;
            if (this.cacheHolder != null) {
                return;
            }
            if (this.inUseCount != 0) {
                return;
            }
        }
        try {
            this.makeInvalid(11, lcc);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
        }
    }

    final void setConstantAction(ConstantAction constantAction) {
        this.executionConstants = constantAction;
    }

    @Override
    public final ConstantAction getConstantAction() {
        return this.executionConstants;
    }

    final void setSavedObjects(Object[] objects) {
        this.savedObjects = objects;
    }

    @Override
    public final Object getSavedObject(int objectNum) {
        if (objectNum < 0 || objectNum >= this.savedObjects.length) {
            SanityManager.THROWASSERT("request for savedObject entry " + objectNum + " invalid; savedObjects has " + this.savedObjects.length + " entries");
        }
        return this.savedObjects[objectNum];
    }

    @Override
    public final List<Object> getSavedObjects() {
        return ArrayUtil.asReadOnlyList(this.savedObjects);
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setValid() {
        this.isValid = true;
    }

    @Override
    public void setSPSAction() {
        this.spsAction = true;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 3: 
            case 5: 
            case 48: {
                return;
            }
        }
        lcc.verifyNoOpenResultSets(this, p, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 48: {
                return;
            }
        }
        GenericPreparedStatement genericPreparedStatement = this;
        synchronized (genericPreparedStatement) {
            if (this.compilingStatement) {
                this.invalidatedWhileCompiling = true;
                return;
            }
            boolean alreadyInvalid = !this.isValid;
            this.isValid = false;
            this.beginCompiling();
        }
        try {
            DependencyManager dm = lcc.getDataDictionary().getDependencyManager();
            dm.clearDependencies(lcc, this);
            if (this.execStmtName == null) return;
            switch (action) {
                case 5: 
                case 23: {
                    DataDictionary dd = lcc.getDataDictionary();
                    SchemaDescriptor sd = dd.getSchemaDescriptor(this.execSchemaName, lcc.getTransactionCompile(), true);
                    SPSDescriptor spsd = dd.getSPSDescriptor(this.execStmtName, sd);
                    spsd.makeInvalid(action, lcc);
                    return;
                }
            }
            return;
        }
        finally {
            this.endCompiling();
        }
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public DependableFinder getDependableFinder() {
        return null;
    }

    @Override
    public String getObjectName() {
        return this.UUIDString;
    }

    @Override
    public UUID getObjectID() {
        return this.UUIDValue;
    }

    @Override
    public String getClassType() {
        return "PreparedStatement";
    }

    @Override
    public boolean referencesSessionSchema() {
        return this.referencesSessionSchema;
    }

    public boolean referencesSessionSchema(StatementNode qt) throws StandardException {
        this.referencesSessionSchema = qt.referencesSessionSchema();
        return this.referencesSessionSchema;
    }

    void completeCompile(StatementNode qt) throws StandardException {
        this.paramTypeDescriptors = qt.getParameterTypes();
        if (this.targetTable != null) {
            this.targetTable = null;
            this.updateMode = 0;
            this.updateColumns = null;
        }
        this.resultDesc = qt.makeResultDescription();
        if (this.resultDesc != null) {
            this.setCursorInfo((CursorInfo)qt.getCursorInfo());
        }
        this.isValid = true;
        this.rowCountStats.reset();
    }

    @Override
    public GeneratedClass getActivationClass() throws StandardException {
        return this.activationClass;
    }

    void setActivationClass(GeneratedClass ac) {
        this.activationClass = ac;
    }

    @Override
    public int getUpdateMode() {
        return this.updateMode;
    }

    @Override
    public ExecCursorTableReference getTargetTable() {
        SanityManager.ASSERT(this.targetTable != null, "Not a cursor, no target table");
        return this.targetTable;
    }

    @Override
    public boolean hasUpdateColumns() {
        return this.updateColumns != null && !this.updateColumns.isEmpty();
    }

    @Override
    public boolean isUpdateColumn(String columnName) {
        return this.updateColumns != null && this.updateColumns.contains(columnName);
    }

    @Override
    public Object getCursorInfo() {
        return new CursorInfo(this.updateMode, this.targetTable, this.updateColumns);
    }

    void setCursorInfo(CursorInfo cursorInfo) {
        if (cursorInfo != null) {
            this.updateMode = cursorInfo.updateMode;
            this.targetTable = cursorInfo.targetTable;
            this.updateColumns = cursorInfo.updateColumns;
        }
    }

    ByteArray getByteCodeSaver() {
        return null;
    }

    @Override
    public boolean needsSavepoint() {
        return this.needsSavepoint;
    }

    void setNeedsSavepoint(boolean needsSavepoint) {
        this.needsSavepoint = needsSavepoint;
    }

    void setIsAtomic(boolean isAtomic) {
        this.isAtomic = isAtomic;
    }

    @Override
    public boolean isAtomic() {
        return this.isAtomic;
    }

    void setExecuteStatementNameAndSchema(String execStmtName, String execSchemaName) {
        this.execStmtName = execStmtName;
        this.execSchemaName = execSchemaName;
    }

    @Override
    public ExecPreparedStatement getClone() throws StandardException {
        GenericPreparedStatement clone = new GenericPreparedStatement(this.statement);
        clone.activationClass = this.getActivationClass();
        clone.resultDesc = this.resultDesc;
        clone.paramTypeDescriptors = this.paramTypeDescriptors;
        clone.executionConstants = this.executionConstants;
        clone.UUIDString = this.UUIDString;
        clone.UUIDValue = this.UUIDValue;
        clone.savedObjects = this.savedObjects;
        clone.execStmtName = this.execStmtName;
        clone.execSchemaName = this.execSchemaName;
        clone.isAtomic = this.isAtomic;
        clone.sourceTxt = this.sourceTxt;
        clone.targetTable = this.targetTable;
        clone.updateColumns = this.updateColumns;
        clone.updateMode = this.updateMode;
        clone.needsSavepoint = this.needsSavepoint;
        clone.rowCountStats = this.rowCountStats;
        return clone;
    }

    public void setCacheHolder(Cacheable cacheHolder) {
        this.cacheHolder = cacheHolder;
        if (cacheHolder == null) {
            if (!this.isValid || this.inUseCount != 0) {
                return;
            }
            ContextManager cm = GenericPreparedStatement.getContextService().getCurrentContextManager();
            LanguageConnectionContext lcc = (LanguageConnectionContext)cm.getContext("LanguageConnectionContext");
            try {
                this.makeInvalid(11, lcc);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT("Unexpected exception", se);
            }
        }
    }

    public String toString() {
        return this.getObjectName();
    }

    public boolean isStorable() {
        return false;
    }

    public void setRequiredPermissionsList(List<StatementPermission> requiredPermissionsList) {
        this.requiredPermissionsList = requiredPermissionsList;
    }

    @Override
    public List<StatementPermission> getRequiredPermissionsList() {
        return this.requiredPermissionsList;
    }

    @Override
    public final long getVersionCounter() {
        return this.versionCounter;
    }

    public final void incrementVersionCounter() {
        ++this.versionCounter;
    }

    @Override
    public int incrementExecutionCount() {
        return this.rowCountStats.incrementExecutionCount();
    }

    @Override
    public void setStalePlanCheckInterval(int interval) {
        this.rowCountStats.setStalePlanCheckInterval(interval);
    }

    @Override
    public int getStalePlanCheckInterval() {
        return this.rowCountStats.getStalePlanCheckInterval();
    }

    @Override
    public long getInitialRowCount(int rsNum, long currentRowCount) {
        return this.rowCountStats.getInitialRowCount(rsNum, currentRowCount);
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static class RowCountStatistics {
        private int stalePlanCheckInterval;
        private int executionCount;
        private ArrayList<Long> rowCounts;

        private RowCountStatistics() {
        }

        int incrementExecutionCount() {
            return ++this.executionCount;
        }

        synchronized long getInitialRowCount(int rsNum, long rowCount) {
            Long initialCount;
            if (this.rowCounts == null) {
                this.rowCounts = new ArrayList();
            }
            if (rsNum >= this.rowCounts.size()) {
                int newSize = rsNum + 1;
                this.rowCounts.addAll(Collections.nCopies(newSize - this.rowCounts.size(), null));
            }
            if ((initialCount = this.rowCounts.get(rsNum)) == null) {
                this.rowCounts.set(rsNum, rowCount);
                return rowCount;
            }
            return initialCount;
        }

        void setStalePlanCheckInterval(int interval) {
            this.stalePlanCheckInterval = interval;
        }

        int getStalePlanCheckInterval() {
            return this.stalePlanCheckInterval;
        }

        synchronized void reset() {
            this.stalePlanCheckInterval = 0;
            this.executionCount = 0;
            this.rowCounts = null;
        }
    }
}

