/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.SignedBinary;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetResultSet;
import org.apache.derby.client.net.NetSqlca;
import org.apache.derby.client.net.Typdef;
import org.apache.derby.shared.common.sanity.SanityManager;

class NetCursor
extends Cursor {
    NetResultSet netResultSet_;
    private NetAgent netAgent_;
    Typdef qrydscTypdef_;
    int maximumRowSize_;
    boolean blocking_;
    int[] typeToUseForComputingDataLength_;
    boolean[] isGraphic_;
    HashMap<Integer, Integer> extdtaPositions_;
    ArrayList<byte[]> extdtaData_;
    boolean rtnextrow_ = true;
    private boolean qryclsimpEnabled_;

    NetCursor(NetAgent netAgent) {
        super(netAgent);
        this.netAgent_ = netAgent;
        this.maximumRowSize_ = 0;
        this.extdtaPositions_ = new HashMap();
        this.extdtaData_ = new ArrayList();
    }

    NetCursor(NetAgent netAgent, int qryprctyp) {
        this(netAgent);
        if (qryprctyp == 9240) {
            this.blocking_ = false;
        } else if (qryprctyp == 9239) {
            this.blocking_ = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean calculateColumnOffsetsForRow_(int rowIndex, boolean allowServerFetch) throws SqlException, DisconnectException {
        int daNullIndicator = 255;
        int colNullIndicator = 255;
        int[] columnDataPosition = null;
        int[] columnDataComputedLength = null;
        boolean[] columnDataIsNull = null;
        boolean receivedDeleteHoleWarning = false;
        boolean receivedRowUpdatedWarning = false;
        if (this.position_ == this.lastValidBytePosition_ && this.netResultSet_ != null && this.netResultSet_.scrollable_) {
            return false;
        }
        if (this.hasLobs_) {
            this.extdtaPositions_.clear();
        }
        NetSqlca[] netSqlca = this.parseSQLCARD(this.qrydscTypdef_);
        daNullIndicator = this.readFdocaOneByte();
        if (netSqlca != null) {
            for (int i = 0; i < netSqlca.length; ++i) {
                int sqlcode = netSqlca[i].getSqlCode();
                if (sqlcode < 0) {
                    throw new SqlException(this.netAgent_.logWriter_, netSqlca[i]);
                }
                if (sqlcode == SqlCode.END_OF_DATA.getCode()) {
                    this.setAllRowsReceivedFromServer(true);
                    if (this.netResultSet_ == null || !netSqlca[i].containsSqlcax()) continue;
                    this.netResultSet_.setRowCountEvent(netSqlca[i].getRowCount());
                    continue;
                }
                if (this.netResultSet_ == null || sqlcode <= 0) continue;
                String sqlState = netSqlca[i].getSqlState();
                if (!sqlState.equals("02502") && !sqlState.equals("rwupd")) {
                    this.netResultSet_.accumulateWarning(new SqlWarning(this.agent_.logWriter_, netSqlca[i]));
                    continue;
                }
                receivedDeleteHoleWarning |= sqlState.equals("02502");
                receivedRowUpdatedWarning |= sqlState.equals("rwupd");
            }
        }
        this.setIsUpdataDeleteHole(rowIndex, receivedDeleteHoleWarning);
        this.setIsRowUpdated(receivedRowUpdatedWarning);
        if (this.allRowsReceivedFromServer() && this.position_ == this.lastValidBytePosition_) {
            this.markNextRowPosition();
            this.makeNextRowPositionCurrent();
            return false;
        }
        if (daNullIndicator == 0) {
            if (receivedDeleteHoleWarning) {
                SanityManager.THROWASSERT("Delete hole warning received: nulldata expected");
            }
            this.incrementRowsReadEvent();
            if (this.netResultSet_ != null && this.netResultSet_.scrollable_) {
                columnDataPosition = this.allocateColumnDataPositionArray(rowIndex);
                columnDataComputedLength = this.allocateColumnDataComputedLengthArray(rowIndex);
                columnDataIsNull = this.allocateColumnDataIsNullArray(rowIndex);
                this.setIsUpdataDeleteHole(rowIndex, false);
            } else {
                if (this.columnDataPosition_ == null || this.columnDataComputedLength_ == null || this.isNull_ == null) {
                    this.allocateColumnOffsetAndLengthArrays();
                }
                columnDataPosition = this.columnDataPosition_;
                columnDataComputedLength = this.columnDataComputedLength_;
                columnDataIsNull = this.isNull_;
            }
            for (int index = 0; index < this.columns_; ++index) {
                if (this.nullable_[index]) {
                    colNullIndicator = this.readFdocaOneByte(index);
                }
                if (!this.nullable_[index] || colNullIndicator >= 0 && colNullIndicator <= 127) {
                    columnDataIsNull[index] = false;
                    switch (this.typeToUseForComputingDataLength_[index]) {
                        case 0: {
                            columnDataPosition[index] = this.position_;
                            if (this.isGraphic_[index]) {
                                columnDataComputedLength[index] = this.skipFdocaBytes(this.fdocaLength_[index] * 2, index);
                                break;
                            }
                            columnDataComputedLength[index] = this.skipFdocaBytes(this.fdocaLength_[index], index);
                            break;
                        }
                        case 1: {
                            columnDataPosition[index] = this.position_;
                            int length = this.readFdocaTwoByteLength(index);
                            if (this.isGraphic_[index]) {
                                columnDataComputedLength[index] = this.skipFdocaBytes(length * 2, index) + 2;
                                break;
                            }
                            columnDataComputedLength[index] = this.skipFdocaBytes(length, index) + 2;
                            break;
                        }
                        case 3: {
                            columnDataPosition[index] = this.position_;
                            columnDataComputedLength[index] = this.skipFdocaBytes(this.getDecimalLength(index), index);
                            break;
                        }
                        case 4: {
                            columnDataPosition[index] = this.position_;
                            columnDataComputedLength[index] = this.skipFdocaBytes(this.fdocaLength_[index] & Short.MAX_VALUE, index);
                            break;
                        }
                        case 2: {
                            columnDataPosition[index] = this.position_;
                            int length = this.readFdocaOneByte(index);
                            if (this.isGraphic_[index]) {
                                columnDataComputedLength[index] = this.skipFdocaBytes(length * 2, index) + 1;
                                break;
                            }
                            columnDataComputedLength[index] = this.skipFdocaBytes(length, index) + 1;
                            break;
                        }
                        default: {
                            columnDataPosition[index] = this.position_;
                            if (this.isGraphic_[index]) {
                                columnDataComputedLength[index] = this.skipFdocaBytes(this.fdocaLength_[index] * 2, index);
                                break;
                            }
                            columnDataComputedLength[index] = this.skipFdocaBytes(this.fdocaLength_[index], index);
                            break;
                        }
                    }
                    continue;
                }
                if ((colNullIndicator & 0x80) != 128) continue;
                columnDataIsNull[index] = true;
            }
            this.columnDataPosition_ = columnDataPosition;
            this.columnDataComputedLength_ = columnDataComputedLength;
            this.isNull_ = columnDataIsNull;
            if (this.allRowsReceivedFromServer()) return this.blocking_ || !this.allRowsReceivedFromServer() || daNullIndicator != 255;
            this.calculateLobColumnPositionsForRow();
            if (!this.blocking_ || !this.rtnextrow_ || this.netResultSet_.scrollable_ || this.extdtaPositions_.isEmpty()) return this.blocking_ || !this.allRowsReceivedFromServer() || daNullIndicator != 255;
            if (!allowServerFetch) return false;
            this.netResultSet_.flowFetch();
            return this.blocking_ || !this.allRowsReceivedFromServer() || daNullIndicator != 255;
        } else {
            if (this.netResultSet_ == null || !this.netResultSet_.scrollable_) return this.blocking_ || !this.allRowsReceivedFromServer() || daNullIndicator != 255;
            if (receivedDeleteHoleWarning) {
                this.setIsUpdataDeleteHole(rowIndex, true);
                return this.blocking_ || !this.allRowsReceivedFromServer() || daNullIndicator != 255;
            } else {
                SanityManager.THROWASSERT("Delete hole warning expected");
            }
        }
        return this.blocking_ || !this.allRowsReceivedFromServer() || daNullIndicator != 255;
    }

    void scanDataBufferForEndOfData() throws SqlException {
        while (!this.allRowsReceivedFromServer() && this.position_ != this.lastValidBytePosition_) {
            this.stepNext(false);
        }
    }

    private int readFdocaInt() throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(4);
        int i = SignedBinary.getInt(this.dataBuffer_, this.position_);
        this.position_ += 4;
        return i;
    }

    private int readFdocaOneByte() throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(1);
        return this.dataBuffer_[this.position_++] & 0xFF;
    }

    private int readFdocaOneByte(int index) throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(1, index);
        return this.dataBuffer_[this.position_++] & 0xFF;
    }

    private byte[] readFdocaBytes(int length) throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(length);
        byte[] b = new byte[length];
        System.arraycopy(this.dataBuffer_, this.position_, b, 0, length);
        this.position_ += length;
        return b;
    }

    private int readFdocaTwoByteLength() throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(2);
        return ((this.dataBuffer_[this.position_++] & 0xFF) << 8) + ((this.dataBuffer_[this.position_++] & 0xFF) << 0);
    }

    private int readFdocaTwoByteLength(int index) throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(2, index);
        return ((this.dataBuffer_[this.position_++] & 0xFF) << 8) + ((this.dataBuffer_[this.position_++] & 0xFF) << 0);
    }

    private int skipFdocaBytes(int length) throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(length);
        this.position_ += length;
        return length;
    }

    private int skipFdocaBytes(int length, int index) throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(length, index);
        this.position_ += length;
        return length;
    }

    private void shiftPartialRowToBeginning() {
        int length = this.lastValidBytePosition_ - this.currentRowPosition_;
        this.dataBufferStream_.reset();
        if (this.dataBuffer_ != null) {
            this.dataBufferStream_.write(this.dataBuffer_, this.currentRowPosition_, length);
        }
        for (int i = 0; i < length; ++i) {
            this.dataBuffer_[i] = this.dataBuffer_[this.currentRowPosition_ + i];
        }
        this.position_ = length - (this.lastValidBytePosition_ - this.position_);
        this.lastValidBytePosition_ = length;
    }

    private void adjustColumnOffsetsForColumnsPreviouslyCalculated(int index) {
        int j = 0;
        while (j <= index) {
            int n = j++;
            this.columnDataPosition_[n] = this.columnDataPosition_[n] - this.currentRowPosition_;
        }
    }

    private void resetCurrentRowPosition() {
        this.currentRowPosition_ = 0;
    }

    void calculateLobColumnPositionsForRow() {
        int currentPosition = 0;
        for (int i = 0; i < this.columns_; ++i) {
            if (!this.isNonTrivialDataLob(i) || this.locator(i + 1) != -1) continue;
            this.extdtaPositions_.put(i + 1, currentPosition++);
        }
    }

    private boolean isNonTrivialDataLob(int index) {
        long length = 0L;
        if (this.isNull_[index] || this.jdbcTypes_[index] != 2004 && this.jdbcTypes_[index] != 2005) {
            return false;
        }
        int position = this.columnDataPosition_[index];
        if ((this.dataBuffer_[position] & 0x80) == 128) {
            length = -1L;
        } else {
            byte[] lengthBytes = new byte[this.columnDataComputedLength_[index]];
            byte[] longBytes = new byte[8];
            System.arraycopy(this.dataBuffer_, position, lengthBytes, 0, this.columnDataComputedLength_[index]);
            int j = 0;
            for (int i = 8 - this.columnDataComputedLength_[index]; i < 8; ++i) {
                longBytes[i] = lengthBytes[j];
                ++j;
            }
            length = SignedBinary.getLong(longBytes, 0);
        }
        return length != 0L;
    }

    @Override
    protected void clearLobData_() {
        this.extdtaData_.clear();
        this.extdtaPositions_.clear();
    }

    private NetSqlca[] parseSQLCARD(Typdef typdef) throws DisconnectException, SqlException {
        return this.parseSQLCAGRP(typdef);
    }

    private NetSqlca[] parseSQLCAGRP(Typdef typdef) throws DisconnectException, SqlException {
        NetSqlca[] ret_val;
        if (this.readFdocaOneByte() == 255) {
            return null;
        }
        int sqlcode = this.readFdocaInt();
        byte[] sqlstate = this.readFdocaBytes(5);
        byte[] sqlerrproc = this.readFdocaBytes(8);
        NetSqlca netSqlca = new NetSqlca((ClientConnection)this.netAgent_.netConnection_, sqlcode, sqlstate, sqlerrproc);
        this.parseSQLCAXGRP(typdef, netSqlca);
        NetSqlca[] sqlCa = this.parseSQLDIAGGRP();
        if (sqlCa != null) {
            ret_val = new NetSqlca[sqlCa.length + 1];
            System.arraycopy(sqlCa, 0, ret_val, 1, sqlCa.length);
        } else {
            ret_val = new NetSqlca[]{netSqlca};
        }
        return ret_val;
    }

    private void parseSQLCAXGRP(Typdef typdef, NetSqlca netSqlca) throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            netSqlca.setContainsSqlcax(false);
            return;
        }
        int[] sqlerrd = new int[6];
        for (int i = 0; i < sqlerrd.length; ++i) {
            sqlerrd[i] = this.readFdocaInt();
        }
        byte[] sqlwarn = this.readFdocaBytes(11);
        this.parseVCS(typdef);
        int varcharLength = this.readFdocaTwoByteLength();
        byte[] sqlerrmc = null;
        int sqlerrmcCcsid = 0;
        if (varcharLength != 0) {
            sqlerrmc = this.readFdocaBytes(varcharLength);
            sqlerrmcCcsid = typdef.getCcsidMbc();
            this.skipFdocaBytes(2);
        } else {
            varcharLength = this.readFdocaTwoByteLength();
            sqlerrmc = this.readFdocaBytes(varcharLength);
            sqlerrmcCcsid = typdef.getCcsidSbc();
        }
        netSqlca.setSqlerrd(sqlerrd);
        netSqlca.setSqlwarnBytes(sqlwarn);
        netSqlca.setSqlerrmcBytes(sqlerrmc);
    }

    private NetSqlca[] parseSQLDIAGGRP() throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            return null;
        }
        this.parseSQLDIAGSTT();
        NetSqlca[] sqlca = this.parseSQLDIAGCI();
        this.parseSQLDIAGCN();
        return sqlca;
    }

    private void parseSQLDIAGSTT() throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("0A000.C.6"), "parseSQLDIAGSTT"));
    }

    private NetSqlca[] parseSQLDIAGCI() throws DisconnectException, SqlException {
        int num = this.readFdocaTwoByteLength();
        NetSqlca[] ret_val = null;
        if (num != 0) {
            ret_val = new NetSqlca[num];
        }
        for (int i = 0; i < num; ++i) {
            ret_val[i] = this.parseSQLDCROW();
        }
        return ret_val;
    }

    private void parseSQLDIAGCN() throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("0A000.C.6"), "parseSQLDIAGCN"));
    }

    private NetSqlca parseSQLDCGRP() throws DisconnectException, SqlException {
        int sqldcCode = this.readFdocaInt();
        String sqldcState = this.readFdocaString(5, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        int sqldcReason = this.readFdocaInt();
        this.skipFdocaBytes(12);
        NetSqlca sqlca = new NetSqlca((ClientConnection)this.netAgent_.netConnection_, sqldcCode, sqldcState, (byte[])null);
        this.skipFdocaBytes(49);
        this.parseSQLDCTOKS();
        String sqldcMsg = this.parseVCS(this.qrydscTypdef_);
        if (sqldcMsg != null) {
            sqlca.setSqlerrmcBytes(sqldcMsg.getBytes());
        }
        this.skipFdocaBytes(12);
        this.parseSQLDCXGRP();
        return sqlca;
    }

    private NetSqlca parseSQLDCROW() throws DisconnectException, SqlException {
        return this.parseSQLDCGRP();
    }

    private void parseSQLDCTOKS() throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("0A000.C.6"), "parseSQLDCTOKS"));
    }

    private void parseSQLDCXGRP() throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("0A000.C.6"), "parseSQLDCXGRP"));
    }

    private String parseVCS(Typdef typdefInEffect) throws DisconnectException, SqlException {
        return this.readFdocaString(this.readFdocaTwoByteLength(), typdefInEffect.getCcsidSbcEncoding());
    }

    private String readFdocaString(int length, Charset encoding) throws SqlException {
        if (length == 0) {
            return null;
        }
        this.checkForSplitRowAndComplete(length);
        String s = new String(this.dataBuffer_, this.position_, length, encoding);
        this.position_ += length;
        return s;
    }

    void allocateColumnOffsetAndLengthArrays() {
        this.columnDataPosition_ = new int[this.columns_];
        this.columnDataComputedLength_ = new int[this.columns_];
        this.isNull_ = new boolean[this.columns_];
    }

    private byte[] findExtdtaData(int column) {
        byte[] data = null;
        Integer extdtaQueuePosition = this.extdtaPositions_.get(column);
        if (extdtaQueuePosition != null) {
            data = this.extdtaData_.get(extdtaQueuePosition);
        }
        return data;
    }

    @Override
    protected int locator(int column) {
        int locator = this.get_INTEGER(column);
        if (locator == 32768 || locator == 32770 || locator == 32772 || locator == 32774 || locator == 32776 || locator == 0) {
            return -1;
        }
        return locator;
    }

    @Override
    public ClientBlob getBlobColumn_(int column, Agent agent, boolean toBePublished) throws SqlException {
        int locator;
        if (toBePublished && this.netResultSet_ != null) {
            this.netResultSet_.markLOBAsPublished(column);
        }
        if ((locator = this.locator(column)) > 0) {
            return new ClientBlob(agent, locator);
        }
        int index = column - 1;
        ClientBlob blob = null;
        byte[] data = this.findExtdtaData(column);
        if (data != null) {
            int dataOffset = !this.nullable_[index] ? 0 : 1;
            blob = new ClientBlob(data, agent, dataOffset);
        } else {
            blob = new ClientBlob(new byte[0], agent, 0);
        }
        return blob;
    }

    @Override
    public ClientClob getClobColumn_(int column, Agent agent, boolean toBePublished) throws SqlException {
        int locator;
        if (toBePublished && this.netResultSet_ != null) {
            this.netResultSet_.markLOBAsPublished(column);
        }
        if ((locator = this.locator(column)) > 0) {
            return new ClientClob(agent, locator);
        }
        int index = column - 1;
        ClientClob clob = null;
        byte[] data = this.findExtdtaData(column);
        if (data != null) {
            int dataOffset = !this.nullable_[index] ? 0 : 1;
            clob = new ClientClob(agent, data, this.charset_[index], dataOffset);
        } else {
            clob = new ClientClob(agent, "");
        }
        return clob;
    }

    void initializeColumnInfoArrays(Typdef typdef, int columnCount) throws DisconnectException {
        this.qrydscTypdef_ = typdef;
        this.setNumberOfColumns(columnCount);
        this.fdocaLength_ = new int[columnCount];
        this.isGraphic_ = new boolean[columnCount];
        this.typeToUseForComputingDataLength_ = new int[columnCount];
    }

    @Override
    protected void getMoreData_() throws SqlException {
        if (this.netResultSet_.resultSetType_ == 1003) {
            this.resetDataBuffer();
        }
        this.netResultSet_.flowFetch();
    }

    @Override
    public void nullDataForGC() {
        super.nullDataForGC();
        this.qrydscTypdef_ = null;
        this.typeToUseForComputingDataLength_ = null;
        this.isGraphic_ = null;
        if (this.extdtaPositions_ != null) {
            this.extdtaPositions_.clear();
        }
        this.extdtaPositions_ = null;
        if (this.extdtaData_ != null) {
            this.extdtaData_.clear();
        }
        this.extdtaData_ = null;
    }

    private void checkForSplitRowAndComplete(int length, int index) throws SqlException {
        while (this.position_ + length > this.lastValidBytePosition_) {
            this.checkAndThrowReceivedEndqryrm();
            int lastValidByteBeforeFetch = this.completeSplitRow(index);
            this.checkAndThrowReceivedEndqryrm(lastValidByteBeforeFetch);
        }
    }

    private void checkForSplitRowAndComplete(int length) throws SqlException {
        this.checkForSplitRowAndComplete(length, -1);
    }

    private void checkAndThrowReceivedEndqryrm() throws SqlException {
        if (!this.netResultSet_.openOnServer_) {
            SqlException sqlException = null;
            int sqlcode = Utils.getSqlcodeFromSqlca(this.netResultSet_.queryTerminatingSqlca_);
            sqlException = sqlcode < 0 ? new SqlException(this.agent_.logWriter_, this.netResultSet_.queryTerminatingSqlca_) : new SqlException(this.agent_.logWriter_, new ClientMessageId("XN008.S"), new Object[0]);
            try {
                this.netResultSet_.closeX();
            }
            catch (SqlException e) {
                sqlException.setNextException(e);
            }
            throw sqlException;
        }
    }

    private void checkAndThrowReceivedEndqryrm(int lastValidBytePositionBeforeFetch) throws SqlException {
        if (this.lastValidBytePosition_ > lastValidBytePositionBeforeFetch) {
            return;
        }
        this.checkAndThrowReceivedEndqryrm();
    }

    private int completeSplitRow(int index) throws DisconnectException, SqlException {
        int lastValidBytePositionBeforeFetch = 0;
        if (this.netResultSet_ != null && this.netResultSet_.scrollable_) {
            lastValidBytePositionBeforeFetch = this.lastValidBytePosition_;
            this.netResultSet_.flowFetchToCompleteRowset();
        } else {
            this.shiftPartialRowToBeginning();
            this.adjustColumnOffsetsForColumnsPreviouslyCalculated(index);
            this.resetCurrentRowPosition();
            lastValidBytePositionBeforeFetch = this.lastValidBytePosition_;
            this.netResultSet_.flowFetch();
        }
        return lastValidBytePositionBeforeFetch;
    }

    private int[] allocateColumnDataPositionArray(int row) {
        int[] columnDataPosition;
        if (this.columnDataPositionCache_.size() == row) {
            columnDataPosition = new int[this.columns_];
            this.columnDataPositionCache_.add(columnDataPosition);
        } else {
            columnDataPosition = (int[])this.columnDataPositionCache_.get(row);
        }
        return columnDataPosition;
    }

    private int[] allocateColumnDataComputedLengthArray(int row) {
        int[] columnDataComputedLength;
        if (this.columnDataLengthCache_.size() == row) {
            columnDataComputedLength = new int[this.columns_];
            this.columnDataLengthCache_.add(columnDataComputedLength);
        } else {
            columnDataComputedLength = (int[])this.columnDataLengthCache_.get(row);
        }
        return columnDataComputedLength;
    }

    private boolean[] allocateColumnDataIsNullArray(int row) {
        boolean[] columnDataIsNull;
        if (this.columnDataIsNullCache_.size() <= row) {
            columnDataIsNull = new boolean[this.columns_];
            this.columnDataIsNullCache_.add(columnDataIsNull);
        } else {
            columnDataIsNull = (boolean[])this.columnDataIsNullCache_.get(row);
        }
        return columnDataIsNull;
    }

    protected int getDecimalLength(int index) {
        return ((this.fdocaLength_[index] >> 8 & 0xFF) + 2) / 2;
    }

    @Override
    public final void setAllRowsReceivedFromServer(boolean b) {
        if (b && this.qryclsimpEnabled_) {
            this.netResultSet_.markClosedOnServer();
        }
        super.setAllRowsReceivedFromServer(b);
    }

    final void setQryclsimpEnabled(boolean flag) {
        this.qryclsimpEnabled_ = flag;
    }

    final boolean getQryclsimpEnabled() {
        return this.qryclsimpEnabled_;
    }
}

