/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

class DropDatabaseSetup
extends BaseTestSetup {
    private final String logicalDBName;
    private final boolean shutdownBeforeDrop;

    DropDatabaseSetup(Test test, String logicalDBName) {
        this(test, logicalDBName, true);
    }

    DropDatabaseSetup(Test test, String logicalDBName, boolean shutdown2) {
        super(test);
        this.logicalDBName = logicalDBName;
        this.shutdownBeforeDrop = shutdown2;
    }

    protected void tearDown() throws Exception {
        if (this.shutdownBeforeDrop) {
            this.shutdownDatabase();
        }
        this.removeDatabase();
    }

    private void shutdownDatabase() throws SQLException {
        boolean shutdown2;
        TestConfiguration config = TestConfiguration.getCurrent();
        try {
            config.openConnection(this.logicalDBName).close();
            shutdown2 = true;
        }
        catch (SQLException e) {
            String sqlState = e.getSQLState();
            if ("XJ040".equals(sqlState) || "08004".equals(sqlState) || "4251I".equals(sqlState)) {
                shutdown2 = false;
            }
            throw e;
        }
        if (shutdown2) {
            DataSource ds = JDBCDataSource.getDataSourceLogical(this.logicalDBName);
            JDBCDataSource.shutdownDatabase(ds);
        }
    }

    void removeDatabase() {
        TestConfiguration config = TestConfiguration.getCurrent();
        Object dbName = config.getPhysicalDatabaseName(this.logicalDBName);
        dbName = ((String)dbName).replace('/', File.separatorChar);
        String dsh = BaseTestCase.getSystemProperty("derby.system.home");
        if (dsh == null) {
            DropDatabaseSetup.fail((String)"not implemented");
        } else {
            dbName = dsh + File.separator + (String)dbName;
        }
        DropDatabaseSetup.removeDirectory((String)dbName);
        String logDevice = config.getConnectionAttributes().getProperty("logDevice");
        if (logDevice != null) {
            DropDatabaseSetup.removeDirectory(logDevice);
        }
    }

    static void removeDirectory(String path) {
        File dir = new File(path);
        DropDatabaseSetup.removeDirectory(dir);
    }

    static void removeDirectory(File dir) {
        if (!PrivilegedFileOpsForTests.exists(dir)) {
            return;
        }
        BaseTestCase.assertDirectoryDeleted(dir);
    }

    static void removeFiles(String[] list) {
        for (int i = 0; i < list.length; ++i) {
            try {
                File dfile = new File(list[i].toString());
                DropDatabaseSetup.assertTrue((String)list[i].toString(), (boolean)dfile.delete());
                continue;
            }
            catch (IllegalArgumentException e) {
                DropDatabaseSetup.fail((String)"open file error");
            }
        }
    }
}

