/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests.helpers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.IndexStatsUtil;

public class DisposableIndexStatistics {
    private static final int ROW_COUNT = 2000;
    private final DerbyVersion oldVersion;
    private final Connection con;
    private final String tbl;
    private final String fktbl;
    private final String pktbl;

    public DisposableIndexStatistics(DerbyVersion oldVersion, Connection con, String tableName) {
        this.oldVersion = oldVersion;
        this.con = con;
        this.tbl = tableName;
        this.fktbl = tableName + "_FK";
        this.pktbl = tableName + "_PK_2COL";
    }

    public void createAndPopulateTables() throws SQLException {
        this.con.setAutoCommit(true);
        Statement stmt = this.con.createStatement();
        stmt.executeUpdate("create table " + this.pktbl + "( id1 int generated always as identity, id2 int not null)");
        stmt.executeUpdate("create table " + this.fktbl + "( id int not null generated always as identity)");
        stmt.executeUpdate("create table " + this.tbl + "( id int not null generated always as identity, fk_dropped int not null, fk_self int, fk_self_notnull int not null, nonunique int)");
        this.insertData(this.con);
        IndexStatsUtil stats = new IndexStatsUtil(this.con);
        stmt.executeUpdate("alter table " + this.pktbl + " add constraint PK_TWOCOL_PKTAB primary key (id1, id2)");
        stats.getStatsTable(this.pktbl, 2);
        stmt.executeUpdate("alter table " + this.fktbl + " add constraint PK_FKTAB primary key (id)");
        stats.getStatsTable(this.fktbl, 1);
        stmt.executeUpdate("alter table " + this.tbl + " add constraint PK_MAIN primary key (id)");
        stats.getStatsTable(this.tbl, 1);
        stmt.executeUpdate("create index DUPS_MAIN on " + this.tbl + "(nonunique)");
        stats.getStatsTable(this.tbl, 2);
        stmt.executeUpdate("alter table " + this.tbl + " add constraint FKS_MAIN foreign key (fk_self) references " + this.tbl + "(id)");
        stats.getStatsTable(this.tbl, 3);
        stmt.executeUpdate("alter table " + this.tbl + " add constraint FKSNN_MAIN foreign key (fk_self_notnull) references " + this.tbl + "(id)");
        stats.getStatsTable(this.tbl, 4);
        int preFkAddition = stats.getStatsTable(this.tbl).length;
        stmt.executeUpdate("alter table " + this.tbl + " add constraint fk_to_be_dropped foreign key (fk_dropped) references " + this.fktbl + "(id)");
        Assert.assertTrue((stats.getStatsTable(this.tbl).length == preFkAddition + 1 ? 1 : 0) != 0);
        stmt.executeUpdate("alter table " + this.tbl + " drop constraint fk_to_be_dropped");
        Assert.assertTrue((stats.getStatsTable(this.tbl).length == preFkAddition ? 1 : 0) != 0);
        stmt.executeUpdate("alter table " + this.tbl + " add constraint fk_on_pk foreign key (id) references " + this.fktbl + "(id)");
        stmt.executeUpdate("call syscs_util.syscs_update_statistics('APP', '" + this.tbl + "', null)");
        Assert.assertTrue((stats.getStatsTable(this.tbl).length == preFkAddition + 1 ? 1 : 0) != 0);
        stmt.executeUpdate("alter table " + this.tbl + " drop constraint fk_on_pk");
        int tableStatsCount = stats.getStatsTable(this.tbl).length;
        if (DisposableIndexStatistics.hasDerby5681Bug(this.oldVersion)) {
            Assert.assertEquals((int)(preFkAddition + 1), (int)tableStatsCount);
        } else {
            Assert.assertEquals((int)preFkAddition, (int)tableStatsCount);
        }
        int max = DisposableIndexStatistics.getNumTotalPossibleStats();
        int min = max - (DisposableIndexStatistics.getNumNotNeededDisposableStats() + DisposableIndexStatistics.getNumOrphanedDisposableStats());
        int cur = this.getAllRelevantStats(null);
        Assert.assertTrue((String)("cur=" + cur + ", min=" + min), (cur >= min ? 1 : 0) != 0);
        Assert.assertTrue((String)("cur=" + cur + ", max=" + max), (cur <= max ? 1 : 0) != 0);
    }

    private void insertData(Connection con) throws SQLException {
        int row;
        boolean oldAutoCommitValue = con.getAutoCommit();
        con.setAutoCommit(false);
        PreparedStatement ps = con.prepareStatement("insert into " + this.fktbl + " values (DEFAULT)");
        for (row = 0; row < 2000; ++row) {
            ps.executeUpdate();
        }
        ps.close();
        con.commit();
        ps = con.prepareStatement("insert into " + this.pktbl + " values (DEFAULT, ?)");
        for (row = 0; row < 2000; ++row) {
            ps.setInt(1, row);
            ps.executeUpdate();
        }
        ps.close();
        con.commit();
        ps = con.prepareStatement("insert into " + this.tbl + " values (DEFAULT,?,?,?,?)");
        for (row = 0; row < 2000; ++row) {
            ps.setInt(1, row % 2000 + 1);
            ps.setInt(2, row % 2000 + 1);
            ps.setInt(3, row % 19 + 1);
            ps.setInt(4, row % 10);
            ps.executeUpdate();
        }
        ps.close();
        con.commit();
        con.setAutoCommit(oldAutoCommitValue);
    }

    public String[] getTableNames() {
        return new String[]{this.tbl, this.fktbl, this.pktbl};
    }

    public void assertStatsCount(boolean orphaned_disposedOf, boolean notneeded_disposedOf) throws SQLException {
        ArrayList<IndexStatsUtil.IdxStats> entries;
        int found;
        int expected = DisposableIndexStatistics.getNumTotalPossibleStats();
        if (!DisposableIndexStatistics.hasDerby5681Bug(this.oldVersion)) {
            expected -= DisposableIndexStatistics.getNumOrphanedDisposableStats();
        } else if (orphaned_disposedOf) {
            expected -= DisposableIndexStatistics.getNumOrphanedDisposableStats();
        }
        if (notneeded_disposedOf) {
            expected -= DisposableIndexStatistics.getNumNotNeededDisposableStats();
        }
        if ((found = this.getAllRelevantStats(entries = new ArrayList<IndexStatsUtil.IdxStats>())) != expected) {
            Assert.assertEquals((String)IndexStatsUtil.buildStatString(this.getStatArray(entries), "DisposableIndexStatistics tables"), (int)expected, (int)found);
        }
    }

    private IndexStatsUtil.IdxStats[] getStatArray(List<IndexStatsUtil.IdxStats> list) {
        return list.toArray(new IndexStatsUtil.IdxStats[list.size()]);
    }

    private int getAllRelevantStats(List<IndexStatsUtil.IdxStats> list) throws SQLException {
        boolean oldAutoCommitValue = this.con.getAutoCommit();
        this.con.setAutoCommit(true);
        IndexStatsUtil stats = new IndexStatsUtil(this.con);
        String[] tables = this.getTableNames();
        int count = 0;
        for (int i = 0; i < tables.length; ++i) {
            IndexStatsUtil.IdxStats[] entries = stats.getStatsTable(tables[i]);
            if (list != null) {
                list.addAll(Arrays.asList(entries));
            }
            count += entries.length;
        }
        stats.release(false);
        this.con.setAutoCommit(oldAutoCommitValue);
        return count;
    }

    public static int getNumTotalPossibleStats() {
        return 8;
    }

    public static int getNumNotNeededDisposableStats() {
        return 2;
    }

    public static int getNumOrphanedDisposableStats() {
        return 1;
    }

    public static boolean hasDerby5681Bug(DerbyVersion oldVersion) {
        if (oldVersion.atLeast(DerbyVersion._10_9)) {
            return false;
        }
        if (oldVersion.atMajorMinor(10, 8)) {
            return !oldVersion.greaterThan(DerbyVersion._10_8_2_2);
        }
        if (oldVersion.atMajorMinor(10, 7)) {
            return !oldVersion.greaterThan(DerbyVersion._10_7_1_1);
        }
        if (oldVersion.atMajorMinor(10, 6)) {
            return !oldVersion.greaterThan(DerbyVersion._10_6_2_1);
        }
        if (oldVersion.atMajorMinor(10, 5)) {
            return !oldVersion.greaterThan(DerbyVersion._10_5_3_0);
        }
        throw new IllegalStateException("didn't expect to get here, old version is " + oldVersion);
    }
}

