/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLFeatureNotSupportedException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Driver;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Driver40UnbootedTest
extends BaseJDBCTestCase {
    private static final String SUCCESS = "Success";

    public Driver40UnbootedTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("DriverTest tests java.sql.Driver, not supported with JSR169");
        }
        Test test = TestConfiguration.embeddedSuite(Driver40UnbootedTest.class);
        return SecurityManagerSetup.noSecurityManager(test);
    }

    public static void main(String[] args) throws Exception {
        Object statusMessage;
        block2: {
            Driver embeddedDriver = DriverManager.getDriver("jdbc:derby:");
            Wrapper41Driver embeddedWrapper = new Wrapper41Driver(embeddedDriver);
            statusMessage = SUCCESS;
            try {
                embeddedWrapper.getParentLogger();
                statusMessage = "getParentLogger() unexpectedly succeeded";
            }
            catch (Exception se) {
                if (se instanceof SQLFeatureNotSupportedException) break block2;
                statusMessage = "Exception was not a SQLFeatureNotSupportedException. It was a " + se.getClass().getName();
            }
        }
        System.out.print((String)statusMessage);
    }

    public void test_notBooted() throws Exception {
        this.getTestConfiguration();
        if (!TestConfiguration.loadingFromJars()) {
            return;
        }
        String[] command = new String[]{"-Demma.verbosity.level=silent", ((Object)((Object)this)).getClass().getName()};
        Process process = Driver40UnbootedTest.execJavaCmd(command);
        SpawnedProcess spawned = new SpawnedProcess(process, "UnbootedTest");
        Driver40UnbootedTest.assertEquals((int)0, (int)spawned.complete());
        Driver40UnbootedTest.assertEquals((String)SUCCESS, (String)spawned.getFullServerOutput());
    }
}

