/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derby.jdbc.BasicClientDataSource40;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SimplePerfTest
extends BaseJDBCTestCase {
    private static String dbPath = "UNDEFINED!";
    private static String masterHostName = "UNDEFINED!";
    private static int masterPortNo = -1;
    private static int tuplesToInsert = 0;
    private static int commitFreq = 0;

    public SimplePerfTest(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() throws Exception {
        masterHostName = System.getProperty("test.serverHost", "localhost");
        masterPortNo = Integer.parseInt(System.getProperty("test.serverPort", "1527"));
        dbPath = System.getProperty("test.dbPath", "wombat");
        BaseTestSuite suite = new BaseTestSuite("SimplePerfTest");
        tuplesToInsert = Integer.parseInt(System.getProperty("test.inserts", "1000"));
        commitFreq = Integer.parseInt(System.getProperty("test.commitFreq", "0"));
        suite.addTest(SimplePerfTest.suite(masterHostName, masterPortNo, dbPath));
        return suite;
    }

    public static Test suite(String serverHost, int serverPort, String dbPath) {
        Test t = TestConfiguration.existingServerSuite(SimplePerfTest.class, false, serverHost, serverPort, dbPath);
        return SecurityManagerSetup.noSecurityManager(t);
    }

    public void testInserts() throws SQLException, IOException, InterruptedException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Object vc = "";
        for (int i = 0; i < 20000; ++i) {
            vc = (String)vc + "a";
        }
        Connection conn = this.clientConnection(masterHostName, masterPortNo, dbPath);
        Statement s = conn.createStatement();
        try {
            s.executeUpdate("drop table t");
        }
        catch (SQLException ignore) {
            System.out.println("'drop table t' caused: " + ignore.getMessage());
        }
        s.executeUpdate("create table t (i integer primary key, vc varchar(20100))");
        PreparedStatement pSt = conn.prepareStatement("insert into t values (?,?)");
        conn.setAutoCommit(commitFreq == 0);
        for (int i = 0; i < tuplesToInsert; ++i) {
            pSt.setInt(1, i);
            pSt.setString(2, (String)vc + i);
            try {
                pSt.execute();
            }
            catch (Exception e) {
                System.out.println("Exception when inserting: " + e.getMessage());
                return;
            }
            if (commitFreq == 0 || i % commitFreq != 0) continue;
            System.out.println("i: " + i);
            conn.commit();
        }
        conn.commit();
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        System.out.println("count: " + count);
    }

    public void verifyTestInserts() throws SQLException, IOException, InterruptedException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Connection conn = this.clientConnection(masterHostName, masterPortNo, dbPath);
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
    }

    private Connection clientConnection(String hostName, int portNo, String dbPath) throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        BasicClientDataSource40 ds;
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            ds = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            ds = new BasicClientDataSource40();
        }
        ds.setDatabaseName(dbPath);
        ds.setServerName(hostName);
        ds.setPortNumber(portNo);
        return ds.getConnection();
    }
}

