/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.TimeZone;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestSetup;

public class TimeZoneTestSetup
extends BaseTestSetup {
    private TimeZone savedDefault;
    private TimeZone requestedDefault;

    public TimeZoneTestSetup(Test test, String string) {
        this(test, TimeZone.getTimeZone(string));
    }

    public TimeZoneTestSetup(Test test, TimeZone timeZone) {
        super(test);
        this.requestedDefault = timeZone;
    }

    protected void setUp() {
        this.savedDefault = TimeZone.getDefault();
        TimeZoneTestSetup.setDefault(this.requestedDefault);
    }

    protected void tearDown() {
        TimeZoneTestSetup.setDefault(this.savedDefault);
        this.savedDefault = null;
        this.requestedDefault = null;
    }

    public static void setDefault(final TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("tz cannot be <null>");
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                TimeZone.setDefault(timeZone);
                return null;
            }
        });
    }
}

