/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;

public class BackupPathTests {
    public static void main(String[] stringArray) throws Throwable {
        try {
            ij.getPropertyArg((String[])stringArray);
            Connection connection = ij.startJBMS();
            connection.setAutoCommit(true);
            Statement statement = connection.createStatement();
            statement.execute("call sqlj.install_jar('extin/brtestjar.jar', 'math_routines', 0)");
            statement.close();
            BackupPathTests.logMsg("Begin Backup Path Tests");
            String string = System.getProperty("derby.system.home");
            String string2 = string + File.separator + "wombat";
            BackupPathTests.logMsg("case1 : try Backup with backup path as database dir");
            try {
                BackupPathTests.performBackup(connection, string2);
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("XSRSC")) {
                    BackupPathTests.logMsg("Backup in to a database dir failed");
                }
                throw sQLException;
            }
            BackupPathTests.logMsg("End test case1");
            BackupPathTests.logMsg("case2 : Backup with backup path as database jar dir");
            String string3 = string2 + File.separator + "jar";
            BackupPathTests.performBackup(connection, string3);
            BackupPathTests.logMsg("End test case 2");
            BackupPathTests.logMsg("case 3: Backup again into the same db jar dir location");
            BackupPathTests.performBackup(connection, string3);
            BackupPathTests.logMsg("End test case 3");
            BackupPathTests.logMsg("case 4: Backup using an absolute path");
            String string4 = new File("extinout/backupPathTests").getAbsolutePath();
            BackupPathTests.performBackup(connection, string4);
            BackupPathTests.logMsg("End test case 4");
            connection.close();
            BackupPathTests.logMsg("End Backup Path Tests");
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }

    private static void performBackup(Connection connection, String string) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        callableStatement.setString(1, string);
        callableStatement.execute();
        callableStatement.close();
    }

    private static void logMsg(String string) {
        System.out.println(string);
    }
}

