/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class SysDiagVTIMappingTest
extends BaseJDBCTestCase {
    private static final String testLogFile = "sys_vti_test_derby.tstlog";
    private static final String[] ALL_SPACE_TABLE_COLUMNS = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING", "TABLEID"};
    private static final String BAD_FROM_LIST_JOIN = "42ZB7";

    public SysDiagVTIMappingTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Diagnostic VTI Table Mappings");
        Test test = TestConfiguration.defaultSuite(SysDiagVTIMappingTest.class);
        Properties properties = new Properties();
        properties.put("derby.language.logStatementText", "true");
        SystemPropertyTestSetup systemPropertyTestSetup = new SystemPropertyTestSetup(test, properties);
        baseTestSuite.addTest((Test)systemPropertyTestSetup);
        return SecurityManagerSetup.noSecurityManager((Test)new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/tests/lang/sys_vti_test_derby.tstlog"}));
    }

    public void setUp() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table app.t1 (i int, c varchar(10))");
        statement.execute("insert into app.t1 values (1, 'one'), (2, 'two'), (4, 'four')");
        statement.close();
    }

    @Override
    public void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("drop table app.t1");
        statement.close();
        super.tearDown();
    }

    public void testSpaceTable() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set schema APP");
        SysDiagVTIMappingTest.assertStatementError("42ZB4", statement, "select * from TABLE(SPACE_TABLE('APP')) x");
        SysDiagVTIMappingTest.assertStatementError("42ZB4", statement, "select * from TABLE(APP.SPACE_TABLE('APP', 'T1')) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "select * from TABLE TABLE(SYSCS_DIAG.SPACE_TABLE('T1')) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "select * from TABLE TABLE (select * from t1) x");
        SysDiagVTIMappingTest.assertStatementError("42Y07", statement, "select * from TABLE(SYSCS_DIAG.SPACE_TABLE('T1', 'APP')) x");
        SysDiagVTIMappingTest.assertStatementError("42Y07", statement, "select * from TABLE(SYSCS_DIAG.SPACE_TABLE('NOTTHERE', 'T1')) x");
        statement.executeUpdate("set schema SYSCS_DIAG");
        SysDiagVTIMappingTest.assertStatementError("42ZB4", statement, "select * from TABLE(APP.SPACE_TABLE('APP', 'T1')) x");
        statement.executeUpdate("set schema APP");
        ResultSet resultSet = statement.executeQuery("select t.tableid from sys.systables t, sys.sysschemas s\nwhere t.schemaid = s.schemaid\nand s.schemaname = 'APP'\nand t.tablename = 'T1'");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        ResultSet resultSet2 = statement.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'T1')) x");
        String[] stringArray = ALL_SPACE_TABLE_COLUMNS;
        JDBC.assertColumnNames(resultSet2, stringArray);
        Object[][] objectArray = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", string}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement.executeQuery(" select * from TABLE(SYSCS_DIAG.SPACE_TABLE('T1')) x");
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", string}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        PreparedStatement preparedStatement = this.prepareStatement("select * from TABLE(SYSCS_DIAG.SPACE_TABLE(?, ?)) x");
        preparedStatement.setString(1, "APP");
        preparedStatement.setString(2, "T1");
        resultSet2 = preparedStatement.executeQuery();
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", string}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        preparedStatement = this.prepareStatement("select * from TABLE(SYSCS_DIAG.SPACE_TABLE(?)) x");
        preparedStatement.setString(1, "T1");
        resultSet2 = preparedStatement.executeQuery();
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", string}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('APP')) x");
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertDrainResults(resultSet2, 0);
        resultSet2 = statement.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'NOTTHERE')) x");
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertDrainResults(resultSet2, 0);
        resultSet2 = statement.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('SYSCS_DIAG', 'NOTTHERE')) x");
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertDrainResults(resultSet2, 0);
        resultSet2 = statement.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('SYSCS_DIAG', 'LOCK_TABLE')) x");
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertDrainResults(resultSet2, 0);
        statement.executeUpdate("set schema syscs_diag");
        preparedStatement = this.prepareStatement("select * from TABLE(SPACE_TABLE(?, ?)) x");
        preparedStatement.setString(1, "APP");
        preparedStatement.setString(2, "T1");
        resultSet2 = preparedStatement.executeQuery();
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", string}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        preparedStatement = this.prepareStatement("select * from TABLE(SPACE_TABLE(?)) x");
        preparedStatement.setString(1, "T1");
        resultSet2 = preparedStatement.executeQuery();
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertDrainResults(resultSet2, 0);
        resultSet2 = statement.executeQuery("select * from TABLE(SPACE_TABLE('LOCK_TABLE')) x");
        JDBC.assertColumnNames(resultSet2, stringArray);
        JDBC.assertDrainResults(resultSet2, 0);
        statement.executeUpdate("set schema app");
        resultSet2 = statement.executeQuery("select cast (conglomeratename as varchar(30)), t1.* from  TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'T1')) x,  t1 where x.conglomeratename is not null");
        stringArray = new String[]{"1", "I", "C"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        objectArray = new String[][]{{"T1", "1", "one"}, {"T1", "2", "two"}, {"T1", "4", "four"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement.executeUpdate("set schema APP");
        resultSet2 = statement.executeQuery("SELECT * FROM NEW org.apache.derby.diag.SpaceTable('T1') as x");
        JDBC.assertColumnNames(resultSet2, ALL_SPACE_TABLE_COLUMNS);
        objectArray = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", string}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement.executeQuery("SELECT * FROM NEW org.apache.derby.diag.SpaceTable('APP', 'T1') as x");
        JDBC.assertColumnNames(resultSet2, ALL_SPACE_TABLE_COLUMNS);
        objectArray = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", string}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement.executeQuery("select t2.*\n    from\n        sys.systables systabs,\n        table (syscs_diag.space_table()) as t2\n    where systabs.tabletype = 'T'\n    and systabs.tableid = t2.tableid\n");
        JDBC.assertColumnNames(resultSet2, ALL_SPACE_TABLE_COLUMNS);
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement.executeQuery("select t1.*\n    from\n        sys.systables systabs1,\n        table (syscs_diag.space_table( systabs1.tablename )) as t1\n    where systabs1.tabletype = 'T'\nunion\nselect t2.*\n    from\n        sys.systables systabs2,\n        table (syscs_diag.space_table( systabs2.tablename )) as t2\n    where systabs2.tabletype = 'T'\n");
        JDBC.assertColumnNames(resultSet2, ALL_SPACE_TABLE_COLUMNS);
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement.executeQuery("select t2.*\n    from\n        sys.systables systabs,\n        table (syscs_diag.space_table(systabs.tablename)) as t2,\n        sys.sysconglomerates syscgs\n    where systabs.tabletype = 'T' and systabs.tableid = syscgs.tableid\n");
        JDBC.assertColumnNames(resultSet2, ALL_SPACE_TABLE_COLUMNS);
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        resultSet2 = statement.executeQuery("select t2.*\n    from\n        sys.sysconglomerates syscgs,\n        table (syscs_diag.space_table(systabs.tablename)) as t2,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = syscgs.tableid\n");
        JDBC.assertColumnNames(resultSet2, ALL_SPACE_TABLE_COLUMNS);
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        this.checkIllegalUses(statement, "space_table", "SpaceTable", "('APP', 'T1')", "conglomeratename");
        this.getConnection().rollback();
        statement.close();
    }

    public void testSpaceTable_0argConstructor() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select conglomeratename, isindex, pagesize, tableid\nfrom table(syscs_diag.space_table()) x\nwhere conglomeratename like 'SYS%'\norder by conglomeratename");
        String[] stringArray = new String[]{"CONGLOMERATENAME", "ISINDEX", "PAGESIZE", "TABLEID"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"SYSALIASES", "0", "4096", "c013800d-00d7-ddbd-08ce-000a0a411400"}, {"SYSALIASES_INDEX1", "1", "4096", "c013800d-00d7-ddbd-08ce-000a0a411400"}, {"SYSALIASES_INDEX2", "1", "4096", "c013800d-00d7-ddbd-08ce-000a0a411400"}, {"SYSALIASES_INDEX3", "1", "4096", "c013800d-00d7-ddbd-08ce-000a0a411400"}, {"SYSCHECKS", "0", "4096", "80000056-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCHECKS_INDEX1", "1", "4096", "80000056-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCOLPERMS", "0", "4096", "286cc01e-0103-0e39-b8e7-00000010f010"}, {"SYSCOLPERMS_INDEX1", "1", "4096", "286cc01e-0103-0e39-b8e7-00000010f010"}, {"SYSCOLPERMS_INDEX2", "1", "4096", "286cc01e-0103-0e39-b8e7-00000010f010"}, {"SYSCOLPERMS_INDEX3", "1", "4096", "286cc01e-0103-0e39-b8e7-00000010f010"}, {"SYSCOLUMNS", "0", "4096", "8000001e-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCOLUMNS_INDEX1", "1", "4096", "8000001e-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCOLUMNS_INDEX2", "1", "4096", "8000001e-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONGLOMERATES", "0", "4096", "80000010-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONGLOMERATES_INDEX1", "1", "4096", "80000010-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONGLOMERATES_INDEX2", "1", "4096", "80000010-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONGLOMERATES_INDEX3", "1", "4096", "80000010-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONSTRAINTS", "0", "4096", "8000002f-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONSTRAINTS_INDEX1", "1", "4096", "8000002f-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONSTRAINTS_INDEX2", "1", "4096", "8000002f-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONSTRAINTS_INDEX3", "1", "4096", "8000002f-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSDEPENDS", "0", "4096", "8000003e-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSDEPENDS_INDEX1", "1", "4096", "8000003e-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSDEPENDS_INDEX2", "1", "4096", "8000003e-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSDUMMY1", "0", "4096", "c013800d-00f8-5b70-bea3-00000019ed88"}, {"SYSFILES", "0", "4096", "80000000-00d3-e222-873f-000a0a0b1900"}, {"SYSFILES_INDEX1", "1", "4096", "80000000-00d3-e222-873f-000a0a0b1900"}, {"SYSFILES_INDEX2", "1", "4096", "80000000-00d3-e222-873f-000a0a0b1900"}, {"SYSFOREIGNKEYS", "0", "4096", "8000005b-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSFOREIGNKEYS_INDEX1", "1", "4096", "8000005b-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSFOREIGNKEYS_INDEX2", "1", "4096", "8000005b-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSKEYS", "0", "4096", "80000039-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSKEYS_INDEX1", "1", "4096", "80000039-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSPERMS", "0", "4096", "9810800c-0121-c5e1-a2f5-00000043e718"}, {"SYSPERMS_INDEX1", "1", "4096", "9810800c-0121-c5e1-a2f5-00000043e718"}, {"SYSPERMS_INDEX2", "1", "4096", "9810800c-0121-c5e1-a2f5-00000043e718"}, {"SYSPERMS_INDEX3", "1", "4096", "9810800c-0121-c5e1-a2f5-00000043e718"}, {"SYSROLES", "0", "4096", "e03f4017-0115-382c-08df-ffffe275b270"}, {"SYSROLES_INDEX1", "1", "4096", "e03f4017-0115-382c-08df-ffffe275b270"}, {"SYSROLES_INDEX2", "1", "4096", "e03f4017-0115-382c-08df-ffffe275b270"}, {"SYSROLES_INDEX3", "1", "4096", "e03f4017-0115-382c-08df-ffffe275b270"}, {"SYSROUTINEPERMS", "0", "4096", "2057c01b-0103-0e39-b8e7-00000010f010"}, {"SYSROUTINEPERMS_INDEX1", "1", "4096", "2057c01b-0103-0e39-b8e7-00000010f010"}, {"SYSROUTINEPERMS_INDEX2", "1", "4096", "2057c01b-0103-0e39-b8e7-00000010f010"}, {"SYSROUTINEPERMS_INDEX3", "1", "4096", "2057c01b-0103-0e39-b8e7-00000010f010"}, {"SYSSCHEMAS", "0", "4096", "80000022-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSSCHEMAS_INDEX1", "1", "4096", "80000022-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSSCHEMAS_INDEX2", "1", "4096", "80000022-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSSEQUENCES", "0", "4096", "9810800c-0121-c5e2-e794-00000043e718"}, {"SYSSEQUENCES_INDEX1", "1", "4096", "9810800c-0121-c5e2-e794-00000043e718"}, {"SYSSEQUENCES_INDEX2", "1", "4096", "9810800c-0121-c5e2-e794-00000043e718"}, {"SYSSTATEMENTS", "0", "4096", "80000000-00d1-15f7-ab70-000a0a0b1500"}, {"SYSSTATEMENTS_INDEX1", "1", "4096", "80000000-00d1-15f7-ab70-000a0a0b1500"}, {"SYSSTATEMENTS_INDEX2", "1", "4096", "80000000-00d1-15f7-ab70-000a0a0b1500"}, {"SYSSTATISTICS", "0", "4096", "f81e0010-00e3-6612-5a96-009e3a3b5e00"}, {"SYSSTATISTICS_INDEX1", "1", "4096", "f81e0010-00e3-6612-5a96-009e3a3b5e00"}, {"SYSTABLEPERMS", "0", "4096", "b8450018-0103-0e39-b8e7-00000010f010"}, {"SYSTABLEPERMS_INDEX1", "1", "4096", "b8450018-0103-0e39-b8e7-00000010f010"}, {"SYSTABLEPERMS_INDEX2", "1", "4096", "b8450018-0103-0e39-b8e7-00000010f010"}, {"SYSTABLEPERMS_INDEX3", "1", "4096", "b8450018-0103-0e39-b8e7-00000010f010"}, {"SYSTABLES", "0", "4096", "80000018-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSTABLES_INDEX1", "1", "4096", "80000018-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSTABLES_INDEX2", "1", "4096", "80000018-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSTRIGGERS", "0", "4096", "c013800d-00d7-c025-4809-000a0a411200"}, {"SYSTRIGGERS_INDEX1", "1", "4096", "c013800d-00d7-c025-4809-000a0a411200"}, {"SYSTRIGGERS_INDEX2", "1", "4096", "c013800d-00d7-c025-4809-000a0a411200"}, {"SYSTRIGGERS_INDEX3", "1", "4096", "c013800d-00d7-c025-4809-000a0a411200"}, {"SYSUSERS", "0", "4096", "9810800c-0134-14a5-40c1-000004f61f90"}, {"SYSUSERS_INDEX1", "1", "4096", "9810800c-0134-14a5-40c1-000004f61f90"}, {"SYSVIEWS", "0", "4096", "8000004d-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSVIEWS_INDEX1", "1", "4096", "8000004d-00d0-fd77-3ed8-000a0a0b1900"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void test_vti2vtiJoinInFromList() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        connection.prepareStatement("select t1.*\nfrom \n    sys.systables systabs,\n    table ( syscs_diag.space_table( systabs.tablename ) ) as t1\nwhere systabs.tabletype = 'T'\n");
        connection.prepareStatement("select t1.*\nfrom \n    table ( syscs_diag.space_table( systabs.tablename ) ) as t1,\n    sys.systables systabs\nwhere systabs.tabletype = 'T'\n");
        SysDiagVTIMappingTest.assertStatementError(BAD_FROM_LIST_JOIN, statement, "select t1.*, t2.*\nfrom \n    sys.systables systabs,\n    table ( syscs_diag.space_table( systabs.tablename ) ) as t1,\n    table ( syscs_diag.space_table( t1.conglomeratename ) ) as t2\nwhere systabs.tabletype = 'T'\n");
        SysDiagVTIMappingTest.assertStatementError("42X04", statement, "select t1.*, t2.*\nfrom \n    sys.systables systabs,\n    table ( syscs_diag.space_table( t1.conglomeratename ) ) as t2,\n    table ( syscs_diag.space_table( systabs.tablename ) ) as t1\nwhere systabs.tabletype = 'T'\n");
    }

    public void testStatementDuration() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set schema APP");
        URL uRL = SupportFilesSetup.getReadOnlyURL(testLogFile);
        String string = "('" + uRL.getFile() + "')";
        ResultSet resultSet = statement.executeQuery("select * from TABLE(SYSCS_DIAG.STATEMENT_DURATION" + string + ") x");
        String[] stringArray = new String[]{"TS", "THREADID", "XID", "LCCID", "LOGTEXT", "DURATION"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "(DATABASE = ugh), (DRDAID = null), Cleanup action starting", "0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("SELECT * FROM NEW org.apache.derby.diag.StatementDuration" + string + " as x");
        stringArray = new String[]{"TS", "THREADID", "XID", "LCCID", "LOGTEXT", "DURATION"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "(DATABASE = ugh), (DRDAID = null), Cleanup action starting", "0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        this.checkIllegalUses(statement, "statement_duration", "StatementDuration", string, "logtext");
    }

    public void testErrorLogReader() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set schema APP");
        URL uRL = SupportFilesSetup.getReadOnlyURL(testLogFile);
        String string = "('" + uRL.getFile() + "')";
        ResultSet resultSet = statement.executeQuery(" select * from TABLE(SYSCS_DIAG.ERROR_LOG_READER" + string + ") x");
        String[] stringArray = new String[]{"TS", "THREADID", "XID", "LCCID", "DATABASE", "DRDAID", "LOGTEXT"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "ugh", "null", "Cleanup action starting"}, {"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "ugh", "null", "Failed Statement is: select * from oops"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("SELECT * FROM NEW org.apache.derby.diag.ErrorLogReader" + string + " as x");
        stringArray = new String[]{"TS", "THREADID", "XID", "LCCID", "DATABASE", "DRDAID", "LOGTEXT"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "ugh", "null", "Cleanup action starting"}, {"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "ugh", "null", "Failed Statement is: select * from oops"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        this.checkIllegalUses(statement, "error_log_reader", "ErrorLogReader", string, "logtext");
    }

    public void testInvalidTableFunctions() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set schema APP");
        ResultSet resultSet = statement.executeQuery("select * from table (select * from t1) x");
        String[] stringArray = new String[]{"I", "C"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "one"}, {"2", "two"}, {"4", "four"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from table (values (1, 2), (2, 3)) x");
        stringArray = new String[]{"1", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2"}, {"2", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "select * from table (app.t1) x");
        SysDiagVTIMappingTest.assertStatementError("42ZB4", statement, "select * from table (app.t1()) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "select * from table (syscs_diag.lock_table) x");
        SysDiagVTIMappingTest.assertStatementError("42Y03", statement, "select * from table (syscs_diag.lock_table()) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "select * from table (syscs_diag.transaction_table) x");
        SysDiagVTIMappingTest.assertStatementError("42Y03", statement, "select * from table (syscs_diag.transaction_table()) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "select * from table (syscs_diag.statement_cache) x");
        SysDiagVTIMappingTest.assertStatementError("42Y03", statement, "select * from table (syscs_diag.statement_cache()) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "select * from table (syscs_diag.error_messages) x");
        SysDiagVTIMappingTest.assertStatementError("42Y03", statement, "select * from table (syscs_diag.error_messages()) x");
        this.getConnection().rollback();
        statement.close();
    }

    public void testOrderBy() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("set schema APP");
        statement.execute("create table ob_t1 (i int, c char(250))");
        statement.execute("create index i_ix on ob_t1 (i)");
        statement.execute("create index c_ix on ob_t1 (c desc)");
        String[][] stringArray = new String[][]{{"C_IX", "1", "0"}, {"I_IX", "1", "0"}, {"OB_T1", "0", "0"}};
        ResultSet resultSet = statement.executeQuery("select CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 1");
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select distinct CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 1");
        JDBC.assertFullResultSet(resultSet, stringArray);
        stringArray = new String[][]{{"OB_T1", "0", "0"}, {"C_IX", "1", "0"}, {"I_IX", "1", "0"}};
        resultSet = statement.executeQuery("select CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 2, 1");
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select distinct CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 2, 1");
        JDBC.assertFullResultSet(resultSet, stringArray);
        stringArray = new String[][]{{"OB_T1", "0", "0"}, {"I_IX", "1", "0"}, {"C_IX", "1", "0"}};
        resultSet = statement.executeQuery("select CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 2, 1 desc");
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select distinct CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 2, 1 desc");
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("drop table ob_t1");
        statement.close();
    }

    public void testCorrelatedReferences() throws SQLException {
        Statement statement = this.createStatement();
        String[][] stringArray = new String[][]{};
        ResultSet resultSet = statement.executeQuery("select s.schemaname, t.tableName\nfrom sys.sysschemas s, sys.systables t\nwhere t.schemaid=s.schemaid\nand exists\n(\n  select vti.*\n  from table( syscs_diag.space_table( s.schemaname, t.tableName ) ) as vti\n  where vti.numfreepages < -1\n)\n");
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet.close();
        statement.close();
    }

    public void testContainedRoles() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from table(syscs_diag.contained_roles(null, 0))t");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select * from table(syscs_diag.contained_roles(null))t");
        JDBC.assertEmpty(resultSet);
        resultSet.close();
        statement.close();
    }

    public void test_5391() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from table (syscs_diag.error_log_reader( )) as t1");
        this.vetTimestamp(resultSet);
        resultSet.close();
        ResultSet resultSet2 = statement.executeQuery("select * from table (syscs_diag.statement_duration()) as t1");
        this.vetTimestamp(resultSet2);
        resultSet2.close();
        statement.close();
    }

    private void vetTimestamp(ResultSet resultSet) throws Exception {
        SysDiagVTIMappingTest.assertTrue((boolean)resultSet.next());
        String string = resultSet.getString(1).trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        Timestamp timestamp = new Timestamp(simpleDateFormat.parse(string).getTime());
        SysDiagVTIMappingTest.println(timestamp.toString());
    }

    private void checkIllegalUses(Statement statement, String string, String string2, String string3, String string4) throws SQLException {
        SysDiagVTIMappingTest.assertStatementError("42X05", statement, "select * from syscs_diag." + string);
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "select * from syscs_diag." + string + string3 + " x");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "select * from (syscs_diag." + string + string3 + ") x");
        SysDiagVTIMappingTest.assertStatementError("42Y55", statement, "drop table syscs_diag." + string);
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "drop table syscs_diag." + string + string3);
        SysDiagVTIMappingTest.assertStatementError("42X62", statement, "drop function syscs_diag." + string);
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "drop function syscs_diag." + string + string3);
        SysDiagVTIMappingTest.assertStatementError("42X62", statement, "alter table syscs_diag." + string + " add column bad int");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "alter table syscs_diag." + string + string3 + " add column bad int");
        SysDiagVTIMappingTest.assertStatementError("42X05", statement, "update syscs_diag." + string + " set " + string4 + " = NULL");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "update syscs_diag." + string + string3 + " set " + string4 + "  = NULL");
        SysDiagVTIMappingTest.assertStatementError("42X05", statement, "delete from syscs_diag." + string + " where 1 = 1");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "delete from syscs_diag." + string + string3 + " where 1 = 1");
        SysDiagVTIMappingTest.assertStatementError("42X05", statement, "insert into syscs_diag." + string + " values('bad')");
        SysDiagVTIMappingTest.assertStatementError("42X05", statement, "insert into syscs_diag." + string + " (" + string4 + ") values('bad')");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "insert into syscs_diag." + string + string3 + " values('bad')");
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, 1)");
        callableStatement.setString(1, "SYSCS_DIAG");
        callableStatement.setString(2, string.toUpperCase());
        SysDiagVTIMappingTest.assertStatementError("42X62", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, 1, 1, 1)");
        callableStatement.setString(1, "SYSCS_DIAG");
        callableStatement.setString(2, string.toUpperCase());
        SysDiagVTIMappingTest.assertStatementError("42Y55", callableStatement);
        SysDiagVTIMappingTest.assertStatementError("42X08", statement, "update new org.apache.derby.diag." + string2 + string3 + " set " + string4 + " = NULL");
        SysDiagVTIMappingTest.assertStatementError("42X08", statement, "delete from new org.apache.derby.diag." + string2 + string3 + " where 1 = 0");
        statement.execute("set schema syscs_diag");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "select * from " + string + string3 + " x");
        SysDiagVTIMappingTest.assertStatementError("42X01", statement, "select * from (" + string + string3 + ") x");
        statement.execute("set schema app");
    }
}

