/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby5165Test
extends BaseJDBCTestCase {
    public Derby5165Test(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3()) {
            Test test = TestConfiguration.embeddedSuite(Derby5165Test.class);
            test = DatabasePropertyTestSetup.setLockTimeouts(test, 2, 4);
            test = TestConfiguration.singleUseDatabaseDecorator(test, "d5165db");
            test = TestConfiguration.singleUseDatabaseDecorator(test, "d5165db2");
            test = TestConfiguration.singleUseDatabaseDecorator(test, "d5165db3");
            test = TestConfiguration.singleUseDatabaseDecorator(test, "d5165db4");
            return test;
        }
        return new BaseTestSuite("Derby5165Test cannot run without XA support");
    }

    public void testXAUpdateLockKeptPastDBRestart() throws InterruptedException, SQLException, XAException {
        if (Derby5165Test.usingDerbyNetClient()) {
            return;
        }
        XADataSource xads = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xads, "databaseName", "d5165db");
        XAConnection xac = xads.getXAConnection();
        XAResource xar = xac.getXAResource();
        Connection conn = xac.getConnection();
        Statement s = conn.createStatement();
        String tableName = "d5165t";
        this.createAndLoadTable(conn, tableName, true);
        conn.commit();
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from " + tableName), "1");
        conn.close();
        s.close();
        MyXid xid1 = new MyXid(1, 2, 3);
        xar.start(xid1, 0);
        Connection c1 = xac.getConnection();
        Statement s1 = c1.createStatement();
        s1.execute("update " + tableName + " set x = 2 where x = 1");
        xar.end(xid1, 0x4000000);
        xar.prepare(xid1);
        try {
            DataSource ds = JDBCDataSource.getDataSource("d5165db");
            JDBCDataSource.shutdownDatabase(ds);
        }
        catch (Exception ds) {
            // empty catch block
        }
        Connection c2 = this.openConnection("d5165db");
        Statement s2 = c2.createStatement();
        try {
            ResultSet rs = s2.executeQuery("select * from " + tableName);
            while (rs.next()) {
                rs.getInt(1);
            }
            rs.close();
            Derby5165Test.fail((String)"expected a timeout");
        }
        catch (SQLException sqle) {
            Derby5165Test.assertSQLState("40XL1", sqle);
        }
        s.close();
        c2.close();
        s2.close();
        xac.close();
    }

    public void testXAInsertLockKeptPastDBRestart() throws InterruptedException, SQLException, XAException {
        if (Derby5165Test.usingDerbyNetClient()) {
            return;
        }
        Connection ctmp = this.openConnection("d5165db2");
        ctmp.close();
        XADataSource xads = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xads, "databaseName", "d5165db2");
        XAConnection xac = xads.getXAConnection();
        XAResource xar = xac.getXAResource();
        Connection conn = xac.getConnection();
        Statement s = conn.createStatement();
        String tableName = "d5165t";
        this.createAndLoadTable(conn, tableName, true);
        conn.commit();
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from " + tableName), "1");
        conn.close();
        s.close();
        MyXid xid1 = new MyXid(1, 2, 3);
        xar.start(xid1, 0);
        Connection c1 = xac.getConnection();
        Statement s1 = c1.createStatement();
        s1.execute("insert into " + tableName + " values 2");
        xar.end(xid1, 0x4000000);
        xar.prepare(xid1);
        try {
            DataSource ds = JDBCDataSource.getDataSource("d5165db2");
            JDBCDataSource.shutdownDatabase(ds);
        }
        catch (Exception ds) {
            // empty catch block
        }
        Connection c2 = this.openConnection("d5165db2");
        Statement s2 = c2.createStatement();
        try {
            ResultSet rs = s2.executeQuery("select * from " + tableName);
            while (rs.next()) {
                rs.getInt(1);
            }
            rs.close();
            Derby5165Test.fail((String)"expected a timeout");
        }
        catch (SQLException sqle) {
            Derby5165Test.assertSQLState("40XL1", sqle);
        }
        s.close();
        c2.close();
        s2.close();
        xac.close();
    }

    public void testXAUpdateLockKeptPastCrashedDBRestart() throws Exception {
        Derby5165Test.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.jdbcapi.Derby5165Test.launchUpdate", "d5165db3");
        Derby5165Test.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.jdbcapi.Derby5165Test.checkUpdate", "d5165db3");
    }

    public void testXAInsertLockKeptPastCrashedDBRestart() throws Exception {
        Derby5165Test.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.jdbcapi.Derby5165Test.launchInsert", "d5165db4");
        Derby5165Test.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.jdbcapi.Derby5165Test.checkInsert", "d5165db4");
    }

    public void launchUpdate() throws Exception {
        Connection simpleconn = this.getConnection();
        this.setAutoCommit(false);
        String tableName = "d5165t2";
        this.createAndLoadTable(simpleconn, tableName, true);
        XADataSource xads = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xads, "databaseName", "d5165db3");
        XAConnection xac = xads.getXAConnection();
        XAResource xar = xac.getXAResource();
        Connection conn = xac.getConnection();
        Statement s = conn.createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from " + tableName), "1");
        conn.close();
        s.close();
        MyXid xid1 = new MyXid(1, 2, 3);
        xar.start(xid1, 0);
        Connection c1 = xac.getConnection();
        Statement s1 = c1.createStatement();
        s1.execute("update " + tableName + " set x = 2 where x = 1");
        xar.end(xid1, 0x4000000);
        xar.prepare(xid1);
    }

    public void checkUpdate() throws Exception {
        String tableName = "d5165t2";
        Connection c2 = this.getConnection();
        this.setAutoCommit(false);
        Statement s2 = c2.createStatement();
        try {
            ResultSet rs = s2.executeQuery("select * from " + tableName);
            while (rs.next()) {
                rs.getInt(1);
            }
            rs.close();
            Derby5165Test.fail((String)"expected a timeout");
        }
        catch (SQLException sqle) {
            Derby5165Test.assertSQLState("40XL1", sqle);
        }
    }

    public void launchInsert() throws Exception {
        String tableName = "d5165t3";
        Connection simpleconn = this.getConnection();
        this.setAutoCommit(false);
        this.createAndLoadTable(simpleconn, tableName, true);
        XADataSource xads = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xads, "databaseName", "d5165db4");
        XAConnection xac = xads.getXAConnection();
        XAResource xar = xac.getXAResource();
        Connection conn = xac.getConnection();
        Statement s = conn.createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from " + tableName), "1");
        conn.close();
        s.close();
        MyXid xid1 = new MyXid(1, 2, 3);
        xar.start(xid1, 0);
        Connection c1 = xac.getConnection();
        Statement s1 = c1.createStatement();
        s1.execute("insert into " + tableName + " values 2");
        xar.end(xid1, 0x4000000);
        xar.prepare(xid1);
    }

    public void checkInsert() throws Exception {
        String tableName = "d5165t3";
        Connection c2 = this.getConnection();
        this.setAutoCommit(false);
        Statement s2 = c2.createStatement();
        try {
            ResultSet rs = s2.executeQuery("select * from " + tableName);
            while (rs.next()) {
                rs.getInt(1);
            }
            rs.close();
            Derby5165Test.fail((String)"expected a timeout");
        }
        catch (SQLException sqle) {
            Derby5165Test.assertSQLState("40XL1", sqle);
        }
    }

    private void createAndLoadTable(Connection conn, String tblname, boolean create_table) throws SQLException {
        if (create_table) {
            Statement s = conn.createStatement();
            s.executeUpdate("create table " + tblname + "(x int)");
            s.executeUpdate("insert into " + tblname + " values 1");
            conn.commit();
            JDBC.assertSingleValueResultSet(s.executeQuery("select * from " + tblname), "1");
            s.close();
            Derby5165Test.println("table created: " + tblname);
        }
    }

    private static class MyXid
    implements Xid {
        int formatId;
        byte txid;
        byte bq;

        MyXid(int formatId, int txid, int bq) {
            this.formatId = formatId;
            this.txid = (byte)txid;
            this.bq = (byte)bq;
        }

        @Override
        public int getFormatId() {
            return this.formatId;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            return new byte[]{this.txid};
        }

        @Override
        public byte[] getBranchQualifier() {
            return new byte[]{this.bq};
        }
    }
}

