/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SetObjectUnsupportedTest
extends BaseJDBCTestCase {
    private final TypeInfo typeInfo;
    private final boolean callable;
    private static final TypeInfo[] TYPES = new TypeInfo[]{new TypeInfo("ARRAY", 2003), new TypeInfo("DATALINK", 70), new TypeInfo("NCHAR", -15), new TypeInfo("NCLOB", 2011), new TypeInfo("NVARCHAR", -9), new TypeInfo("LONGNVARCHAR", -16), new TypeInfo("REF", 2006), new TypeInfo("ROWID", -8), new TypeInfo("SQLXML", 2009), new TypeInfo("STRUCT", 2002)};

    private SetObjectUnsupportedTest(String name, TypeInfo typeInfo, boolean callable) {
        super(name);
        this.typeInfo = typeInfo;
        this.callable = callable;
    }

    public String getName() {
        return super.getName() + "_" + this.typeInfo.name;
    }

    private PreparedStatement prepare() throws SQLException {
        String sql = "values (CAST (? AS VARCHAR(128)))";
        return this.callable ? this.prepareCall(sql) : this.prepareStatement(sql);
    }

    public void testUnsupportedSetObject() throws SQLException {
        PreparedStatement ps = this.prepare();
        try {
            ps.setObject(1, null, this.typeInfo.type);
            SetObjectUnsupportedTest.fail((String)"No exception thrown.");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        ps.close();
    }

    public void testUnsupportedSetObjectWithScale() throws SQLException {
        PreparedStatement ps = this.prepare();
        try {
            ps.setObject(1, null, this.typeInfo.type, 0);
            SetObjectUnsupportedTest.fail((String)"No exception thrown.");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        ps.close();
    }

    public void testUnsupportedSetNull() throws SQLException {
        PreparedStatement ps = this.prepare();
        try {
            ps.setNull(1, this.typeInfo.type);
            SetObjectUnsupportedTest.fail((String)"No exception thrown.");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        ps.close();
    }

    public void testUnsupportedSetNullWithTypeName() throws SQLException {
        PreparedStatement ps = this.prepare();
        try {
            ps.setNull(1, this.typeInfo.type, this.typeInfo.name);
            SetObjectUnsupportedTest.fail((String)"No exception thrown.");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        ps.close();
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("SetObjectUnsupportedTest suite");
        suite.addTest(SetObjectUnsupportedTest.baseSuite(false, "SetObjectUnsupportedTest:prepared"));
        suite.addTest(SetObjectUnsupportedTest.baseSuite(true, "SetObjectUnsupportedTest:callable"));
        BaseTestSuite client = new BaseTestSuite("SetObjectUnsupportedTest:client");
        client.addTest(SetObjectUnsupportedTest.baseSuite(false, "SetObjectUnsupportedTest:prepared"));
        client.addTest(SetObjectUnsupportedTest.baseSuite(true, "SetObjectUnsupportedTest:callable"));
        suite.addTest(TestConfiguration.clientServerDecorator((Test)client));
        return suite;
    }

    static Test baseSuite(boolean callable, String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        for (TypeInfo typeInfo : TYPES) {
            suite.addTest((Test)new SetObjectUnsupportedTest("testUnsupportedSetObject", typeInfo, callable));
            suite.addTest((Test)new SetObjectUnsupportedTest("testUnsupportedSetObjectWithScale", typeInfo, callable));
            suite.addTest((Test)new SetObjectUnsupportedTest("testUnsupportedSetNull", typeInfo, callable));
            suite.addTest((Test)new SetObjectUnsupportedTest("testUnsupportedSetNullWithTypeName", typeInfo, callable));
        }
        return suite;
    }

    private static class TypeInfo {
        final String name;
        final int type;

        TypeInfo(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

