/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest;

import org.apache.derbyTesting.system.nstest.NsTest;

public class TimerThread
extends Thread {
    private long _sleepTime;
    private boolean _continueRunning = true;

    public TimerThread(long sleepTime) {
        this._sleepTime = sleepTime;
    }

    @Override
    public void run() {
        long remainingTime = this._sleepTime;
        while (this._continueRunning) {
            long cycleStartTime = System.currentTimeMillis();
            try {
                if (remainingTime > 0L) {
                    NsTest.logger.println("TimerThread sleeping for " + remainingTime + " milliseconds.");
                    TimerThread.sleep(remainingTime);
                }
                NsTest.logger.println("TimerThread attempting to shut down the program.");
                NsTest.printStatistics();
                Runtime.getRuntime().halt(0);
            }
            catch (InterruptedException ie) {
                NsTest.printException(TimerThread.class.getName(), ie);
            }
            long elapsedTime = System.currentTimeMillis() - cycleStartTime;
            remainingTime -= elapsedTime;
        }
    }

    public void stopNow() {
        this._continueRunning = false;
    }
}

